/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.accept;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BillAmountHelper;
import kd.mpscmm.msbd.common.pojo.BillAmountInfo;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.consts.PurAcceptBillConst;
import kd.scmc.pm.enums.DiscountTypeEnum;
import kd.scmc.pm.enums.ExchangeTypeEnum;
import kd.scmc.pm.utils.CommonUtils;

public class PurAcceptBillPlugin
extends AbstractBillPlugIn
implements EntryGridBindDataListener,
BeforeF7SelectListener {
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final String CUR_AMTPRECISION = "amtprecision";
    private static final String CUR_PRICEPRECISION = "priceprecision";
    private static final String STOPCHANGE = "stopChange";
    private static final String BILLENTRY = "billentry";
    private static final String BILL = "bill";

    public void registerListener(EventObject e) {
        EntryGrid billEntry;
        BasedataEdit invoiceBizTypeEdit;
        BasedataEdit recdept;
        super.registerListener(e);
        BasedataEdit taxrateid = (BasedataEdit)this.getView().getControl("taxrateid");
        if (taxrateid != null) {
            taxrateid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((recdept = (BasedataEdit)this.getView().getControl("recdept")) != null) {
            recdept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((invoiceBizTypeEdit = (BasedataEdit)this.getView().getControl("invoicebiztype")) != null) {
            invoiceBizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((billEntry = (EntryGrid)this.getView().getControl(BILLENTRY)) != null) {
            billEntry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String stopChange = this.getPageCache().get(STOPCHANGE);
        if ("true".equals(stopChange)) {
            return;
        }
        String billcretype = this.getPageCache().get("billcretype");
        if ("1".equals(billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject bizUser = (DynamicObject)model.getValue("recoperator");
        if (!CommonUtils.isNull((Object)bizUser)) {
            long userId = (Long)bizUser.getPkValue();
            Long deptId = UserServiceHelper.getUserMainOrgId((long)userId);
            model.setValue("recdept", (Object)deptId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject biztype = (DynamicObject)this.getModel().getValue("biztype");
        if (biztype == null) {
            return;
        }
        String number = biztype.getString("number");
        if (number != null && ("1131".equals(number) || "1132".equals(number)) || "1121".equals(number)) {
            PurAcceptBillPlugin.setRedColumn(this.getView(), PurAcceptBillConst.getEntryRedColumns(), BILLENTRY);
            PurAcceptBillPlugin.setRedColumn(this.getView(), PurAcceptBillConst.getAllRedColumns(), "allocationentry");
        }
        this.setEntryAmountInfoEnableByInputAmount();
        this.setDiscountRateScale(this.getModel().getValue("settlecurrency"));
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.setDiscountRateScale(this.getModel().getValue("settlecurrency"));
    }

    private void setEntryAmountInfoEnableByInputAmount() {
        Boolean inputAmount = (Boolean)this.getModel().getValue("inputamount");
        Boolean isTax = (Boolean)this.getModel().getValue("istax");
        if (isTax.booleanValue() && inputAmount.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"amountandtax"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"priceandtax", "price", "amount"});
        } else if (isTax.booleanValue() && !inputAmount.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"priceandtax"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amount", "price", "amountandtax"});
        } else if (!isTax.booleanValue() && inputAmount.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"amount"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"price", "priceandtax", "amountandtax"});
        } else if (!isTax.booleanValue() && !inputAmount.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"price"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amountandtax", "amount", "priceandtax"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setInverse();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "save": 
            case "unsubmit": 
            case "unaudit": 
            case "audit": 
            case "submit": {
                this.setInverse();
                break;
            }
            case "adeleteentry": {
                this.caculateExpenseallocation();
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("allocationentry".equals(entryName)) {
            this.caculateExpenseallocation();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String filedName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (filedName) {
            case "taxrateid": {
                Date bizTime = (Date)this.getModel().getValue("biztime");
                QFilter activeQfilter = new QFilter("activedate", "<=", (Object)bizTime);
                QFilter expQfilter = new QFilter("expdate", ">", (Object)bizTime);
                expQfilter = QFilter.isNull((String)"expdate").or(expQfilter);
                QFilter qFilter = expQfilter.and(activeQfilter);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "recdept": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u9700\u6c42\u7ec4\u7ec7\u201d\u3002", (String)"PurAcceptBillPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                Long orgId = (Long)org.getPkValue();
                List deptIDs = OrgHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId, (boolean)true);
                DynamicObject user = (DynamicObject)this.getModel().getValue("recoperator");
                if (user != null) {
                    Long userID = (Long)user.getPkValue();
                    Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                    deptIDs.add(deptID);
                }
                QFilter q6 = new QFilter("id", "in", (Object)deptIDs);
                showParameter.getListFilterParameter().getQFilters().add(q6);
                break;
            }
            case "invoicebiztype": {
                String appNmuber = this.getModel().getDataEntityType().getAppId();
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNmuber);
                if (appInfo == null) break;
                String bizCloudNumber = appInfo.getCloudNum();
                QFilter appIdQFilter = new QFilter("mulbiz.fbasedataid.number", "=", (Object)bizCloudNumber);
                QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
                showParameter.getListFilterParameter().getQFilters().add(appIdQFilter.and(enableQFilter));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String stopChange = this.getPageCache().get(STOPCHANGE);
        if ("true".equals(stopChange)) {
            return;
        }
        ChangeData[] changeData = e.getChangeSet();
        String fielKey = e.getProperty().getName();
        block35: for (int i = 0; i < changeData.length; ++i) {
            this.changeData(fielKey, changeData[i]);
            int rowIndex = changeData[i].getRowIndex();
            Object newValue = changeData[i].getNewValue();
            Object oldValue = changeData[i].getOldValue();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fielKey) {
                case "qty": {
                    if (this.isBackCalculate() && !this.checkDiscountRateToOther(new int[]{rowIndex}, this.getModel()).booleanValue()) {
                        this.showErrMsg();
                        this.revertEntryValue(changeData[i], rowIndex, fielKey);
                        return;
                    }
                    this.changeQty(newValue, oldValue, rowIndex);
                    continue block35;
                }
                case "price": 
                case "priceandtax": {
                    this.changePriceField(rowIndex, newValue);
                    boolean isComplian = this.checkIsCompliance(fielKey, newValue, oldValue, rowIndex);
                    if (!isComplian) continue block35;
                    this.calAmount(fielKey, oldValue, rowIndex);
                    continue block35;
                }
                case "discounttype": 
                case "discountrate": {
                    boolean isCompliance = this.checkIsCompliance(fielKey, newValue, oldValue, rowIndex);
                    if (!isCompliance) continue block35;
                    this.calAmount(fielKey, oldValue, rowIndex);
                    continue block35;
                }
                case "discountamount": {
                    if (!this.changeDiscountAmountInfo(oldValue, rowIndex)) continue block35;
                    this.calAmount(fielKey, oldValue, rowIndex, Boolean.TRUE);
                    continue block35;
                }
                case "taxrateid": {
                    if (this.isBackCalculate() && !this.checkDiscountRateToOther(new int[]{rowIndex}, this.getModel()).booleanValue()) {
                        this.showErrMsg();
                        this.revertEntryValue(changeData[i], rowIndex, fielKey);
                        return;
                    }
                    if (newValue instanceof DynamicObject) {
                        DynamicObject taxRateID = (DynamicObject)newValue;
                        this.getModel().setValue("taxrate", (Object)taxRateID.getBigDecimal("taxrate"), rowIndex);
                    } else {
                        this.getModel().setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex);
                    }
                    this.calAmount(fielKey, oldValue, rowIndex);
                    continue block35;
                }
                case "isexpensealloc": {
                    if (!((Boolean)newValue).booleanValue()) {
                        this.getModel().deleteEntryData("allocationentry");
                        continue block35;
                    }
                    this.getModel().setValue("isallocbyper", (Object)Boolean.TRUE);
                    continue block35;
                }
                case "totalamount": 
                case "a_allocationamt": 
                case "a_allocationper": {
                    this.caculateExpenseallocation();
                    continue block35;
                }
                case "istax": {
                    if (this.isBackCalculate() && !PurAcceptBillPlugin.cheackDiscountRateToEntry(this.getModel().getDataEntity(true)).booleanValue()) {
                        this.showErrMsg();
                        this.getPageCache().put(STOPCHANGE, "true");
                        this.getModel().setValue("istax", oldValue);
                        this.getPageCache().put(STOPCHANGE, "false");
                        return;
                    }
                    if (!this.checkAllIsCompliance(oldValue, newValue)) continue block35;
                    this.setEntryAmountInfoEnableByInputAmount();
                    this.calAllAmount();
                    continue block35;
                }
                case "amount": 
                case "amountandtax": {
                    if (this.isBackCalculate() && !this.checkDiscountRateToOther(new int[]{rowIndex}, this.getModel()).booleanValue()) {
                        this.showErrMsg();
                        this.revertEntryValue(changeData[i], rowIndex, fielKey);
                        return;
                    }
                    this.calAmount(fielKey, oldValue, rowIndex);
                    continue block35;
                }
                case "inputamount": {
                    this.setEntryAmountInfoEnableByInputAmount();
                    continue block35;
                }
                case "biztime": {
                    Date biztime = (Date)changeData[i].getNewValue();
                    this.getModel().setValue("bookdate", (Object)biztime);
                    continue block35;
                }
                case "recoperator": {
                    this.changeRecoPerotor(newValue);
                    continue block35;
                }
                case "supplier": {
                    DynamicObject supplier = newValue instanceof DynamicObject ? (DynamicObject)newValue : null;
                    IDataModel bill = this.getModel();
                    Object invoiceBizType = bill.getValue("invoicebiztype");
                    if (invoiceBizType != null) continue block35;
                    String appId = this.getView().getFormShowParameter().getAppId();
                    bill.setValue("invoicebiztype", (Object)SupplierHelper.getInvoiceType((DynamicObject)supplier, (String)appId));
                    continue block35;
                }
            }
        }
    }

    private Boolean checkDiscountRateToOther(int[] rowIndexs, IDataModel model) {
        Boolean result = Boolean.TRUE;
        for (int i = 0; i < rowIndexs.length; ++i) {
            int rowIndex = rowIndexs[i];
            BigDecimal discountrate = BigDecimal.ZERO;
            discountrate = (BigDecimal)model.getValue("discountrate", rowIndex);
            String discounttype = (String)model.getValue("discounttype", rowIndex);
            if (discountrate == null || discountrate.compareTo(new BigDecimal("100")) <= 0 && discountrate.compareTo(new BigDecimal("100")) != 0 || !DiscountTypeEnum.DISRATE.getValue().equals(discounttype)) continue;
            result = Boolean.FALSE;
        }
        return result;
    }

    private void revertEntryValue(ChangeData changeData, int rowIndex, String propName) {
        this.getPageCache().put(STOPCHANGE, "true");
        this.getModel().setValue(propName, changeData.getOldValue(), rowIndex);
        this.getPageCache().put(STOPCHANGE, "false");
    }

    private void showErrMsg() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u4ef7\u683c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PurAcceptBillPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
    }

    public static Boolean cheackDiscountRateToEntry(DynamicObject bill) {
        BigDecimal discountrate = BigDecimal.ZERO;
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(BILLENTRY);
        Boolean result = Boolean.TRUE;
        for (int j = 0; j < entrys.size(); ++j) {
            DynamicObject entry = (DynamicObject)entrys.get(j);
            discountrate = (BigDecimal)entry.get("discountrate");
            String discounttype = (String)entry.get("discounttype");
            if (discountrate.compareTo(new BigDecimal("100")) <= 0 && discountrate.compareTo(new BigDecimal("100")) != 0 || !DiscountTypeEnum.DISRATE.getValue().equals(discounttype)) continue;
            result = Boolean.FALSE;
            break;
        }
        return result;
    }

    private boolean checkIsCompliance(String fielKey, Object newValue, Object oldValue, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String discountType = (String)model.getValue("discounttype", rowIndex);
        boolean isTax = (Boolean)model.getValue("istax");
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        boolean isPresent = (Boolean)this.getModel().getValue("ispresent", rowIndex);
        boolean isCompliance = true;
        if (!isPresent && DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            if (BigDecimalUtil.largeThan((BigDecimal)discountRate, (BigDecimal)BigDecimalUtil.HUNDRED) || BigDecimalUtil.lessThan((BigDecimal)discountRate, (BigDecimal)BigDecimalUtil.ZERO)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u7387(%)\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u8303\u56f4\u4e3a\uff1a0\u2264\u5355\u4f4d\u6298\u6263(\u7387)\u2264100\u3002", (String)"PurAcceptBillPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                isCompliance = false;
            }
        } else if (!isPresent && (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType))) {
            if (isTax && BigDecimalUtil.largeThan((BigDecimal)discountRate, (BigDecimal)priceAndTax)) {
                if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurAcceptBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurAcceptBillPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                }
                isCompliance = false;
            } else if (!isTax && BigDecimalUtil.largeThan((BigDecimal)discountRate, (BigDecimal)price)) {
                if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"PurAcceptBillPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"PurAcceptBillPlugin_6", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                }
                isCompliance = false;
            }
        } else if (!isPresent && DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            model.beginInit();
            model.setValue("discountrate", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.endInit();
            view.updateView("discountrate", rowIndex);
        }
        if (!isCompliance) {
            this.getPageCache().put(STOPCHANGE, "true");
            model.setValue(fielKey, oldValue, rowIndex);
            this.getPageCache().put(STOPCHANGE, "false");
        }
        return isCompliance;
    }

    private boolean changeDiscountAmountInfo(Object oldValue, int rowIndex) {
        String discountType = (String)this.getModel().getValue("discounttype", rowIndex);
        if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_AMTPRECISION);
            BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountamount", rowIndex);
            discountAmount = discountAmount.setScale(settleAmtPrecision, 4);
            BigDecimal amountAndTax = BigDecimal.ZERO;
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)this.getModel().getValue("priceandtax", rowIndex);
                if (qty != null && priceAndTax != null) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                }
            } else {
                BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
                if (qty != null && price != null) {
                    BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                    if (taxRate == null) {
                        taxRate = BigDecimal.ZERO;
                    }
                    amountAndTax = qty.multiply(price).multiply(BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100")))).setScale(settleAmtPrecision, 4);
                }
            }
            if (discountAmount.compareTo(amountAndTax) > 0) {
                this.getPageCache().put(STOPCHANGE, "true");
                this.getModel().setValue("discountamount", oldValue, rowIndex);
                this.getPageCache().put(STOPCHANGE, "false");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u6298\u6263\u989d\u4e0d\u80fd\u5927\u4e8e\u201c\u6570\u91cf\u201d\u4e58\u4ee5\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"PurAcceptBillPlugin_7", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkAllIsCompliance(Object oldValue, Object newValue) {
        if (newValue instanceof Boolean && ((Boolean)newValue).booleanValue()) {
            return true;
        }
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(BILLENTRY);
        for (int i = 0; i < rowCount; ++i) {
            BigDecimal price;
            BigDecimal discountRate;
            String discountType = (String)model.getValue("discounttype", i);
            if (!DiscountTypeEnum.UNITDIS.getValue().equals(discountType) && !DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) || !BigDecimalUtil.largeThan((BigDecimal)(discountRate = (BigDecimal)model.getValue("discountrate", i)), (BigDecimal)(price = (BigDecimal)model.getValue("price", i)))) continue;
            this.getPageCache().put(STOPCHANGE, "true");
            model.setValue("istax", oldValue);
            this.getPageCache().put(STOPCHANGE, "false");
            if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"PurAcceptBillPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"PurAcceptBillPlugin_6", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (BILLENTRY.equals(entryName)) {
            this.calcTotalAmount();
        }
    }

    private void changeData(String propName, ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        ArrayList<String> entry = new ArrayList<String>(Arrays.asList(PurAcceptBillConst.getEntryRedColumns()));
        ArrayList<String> bill = new ArrayList<String>(Arrays.asList(PurAcceptBillConst.getBillRedColumns()));
        ArrayList<String> all = new ArrayList<String>(Arrays.asList(PurAcceptBillConst.getAllRedColumns()));
        entry.addAll(bill);
        entry.addAll(all);
        if (entry.contains(propName) && newValue instanceof BigDecimal) {
            BigDecimal value = (BigDecimal)newValue;
            BigDecimal oldValueBigDecimal = BigDecimal.ZERO;
            if (oldValue != null && BigDecimal.ZERO.compareTo((BigDecimal)oldValue) < 0) {
                oldValueBigDecimal = (BigDecimal)oldValue;
            }
            if (BigDecimal.ZERO.compareTo(value) > 0) {
                this.getModel().setValue(propName, (Object)oldValueBigDecimal, rowIndex);
            }
        }
    }

    private static int getPrecision(DynamicObject bill) {
        int precision = 10;
        DynamicObject currency = bill.getDynamicObject("settlecurrency");
        if (currency != null) {
            precision = currency.getInt(CUR_AMTPRECISION);
        }
        return precision;
    }

    private void caculateExpenseallocation() {
        if (!((Boolean)this.getModel().getValue("isexpensealloc")).booleanValue()) {
            return;
        }
        Boolean isallocbyper = (Boolean)this.getModel().getValue("isallocbyper");
        DynamicObjectCollection allocationentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("allocationentry");
        if (allocationentry.size() == 0) {
            return;
        }
        this.getPageCache().put(STOPCHANGE, "true");
        BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount");
        if (totalAmount == null) {
            totalAmount = BigDecimal.ZERO;
        }
        totalAmount = totalAmount.abs();
        if (isallocbyper.booleanValue()) {
            BigDecimal sumAllocationPer = BigDecimal.ZERO;
            BigDecimal sumAllocationAmt = BigDecimal.ZERO;
            BigDecimal allocationAmt = BigDecimal.ZERO;
            for (DynamicObject entry : allocationentry) {
                BigDecimal allocationper = entry.getBigDecimal("a_allocationper");
                if (allocationper == null) continue;
                sumAllocationPer = sumAllocationPer.add(allocationper);
            }
            for (int i = 0; i < allocationentry.size(); ++i) {
                BigDecimal allocationPer = (BigDecimal)this.getModel().getValue("a_allocationper", i);
                if (allocationPer == null || allocationPer.compareTo(BigDecimal.ZERO) == 0) {
                    allocationAmt = BigDecimal.ZERO;
                } else if (i == allocationentry.size() - 1 && BigDecimalUtil.equals((BigDecimal)sumAllocationPer, (BigDecimal)HUNDRED)) {
                    allocationAmt = totalAmount.subtract(sumAllocationAmt);
                } else {
                    int precision = PurAcceptBillPlugin.getPrecision(this.getModel().getDataEntity());
                    allocationAmt = totalAmount.multiply(allocationPer).divide(HUNDRED, precision, RoundingMode.HALF_UP);
                    sumAllocationAmt = sumAllocationAmt.add(allocationAmt);
                }
                this.getModel().setValue("a_allocationamt", (Object)allocationAmt, i);
            }
        } else {
            BigDecimal sumAllocationAmt = BigDecimal.ZERO;
            BigDecimal sumAllocationPer = BigDecimal.ZERO;
            for (DynamicObject entry : allocationentry) {
                BigDecimal allocationamt = entry.getBigDecimal("a_allocationamt");
                if (allocationamt == null) continue;
                sumAllocationAmt = sumAllocationAmt.add(allocationamt.abs());
            }
            for (int i = 0; i < allocationentry.size(); ++i) {
                BigDecimal alloCationPer;
                BigDecimal allocationAmt = ((DynamicObject)allocationentry.get(i)).getBigDecimal("a_allocationamt");
                if (BigDecimalUtil.isZero((BigDecimal)totalAmount) || BigDecimalUtil.isBlank((BigDecimal)allocationAmt)) {
                    alloCationPer = BigDecimal.ZERO;
                } else if (i == allocationentry.size() - 1 && sumAllocationAmt.compareTo(totalAmount) == 0) {
                    alloCationPer = HUNDRED.subtract(sumAllocationPer);
                } else {
                    alloCationPer = allocationAmt.abs().divide(totalAmount, 10, RoundingMode.HALF_UP).multiply(HUNDRED).setScale(2, RoundingMode.HALF_UP);
                    sumAllocationPer = sumAllocationPer.add(alloCationPer);
                }
                this.getModel().setValue("a_allocationper", (Object)alloCationPer, i);
            }
        }
        this.getPageCache().put(STOPCHANGE, "false");
    }

    private void changeQty(Object newValue, Object oldValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal qty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            if (material == null || unit == null) {
                return;
            }
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            if (baseUnit != null) {
                BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)material.getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                this.getPageCache().put(STOPCHANGE, "true");
                model.setValue("baseqty", (Object)baseQty, rowIndex);
                this.getPageCache().put(STOPCHANGE, "false");
            }
            this.calAmount("qty", oldValue, rowIndex);
        }
    }

    private void changePriceField(int rowIndex, Object newValue) {
        boolean isPresent = (Boolean)this.getModel().getValue("ispresent", rowIndex);
        if (isPresent) {
            BigDecimal price = (BigDecimal)newValue;
            if (BigDecimalUtil.isZero((BigDecimal)price)) {
                this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
            } else {
                this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
                this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
            }
        }
    }

    private void calAllAmount() {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt(CUR_AMTPRECISION);
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_AMTPRECISION);
        int settlePricePrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_PRICEPRECISION);
        BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
        boolean isIndirectRate = ExchangeTypeEnum.isIndirectRate((Object)model.getValue("exchangetype"));
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal totalAmountAndTax = BigDecimal.ZERO;
        boolean inputAmount = (Boolean)model.getValue("inputamount");
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection(BILLENTRY);
        if (entrys != null && !entrys.isEmpty()) {
            DataEntityPropertyCollection properties = ((DynamicObject)entrys.get(0)).getDynamicObjectType().getProperties();
            DynamicProperty qtyP = (DynamicProperty)properties.get((Object)"qty");
            DynamicProperty priceP = (DynamicProperty)properties.get((Object)"price");
            DynamicProperty priceAndTaxP = (DynamicProperty)properties.get((Object)"priceandtax");
            DynamicProperty taxRateP = (DynamicProperty)properties.get((Object)"taxrate");
            DynamicProperty discountTypeP = (DynamicProperty)properties.get((Object)"discounttype");
            DynamicProperty discountRateP = (DynamicProperty)properties.get((Object)"discountrate");
            DynamicProperty amountP = (DynamicProperty)properties.get((Object)"amount");
            DynamicProperty discountAmountP = (DynamicProperty)properties.get((Object)"discountamount");
            DynamicProperty taxAmountP = (DynamicProperty)properties.get((Object)"taxamount");
            DynamicProperty amountAndTaxP = (DynamicProperty)properties.get((Object)"amountandtax");
            model.beginInit();
            for (DynamicObject entry : entrys) {
                BigDecimal qty = (BigDecimal)qtyP.getValueFast((Object)entry);
                BigDecimal price = (BigDecimal)priceP.getValueFast((Object)entry);
                BigDecimal priceAndTax = (BigDecimal)priceAndTaxP.getValueFast((Object)entry);
                BigDecimal taxRate = (BigDecimal)taxRateP.getValueFast((Object)entry);
                String discountType = (String)discountTypeP.getValueFast((Object)entry);
                BigDecimal discountRate = (BigDecimal)discountRateP.getValueFast((Object)entry);
                BigDecimal amount = (BigDecimal)amountP.getValueFast((Object)entry);
                BigDecimal taxAmount = (BigDecimal)taxAmountP.getValueFast((Object)entry);
                BigDecimal amountAndTax = (BigDecimal)amountAndTaxP.getValueFast((Object)entry);
                BillAmountInfo billAmountInfo = new BillAmountInfo();
                billAmountInfo.setInputamount(inputAmount);
                billAmountInfo.setAmount(amount);
                billAmountInfo.setTaxAmount(taxAmount);
                billAmountInfo.setAmountAndTax(amountAndTax);
                billAmountInfo.setTax(isTax);
                billAmountInfo.setQty(qty);
                billAmountInfo.setPrice(price);
                billAmountInfo.setPriceAndTax(priceAndTax);
                billAmountInfo.setTaxRate(taxRate);
                billAmountInfo.setDiscountType(discountType);
                billAmountInfo.setDiscountRate(discountRate);
                billAmountInfo.setExChangeRate(exChangeRate);
                billAmountInfo.setSettlePricePrecision(settlePricePrecision);
                billAmountInfo.setSettleAmtPrecision(settleAmtPrecision);
                billAmountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
                billAmountInfo.setIndirectExRate(isIndirectRate);
                Map amountInfoMap = BillAmountHelper.calAmount((BillAmountInfo)billAmountInfo);
                if (this.isBackCalculate()) {
                    priceP.setValueFast((Object)entry, amountInfoMap.get("price"));
                    priceAndTaxP.setValueFast((Object)entry, amountInfoMap.get("priceandtax"));
                } else if (isTax) {
                    priceP.setValueFast((Object)entry, amountInfoMap.get("price"));
                } else {
                    priceAndTaxP.setValueFast((Object)entry, amountInfoMap.get("priceandtax"));
                }
                amountP.setValueFast((Object)entry, amountInfoMap.get("amount"));
                discountAmountP.setValueFast((Object)entry, amountInfoMap.get("discountamount"));
                taxAmountP.setValueFast((Object)entry, amountInfoMap.get("taxamount"));
                amountAndTaxP.setValueFast((Object)entry, amountInfoMap.get("amountandtax"));
                totalAmount = totalAmount.add((BigDecimal)amountInfoMap.get("amount"));
                totalTaxAmount = totalTaxAmount.add((BigDecimal)amountInfoMap.get("taxamount"));
                totalAmountAndTax = totalAmountAndTax.add((BigDecimal)amountInfoMap.get("amountandtax"));
            }
            model.endInit();
            this.getView().updateView(BILLENTRY);
            model.setValue("totalamount", (Object)totalAmount);
            model.setValue("totaltaxamount", (Object)totalTaxAmount);
            model.setValue("totalallamount", (Object)totalAmountAndTax);
        }
    }

    private void calAmount(String changeFieldKey, Object oldValue, int rowIndex) {
        this.calAmount(changeFieldKey, oldValue, rowIndex, Boolean.FALSE);
    }

    private void calAmount(String changeFieldKey, Object oldValue, int rowIndex, Boolean isCalDiscountRate) {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt(CUR_AMTPRECISION);
        int settleAmtPrecision = PurAcceptBillPlugin.getPrecision(this.getModel().getDataEntity());
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        int settlePricePrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_PRICEPRECISION);
        BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        BigDecimal discountAmount = (BigDecimal)model.getValue("discountamount", rowIndex);
        boolean isIndirectRate = ExchangeTypeEnum.isIndirectRate((Object)model.getValue("exchangetype"));
        boolean inputAmount = (Boolean)model.getValue("inputamount");
        BillAmountInfo billAmountInfo = new BillAmountInfo();
        billAmountInfo.setTax(isTax);
        billAmountInfo.setInputamount(inputAmount);
        billAmountInfo.setAmount((BigDecimal)model.getValue("amount", rowIndex));
        billAmountInfo.setTaxAmount((BigDecimal)model.getValue("taxamount", rowIndex));
        billAmountInfo.setAmountAndTax((BigDecimal)model.getValue("amountandtax", rowIndex));
        billAmountInfo.setInputamount(inputAmount);
        billAmountInfo.setQty(qty.abs());
        billAmountInfo.setPrice(price);
        billAmountInfo.setPriceAndTax(priceAndTax);
        billAmountInfo.setTaxRate(taxRate);
        billAmountInfo.setDiscountType(discountType);
        billAmountInfo.setDiscountRate(discountRate);
        billAmountInfo.setDiscountAmount(discountAmount);
        billAmountInfo.setExChangeRate(exChangeRate);
        billAmountInfo.setSettlePricePrecision(settlePricePrecision);
        billAmountInfo.setSettleAmtPrecision(settleAmtPrecision);
        billAmountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
        billAmountInfo.setIndirectExRate(isIndirectRate);
        Map amountInfoMap = BillAmountHelper.calAmount((BillAmountInfo)billAmountInfo, (Boolean)isCalDiscountRate);
        model.beginInit();
        if (this.isBackCalculate()) {
            model.setValue("price", amountInfoMap.get("price"), rowIndex);
            model.setValue("priceandtax", amountInfoMap.get("priceandtax"), rowIndex);
        } else if (isTax) {
            model.setValue("price", amountInfoMap.get("price"), rowIndex);
        } else {
            model.setValue("priceandtax", amountInfoMap.get("priceandtax"), rowIndex);
        }
        BigDecimal amount = (BigDecimal)amountInfoMap.get("amount");
        BigDecimal taxAmount = (BigDecimal)amountInfoMap.get("taxamount");
        BigDecimal amountAndTax = (BigDecimal)amountInfoMap.get("amountandtax");
        model.setValue("amount", (Object)amount, rowIndex);
        model.setValue("taxamount", (Object)taxAmount, rowIndex);
        model.setValue("amountandtax", (Object)amountAndTax, rowIndex);
        model.setValue("discountamount", amountInfoMap.get("discountamount"), rowIndex);
        model.setValue("discountrate", amountInfoMap.get("discountrate"), rowIndex);
        model.endInit();
        this.getView().updateView("price", rowIndex);
        this.getView().updateView("priceandtax", rowIndex);
        this.getView().updateView("amount", rowIndex);
        this.getView().updateView("taxamount", rowIndex);
        this.getView().updateView("discountamount", rowIndex);
        this.getView().updateView("discountrate", rowIndex);
        this.getView().updateView("amountandtax", rowIndex);
        this.calcTotalAmount();
    }

    private void calcTotalAmount() {
        IDataModel model = this.getModel();
        for (Map.Entry entry : AmountHelper.calcTotalAmount((DynamicObject)model.getDataEntity(true)).entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    public static void setRedColumn(IFormView view, String[] redColumns, String entryName) {
        String redColor = "#ff0000";
        PurAcceptBillPlugin.setColumsColor(redColor, view, redColumns, entryName);
    }

    public static void setColumsColor(String redColor, IFormView view, String[] redColumns, String entryName) {
        EntryGrid grid = (EntryGrid)view.getControl(entryName);
        for (String redColumn : redColumns) {
            grid.setColumnProperty(redColumn, "fc", (Object)redColor);
        }
    }

    private void setInverse() {
        DynamicObject biztype = (DynamicObject)this.getModel().getValue("biztype");
        if (biztype == null) {
            return;
        }
        String number = biztype.getString("number");
        if (number != null && ("1131".equals(number) || "1132".equals(number)) || "1121".equals(number)) {
            this.setInverseValues(this.getModel(), PurAcceptBillConst.getEntryRedColumns(), BILLENTRY);
            this.setInverseValues(this.getModel(), PurAcceptBillConst.getAllRedColumns(), "allocationentry");
            this.setInverseValues(this.getModel(), PurAcceptBillConst.getBillRedColumns(), BILL);
        }
        EntryGrid billentry = (EntryGrid)this.getControl(BILLENTRY);
        billentry.summary();
        EntryGrid allocationEntry = (EntryGrid)this.getControl("allocationentry");
        allocationEntry.summary();
    }

    private void setInverseValues(IDataModel model, String[] needInverseColumns, String entityName) {
        this.getPageCache().put(STOPCHANGE, "true");
        if (BILL.equals(entityName)) {
            for (String column : needInverseColumns) {
                BigDecimal value = (BigDecimal)model.getValue(column);
                if (value == null) {
                    value = BigDecimal.ZERO;
                }
                model.setValue(column, (Object)value.abs());
            }
        } else {
            DynamicObjectCollection entrys = model.getEntryEntity(entityName);
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                for (String column : needInverseColumns) {
                    BigDecimal value = ((DynamicObject)entrys.get(i)).getBigDecimal(column);
                    if (value == null) {
                        value = BigDecimal.ZERO;
                    }
                    model.setValue(column, (Object)value.abs(), i);
                }
            }
        }
        this.getPageCache().put(STOPCHANGE, "false");
    }

    private void changeRecoPerotor(Object newValue) {
        DynamicObject bizuser;
        Long userID;
        Long deptID = null;
        this.getModel().beginInit();
        if (newValue instanceof DynamicObject && (userID = (Long)(bizuser = (DynamicObject)newValue).getPkValue()) != null) {
            deptID = UserServiceHelper.getUserMainOrgId((long)userID);
        }
        this.getModel().endInit();
        this.getView().updateView("recoperator");
        this.getModel().setValue("recdept", deptID);
    }

    private boolean isBackCalculate() {
        Boolean inputamount = Boolean.FALSE;
        if (this.getControl("inputamount") != null) {
            inputamount = (Boolean)this.getModel().getValue("inputamount");
        }
        return inputamount;
    }

    private void setDiscountRateScale(Object newValue) {
        int priceRecision = 4;
        if (newValue instanceof DynamicObject) {
            DynamicObject settleCurrency = (DynamicObject)newValue;
            priceRecision = settleCurrency.getInt(CUR_PRICEPRECISION);
        }
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(BILLENTRY, "setColEditorProp", new Object[]{"discountrate", "sc", priceRecision});
    }
}

