/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.BatXBillHelper;
import kd.mpscmm.msbd.changemodel.common.enums.BatChangeStatusEnum;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.enums.BizCancelStatusEnum;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.StatusEnum;

public class BatXPurApplyBillPlugin
extends AbstractBillPlugIn
implements EntryGridBindDataListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"xsbillno"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBatChangeBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return;
        }
        block8: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            switch (fieldKey) {
                case "afterqty": {
                    this.changeAfterQty((BigDecimal)newValue, rowIndex);
                    continue block8;
                }
                case "xsbillno": {
                    if (!StringUtils.isBlank((Object)newValue)) continue block8;
                    this.getPageCache().put("stopChange", "true");
                    this.getModel().setValue("xsbillentryid", null);
                    this.getModel().setValue("xsbillid", null);
                    this.getModel().setValue("xsbillentryseq", null);
                    this.getModel().setValue("entryoperator", null);
                    this.getModel().setValue("entryoperatorgroup", null);
                    this.getModel().setValue("supplier", null);
                    this.getModel().setValue("auxpty", null);
                    this.getModel().setValue("entrycomment", null);
                    this.getModel().setValue("material", null);
                    this.getModel().setValue("materialname", null);
                    this.getModel().setValue("afterqty", (Object)BigDecimal.ZERO);
                    this.getModel().setValue("unit", null);
                    this.getModel().setValue("baseunit", null);
                    this.getModel().setValue("baseqty", null);
                    this.getModel().setValue("qty", (Object)BigDecimal.ZERO);
                    this.getModel().setValue("afterbaseqty", (Object)BigDecimal.ZERO);
                    this.getModel().setValue("baseqty", (Object)BigDecimal.ZERO);
                    this.getModel().setValue("reqdate", null);
                    this.getModel().setValue("afterreqdate", null);
                    this.getModel().setValue("srcbillentity", null);
                    this.getModel().setValue("srcbillentryid", null);
                    this.getModel().setValue("srcbillentryseq", null);
                    this.getModel().setValue("srcbillid", null);
                    this.getModel().setValue("srcbillnumber", null);
                    this.getModel().setValue("entrycomment", null);
                    this.getPageCache().put("stopChange", "false");
                    continue block8;
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equalsIgnoreCase("xsbillno")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBatChangeBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long orgId = (Long)org.getPkValue();
            ArrayList<Long> entryPks = new ArrayList<Long>(8);
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entrys) {
                Long entryId = entry.getLong("xsbillentryid");
                if (entryId == 0L) continue;
                entryPks.add(entry.getLong("xsbillentryid"));
            }
            QFilter q = new QFilter("entryentity.changestatus", "=", (Object)BatChangeStatusEnum.NORMAL.getValue());
            Object pkId = this.getModel().getDataEntity().getPkValue();
            if (pkId != null) {
                QFilter q1 = new QFilter("id", "!=", pkId);
                q.and(q1);
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_batxpurapplybill", (String)"entryentity.xsbillentryid xsbillentryid", (QFilter[])new QFilter[]{q}, null);){
                if (ds != null) {
                    for (Row row : ds) {
                        entryPks.add(row.getLong("xsbillentryid"));
                    }
                }
            }
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pm_purapplybill_bclayout", (boolean)true);
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            listShowParameter.setUseOrgId(orgId.longValue());
            listShowParameter.setUseOrgIds(Collections.singletonList(orgId));
            filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
            filters.add(new QFilter("changestatus", "not in", Arrays.asList("B", "B1")));
            filters.add(new QFilter("closestatus", "!=", (Object)BizCloseStatusEnum.CLOSE.getValue()));
            filters.add(new QFilter("cancelstatus", "!=", (Object)BizCancelStatusEnum.CANCEL.getValue()));
            filters.add(new QFilter("org", "=", (Object)orgId));
            filters.add(new QFilter("billentry.rowclosestatus", "!=", (Object)RowCloseStatusEnum.ROWCLOSE.getValue()));
            filters.add(new QFilter("billentry.id", "not in", entryPks));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "batchange_callback");
            listShowParameter.setCloseCallBack(closeCallBack);
            listShowParameter.setCustomParam("ismergerows", (Object)Boolean.FALSE);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("batchange_callback".equals(actionId) && (returnData = (ListSelectedRowCollection)e.getReturnData()) != null) {
            BatXBillHelper.addEntrysByReturnData((IDataModel)this.getModel(), (ListSelectedRowCollection)returnData);
            this.getView().updateView("entryentity");
        }
    }

    private void changeAfterQty(BigDecimal newValue, int rowIndex) {
        DynamicObject master;
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
        DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
        DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
        DynamicObject dynamicObject = master = material == null ? null : material.getDynamicObject("masterid");
        if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
            model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
        }
        if (baseUnit != null && master != null && unit != null) {
            BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)master.getPkValue()), (DynamicObject)unit, (BigDecimal)newValue, (DynamicObject)baseUnit);
            model.setValue("afterbaseqty", (Object)baseQty, rowIndex);
        }
    }
}

