/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.apply;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.AppParameterHelper;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.BizCategoryHelper;
import kd.scmc.pm.business.helper.CurrencyHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.business.helper.PurApplyBillHelper;
import kd.scmc.pm.business.pojo.AmountInfo;
import kd.scmc.pm.enums.StatusEnum;

public class PurApplyBillImportPlugin
extends AbstractFormPlugin {
    private final BigDecimal ZERO = BigDecimal.ZERO;
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        BillImportHelper.billCreTypeFlag((IPageCache)pageCache, (List)sourceDataList);
        IDataModel model = (IDataModel)e.getSource();
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null) {
            hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)model.getDataEntityType().getName(), (String)"02");
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype) && !BillImportHelper.isAPI((String)billcretype)) {
            return;
        }
        DynamicObject org = this.getBaseDataFromCache(e.getSourceData(), "org", "bos_org", null, null);
        if (org == null) {
            return;
        }
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null || !hasPermissionOrg.contains(org.getPkValue())) {
            Map propMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("org"));
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"PurApplyBillImportPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
            e.setFireAfterImportData(false);
            return;
        }
        Map billEntry = BillImportHelper.format4ImportAndApi(e.getSourceData().get("billentry"));
        if (billEntry != null) {
            List sourceData = (List)billEntry.get("sourceData");
            block0: for (Map enrty : sourceData) {
                QFilter operatorgroupOrgFilter;
                Map operatorGroupMap = BillImportHelper.format4ImportAndApi(enrty.get("entryoperatorgroup"));
                Map operatorMap = BillImportHelper.format4ImportAndApi(enrty.get("entryoperator"));
                if (operatorGroupMap != null && operatorMap != null) {
                    operatorgroupOrgFilter = this.getBaseDataOrgFilterFromCache(org, "operatorgroup", "bd_operatorgroup");
                    DynamicObject operatorGroup = this.getBaseDataFromCache(enrty, "entryoperatorgroup", "bd_operatorgroup", "id,operatornumber,operatorname", new QFilter[]{new QFilter((String)operatorGroupMap.get("importprop"), "=", operatorGroupMap.get(operatorGroupMap.get("importprop"))), operatorgroupOrgFilter});
                    if (operatorGroup == null || operatorMap.get(operatorMap.get("importprop")) == null) continue;
                    DynamicObjectCollection entryentity = operatorGroup.getDynamicObjectCollection("entryentity");
                    for (DynamicObject operator : entryentity) {
                        if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) continue;
                        HashMap<String, Object> newOperator = new HashMap<String, Object>();
                        newOperator.put("id", operator.getPkValue());
                        enrty.put("entryoperator", newOperator);
                        continue block0;
                    }
                    continue;
                }
                if (operatorMap == null) continue;
                operatorgroupOrgFilter = this.getBaseDataOrgFilterFromCache(org, "operatorgroup", "bd_operatorgroup");
                QFilter operatorgroupTypeFilter = new QFilter("operatorgrouptype", "=", (Object)"CGZ");
                Map operatorgroups = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,operatornumber,operatorname", (QFilter[])new QFilter[]{operatorgroupOrgFilter, operatorgroupTypeFilter});
                block2: for (DynamicObject operatorGroup : operatorgroups.values()) {
                    DynamicObjectCollection entryentity = operatorGroup.getDynamicObjectCollection("entryentity");
                    for (DynamicObject operator : entryentity) {
                        if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) continue;
                        HashMap<String, Object> newOperator = new HashMap<String, Object>();
                        newOperator.put("id", operator.getPkValue());
                        enrty.put("entryoperator", newOperator);
                        HashMap<String, Object> newOperatorGroup = new HashMap<String, Object>();
                        newOperatorGroup.put("id", operatorGroup.getPkValue());
                        enrty.put("entryoperatorgroup", newOperatorGroup);
                        continue block2;
                    }
                }
            }
        }
        if (BillImportHelper.isImport((String)billcretype)) {
            Map supplierMap;
            QFilter supplierOrgFilter;
            DynamicObject billtype = this.getBaseDataFromCache(e.getSourceData(), "billtype", "bos_billtype", "billformid", null);
            if (billtype == null) {
                return;
            }
            String formId = this.getView().getFormShowParameter().getFormId();
            if (!billtype.getDynamicObject("billformid").getPkValue().equals(formId)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u7b26\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"PurApplyBillImportPlugin_8", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
            }
            Map billtypeMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("billtype"));
            DynamicObject billtypeparameter = (DynamicObject)this.tempCache.get("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")));
            if (billtype != null && billtypeparameter == null) {
                billtypeparameter = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)"pm_purapplybill", (String)"pm_billtypeparameter", (long)((Long)billtype.getPkValue()));
                this.tempCache.put("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")), billtypeparameter);
            }
            if ((supplierOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_supplierOrgFilter")) == null) {
                supplierOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)org.getPkValue()));
                this.tempCache.put(org.getPkValue() + "_supplierOrgFilter", supplierOrgFilter);
            }
            if ((supplierMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("supplier"))) != null) {
                DynamicObject supplier = this.getBaseDataFromCache(e.getSourceData(), "supplier", "bd_supplier", "id,enablevmi", new QFilter[]{new QFilter((String)supplierMap.get("importprop"), "=", supplierMap.get(supplierMap.get("importprop"))), supplierOrgFilter});
                if (supplier == null) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%1$s\u201d\u4e0d\u5728\u8be5\u91c7\u8d2d\u7ec4\u7ec7\u7684\u4f7f\u7528\u8303\u56f4\u5185\u3002", (String)"PurApplyBillImportPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]), supplierMap.get(supplierMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
                DynamicObject bizType = this.getBaseDataFromCache(e.getSourceData(), "biztype", "bd_biztype", null, null);
                if (bizType != null && BizCategoryHelper.isVMI((Long)((Long)bizType.getPkValue())) && !supplier.getBoolean("enablevmi")) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u201c\u53efVMI\u201d\u7684\u4f9b\u5e94\u5546\u3002", (String)"PurApplyBillImportPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]), supplierMap.get(supplierMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        IDataModel model = this.getModel();
        if (BillImportHelper.isAPI((String)billcretype)) {
            DynamicObject bill = model.getDataEntity(true);
            PurApplyBillHelper.completeBillInfo(Collections.singletonList(bill));
        } else if (BillImportHelper.isImport((String)billcretype)) {
            Long lineTypeId;
            model.setValue("billcretype", (Object)"1");
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (org == null) {
                return;
            }
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            DynamicObject billType = (DynamicObject)model.getValue("billtype");
            DynamicObject bizType = (DynamicObject)model.getValue("biztype");
            model.setValue("billstatus", (Object)StatusEnum.SAVE.getValue());
            if (billType != null && bizType == null) {
                Long bizTypeId = (Long)this.tempCache.get(billType.getPkValue() + "-biztype");
                if (bizTypeId == null && (bizTypeId = BizTypeHelper.getDefaultBizType((String)"pm_purapplybill", (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter")) != null) {
                    this.tempCache.put(billType.getPkValue() + "-biztype", bizTypeId);
                }
                if (bizTypeId != null) {
                    model.setValue("biztype", (Object)bizTypeId);
                }
            }
            DynamicObject defaultLineType = null;
            bizType = (DynamicObject)model.getValue("biztype");
            if (bizType != null && (lineTypeId = BizTypeHelper.getDefaultLineType((Long)((Long)bizType.getPkValue()))) != null) {
                defaultLineType = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype");
            }
            if (currency == null) {
                Map currencyMap = (Map)this.tempCache.get(org.getPkValue() + "-currencyMap");
                if (currencyMap == null) {
                    currencyMap = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
                    if (currencyMap != null) {
                        this.tempCache.put(org.getPkValue() + "-currencyMap", currencyMap);
                        model.setValue("currency", currencyMap.get("baseCurrencyID"));
                    }
                } else {
                    model.setValue("currency", currencyMap.get("baseCurrencyID"));
                }
            }
            BigDecimal totalAmount = this.ZERO;
            String entityName = model.getDataEntityType().getName();
            DynamicObjectCollection billentrys = (DynamicObjectCollection)model.getValue("billentry");
            if (billentrys != null) {
                Long orgId = (Long)org.getPkValue();
                boolean isUpApply = false;
                if (!entityName.equals("pm_purplanbill")) {
                    if (this.tempCache.containsKey(orgId + "Operator")) {
                        isUpApply = (Boolean)this.tempCache.get(orgId + "Operator");
                    } else {
                        Object isUpApplyObj = AppParameterHelper.getPmAppParameter((Long)orgId, (String)"purapplyfitoperator");
                        if (isUpApplyObj instanceof Boolean) {
                            isUpApply = (Boolean)isUpApplyObj;
                            this.tempCache.put(orgId + "Operator", (Boolean)isUpApplyObj);
                        }
                    }
                    if (isUpApply) {
                        Map operatorMap;
                        HashSet<Long> materialNumber = new HashSet<Long>(billentrys.size());
                        for (Object billEntry : billentrys) {
                            DynamicObject dynamicObject2 = billEntry.getDynamicObject("material");
                            dynamicObject2 = dynamicObject2 == null ? null : dynamicObject2.getDynamicObject("masterid");
                            if (dynamicObject2 == null) continue;
                            Long materialId = (Long)dynamicObject2.getPkValue();
                            String OperatorKey = String.valueOf(orgId) + materialId;
                            if (this.tempCache.containsKey(OperatorKey)) continue;
                            materialNumber.add(materialId);
                        }
                        if (materialNumber.size() > 0 && (operatorMap = PurApplyBillHelper.getMaterialFitOperatorNew((Long)orgId, materialNumber)) != null && operatorMap.size() > 0) {
                            for (Map.Entry entry : operatorMap.entrySet()) {
                                this.tempCache.put(String.valueOf(orgId) + entry.getKey(), entry.getValue());
                            }
                        }
                    }
                }
                for (DynamicObject billentry : billentrys) {
                    Object isUpApplyObj;
                    int index = billentry.getInt("seq") - 1;
                    DynamicObject dynamicObject = billentry.getDynamicObject("material");
                    if (dynamicObject == null || dynamicObject.getDynamicObject("masterid") == null) break;
                    DynamicObject lineType = billentry.getDynamicObject("linetype");
                    if (lineType == null && defaultLineType != null) {
                        billentry.set("linetype", (Object)defaultLineType);
                    }
                    DynamicObject materialMasterId = dynamicObject.getDynamicObject("masterid");
                    model.setValue("materialmasterid", materialMasterId.getPkValue(), index);
                    boolean isdisposable = materialMasterId.getBoolean("isdisposable");
                    if (StringUtils.isBlank((CharSequence)billentry.getString("materialname")) || !isdisposable) {
                        billentry.set("materialname", (Object)materialMasterId.getLocaleString("name").toString());
                    }
                    billentry.set("baseunit", (Object)dynamicObject.getDynamicObject("masterid").getDynamicObject("baseunit"));
                    billentry.set("auxunit", (Object)dynamicObject.getDynamicObject("masterid").getDynamicObject("auxptyunit"));
                    DynamicObject unit = billentry.getDynamicObject("unit");
                    DynamicObject baseunit = billentry.getDynamicObject("baseunit");
                    if (unit == null) {
                        unit = dynamicObject.getDynamicObject("purchaseunit");
                        billentry.set("unit", (Object)unit);
                    }
                    if (unit != null && baseunit != null) {
                        if (unit.getPkValue().equals(baseunit.getPkValue())) {
                            billentry.set("baseqty", (Object)billentry.getBigDecimal("applyqty"));
                        } else {
                            billentry.set("baseqty", (Object)BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)dynamicObject.getDynamicObject("masterid").getPkValue()), (DynamicObject)unit, (BigDecimal)billentry.getBigDecimal("applyqty"), (DynamicObject)baseunit));
                        }
                    }
                    AmountInfo amountInfo = new AmountInfo();
                    if (model.getValue("istax") == null) {
                        amountInfo.setTax(true);
                    } else {
                        amountInfo.setTax(((Boolean)model.getValue("istax")).booleanValue());
                    }
                    amountInfo.setQty(billentry.getBigDecimal("applyqty"));
                    amountInfo.setPrice(billentry.getBigDecimal("price"));
                    amountInfo.setPriceAndTax(billentry.getBigDecimal("priceandtax"));
                    amountInfo.setCurrencyAmtPrecision(((DynamicObject)model.getValue("currency")).getInt("amtprecision"));
                    amountInfo.setSettleAmtPrecision(((DynamicObject)model.getValue("currency")).getInt("amtprecision"));
                    amountInfo.setSettlePricePrecision(((DynamicObject)model.getValue("currency")).getInt("priceprecision"));
                    DynamicObject taxRateId = billentry.getDynamicObject("taxrateid");
                    if (taxRateId == null) {
                        amountInfo.setTaxRate(this.ZERO);
                        billentry.set("taxrate", (Object)this.ZERO);
                    } else {
                        BigDecimal taxRate = taxRateId.getBigDecimal("taxrate");
                        amountInfo.setTaxRate(taxRate);
                        billentry.set("taxrate", (Object)taxRate);
                    }
                    amountInfo = AmountHelper.getAmount((AmountInfo)amountInfo);
                    billentry.set("price", (Object)amountInfo.getPrice());
                    billentry.set("qty", (Object)billentry.getBigDecimal("applyqty"));
                    billentry.set("priceandtax", (Object)amountInfo.getPriceAndTax());
                    billentry.set("taxamount", (Object)amountInfo.getTaxAmount());
                    billentry.set("amount", (Object)amountInfo.getAmount());
                    billentry.set("amountandtax", (Object)amountInfo.getAmountAndTax());
                    totalAmount = totalAmount.add(amountInfo.getAmountAndTax());
                    DynamicObject entryoperator = billentry.getDynamicObject("entryoperator");
                    DynamicObject entryoperatorgroup = billentry.getDynamicObject("entryoperatorgroup");
                    if (entryoperator == null && entryoperatorgroup == null && billentry.get("entryoperator") == null && billentry.get("entryoperatorgroup") == null && (isUpApplyObj = this.tempCache.get(orgId + "Operator")) instanceof Boolean && ((Boolean)isUpApplyObj).booleanValue() && !entityName.equals("pm_purplanbill")) {
                        Long number = (Long)materialMasterId.getPkValue();
                        String OperatorKey = String.valueOf(orgId) + number;
                        Object materFitOpeInfoObj = this.tempCache.get(OperatorKey);
                        if (materFitOpeInfoObj instanceof Map) {
                            Map materFitOpeInfo = (Map)materFitOpeInfoObj;
                            billentry.set("entryoperator_id", materFitOpeInfo.get("operator"));
                            billentry.set("entryoperatorgroup_id", materFitOpeInfo.get("operatorgroup"));
                        }
                    }
                    ++index;
                }
                model.setValue("totalallamount", (Object)totalAmount);
            }
        }
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map propMap = BillImportHelper.format4ImportAndApi((Object)sourceData.get(propName));
        String importProp = null;
        if (propMap != null) {
            importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }

    private QFilter getBaseDataOrgFilterFromCache(DynamicObject org, String propName, String propEntityName) {
        QFilter baseDataOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_" + propName + "OrgFilter");
        if (baseDataOrgFilter == null) {
            baseDataOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)propEntityName, (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_" + propName + "OrgFilter", baseDataOrgFilter);
        }
        return baseDataOrgFilter;
    }
}

