/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.PurApplyMalHelper;
import kd.scmc.pm.business.pojo.AmountInfo;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.provider.MateriaListDataProvider;
import kd.scmc.pm.utils.CommonUtils;

public class PurApplyBillListPlugin
extends AbstractListPlugin {
    private static final int SETTLEMAXBILLCOUNT = 10000;
    private static final String CUR_AMTPRECISION = "amtprecision";
    private static final String CUR_PRICEPRECISION = "priceprecision";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (args.getListSelectedData() == null || args.getListSelectedData().size() == 0) {
            return;
        }
        switch (operateKey) {
            case "quota": {
                HashSet<Long> purApplybillids = new HashSet<Long>(16);
                for (ListSelectedRow listSelectedRow : args.getListSelectedData()) {
                    purApplybillids.add((Long)listSelectedRow.getPrimaryKeyValue());
                }
                if (purApplybillids.size() > 10000) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u989d\u4e0b\u5355\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u7f29\u5c0f\u8303\u56f4\u3002", (String)"PurApplyBillListPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter pkFilter = new QFilter("id", "in", purApplybillids);
                DynamicObjectCollection purApplyBills = QueryServiceHelper.query((String)"pm_purapplybill", (String)"billstatus,closestatus,billno,billtype,org", (QFilter[])new QFilter[]{pkFilter});
                if (purApplyBills == null || purApplyBills.size() == 0) {
                    return;
                }
                DynamicObject oneBill = (DynamicObject)purApplyBills.get(0);
                Long firstOrgId = oneBill.get("org") == null ? Long.valueOf(0L) : (Long)oneBill.get("org");
                Long firstBillTypeId = oneBill.get("billtype") == null ? Long.valueOf(0L) : (Long)oneBill.get("billtype");
                for (DynamicObject bill : purApplyBills) {
                    Long currentBillTypeId;
                    Long currentOrgId = bill.get("org") == null ? Long.valueOf(0L) : (Long)bill.get("org");
                    Long l = currentBillTypeId = bill.get("billtype") == null ? Long.valueOf(0L) : (Long)bill.get("billtype");
                    if (currentOrgId != null && currentBillTypeId != null && firstBillTypeId.equals(currentBillTypeId) && firstOrgId.equals(currentOrgId)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7533\u8bf7\u7ec4\u7ec7\u201d\u548c\u201c\u5355\u636e\u7c7b\u578b\u201d\u5747\u76f8\u540c\u7684\u91c7\u8d2d\u7533\u8bf7\u5355\u3002", (String)"PurApplyBillListPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<String> errorList = new ArrayList<String>();
                for (DynamicObject bill : purApplyBills) {
                    String billStatus = bill.getString("billstatus");
                    String closeStatus = bill.getString("closestatus");
                    String billNo = bill.getString("billno");
                    if (StatusEnum.AUDIT.getValue().equals(billStatus) && !BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) continue;
                    errorList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u4e0d\u7b26\u5408\u914d\u989d\u4e0b\u5355\u6761\u4ef6\u3002", (String)"PurApplyBillListPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]), billNo));
                }
                if (errorList.size() > 0) {
                    this.getView().showConfirm(StringUtils.strip((String)((Object)errorList).toString(), (String)"[]").replace(",", ""), MessageBoxOptions.None);
                    return;
                }
                this.showQuotaPushOrderForm(firstOrgId, firstBillTypeId, purApplybillids);
                break;
            }
            case "malpurchase": {
                this.beforeMalPurchase(args);
                break;
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new MateriaListDataProvider("billentry.materialname", "billentry.material"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "malpurchase": {
                this.showMalPurchase(afterDoOperationEventArgs);
                break;
            }
            case "showmalorder": {
                this.showMalOrder(afterDoOperationEventArgs);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String clickKey;
        super.itemClick(evt);
        switch (clickKey = evt.getItemKey()) {
            case "bar_billexecquery": {
                this.showBillExecForm();
            }
        }
    }

    private void beforeMalPurchase(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (listSelectedData == null) {
            return;
        }
        List selectedIdMaps = listSelectedData.getPKEntryIdValues();
        if (selectedIdMaps == null) {
            return;
        }
        HashMap<String, ArrayList<String>> paramMap = new HashMap<String, ArrayList<String>>(16);
        for (Map idMap : selectedIdMaps) {
            for (Map.Entry entry : idMap.entrySet()) {
                Long billId = (Long)entry.getKey();
                Long entryId = (Long)entry.getValue();
                if (billId == null || entryId == null) continue;
                String billIdStr = billId.toString();
                ArrayList<String> entryIds = (ArrayList<String>)paramMap.get(billIdStr);
                if (entryIds == null) {
                    entryIds = new ArrayList<String>();
                }
                entryIds.add(entryId.toString());
                paramMap.put(billIdStr, entryIds);
            }
        }
        PurApplyMalHelper.beforeMalPurchase((EventObject)args, paramMap);
    }

    private void showMalPurchase(AfterDoOperationEventArgs args) {
        FormShowParameter showParameter = PurApplyMalHelper.getMalPurchaseShowParameter((EventObject)args);
        if (showParameter != null) {
            this.getView().showForm(showParameter);
        }
    }

    private void showMalOrder(AfterDoOperationEventArgs args) {
        FormShowParameter showParameter = PurApplyMalHelper.getMalOrderShowParameter((EventObject)args);
        if (showParameter != null) {
            this.getView().showForm(showParameter);
        }
    }

    private List<DynamicObject> reCalQtyAndAmount(DynamicObject[] bills) {
        ArrayList<DynamicObject> saveBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject purApply : bills) {
            if (purApply == null) continue;
            boolean flag = false;
            boolean isTax = purApply.getBoolean("istax");
            DynamicObject currency = purApply.getDynamicObject("currency");
            int currencyAmtPrecision = currency == null ? 10 : currency.getInt(CUR_AMTPRECISION);
            int currencyPricePrecision = currency == null ? 10 : currency.getInt(CUR_PRICEPRECISION);
            BigDecimal totalAllAmountOld = purApply.getBigDecimal("totalallamount");
            BigDecimal totalAllAmount = BigDecimal.ZERO;
            DynamicObjectCollection entrys = purApply.getDynamicObjectCollection("billentry");
            if (entrys != null && !entrys.isEmpty()) {
                DataEntityPropertyCollection properties = ((DynamicObject)entrys.get(0)).getDynamicObjectType().getProperties();
                DynamicProperty applyQtyP = (DynamicProperty)properties.get((Object)"applyqty");
                DynamicProperty qtyP = (DynamicProperty)properties.get((Object)"qty");
                DynamicProperty priceP = (DynamicProperty)properties.get((Object)"price");
                DynamicProperty priceAndTaxP = (DynamicProperty)properties.get((Object)"priceandtax");
                DynamicProperty taxRateP = (DynamicProperty)properties.get((Object)"taxrate");
                DynamicProperty amountP = (DynamicProperty)properties.get((Object)"amount");
                DynamicProperty taxAmountP = (DynamicProperty)properties.get((Object)"taxamount");
                DynamicProperty amountAndTaxP = (DynamicProperty)properties.get((Object)"amountandtax");
                for (DynamicObject entry : entrys) {
                    BigDecimal applyQty = (BigDecimal)applyQtyP.getValueFast((Object)entry);
                    BigDecimal qty = (BigDecimal)qtyP.getValueFast((Object)entry);
                    if (applyQty == null || applyQty.compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal amountAndTax = (BigDecimal)amountAndTaxP.getValueFast((Object)entry);
                    if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
                        flag = true;
                        qtyP.setValueFast((Object)entry, (Object)applyQty);
                        BigDecimal price = (BigDecimal)priceP.getValueFast((Object)entry);
                        BigDecimal priceAndTax = (BigDecimal)priceAndTaxP.getValueFast((Object)entry);
                        BigDecimal taxRate = (BigDecimal)taxRateP.getValueFast((Object)entry);
                        AmountInfo amountInfo = new AmountInfo();
                        amountInfo.setTax(isTax);
                        amountInfo.setQty(applyQty);
                        amountInfo.setPrice(price);
                        amountInfo.setPriceAndTax(priceAndTax);
                        amountInfo.setTaxRate(taxRate);
                        amountInfo.setSettlePricePrecision(currencyPricePrecision);
                        amountInfo.setSettleAmtPrecision(currencyAmtPrecision);
                        amountInfo = AmountHelper.getAmount((AmountInfo)amountInfo);
                        if (isTax) {
                            priceP.setValueFast((Object)entry, (Object)amountInfo.getPrice());
                        } else {
                            priceAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getPriceAndTax());
                        }
                        amountP.setValueFast((Object)entry, (Object)amountInfo.getAmount());
                        taxAmountP.setValueFast((Object)entry, (Object)amountInfo.getTaxAmount());
                        amountAndTax = amountInfo.getAmountAndTax();
                        amountAndTaxP.setValueFast((Object)entry, (Object)amountAndTax);
                    }
                    if (amountAndTax == null) continue;
                    totalAllAmount = totalAllAmount.add(amountAndTax);
                }
                if (totalAllAmountOld == null || totalAllAmountOld.compareTo(totalAllAmount) != 0) {
                    purApply.set("totalallamount", (Object)totalAllAmount);
                }
            }
            if (!flag) continue;
            saveBills.add(purApply);
        }
        return saveBills;
    }

    private void showQuotaPushOrderForm(Long orgId, Long billTypeId, Set<Long> purApplybillids) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("org", orgId);
        param.put("billtype", billTypeId);
        param.put("ispurapplybill", Boolean.TRUE);
        param.put("billids", new ArrayList<Long>(purApplybillids));
        FormShowParameter quotaPushOrderForm = new FormShowParameter();
        quotaPushOrderForm.setFormId("pm_quotaorder");
        quotaPushOrderForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        quotaPushOrderForm.setCustomParams(param);
        this.getView().showForm(quotaPushOrderForm);
    }

    private void showBillExecForm() {
        ListSelectedRowCollection selectRows = ((IListView)this.getView()).getSelectedRows();
        if (CommonUtils.isNull((Object)selectRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurOrderBillListPlugin_8", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter IDFilter = new QFilter("id", "in", selectRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList()));
        DynamicObjectCollection billList = QueryServiceHelper.query((String)"pm_purapplybill", (String)"id,biztime,org", (QFilter[])new QFilter[]{IDFilter, statusFilter});
        if (CommonUtils.isNull((Object)billList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6682\u65e0\u6570\u636e\u3002", (String)"PurOrderBillListPlugin_10", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowCount = billList.size();
        ArrayList<Long> ids = new ArrayList<Long>(rowCount);
        ArrayList<Long> orgList = new ArrayList<Long>(rowCount);
        Date minDate = null;
        Date maxDate = null;
        for (DynamicObject bill : billList) {
            ids.add(bill.getLong("id"));
            orgList.add(bill.getLong("org"));
            Date billDate = bill.getDate("biztime");
            if (null == minDate) {
                minDate = billDate;
            } else if (minDate.compareTo(billDate) > 0) {
                minDate = billDate;
            }
            if (null == maxDate) {
                maxDate = billDate;
                continue;
            }
            if (billDate.compareTo(maxDate) <= 0) continue;
            maxDate = billDate;
        }
        if (orgList.stream().distinct().count() > 1L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u8de8\u7ec4\u7ec7\u67e5\u8be2\u3002", (String)"PurOrderBillListPlugin_9", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportShowParameter formParam = new ReportShowParameter();
        formParam.setFormId("pm_purapplyrpt");
        formParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("selectbill", ids);
        filter.addFilterItem("headorg", orgList.get(0));
        filter.addFilterItem("startdate", (Object)minDate);
        filter.addFilterItem("enddate", (Object)maxDate);
        formParam.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)formParam);
    }
}

