/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.AppParameterHelper;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.BizCategoryHelper;
import kd.scmc.pm.business.helper.MaterialHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.business.helper.PurApplyBillHelper;
import kd.scmc.pm.business.helper.PurApplyMalHelper;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.business.pojo.AmountInfo;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.enums.UnitConvertDirEnum;

public class PurApplyBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
ItemClickListener {
    private final Log log = LogFactory.getLog(PurApplyBillPlugin.class);
    private final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String BILLEXECRPT = "pm_purapplyrpt";
    private static final String CUR_AMTPRECISION = "amtprecision";
    private static final String CUR_PRICEPRECISION = "priceprecision";

    public void registerListener(EventObject e) {
        BasedataEdit configuredCode;
        BasedataEdit dept;
        Toolbar tbMainEntry;
        BasedataEdit projectEdit;
        BasedataEdit supplier;
        BasedataEdit operator = (BasedataEdit)this.getView().getControl("entryoperator");
        if (operator != null) {
            operator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((projectEdit = (BasedataEdit)this.getView().getControl("project")) != null) {
            projectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tbMainEntry = (Toolbar)this.getView().getControl("tbmainentry")) != null) {
            tbMainEntry.addItemClickListener((ItemClickListener)this);
        }
        Toolbar tbMain = (Toolbar)this.getView().getControl("tbmain");
        if (tbMainEntry != null) {
            tbMain.addItemClickListener((ItemClickListener)this);
        }
        if ((dept = (BasedataEdit)this.getView().getControl("dept")) != null) {
            dept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((configuredCode = (BasedataEdit)this.getControl("configuredcode")) != null) {
            configuredCode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        int entryRowCount = model.getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.initNewDataEntry(orgId, i);
        }
        DynamicObject bizUser = (DynamicObject)model.getValue("bizuser");
        if (!CommonUtils.isNull((Object)bizUser)) {
            long userId = (Long)bizUser.getPkValue();
            Long deptId = UserServiceHelper.getUserMainOrgId((long)userId);
            model.setValue("dept", (Object)deptId);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.initNewDataEntry(orgId, rowIndex);
            }
        }
        this.calcTotalAmount();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            this.calcTotalAmount();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        block29: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldKey) {
                case "entryoperator": {
                    this.changeOperator(newValue, rowIndex);
                    continue block29;
                }
                case "material": {
                    this.changeMaterial(oldValue, newValue, rowIndex);
                    continue block29;
                }
                case "unit": {
                    this.changeUnit(newValue, rowIndex);
                    continue block29;
                }
                case "applyqty": {
                    this.changeApplyQty(newValue, rowIndex);
                    continue block29;
                }
                case "qty": {
                    this.changeQty(newValue, rowIndex);
                    continue block29;
                }
                case "auxqty": {
                    this.changeAuxQty(newValue, rowIndex);
                    continue block29;
                }
                case "price": 
                case "priceandtax": {
                    this.calAmount(rowIndex);
                    continue block29;
                }
                case "taxrateid": {
                    this.changeTaxRateID(newValue, rowIndex);
                    continue block29;
                }
                case "taxrate": {
                    this.calAmount(rowIndex);
                    continue block29;
                }
                case "currency": {
                    this.calAllAmount();
                    continue block29;
                }
                case "istax": {
                    this.calAllAmount();
                    continue block29;
                }
                case "bizuser": {
                    this.changeBizuser(newValue);
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            this.showOrgTip();
            e.setCancel(true);
            return;
        }
        int row = e.getRow();
        Long orgId = (Long)org.getPkValue();
        switch (fieldKey) {
            case "entryoperator": {
                QFilter q1 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg(orgId));
                QFilter q2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                try {
                    showParameter.getListFilterParameter().getQFilters().add(q1.and(q2));
                }
                catch (Exception ee) {
                    showParameter.getListFilterParameter().getQFilters().add(q1);
                    this.log.error(ee.getMessage());
                }
                break;
            }
            case "supplier": {
                DynamicObject bizType = (DynamicObject)model.getValue("biztype");
                if (bizType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"PurApplyBillPlugin_18", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                Long bizTypeID = (Long)bizType.getPkValue();
                if (BizCategoryHelper.isVMI((Long)bizTypeID)) {
                    QFilter qFilter = new QFilter("enablevmi", "=", (Object)"1");
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                }
                showParameter.getListFilterParameter().getQFilters().add(SupplierHelper.getPurchaseFilter());
                break;
            }
            case "dept": {
                List deptIDs = OrgHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId, (boolean)true);
                DynamicObject user = (DynamicObject)model.getValue("bizuser");
                if (user != null) {
                    Long userID = (Long)user.getPkValue();
                    Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                    deptIDs.add(deptID);
                }
                QFilter q6 = new QFilter("id", "in", (Object)deptIDs);
                showParameter.getListFilterParameter().getQFilters().add(q6);
                break;
            }
            case "configuredcode": {
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", row);
                if (material != null && material.getDynamicObject("masterid") != null) {
                    QFilter qFilter = new QFilter("material", "=", material.getDynamicObject("masterid").getPkValue());
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"PurApplyBillPlugin_21", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("openorderbillquery".equals(itemKey)) {
            this.showOpenOrderBillReport();
        }
        if ("bar_billexecquery".equals(itemKey)) {
            this.showBillExecForm();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "quota": {
                String billStatus = (String)this.getModel().getValue("billstatus");
                String closeStatus = (String)this.getModel().getValue("closestatus");
                if (StatusEnum.AUDIT.getValue().equals(billStatus) && !BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) break;
                String billNo = (String)this.getModel().getValue("billno");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u4e0d\u7b26\u5408\u914d\u989d\u4e0b\u5355\u6761\u4ef6\u3002", (String)"PurApplyBillPlugin_19", (String)"scmc-pm-formplugin", (Object[])new Object[0]), billNo));
                args.setCancel(true);
                return;
            }
            case "scmcavbinvquery": {
                IDataModel model = this.getModel();
                EntryGrid billEntry = (EntryGrid)this.getView().getControl("billentry");
                int[] selectRows = billEntry.getSelectRows();
                if (selectRows.length == 0) {
                    DynamicObjectCollection billEntryObjs = model.getEntryEntity("billentry");
                    if (CommonUtils.isNull((Object)billEntryObjs)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u7269\u6599\u7f16\u7801\u201d\u548c\u201c\u6536\u8d27\u7ec4\u7ec7\u201d\u3002", (String)"PurApplyBillPlugin_20", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    for (DynamicObject billEntryObj : billEntryObjs) {
                        Object entryRecOrg = billEntryObj.get("entryrecorg");
                        Object material = billEntryObj.get("material");
                        if (!CommonUtils.isNull((Object)entryRecOrg) && !CommonUtils.isNull((Object)material)) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u7269\u6599\u7f16\u7801\u201d\u548c\u201c\u6536\u8d27\u7ec4\u7ec7\u201d\u3002", (String)"PurApplyBillPlugin_20", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                } else {
                    for (int selectRow : selectRows) {
                        Object entryRecOrg = model.getValue("entryrecorg", selectRow);
                        Object material = model.getValue("material", selectRow);
                        if (!CommonUtils.isNull((Object)entryRecOrg) && !CommonUtils.isNull((Object)material)) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u7269\u6599\u7f16\u7801\u201d\u548c\u201c\u6536\u8d27\u7ec4\u7ec7\u201d\u3002", (String)"PurApplyBillPlugin_20", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                break;
            }
            case "malpurchase": {
                this.beforeMalPurchase(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        switch (operateKey = e.getOperateKey()) {
            case "quota": {
                this.showQuotaPushOrderForm();
                break;
            }
            case "malpurchase": {
                this.showMalPurchase(e);
                break;
            }
            case "showmalorder": {
                this.showMalOrder(e);
                break;
            }
        }
    }

    private void showQuotaPushOrderForm() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("org", org.getPkValue());
        param.put("ispurapplybill", Boolean.TRUE);
        param.put("billtype", billType.getPkValue());
        param.put("billids", Collections.singletonList((Long)model.getValue("id")));
        FormShowParameter quotaPushOrderForm = new FormShowParameter();
        quotaPushOrderForm.setFormId("pm_quotaorder");
        quotaPushOrderForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        quotaPushOrderForm.setCustomParams(param);
        this.getView().showForm(quotaPushOrderForm);
    }

    private void showOpenOrderBillReport() {
        DynamicObject bizType;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            this.showOrgTip();
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        Long reqOrgId = null;
        Long recOrgId = null;
        ArrayList<DynamicObject> materialList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> supplierList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> projectList = new ArrayList<DynamicObject>();
        HashSet<Object> materialIdSet = new HashSet<Object>(16);
        HashSet<Object> supplierIdSet = new HashSet<Object>(16);
        HashSet<Object> projectIdSet = new HashSet<Object>(16);
        int[] selectRows = this.getBillEntrySelectedRows();
        if (selectRows != null && selectRows.length > 0) {
            for (int selectRow : selectRows) {
                Long entryRecOgrPkValue;
                DynamicObject entryRecOrg;
                Long entryReqOgrPkValue;
                DynamicObject material = (DynamicObject)model.getValue("material", selectRow);
                this.putMultipleDynamicObjectList(material, materialList, materialIdSet);
                DynamicObject supplier = (DynamicObject)model.getValue("supplier", selectRow);
                this.putMultipleDynamicObjectList(supplier, supplierList, supplierIdSet);
                DynamicObject entryReqOrg = (DynamicObject)model.getValue("entryreqorg", selectRow);
                if (entryReqOrg != null && (entryReqOgrPkValue = (Long)entryReqOrg.getPkValue()) != null && 0L != entryReqOgrPkValue) {
                    if (reqOrgId == null) {
                        reqOrgId = entryReqOgrPkValue;
                    } else if (!((Object)reqOrgId).equals(entryReqOgrPkValue)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u6c42\u7ec4\u7ec7\u76f8\u540c\u7684\u6570\u636e\u8fdb\u884c\u67e5\u8be2\u3002", (String)"PurApplyBillPlugin_16", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if ((entryRecOrg = (DynamicObject)model.getValue("entryrecorg", selectRow)) != null && (entryRecOgrPkValue = (Long)entryRecOrg.getPkValue()) != null && 0L != entryRecOgrPkValue) {
                    if (recOrgId == null) {
                        recOrgId = entryRecOgrPkValue;
                    } else if (!((Object)recOrgId).equals(entryRecOgrPkValue)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u6536\u8d27\u7ec4\u7ec7\u76f8\u540c\u7684\u6570\u636e\u8fdb\u884c\u67e5\u8be2\u3002", (String)"PurApplyBillPlugin_17", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                DynamicObject project = (DynamicObject)model.getValue("project", selectRow);
                this.putMultipleDynamicObjectList(project, projectList, projectIdSet);
            }
        }
        filterInfo.addFilterItem("headorg", org.getPkValue());
        Date bizTime = (Date)model.getValue("biztime");
        if (bizTime != null) {
            filterInfo.addFilterItem("enddate", (Object)bizTime);
        }
        if ((bizType = (DynamicObject)model.getValue("biztype")) != null) {
            filterInfo.addFilterItem("headbiztype", bizType.getPkValue());
        }
        if (materialList.size() > 0) {
            filterInfo.addFilterItem("headmaterial", materialList);
        }
        if (supplierList.size() > 0) {
            filterInfo.addFilterItem("headsupplier", supplierList);
        }
        if (projectList.size() > 0) {
            filterInfo.addFilterItem("project", projectList);
        }
        if (reqOrgId != null) {
            filterInfo.addFilterItem("headreqorg", reqOrgId);
        }
        if (recOrgId != null) {
            filterInfo.addFilterItem("headrecorg", recOrgId);
        }
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("pm_openorderbillrpt_new");
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.getCustomParam().put("isFormBill", "1");
        queryParam.setFilter(filterInfo);
        parameter.setQueryParam(queryParam);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void putMultipleDynamicObjectList(DynamicObject object, List<DynamicObject> objectList, Set<Object> objectIdSet) {
        if (object == null) {
            return;
        }
        if (!objectIdSet.contains(object.getPkValue())) {
            objectList.add(object);
            objectIdSet.add(object.getPkValue());
        }
    }

    private void initNewDataEntry(Long orgId, int rowIndex) {
        IDataModel model = this.getModel();
        model.setValue("entrypurog", (Object)orgId, rowIndex);
    }

    private void changeMaterial(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("applyqty", (Object)this.ZERO, rowIndex);
        model.setValue("price", (Object)this.ZERO, rowIndex);
        model.setValue("priceandtax", (Object)this.ZERO, rowIndex);
        model.setValue("taxrateid", null, rowIndex);
        model.setValue("taxrate", (Object)this.ZERO, rowIndex);
        model.setValue("amount", (Object)this.ZERO, rowIndex);
        model.setValue("taxamount", (Object)this.ZERO, rowIndex);
        model.setValue("configuredcode", null, rowIndex);
        model.setValue("entryoperator", null, rowIndex);
        model.setValue("entryoperatorgroup", null, rowIndex);
        model.setValue("amountandtax", (Object)this.ZERO, rowIndex);
        if (newValue instanceof DynamicObject) {
            DynamicObject material = (DynamicObject)newValue;
            DynamicObject supplier = (DynamicObject)model.getValue("supplier");
            DynamicObject defaultTaxRate = MaterialHelper.getDefaultTaxRate((DynamicObject)supplier, (DynamicObject)material);
            if (defaultTaxRate != null) {
                model.setValue("taxrateid", defaultTaxRate.getPkValue(), rowIndex);
                model.setValue("taxrate", (Object)defaultTaxRate.getBigDecimal("taxrate"), rowIndex);
            }
            DynamicObject master = material.getDynamicObject("masterid");
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (master != null && org != null) {
                Long masterID = (Long)master.getPkValue();
                Long orgPkValue = (Long)org.getPkValue();
                String isUpApply = this.getIsUpApply(orgPkValue);
                String entityName = model.getDataEntityType().getName();
                if (isUpApply.equals("true") && !entityName.equals("pm_purplanbill")) {
                    Map materFitOpeInfo;
                    HashSet<Long> materialIDSet = new HashSet<Long>();
                    materialIDSet.add(masterID);
                    Map OperatorMap = PurApplyBillHelper.getMaterialFitOperatorNew((Long)orgPkValue, materialIDSet);
                    if (OperatorMap != null && OperatorMap.size() > 0 && (materFitOpeInfo = (Map)OperatorMap.get(masterID)) != null) {
                        model.setValue("entryoperator", materFitOpeInfo.get("operator"), rowIndex);
                        model.setValue("entryoperatorgroup", materFitOpeInfo.get("operatorgroup"), rowIndex);
                    }
                }
            }
        }
        this.calcTotalAmount();
        model.endInit();
        IFormView view = this.getView();
        view.updateView("applyqty", rowIndex);
        view.updateView("price", rowIndex);
        view.updateView("priceandtax", rowIndex);
        view.updateView("taxrateid", rowIndex);
        view.updateView("taxrate", rowIndex);
        view.updateView("amount", rowIndex);
        view.updateView("taxamount", rowIndex);
        view.updateView("amountandtax", rowIndex);
        view.updateView("entryoperator", rowIndex);
        view.updateView("entryoperatorgroup", rowIndex);
        view.updateView("configuredcode", rowIndex);
        view.updateView("totalallamount");
    }

    private void changeUnit(Object newValue, int rowIndex) {
        if (newValue instanceof DynamicObject) {
            DynamicObject unit = (DynamicObject)newValue;
            IDataModel model = this.getModel();
            BigDecimal applyQty = (BigDecimal)model.getValue("applyqty", rowIndex);
            int precision = BillQtyAndUnitHelper.getPrecision((DynamicObject)unit);
            int precisionaccount = BillQtyAndUnitHelper.getPrecisionType((DynamicObject)unit);
            applyQty = applyQty.setScale(precision, precisionaccount);
            model.beginInit();
            model.setValue("applyqty", (Object)applyQty, rowIndex);
            model.endInit();
            this.getView().updateView("applyqty", rowIndex);
        }
    }

    private void changeApplyQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal applyQty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            if (material == null || unit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            model.beginInit();
            BigDecimal qty = applyQty;
            model.setValue("qty", (Object)qty, rowIndex);
            if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
            }
            if (baseUnit != null && master != null) {
                Long masterId = (Long)master.getPkValue();
                BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                model.setValue("baseqty", (Object)baseQty, rowIndex);
                if (auxUnit != null) {
                    String unitConvertDir = master.getString("unitconvertdir");
                    if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                        BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                        model.setValue("auxqty", (Object)auxQty, rowIndex);
                    }
                }
            }
            model.endInit();
            IFormView view = this.getView();
            view.updateView("qty", rowIndex);
            view.updateView("baseunit", rowIndex);
            view.updateView("baseqty", rowIndex);
            view.updateView("auxqty", rowIndex);
            this.calAmount(rowIndex);
        }
    }

    private void changeQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            this.calAmount(rowIndex);
        }
    }

    private void changeAuxQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            if (material == null || auxUnit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            if (master != null) {
                String unitConvertDir = master.getString("unitconvertdir");
                if (UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    model.beginInit();
                    BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
                    model.setValue("applyqty", (Object)qty, rowIndex);
                    model.setValue("qty", (Object)qty, rowIndex);
                    model.endInit();
                    IFormView view = this.getView();
                    view.updateView("applyqty", rowIndex);
                    view.updateView("baseqty", rowIndex);
                    view.updateView("qty", rowIndex);
                    this.calAmount(rowIndex);
                }
            }
        }
    }

    private void changeOperator(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject bizOperator = (DynamicObject)newValue;
            model.setValue("entryoperatorgroup", bizOperator.get("operatorgrpid"), rowIndex);
        } else {
            model.setValue("entryoperatorgroup", null, rowIndex);
        }
        this.getView().updateView("entryoperatorgroup", rowIndex);
    }

    private void changeTaxRateID(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject taxRateID = (DynamicObject)newValue;
            model.setValue("taxrate", (Object)taxRateID.getBigDecimal("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)this.ZERO, rowIndex);
        }
    }

    private void calAmount(int rowIndex) {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt(CUR_AMTPRECISION);
        int currencyPricePrecision = currency == null ? 10 : currency.getInt(CUR_PRICEPRECISION);
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        AmountInfo amountInfo = new AmountInfo();
        amountInfo.setTax(isTax);
        amountInfo.setQty(qty);
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setTaxRate(taxRate);
        amountInfo.setSettlePricePrecision(currencyPricePrecision);
        amountInfo.setSettleAmtPrecision(currencyAmtPrecision);
        amountInfo = AmountHelper.getAmount((AmountInfo)amountInfo);
        model.beginInit();
        if (isTax) {
            model.setValue("price", (Object)amountInfo.getPrice(), rowIndex);
        } else {
            model.setValue("priceandtax", (Object)amountInfo.getPriceAndTax(), rowIndex);
        }
        BigDecimal amountAndTax = amountInfo.getAmountAndTax();
        model.setValue("amount", (Object)amountInfo.getAmount(), rowIndex);
        model.setValue("taxamount", (Object)amountInfo.getTaxAmount(), rowIndex);
        model.setValue("amountandtax", (Object)amountAndTax, rowIndex);
        model.endInit();
        IFormView view = this.getView();
        view.updateView("price", rowIndex);
        view.updateView("priceandtax", rowIndex);
        view.updateView("amount", rowIndex);
        view.updateView("taxamount", rowIndex);
        view.updateView("amountandtax", rowIndex);
        this.calcTotalAmount();
    }

    private void calAllAmount() {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt(CUR_AMTPRECISION);
        int currencyPricePrecision = currency == null ? 10 : currency.getInt(CUR_PRICEPRECISION);
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("billentry");
        if (entrys != null && !entrys.isEmpty()) {
            DataEntityPropertyCollection properties = ((DynamicObject)entrys.get(0)).getDynamicObjectType().getProperties();
            DynamicProperty qtyP = (DynamicProperty)properties.get((Object)"qty");
            DynamicProperty priceP = (DynamicProperty)properties.get((Object)"price");
            DynamicProperty priceAndTaxP = (DynamicProperty)properties.get((Object)"priceandtax");
            DynamicProperty taxRateP = (DynamicProperty)properties.get((Object)"taxrate");
            DynamicProperty amountP = (DynamicProperty)properties.get((Object)"amount");
            DynamicProperty taxAmountP = (DynamicProperty)properties.get((Object)"taxamount");
            DynamicProperty amountAndTaxP = (DynamicProperty)properties.get((Object)"amountandtax");
            model.beginInit();
            for (DynamicObject entry : entrys) {
                BigDecimal qty = (BigDecimal)qtyP.getValueFast((Object)entry);
                BigDecimal price = (BigDecimal)priceP.getValueFast((Object)entry);
                BigDecimal priceAndTax = (BigDecimal)priceAndTaxP.getValueFast((Object)entry);
                BigDecimal taxRate = (BigDecimal)taxRateP.getValueFast((Object)entry);
                AmountInfo amountInfo = new AmountInfo();
                amountInfo.setTax(isTax);
                amountInfo.setQty(qty);
                amountInfo.setPrice(price);
                amountInfo.setPriceAndTax(priceAndTax);
                amountInfo.setTaxRate(taxRate);
                amountInfo.setSettlePricePrecision(currencyPricePrecision);
                amountInfo.setSettleAmtPrecision(currencyAmtPrecision);
                amountInfo = AmountHelper.getAmount((AmountInfo)amountInfo);
                if (isTax) {
                    priceP.setValueFast((Object)entry, (Object)amountInfo.getPrice());
                } else {
                    priceAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getPriceAndTax());
                }
                amountP.setValueFast((Object)entry, (Object)amountInfo.getAmount());
                taxAmountP.setValueFast((Object)entry, (Object)amountInfo.getTaxAmount());
                amountAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getAmountAndTax());
            }
            model.endInit();
            this.getView().updateView("billentry");
        }
        this.calcTotalAmount();
    }

    private void calcTotalAmount() {
        IDataModel model = this.getModel();
        HashMap<String, String> fieldMapping = new HashMap<String, String>(2);
        fieldMapping.put("totalallamount", "amountandtax");
        for (Map.Entry entry : AmountHelper.calcTotalAmount((DynamicObject)model.getDataEntity(true), fieldMapping).entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    private List<Long> getOperatorGroupByOrg(long orgId) {
        QFilter q3;
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "in", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue()), q3 = new QFilter("enable", "in", (Object)EnableStatusEnum.ENABLE.getValue())});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }

    private void showOrgTip() {
        String localeValue = ((IDataEntityProperty)this.getModel().getDataEntityType().getProperties().get((Object)"org")).getDisplayName().getLocaleValue();
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u3002", (String)"PurApplyBillPlugin_15", (String)"scmc-pm-formplugin", (Object[])new Object[0]), localeValue));
    }

    private void changeBizuser(Object newValue) {
        DynamicObject bizuser;
        Long userID;
        Long deptID = null;
        this.getModel().beginInit();
        if (newValue instanceof DynamicObject && (userID = (Long)(bizuser = (DynamicObject)newValue).getPkValue()) != null) {
            deptID = UserServiceHelper.getUserMainOrgId((long)userID);
        }
        this.getModel().endInit();
        this.getView().updateView("bizuser");
        this.getModel().setValue("dept", deptID);
    }

    private void showMalOrder(AfterDoOperationEventArgs e) {
        FormShowParameter showParameter = PurApplyMalHelper.getMalOrderShowParameter((EventObject)e);
        if (showParameter != null) {
            this.getView().showForm(showParameter);
        }
    }

    private void beforeMalPurchase(BeforeDoOperationEventArgs args) {
        DynamicObject bill;
        IDataModel model = this.getModel();
        DynamicObject newData = model.loadReferenceData((bill = model.getDataEntity(true)).getDynamicObjectType(), bill.getPkValue());
        if (newData != null) {
            bill.set("billentry", (Object)newData.getDynamicObjectCollection("billentry"));
        }
        PurApplyMalHelper.beforeMalPurchase((EventObject)args, (DynamicObject)bill, (int[])this.getBillEntrySelectedRows());
    }

    private void showMalPurchase(AfterDoOperationEventArgs e) {
        FormShowParameter showParameter = PurApplyMalHelper.getMalPurchaseShowParameter((EventObject)e);
        if (showParameter != null) {
            this.getView().showForm(showParameter);
        }
    }

    private int[] getBillEntrySelectedRows() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
        if (entryGrid != null) {
            return entryGrid.getSelectRows();
        }
        return null;
    }

    private void showBillExecForm() {
        IDataModel model = this.getView().getModel();
        String billId = String.valueOf(model.getValue("id"));
        String org = String.valueOf(((DynamicObject)model.getValue("org")).get("id"));
        Object fromDate = model.getValue("biztime");
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(Long.valueOf(billId));
        ReportShowParameter formParam = new ReportShowParameter();
        formParam.setFormId(BILLEXECRPT);
        formParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("selectbill", ids);
        filter.addFilterItem("headorg", (Object)org);
        filter.addFilterItem("startdate", fromDate);
        filter.addFilterItem("enddate", fromDate);
        formParam.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)formParam);
    }

    private String getIsUpApply(Long orgPkValue) {
        String isUpApply = this.getView().getPageCache().get(orgPkValue + "isUpApplyObj");
        if (isUpApply == null) {
            Object isUpApplyObj = AppParameterHelper.getPmAppParameter((Long)orgPkValue, (String)"purapplyfitoperator");
            isUpApply = isUpApplyObj instanceof Boolean && (Boolean)isUpApplyObj != false ? "true" : "false";
            this.getView().getPageCache().put(orgPkValue + "isUpApplyObj", isUpApply);
        }
        return isUpApply;
    }
}

