/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.basedata;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;

public class PurQuotaPushOrderPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(PurQuotaPushOrderPlugin.class);
    private static final String ORG = "org";
    private static final String ENTRYID = "entryid";
    private static final String BD_MEASUREUNITS = "bd_measureunits";
    private static final String BD_MEASUREUNITS_ID = "id";
    private static final int zero = 0;

    public void afterCreateNewData(EventObject evt) {
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List applyBillEntryId = (List)formShowParameter.getCustomParam(ENTRYID);
        String quotaParam = (String)formShowParameter.getCustomParam("quotaPattern");
        if ("B".equals(quotaParam)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"quotasrcbillno", "quotasrcbillname", "quotatype"});
            Date bizDate = (Date)this.getModel().getValue("biztime");
            SimpleDateFormat simpleFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String bizTime = simpleFormate.format(bizDate);
            Long quotaScheme = (Long)formShowParameter.getCustomParam("quotascheme");
            Set matchKeys = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"msbdQuotaService", (String)"quotaQueryMatchKey", (Object[])new Object[]{quotaScheme});
            if (matchKeys.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u914d\u989d\u5e94\u7528\u65b9\u6848\u6216\u8005\u5339\u914d\u6761\u4ef6\u4e3a\u7a7a\u3002", (String)"PurQuotaPushOrderPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("billentry.id", "in", (Object)applyBillEntryId);
            HashSet<String> selectlistFields = new HashSet<String>();
            if (matchKeys.contains(ORG)) {
                selectlistFields.add(ORG);
            }
            if (matchKeys.contains("material")) {
                selectlistFields.add("billentry.material");
                selectlistFields.add("billentry.materialmasterid");
            }
            Collections.addAll(selectlistFields, BD_MEASUREUNITS_ID, "billno", "billentry.id", "billentry.seq");
            Collections.addAll(selectlistFields, "billentry.qty", "billentry.joinqty", "billentry.unit", "billentry.baseqty", "billentry.joinbaseqty", "billentry.baseunit", "billentry.auxqty", "billentry.auxunit");
            String selectFields = selectlistFields.stream().collect(Collectors.joining(","));
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"pm_purapplybill", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"billentry.id");
            if (!rows.isEmpty()) {
                Integer dataNum = rows.size();
                HashMap<String, Serializable> QuotaCalParam = new HashMap<String, Serializable>(16);
                LinkedHashMap dataInfos = new LinkedHashMap(16);
                for (DynamicObject row : rows) {
                    HashMap<String, Object> dataInfo = new HashMap<String, Object>(16);
                    if (matchKeys.contains(ORG)) {
                        dataInfo.put(ORG, row.get(ORG));
                    }
                    if (matchKeys.contains("material")) {
                        dataInfo.put("material", row.get("billentry.materialmasterid"));
                    }
                    if (matchKeys.contains("validdate")) {
                        dataInfo.put("validdate", bizTime);
                    }
                    BigDecimal quotaQty = row.getBigDecimal("billentry.baseqty").subtract(row.getBigDecimal("billentry.joinbaseqty"));
                    dataInfo.put("baseQty", quotaQty);
                    dataInfo.put("baseUnit", row.get("billentry.baseunit"));
                    dataInfos.put(row.get("billentry.id").toString(), dataInfo);
                }
                QuotaCalParam.put("quotaSchemeID", quotaScheme);
                QuotaCalParam.put("dataInfos", dataInfos);
                Map quotaResult = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"msbdQuotaService", (String)"quotaCalculateService", (Object[])new Object[]{QuotaCalParam});
                Boolean isSuccess = (Boolean)quotaResult.get("success");
                if (isSuccess == null || !isSuccess.booleanValue()) {
                    if (quotaResult.get("detail") != null && !quotaResult.get("detail").equals("")) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e%1$s", (String)"PurQuotaPushOrderPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]), quotaResult.get("detail")));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u91c7\u8d2d\u914d\u989d\u5b9a\u4e49\u3001\u914d\u989d\u5e94\u7528\u65b9\u6848\u914d\u7f6e\uff0c\u6216\u8005\u5339\u914d\u6761\u4ef6\u7684\u7b26\u5408\u60c5\u51b5\u3002", (String)"PurQuotaPushOrderPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
                log.info("\u914d\u989d\u7ed3\u679c\u5448\u73b0\u5230\u754c\u9762\u5f00\u59cb");
                List quotaRecordDetails = (List)quotaResult.get("quotaRecordDetails");
                if (quotaRecordDetails != null) {
                    HashSet<Object> unitColl = new HashSet<Object>(rows.size());
                    HashMap<Long, Long> idMap = new HashMap<Long, Long>(rows.size());
                    for (DynamicObject row : rows) {
                        Long unitId = row.getLong("billentry.unit");
                        Long baseUnitId = row.getLong("billentry.baseunit");
                        Long auxUnitId = row.getLong("billentry.auxunit");
                        unitColl.add(unitId);
                        unitColl.add(baseUnitId);
                        if (auxUnitId != null && auxUnitId != 0L) {
                            unitColl.add(auxUnitId);
                        }
                        Long entryId = row.getLong("billentry.id");
                        Long billId = row.getLong(BD_MEASUREUNITS_ID);
                        idMap.put(entryId, billId);
                    }
                    QFilter qFilter1 = new QFilter(BD_MEASUREUNITS_ID, "in", unitColl);
                    Map units = BusinessDataServiceHelper.loadFromCache((String)BD_MEASUREUNITS, (QFilter[])new QFilter[]{qFilter1});
                    int rowId = 0;
                    for (DynamicObject rowData : rows) {
                        for (int n = 0; n < quotaRecordDetails.size(); ++n) {
                            Map quotaInfos;
                            Map recordDetail = (Map)quotaRecordDetails.get(n);
                            if (recordDetail.get("dataSuccess") == null || !((Boolean)recordDetail.get("dataSuccess")).booleanValue() || !rowData.getString("billentry.id").equals(recordDetail.get("dataKey").toString()) || (quotaInfos = (Map)recordDetail.get("quotaCalculateResultInfos")) == null) continue;
                            for (int m = 1; m < 999; ++m) {
                                List quotaedInfoLst = (List)quotaInfos.get(m);
                                if (quotaedInfoLst == null) continue;
                                model.batchCreateNewEntryRow("resultentryentity", quotaedInfoLst.size());
                                BigDecimal qtyZero = new BigDecimal(0);
                                for (int i = 0; i < quotaedInfoLst.size(); ++i) {
                                    BigDecimal maxBaseQty = new BigDecimal(((Map)quotaedInfoLst.get(i)).get("maxBaseQty") != null ? ((Map)quotaedInfoLst.get(i)).get("maxBaseQty").toString() : qtyZero.toString());
                                    BigDecimal minBaseQty = new BigDecimal(((Map)quotaedInfoLst.get(i)).get("minBaseQty") != null ? ((Map)quotaedInfoLst.get(i)).get("minBaseQty").toString() : qtyZero.toString());
                                    BigDecimal packageBaseQty = new BigDecimal(((Map)quotaedInfoLst.get(i)).get("packageBaseQty") != null ? ((Map)quotaedInfoLst.get(i)).get("packageBaseQty").toString() : qtyZero.toString());
                                    model.setValue("supplyrank", (Object)m, rowId);
                                    model.setValue("resultmaterial", (Object)rowData.getLong("billentry.material"), rowId);
                                    model.setValue("resultsupplier", ((Map)quotaedInfoLst.get(i)).get("supplier"), rowId);
                                    model.setValue("quotarate", ((Map)quotaedInfoLst.get(i)).get("quotarate"), rowId);
                                    BigDecimal allotbaseqty = new BigDecimal(((Map)quotaedInfoLst.get(i)).get("quotaedBaseQty") != null ? ((Map)quotaedInfoLst.get(i)).get("quotaedBaseQty").toString() : qtyZero.toString());
                                    BigDecimal baseQty = new BigDecimal(((Map)quotaedInfoLst.get(i)).get("srcAdjustBaseQty") != null ? ((Map)quotaedInfoLst.get(i)).get("srcAdjustBaseQty").toString() : qtyZero.toString());
                                    DynamicObject baseUnit = (DynamicObject)units.get(rowData.getLong("billentry.baseunit"));
                                    DynamicObject unit = (DynamicObject)units.get(rowData.getLong("billentry.unit"));
                                    DynamicObject auxUnit = (DynamicObject)units.get(rowData.getLong("billentry.auxunit"));
                                    if (((Map)quotaedInfoLst.get(i)).get("material") != null) {
                                        Long materialID = Long.valueOf(((Map)quotaedInfoLst.get(i)).get("material").toString());
                                        BigDecimal qty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialID, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                                        BigDecimal allotqty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialID, (DynamicObject)baseUnit, (BigDecimal)allotbaseqty, (DynamicObject)unit);
                                        BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialID, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                                        BigDecimal maxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialID, (DynamicObject)baseUnit, (BigDecimal)maxBaseQty, (DynamicObject)unit);
                                        BigDecimal minQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialID, (DynamicObject)baseUnit, (BigDecimal)minBaseQty, (DynamicObject)unit);
                                        BigDecimal packageQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialID, (DynamicObject)baseUnit, (BigDecimal)packageBaseQty, (DynamicObject)unit);
                                        model.setValue("quotaqty", (Object)qty, rowId);
                                        model.setValue("allotqty", (Object)allotqty, rowId);
                                        model.setValue("auxqty", (Object)auxQty, rowId);
                                        model.setValue("maxbillqty", (Object)maxQty, rowId);
                                        model.setValue("minbillqty", (Object)minQty, rowId);
                                        model.setValue("packingqty", (Object)packageQty, rowId);
                                        model.setValue("packagebatchqty", (Object)this.calPackageBatchQty(packageQty), rowId);
                                    }
                                    model.setValue("baseqty", (Object)baseQty, rowId);
                                    model.setValue("baseunit", (Object)baseUnit, rowId);
                                    model.setValue("resultunit", (Object)unit, rowId);
                                    model.setValue("auxunit", (Object)auxUnit, rowId);
                                    DynamicObject purQuota = BusinessDataServiceHelper.loadSingleFromCache((String)"pm_purquota", (QFilter[])new QFilter[]{new QFilter(BD_MEASUREUNITS_ID, "in", ((Map)quotaedInfoLst.get(i)).get("quotaId"))});
                                    model.setValue("purquotanum", (Object)purQuota, rowId);
                                    DynamicObject quotacalrule = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_quotacalrule", (QFilter[])new QFilter[]{new QFilter(BD_MEASUREUNITS_ID, "in", recordDetail.get("quotaCalRuleID"))});
                                    model.setValue("quotacalrule", (Object)quotacalrule, rowId);
                                    model.setValue("srcbillentryid", (Object)rowData.getLong("billentry.id"), rowId);
                                    model.setValue("srcbillid", idMap.get(rowData.get("billentry.id")), rowId);
                                    ++rowId;
                                }
                            }
                        }
                    }
                    String result = String.format(ResManager.loadKDString((String)"\u6309\u7167\u914d\u989d\u8ba1\u7b97\uff0c\u9009\u4e2d\u7684%1$s\u884c\u91c7\u8d2d\u7533\u8bf7\u5355\u5206\u5f55\u4e2d\u6709%2$s\u884c\u88ab\u62c6\u5206\u4e3a%3$s\u884c\u3002", (String)"PurQuotaPushOrderPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]), dataNum, quotaRecordDetails.size(), rowId);
                    Label labelAp = (Label)this.getView().getControl("labelap");
                    labelAp.setText(result);
                    log.info("\u914d\u989d\u7ed3\u679c\u5448\u73b0\u5230\u754c\u9762\u7ed3\u675f");
                }
            }
        }
    }

    private long calPackageBatchQty(Object newValue) {
        long packQtyLong = 0L;
        if (newValue instanceof BigDecimal) {
            BigDecimal packingQty = (BigDecimal)newValue;
            packQtyLong = packingQty.compareTo(BigDecimal.ZERO) > 0 && packingQty.compareTo(BigDecimal.ONE) < 0 ? 1L : packingQty.setScale(0, RoundingMode.DOWN).longValue();
        }
        return packQtyLong;
    }
}

