/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.basedata;

import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.enums.QuotaAssignSrcTypeEnum;

public class QuotaAssignListPlugin
extends AbstractListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"quota_number")) {
            args.setCancel(true);
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            Long pkId = (Long)billList.getFocusRowPkId();
            DynamicObject quotaAssign = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)"pm_quotaassign");
            if (quotaAssign == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5220\u9664\u4e86\u3002", (String)"QuotaAssignListPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject quotaScheme = (DynamicObject)quotaAssign.get("quota");
            if (quotaScheme != null) {
                Object pkValue = quotaScheme.getPkValue();
                this.showQuotaForm(pkValue);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("modify".equals(operateKey) || "delete".equals(operateKey)) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            if (listSelectedData == null || listSelectedData.isEmpty()) {
                return;
            }
            ListSelectedRow listSelectedRow = listSelectedData.get(0);
            Object pkValue = listSelectedRow.getPrimaryKeyValue();
            DynamicObject quotaAssign = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"pm_quotaassign");
            if (quotaAssign != null) {
                String srcType = quotaAssign.getString("srctype");
                if (QuotaAssignSrcTypeEnum.QUOTA.getValue().equals(srcType)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u914d\u4e3a\u201c\u914d\u989d\u65b9\u6848\u201d\u751f\u6210\uff0c\u8bf7\u4fee\u6539\u914d\u989d\u65b9\u6848\u3002", (String)"QuotaAssignListPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    private void showQuotaForm(Object pkId) {
        BaseShowParameter quotaFormPram = new BaseShowParameter();
        quotaFormPram.setFormId("pm_quota");
        quotaFormPram.setPkId(pkId);
        quotaFormPram.setStatus(OperationStatus.VIEW);
        quotaFormPram.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String pageId = "pm_quota_" + pkId + "_" + UserServiceHelper.getCurrentUserId();
        quotaFormPram.setPageId(pageId);
        this.getView().showForm((FormShowParameter)quotaFormPram);
    }
}

