/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.basedata;

import com.alibaba.fastjson.JSONArray;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.business.helper.SourceListHelper;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.enums.SupplierFunction;

public class SourceListImportPlugin
extends AbstractFormPlugin {
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        BillImportHelper.billCreTypeFlag((IPageCache)pageCache, (List)sourceDataList);
        IDataModel model = (IDataModel)e.getSource();
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null) {
            hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)model.getDataEntityType().getName(), (String)"02");
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Object orgs;
        Map propMap;
        List hasPermissionOrg;
        Map nameMap;
        Object importtype;
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype) && !BillImportHelper.isAPI((String)billcretype)) {
            return;
        }
        Map data = e.getSourceData();
        if (data == null) {
            return;
        }
        DynamicObject org = this.getBaseDataFromCache(data, "org", "bos_org", null, null);
        if (org == null) {
            return;
        }
        Map option = e.getOption();
        if (!CommonUtils.isNull((Object)option) && "new".equals(importtype = option.get("importtype")) && (nameMap = BillImportHelper.format4ImportAndApi(data.get("name"))) != null) {
            String number = (String)data.get("number");
            DynamicObject nameDyn = this.getBaseDataFromCache(data, "name", "pm_sourcelist", null, new QFilter[]{new QFilter("name", "=", nameMap.get("zh_CN")).and(new QFilter("org", "=", org.getPkValue()))});
            if (nameDyn != null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u201c\u540d\u79f0\u201d\u548c\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u7ec4\u5408\u5b57\u6bb5\u503c\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u5176\u4e2d\u4e00\u9879\u3002", (String)"SourceListImportPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]), number);
                this.cancel(e, msg);
                return;
            }
        }
        if (!((hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg")) != null && hasPermissionOrg.contains(org.getPkValue()) || (propMap = BillImportHelper.format4ImportAndApi(orgs = data.get("org"))) == null)) {
            String msg = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"SourceListImportPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop")));
            this.cancel(e, msg);
            return;
        }
        Map entryentityMap = BillImportHelper.format4ImportAndApi(data.get("entryentity"));
        if (entryentityMap != null) {
            List billentry = (List)entryentityMap.get("sourceData");
            JSONArray billEntryArray = new JSONArray();
            for (Map entry : billentry) {
                Map materialGroup;
                DynamicObject standard;
                Map entryMap = (Map)entry.get("materialsort");
                DynamicObject materialsort = null;
                if (entryMap != null && entryMap.get(entryMap.get("importprop")) != null && (materialsort = (DynamicObject)this.tempCache.get("materialsort_" + (String)entryMap.get("importProp"))) == null) {
                    materialsort = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialgroup", (String)"id,standard,number", (QFilter[])new QFilter[]{new QFilter((String)entryMap.get("importprop"), "=", entryMap.get(entryMap.get("importprop"))), new QFilter("createorg", "=", org.getPkValue())});
                }
                if (materialsort != null && (standard = materialsort.getDynamicObject("standard")) != null && (materialGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"id,standard,number", (QFilter[])new QFilter[]{new QFilter("standard", "=", standard.getPkValue()), new QFilter("createorg", "=", org.getPkValue()), new QFilter((String)entryMap.get("importprop"), "=", entryMap.get(entryMap.get("importprop")))})) != null && materialGroup.size() == 1) {
                    HashMap<String, Object> materialSortMap = new HashMap<String, Object>();
                    materialSortMap.put("id", ((DynamicObject)materialGroup.values().stream().findFirst().get()).getPkValue());
                    materialSortMap.put("importprop", "number");
                    materialSortMap.put("number", materialsort.getString("number"));
                    entry.put("materialsort", materialSortMap);
                }
                billEntryArray.add((Object)entry);
            }
            e.getSourceData().put("entryentity", billEntryArray);
        }
        this.validSupplier(e, "supplier", SupplierFunction.PURCHASE, org);
    }

    public void afterImportData(ImportDataEventArgs e) {
        Object oneRow;
        List entryentityList;
        IDataModel model = this.getModel();
        String billCreType = this.getPageCache().get("billcretype");
        Map sourceData = e.getSourceData();
        if (sourceData == null || sourceData.isEmpty()) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(5);
        Object entryentity = sourceData.get("entryentity");
        if (entryentity instanceof List && !(entryentityList = (List)entryentity).isEmpty() && (oneRow = entryentityList.get(0)) instanceof Map) {
            Map rowMap = (Map)oneRow;
            boolean includePackIntField = rowMap.containsKey("packagebatchqty");
            boolean includePackQtyField = rowMap.containsKey("packingqty");
            if (includePackQtyField || !includePackIntField) {
                param.put("packqtykey", "packingqty");
            } else if (includePackIntField) {
                param.put("packqtykey", "packagebatchqty");
            }
        }
        if (BillImportHelper.isAPI((String)billCreType) || BillImportHelper.isImport((String)billCreType)) {
            DynamicObject bill = model.getDataEntity(true);
            String billcretype = bill.getString("billcretype");
            if (CommonUtils.isNull((Object)billcretype)) {
                bill.set("billcretype", (Object)"1");
            }
            SourceListHelper.completeBillInfo(Collections.singletonList(bill), param);
        }
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map propMap = BillImportHelper.format4ImportAndApi((Object)sourceData.get(propName));
        if (propMap != null) {
            String importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }

    private void validSupplier(BeforeImportDataEventArgs e, String key, SupplierFunction function, DynamicObject org) {
        Map data = e.getSourceData();
        Map supplierMap = BillImportHelper.format4ImportAndApi(data.get(key));
        if (supplierMap != null) {
            String supplierPrefix = function == SupplierFunction.PURCHASE ? ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"SourceListImportPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]) : "";
            Object importValue = supplierMap.get(supplierMap.get("importprop"));
            DynamicObject supplier = this.getSupplier(data, supplierMap, key, org);
            if (supplier == null) {
                this.cancel(e, String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u4e0d\u5728\u8be5\u91c7\u8d2d\u7ec4\u7ec7\u7684\u4f7f\u7528\u8303\u56f4\u3002", (String)"SourceListImportPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]), supplierPrefix, importValue));
                return;
            }
            boolean validResult = SupplierHelper.validBizFunction((DynamicObject)supplier, (SupplierFunction)function);
            if (!validResult || supplier.getBoolean("purchasehold")) {
                this.cancel(e, String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u6ca1\u6709%3$s\u804c\u80fd\uff0c\u6216\u8005\u5df2\u91c7\u8d2d\u51bb\u7ed3\u3002", (String)"SourceListImportPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]), supplierPrefix, importValue, function.getName()));
            }
        }
    }

    private DynamicObject getSupplier(Map<String, Object> dataMap, Map<?, ?> supplierMap, String key, DynamicObject org) {
        QFilter supplierOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_supplierOrgFilter");
        if (supplierOrgFilter == null) {
            supplierOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_supplierOrgFilter", supplierOrgFilter);
        }
        return this.getBaseDataFromCache(dataMap, key, "bd_supplier", "id,enablevmi,bizfunction,purchasehold", new QFilter[]{new QFilter((String)supplierMap.get("importprop"), "=", supplierMap.get(supplierMap.get("importprop"))), supplierOrgFilter});
    }

    private void cancel(BeforeImportDataEventArgs e, String message) {
        e.setCancel(true);
        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), message);
        e.setFireAfterImportData(false);
    }
}

