/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.basedata;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.enums.SourceListTypeEnum;

public class SourceListPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log log = LogFactory.getLog(SourceListPlugin.class);
    private static final String TYPEMATER = "A";
    private static final String TYPEKIND = "B";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";

    public void registerListener(EventObject e) {
        Toolbar entryToolbar;
        BasedataEdit materialsortEdit;
        BasedataEdit materialEdit;
        super.registerListener(e);
        BasedataEdit supplierEdit = (BasedataEdit)this.getView().getControl("supplier");
        if (supplierEdit != null) {
            supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialEdit = (BasedataEdit)this.getView().getControl("material")) != null) {
            materialEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialsortEdit = (BasedataEdit)this.getView().getControl("materialsort")) != null) {
            materialsortEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((entryToolbar = (Toolbar)this.getView().getControl(ADVCONTOOLBARAP)) != null) {
            entryToolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "supplier": {
                QFilter bizfunctionAndHoldFilter = SupplierHelper.getBizfunctionAndHoldFilter((String)key);
                if (bizfunctionAndHoldFilter == null) break;
                showParameter.getListFilterParameter().getQFilters().add(bizfunctionAndHoldFilter);
                break;
            }
            case "material": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                Boolean isVMI = (Boolean)this.getModel().getValue("isvmi", rowIndex);
                if (isVMI == null || !isVMI.booleanValue()) break;
                QFilter qFilter = new QFilter("masterid.enablevmi", "=", (Object)Boolean.TRUE);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("frozen".equals(itemKey) || "unfrozen".equals(itemKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            boolean isFromDB = dataEntity.getDataEntityState().getFromDatabase();
            Object pkValue = dataEntity.getPkValue();
            if (!isFromDB || pkValue == null || Long.compare((Long)pkValue, 0L) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u6570\u636e\u3002", (String)"SourceListPlugin_8", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                return;
            }
            DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
            for (int rowIndex : selectRows) {
                DynamicObject row = (DynamicObject)entryentity.get(rowIndex);
                boolean fromDatabase = row.getDataEntityState().getFromDatabase();
                if (fromDatabase) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u6570\u636e\u3002", (String)"SourceListPlugin_8", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        block5: {
            String key;
            block4: {
                Control source = (Control)e.getSource();
                key = source.getKey();
                if (!"material".equals(key)) break block4;
                int currentRowIndex = e.getCurrentRowIndex();
                ListSelectedRowCollection listSelectedRowCollection = e.getListSelectedRowCollection();
                String type = (String)this.getModel().getValue("type", currentRowIndex);
                if (listSelectedRowCollection.size() <= 1) break block5;
                for (int i = 1; i < listSelectedRowCollection.size(); ++i) {
                    this.getModel().setValue("type", (Object)type, i + currentRowIndex);
                }
                break block5;
            }
            if ("materialsort".equals(key)) {
                int currentRowIndex = e.getCurrentRowIndex();
                ListSelectedRowCollection listSelectedRowCollection = e.getListSelectedRowCollection();
                String type = (String)this.getModel().getValue("type", currentRowIndex);
                if (listSelectedRowCollection.size() > 1) {
                    for (int i = 1; i < listSelectedRowCollection.size(); ++i) {
                        this.getModel().setValue("type", (Object)type, i + currentRowIndex);
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        model = this.getModel();
        view = this.getView();
        propName = e.getProperty().getName();
        oldValue = e.getChangeSet()[0].getOldValue();
        newValue = e.getChangeSet()[0].getNewValue();
        rowIndex = e.getChangeSet()[0].getRowIndex();
        var8_8 = propName;
        var9_9 = -1;
        switch (var8_8.hashCode()) {
            case 3575610: {
                if (!var8_8.equals("type")) break;
                var9_9 = 0;
                break;
            }
            case 299066663: {
                if (!var8_8.equals("material")) break;
                var9_9 = 1;
                break;
            }
            case -2114687163: {
                if (!var8_8.equals("materialsort")) break;
                var9_9 = 2;
                break;
            }
            case 1716287679: {
                if (!var8_8.equals("effectdate")) break;
                var9_9 = 3;
                break;
            }
            case -815785119: {
                if (!var8_8.equals("expirydate")) break;
                var9_9 = 4;
                break;
            }
            case 264906477: {
                if (!var8_8.equals("packingqty")) break;
                var9_9 = 5;
                break;
            }
            case -600538261: {
                if (!var8_8.equals("maxbillqty")) break;
                var9_9 = 6;
                break;
            }
            case 1871461053: {
                if (!var8_8.equals("minbillqty")) break;
                var9_9 = 7;
                break;
            }
            case -1843169787: {
                if (!var8_8.equals("purchaseunit")) break;
                var9_9 = 8;
            }
        }
        switch (var9_9) {
            case 0: {
                selectValue = model.getValue("type", rowIndex);
                if (!"B".equals(selectValue)) ** GOTO lbl55
                model.setValue("purchaseunit", null, rowIndex);
                model.setValue("baseunit", null, rowIndex);
                this.clearRowQty(rowIndex, new String[]{"maxbillqty", "minbillqty", "packingqty"});
                model.setValue("isvmi", (Object)Boolean.FALSE, rowIndex);
                ** GOTO lbl57
lbl55:
                // 1 sources

                if ("A".equals(selectValue)) {
                    model.setValue("packingqty", (Object)1, rowIndex);
                }
            }
lbl57:
            // 5 sources

            case 1: {
                isDuplicate = this.checkMaterialDate(propName, rowIndex, this.getModel().getEntryRowEntity("entryentity", rowIndex));
                model.setValue("purchaseunit", null, rowIndex);
                model.setValue("baseunit", null, rowIndex);
                model.setValue("materialmasterid", null, rowIndex);
                if (newValue == null) {
                    this.clearRowQty(rowIndex, new String[]{"maxbillqty", "minbillqty"});
                    model.setValue("packingqty", (Object)1, rowIndex);
                    break;
                }
                if (isDuplicate.booleanValue() || !(newValue instanceof DynamicObject)) break;
                newMaterial = (DynamicObject)newValue;
                newPk = (Long)newMaterial.getPkValue();
                master = newMaterial.getDynamicObject("masterid");
                if (master != null) {
                    model.setValue("materialmasterid", master.getPkValue(), rowIndex);
                    baseUnit = master.getDynamicObject("baseunit");
                    if (baseUnit != null) {
                        model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
                    }
                }
                if ((oldMaterial = (DynamicObject)oldValue) != null) {
                    oldPk = (Long)oldMaterial.getPkValue();
                    if (newPk != null && !newPk.equals(oldPk)) {
                        this.clearRowQty(rowIndex, new String[]{"maxbillqty", "minbillqty"});
                    }
                }
                if ((dynamicObject = newMaterial.getDynamicObject("purchaseunit")) != null) {
                    model.setValue("purchaseunit", dynamicObject.getPkValue(), rowIndex);
                }
                model.setValue("packingqty", (Object)1, rowIndex);
                break;
            }
            case 2: {
                this.checkSortDate(propName, rowIndex, this.getModel().getEntryRowEntity("entryentity", rowIndex));
                break;
            }
            case 3: {
                if (ObjectUtils.isEmpty((Object)newValue)) {
                    return;
                }
                effDate = (Date)newValue;
                expDate = (Date)this.getModel().getValue("expirydate", rowIndex);
                type1 = (String)this.getModel().getValue("type", rowIndex);
                if (expDate != null && effDate.compareTo(expDate) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u8981\u5c0f\u4e8e\u7b49\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"SourceListPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(propName, null, rowIndex);
                    break;
                }
                if (type1.equals(SourceListTypeEnum.MATERIAL.getValue())) {
                    this.checkMaterialDate(propName, rowIndex, this.getModel().getEntryRowEntity("entryentity", rowIndex));
                    break;
                }
                if (!type1.equals(SourceListTypeEnum.MATERIALGROUP.getValue())) break;
                this.checkSortDate(propName, rowIndex, this.getModel().getEntryRowEntity("entryentity", rowIndex));
                break;
            }
            case 4: {
                if (ObjectUtils.isEmpty((Object)newValue)) {
                    return;
                }
                effDate1 = (Date)this.getModel().getValue("effectdate", rowIndex);
                expDate1 = (Date)newValue;
                type2 = (String)this.getModel().getValue("type", rowIndex);
                if (effDate1 != null && effDate1.compareTo(expDate1) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u8981\u5927\u4e8e\u7b49\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"SourceListPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(propName, null, rowIndex);
                    break;
                }
                if (type2.equals(SourceListTypeEnum.MATERIAL.getValue())) {
                    this.checkMaterialDate(propName, rowIndex, this.getModel().getEntryRowEntity("entryentity", rowIndex));
                    break;
                }
                if (!type2.equals(SourceListTypeEnum.MATERIALGROUP.getValue())) break;
                this.checkSortDate(propName, rowIndex, this.getModel().getEntryRowEntity("entryentity", rowIndex));
                break;
            }
            case 5: {
                this.calPackageBatchQty(newValue, rowIndex);
            }
            case 6: 
            case 7: {
                this.setBaseQtyByQty(propName, (BigDecimal)newValue, (BigDecimal)oldValue, rowIndex);
                break;
            }
            case 8: {
                this.setBaseQtyByUnit((DynamicObject)newValue, rowIndex);
            }
        }
    }

    private void calPackageBatchQty(Object newValue, int rowIndex) {
        long packQtyLong = 0L;
        if (newValue instanceof BigDecimal) {
            BigDecimal packingQty = (BigDecimal)newValue;
            packQtyLong = packingQty.compareTo(BigDecimal.ZERO) > 0 && packingQty.compareTo(BigDecimal.ONE) < 0 ? 1L : packingQty.setScale(0, RoundingMode.DOWN).longValue();
        }
        this.getModel().setValue("packagebatchqty", (Object)packQtyLong, rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection rows = model.getEntryEntity("entryentity");
            for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
                DynamicObject material;
                DynamicObject purchaseunit;
                DynamicObject row = (DynamicObject)rows.get(rowIndex);
                String type = row.getString("type");
                if (!TYPEMATER.equals(type) || (purchaseunit = row.getDynamicObject("purchaseunit")) != null || (material = (DynamicObject)this.getModel().getValue("material", rowIndex)) == null) continue;
                DynamicObject materpurchaseunit = material.getDynamicObject("purchaseunit");
                model.setValue("purchaseunit", (Object)materpurchaseunit, rowIndex);
            }
        }
    }

    private Boolean checkMaterialDate(String key, int rowIndex, DynamicObject srcRow) {
        if (srcRow.get("material") != null && srcRow.getDate("effectdate") != null && srcRow.getDate("expirydate") != null) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entrys) {
                if (entry.get("material") == null || entry.getDate("effectdate") == null || entry.getDate("expirydate") == null || rowIndex == entry.getInt("seq") - 1 || !srcRow.getDynamicObject("material").getPkValue().equals(entry.getDynamicObject("material").getPkValue()) || srcRow.getDate("effectdate").after(entry.getDate("expirydate")) || srcRow.getDate("expirydate").before(entry.getDate("effectdate"))) continue;
                this.getModel().setValue(key, null, rowIndex);
                int seq = entry.getInt("seq");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8f93\u5165\u7684\u884c\u4e0e\u7b2c%1$s\u884c\u6709\u6548\u671f\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SourceListPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]), seq));
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private void checkSortDate(String key, int rowIndex, DynamicObject srcRow) {
        if (srcRow.get("materialsort") != null && srcRow.getDate("effectdate") != null && srcRow.getDate("expirydate") != null) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entrys) {
                if (entry.get("materialsort") == null || entry.getDate("effectdate") == null || entry.getDate("expirydate") == null || rowIndex == entry.getInt("seq") - 1 || !srcRow.getDynamicObject("materialsort").getPkValue().equals(entry.getDynamicObject("materialsort").getPkValue()) || srcRow.getDate("effectdate").after(entry.getDate("expirydate")) || srcRow.getDate("expirydate").before(entry.getDate("effectdate"))) continue;
                this.getModel().setValue(key, null, rowIndex);
                int seq = entry.getInt("seq");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8f93\u5165\u7684\u884c\u4e0e\u7b2c%1$s\u884c\u6709\u6548\u671f\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SourceListPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]), seq));
                return;
            }
        }
    }

    private void setBaseQtyByQty(String propName, BigDecimal qty, BigDecimal oldValue, int index) {
        String baseQtyKey;
        if ("maxbillqty".equals(propName)) {
            baseQtyKey = "maxbillbaseqty";
        } else if ("minbillqty".equals(propName)) {
            baseQtyKey = "minbillbaseqty";
        } else if ("packingqty".equals(propName)) {
            baseQtyKey = "packingbaseqty";
        } else {
            return;
        }
        IDataModel model = this.getModel();
        if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
            this.clearRowQty(index, baseQtyKey);
            return;
        }
        DynamicObject master = this.getMaterialMaster(index);
        DynamicObject unit = (DynamicObject)model.getValue("purchaseunit", index);
        DynamicObject baseUnit = this.getBaseUnit(index);
        if (master == null || unit == null || baseUnit == null) {
            this.clearRowQty(index, baseQtyKey);
            return;
        }
        try {
            model.setValue(baseQtyKey, (Object)this.calcBaseQty(master, unit, baseUnit, qty), index);
        }
        catch (KDBizException e) {
            this.getModel().setValue(propName, (Object)oldValue, index);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private BigDecimal calcBaseQty(DynamicObject master, DynamicObject unit, DynamicObject baseUnit, BigDecimal qty) {
        return BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)master.getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
    }

    private DynamicObject getMaterialMaster(int index) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", index);
        if (material == null) {
            return null;
        }
        return material.getDynamicObject("masterid");
    }

    private void setBaseQtyByUnit(DynamicObject unit, int index) {
        DynamicObject master = this.getMaterialMaster(index);
        DynamicObject baseUnit = this.getBaseUnit(index);
        if (unit == null || master == null || baseUnit == null) {
            this.clearRowQty(index, "maxbillbaseqty", "minbillbaseqty", "packingbaseqty");
            return;
        }
        this.setBaseQtyByUnit("maxbillqty", "maxbillbaseqty", master, unit, baseUnit, index);
        this.setBaseQtyByUnit("minbillqty", "minbillbaseqty", master, unit, baseUnit, index);
        this.setBaseQtyByUnit("packingqty", "packingbaseqty", master, unit, baseUnit, index);
    }

    private void setBaseQtyByUnit(String qtyKey, String baseQtyKey, DynamicObject master, DynamicObject unit, DynamicObject baseUnit, int index) {
        IDataModel model = this.getModel();
        BigDecimal qty = (BigDecimal)model.getValue(qtyKey, index);
        if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
            this.clearRowQty(index, baseQtyKey);
        } else {
            model.setValue(baseQtyKey, (Object)this.calcBaseQty(master, unit, baseUnit, qty), index);
        }
    }

    private void clearRowQty(int index, String ... qtyKey) {
        IDataModel model = this.getModel();
        for (String key : qtyKey) {
            model.setValue(key, (Object)BigDecimal.ZERO, index);
        }
    }

    private DynamicObject getBaseUnit(int index) {
        return (DynamicObject)this.getModel().getValue("baseunit", index);
    }
}

