/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.BillAmountHelper;
import kd.mpscmm.msbd.common.pojo.BillAmountInfo;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;

public class PurAcceptBill2ConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet dataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] dataEntitys = dataEntitySet.FindByEntityKey(this.getTgtMainType().toString());
        HashSet<Long> srcIDs = new HashSet<Long>();
        HashSet<Long> srcEntryIDs = new HashSet<Long>();
        if (dataEntitys == null || dataEntitys.length == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject bill = dataEntity.getDataEntity();
            this.calQtyInfo(bill);
            this.calAmountInfo(bill);
            DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billentrys) {
                Long srcbillid = entry.getLong("srcbillid");
                Long srcbillentryid = entry.getLong("srcbillentryid");
                srcIDs.add(srcbillid);
                srcEntryIDs.add(srcbillentryid);
            }
        }
        this.calAllocationEntry(dataEntitys, srcIDs, srcEntryIDs);
    }

    private void calAllocationEntry(ExtendedDataEntity[] dataEntitys, Set<Long> srcIDs, Set<Long> srcEntryIDs) {
        if (CommonUtils.isNull(srcEntryIDs) || CommonUtils.isNull(srcIDs)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", (Object)srcIDs.toArray());
        QFilter qFilterId = new QFilter("billentry.id", "in", (Object)srcEntryIDs.toArray());
        DynamicObject[] acceptInBills = BusinessDataServiceHelper.load((String)"pm_puracceptbill", (String)this.getProperties(), (QFilter[])new QFilter[]{qFilter, qFilterId});
        if (acceptInBills == null || acceptInBills.length == 0) {
            return;
        }
        HashMap acceptInBillMap = new HashMap(10);
        Arrays.asList(acceptInBills).forEach(inBill -> acceptInBillMap.put((Long)inBill.getPkValue(), inBill));
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection outAllocationEntrys = bill.getDynamicObjectCollection("allocationentry");
            BigDecimal totalAmount = bill.getBigDecimal("totalamount");
            DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
            int settlePrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
            BigDecimal sumAmount = BigDecimal.ZERO;
            BigDecimal sumAllocbyper = BigDecimal.ZERO;
            DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
            HashSet<Long> currentSrcIDs = new HashSet<Long>(10);
            for (DynamicObject entry : billentrys) {
                Long srcbillid = entry.getLong("srcbillid");
                currentSrcIDs.add(srcbillid);
            }
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(10);
            for (Long srcId : currentSrcIDs) {
                DynamicObject srcBill = (DynamicObject)acceptInBillMap.get(srcId);
                if (srcBill == null) continue;
                srcBills.add(srcBill);
            }
            for (DynamicObject srcBill : srcBills) {
                BigDecimal srcTotalAmount = srcBill.getBigDecimal("totalamount");
                DynamicObjectCollection inAllocationEntrys = srcBill.getDynamicObjectCollection("allocationentry");
                for (int i = 0; i < inAllocationEntrys.size(); ++i) {
                    DynamicObject inAllocationEntry = (DynamicObject)inAllocationEntrys.get(i);
                    BigDecimal allocationper = BigDecimal.ZERO;
                    BigDecimal allocationamt = BigDecimal.ZERO;
                    if (i == inAllocationEntrys.size() - 1) {
                        allocationamt = totalAmount.subtract(sumAmount);
                        allocationper = new BigDecimal(100).subtract(sumAllocbyper);
                    } else if (totalAmount.compareTo(BigDecimal.ZERO) != 0) {
                        if (srcBill.getBoolean("isallocbyper")) {
                            allocationper = inAllocationEntry.getBigDecimal("a_allocationper");
                            allocationamt = totalAmount.multiply(allocationper.divide(new BigDecimal(100), 10, RoundingMode.HALF_UP)).setScale(settlePrecision, RoundingMode.HALF_UP);
                            sumAllocbyper = sumAllocbyper.add(allocationper);
                            sumAmount = sumAmount.add(allocationamt);
                        } else {
                            if (BigDecimal.ZERO.compareTo(srcTotalAmount) == 0) continue;
                            allocationamt = totalAmount.multiply(inAllocationEntry.getBigDecimal("a_allocationamt")).divide(srcTotalAmount, settlePrecision, RoundingMode.HALF_UP);
                            allocationper = allocationamt.divide(totalAmount, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
                            sumAllocbyper = sumAllocbyper.add(allocationper);
                            sumAmount = sumAmount.add(allocationamt);
                        }
                    } else {
                        allocationper = inAllocationEntry.getBigDecimal("a_allocationper");
                        allocationamt = inAllocationEntry.getBigDecimal("a_allocationamt");
                        sumAllocbyper = sumAllocbyper.add(allocationper);
                        sumAmount = sumAmount.add(allocationamt);
                    }
                    ((DynamicObject)outAllocationEntrys.get(i)).set("a_allocationamt", (Object)allocationamt);
                    ((DynamicObject)outAllocationEntrys.get(i)).set("a_allocationper", (Object)allocationper);
                }
            }
        }
    }

    private void calQtyInfo(DynamicObject bill) {
        DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
        if (billentrys.isEmpty()) {
            return;
        }
        for (DynamicObject entry : billentrys) {
            DynamicObject material = (DynamicObject)entry.get("material");
            if (material == null) continue;
            DynamicObject unit = entry.getDynamicObject("unit");
            BigDecimal qty = entry.getBigDecimal("qty");
            DynamicObject baseUnit = entry.getDynamicObject("baseunit");
            BigDecimal baseQty = entry.getBigDecimal("baseqty");
            if (unit == null || baseUnit == null) continue;
            if (BigDecimalUtil.isNotBlank((BigDecimal)baseQty) && BigDecimalUtil.isBlank((BigDecimal)qty)) {
                qty = BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)material.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)qty, (DynamicObject)unit);
                entry.set("qty", (Object)qty);
                continue;
            }
            if (!BigDecimalUtil.isNotBlank((BigDecimal)qty) || !BigDecimalUtil.isBlank((BigDecimal)baseQty)) continue;
            baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)material.getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
            entry.set("baseqty", (Object)baseQty);
        }
    }

    private void calAmountInfo(DynamicObject bill) {
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        boolean inputAmount = bill.getBoolean("inputamount");
        int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
        int settlePricePrecision = 10;
        boolean isTax = (Boolean)bill.get("istax");
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal totalAllAmount = BigDecimal.ZERO;
        DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
        if (billentrys.isEmpty()) {
            return;
        }
        for (DynamicObject entry : billentrys) {
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) continue;
            BigDecimal price = entry.getBigDecimal("price");
            BigDecimal qty = entry.getBigDecimal("qty");
            BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
            BigDecimal taxRate = entry.getBigDecimal("taxrate");
            String discountType = entry.getString("discounttype");
            BigDecimal discountRate = entry.getBigDecimal("discountrate");
            BillAmountInfo billAmountInfo = new BillAmountInfo();
            billAmountInfo.setInputamount(inputAmount);
            billAmountInfo.setTax(isTax);
            billAmountInfo.setDiscountType(discountType);
            billAmountInfo.setDiscountRate(discountRate);
            billAmountInfo.setQty(qty);
            billAmountInfo.setPrice(price);
            billAmountInfo.setPriceAndTax(priceAndTax);
            billAmountInfo.setTaxRate(taxRate);
            billAmountInfo.setSettlePricePrecision(settlePricePrecision);
            billAmountInfo.setSettleAmtPrecision(settleAmtPrecision);
            billAmountInfo.setAmountAndTax(entry.getBigDecimal("amountandtax"));
            billAmountInfo.setAmount(entry.getBigDecimal("amount"));
            billAmountInfo.setTaxAmount(entry.getBigDecimal("taxamount"));
            Map amountInfoMap = BillAmountHelper.calAmount((BillAmountInfo)billAmountInfo);
            BigDecimal amount = (BigDecimal)amountInfoMap.get("amount");
            BigDecimal taxAmount = (BigDecimal)amountInfoMap.get("taxamount");
            BigDecimal amountAndTax = (BigDecimal)amountInfoMap.get("amountandtax");
            entry.set("price", amountInfoMap.get("price"));
            entry.set("priceandtax", amountInfoMap.get("priceandtax"));
            entry.set("discountamount", amountInfoMap.get("discountamount"));
            entry.set("amount", amountInfoMap.get("amount"));
            entry.set("taxamount", amountInfoMap.get("taxamount"));
            entry.set("amountandtax", amountInfoMap.get("amountandtax"));
            if (amount != null) {
                totalAmount = totalAmount.add(amount);
            }
            if (taxAmount != null) {
                totalTaxAmount = totalTaxAmount.add(taxAmount);
            }
            if (amountAndTax == null) continue;
            totalAllAmount = totalAllAmount.add(amountAndTax);
        }
        bill.set("totalamount", (Object)totalAmount);
        bill.set("totaltaxamount", (Object)totalTaxAmount);
        bill.set("totalallamount", (Object)totalAllAmount);
    }

    private String getProperties() {
        return "id,isexpensealloc,isallocbyper,totalamount,billentry.id,billentry.amount,billentry.qty,billentry.joinpayablepriceqty,settlecurrency,billentry.payablepriceqty,allocationentry.a_allocationper,allocationentry,a_allocationamt";
    }
}

