/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.pojo.AmountPropertyKey;

public class PurOrder2PurReceiptNoticeConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        if (entitys == null || entitys.length < 1) {
            return;
        }
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(10);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            bills.add(bill);
        }
        List<DynamicObject> results = PurOrder2PurReceiptNoticeConvertPlugin.batchSetNoticeBillDefValue(bills);
        if (results == null || results.size() == 0) {
            return;
        }
    }

    public static List<DynamicObject> batchSetNoticeBillDefValue(List<DynamicObject> bills) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        AmountPropertyKey amountPropertyKey = AmountPropertyKey.getInstance();
        if (bills == null || bills.size() == 0) {
            return null;
        }
        for (DynamicObject bill : bills) {
            DynamicObject billType;
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null || (billType = bill.getDynamicObject("billtype")) == null) continue;
            BigDecimal totalAmount = BigDecimalUtil.ZERO;
            BigDecimal totalTaxAmount = BigDecimalUtil.ZERO;
            BigDecimal totalAmountAndTax = BigDecimalUtil.ZERO;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entries.size(); ++i) {
                Map entryAmountMap;
                DynamicObject entry = (DynamicObject)entries.get(i);
                PurOrder2PurReceiptNoticeConvertPlugin.initQty(entry);
                BigDecimal amount = entry.getBigDecimal("amount");
                BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                BigDecimal taxAmount = entry.getBigDecimal("taxamount");
                BigDecimal qty = entry.getBigDecimal("qty");
                if ((BigDecimalUtil.isBlank((BigDecimal)amount) || BigDecimalUtil.isBlank((BigDecimal)amountAndTax)) && BigDecimalUtil.isNotBlank((BigDecimal)qty) && !(entryAmountMap = AmountHelper.calcAmount((DynamicObject)bill, (AmountPropertyKey)amountPropertyKey, (int)i)).isEmpty()) {
                    amount = (BigDecimal)entryAmountMap.get(amountPropertyKey.getAmount());
                    taxAmount = (BigDecimal)entryAmountMap.get(amountPropertyKey.getTaxAmount());
                    amountAndTax = (BigDecimal)entryAmountMap.get(amountPropertyKey.getAmountAndTax());
                }
                if (amount != null) {
                    totalAmount = totalAmount.add(amount);
                }
                if (taxAmount != null) {
                    totalTaxAmount = totalTaxAmount.add(taxAmount);
                }
                if (amountAndTax == null) continue;
                totalAmountAndTax = totalAmountAndTax.add(amountAndTax);
            }
            bill.set("totalamount", (Object)totalAmount);
            bill.set("totaltaxamount", (Object)totalTaxAmount);
            bill.set("totalallamount", (Object)totalAmountAndTax);
            result.add(bill);
        }
        return result;
    }

    private static void initQty(DynamicObject entry) {
        DynamicObject unit = entry.getDynamicObject("unit");
        BigDecimal qty = entry.getBigDecimal("qty");
        if (BigDecimalUtil.isBlank((BigDecimal)qty)) {
            return;
        }
        if (unit == null) {
            return;
        }
        BigDecimal receiveqtyup = entry.getBigDecimal("receiveqtyup");
        BigDecimal receiveqtydown = entry.getBigDecimal("receiveqtydown");
        BigDecimal receivebaseqtyup = entry.getBigDecimal("receivebaseqtyup");
        BigDecimal receivebaseqtydown = entry.getBigDecimal("receivebaseqtydown");
        if (BigDecimalUtil.isNotBlank((BigDecimal)receiveqtyup) && BigDecimalUtil.isNotBlank((BigDecimal)receiveqtydown) && BigDecimalUtil.isNotBlank((BigDecimal)receivebaseqtyup) && BigDecimalUtil.isNotBlank((BigDecimal)receivebaseqtydown)) {
            return;
        }
        BigDecimal receiveRateUp = entry.getBigDecimal("receiverateup");
        BigDecimal receiveRateDown = entry.getBigDecimal("receiveratedown");
        if (receiveRateUp != null && receiveRateDown != null) {
            BigDecimal receiveQtyUp = BigDecimalUtil.getByGrowRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(BillQtyAndUnitHelper.getPrecision((DynamicObject)unit), BillQtyAndUnitHelper.getUnitRoundingMode((DynamicObject)unit));
            BigDecimal receiveQtyDown = BigDecimalUtil.getByReduceRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateDown)).setScale(BillQtyAndUnitHelper.getPrecision((DynamicObject)unit), BillQtyAndUnitHelper.getUnitRoundingMode((DynamicObject)unit));
            entry.set("receiveqtyup", (Object)receiveQtyUp);
            entry.set("receiveqtydown", (Object)receiveQtyDown);
        }
    }
}

