/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.home;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.DateUtil;

public class PurYearOrderAmountPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Label label = (Label)this.getControl("amount");
        Date currentYearFirstDate = DateUtil.getCurrYearFirst();
        Date currentYearLastDate = DateUtil.getCurrYearLast();
        QFilter currentYearFirstDateFilter = new QFilter("biztime", ">=", (Object)currentYearFirstDate);
        QFilter currentYearLastDateFilter = new QFilter("biztime", "<=", (Object)currentYearLastDate);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        DynamicObjectCollection curamountandtaxCol = QueryServiceHelper.query((String)"pm_purorderbill", (String)"billentry.curamountandtax", (QFilter[])new QFilter[]{currentYearFirstDateFilter, currentYearLastDateFilter, billStatusFilter});
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (curamountandtaxCol != null && curamountandtaxCol.size() > 0) {
            for (int i = 0; i < curamountandtaxCol.size(); ++i) {
                DynamicObject rowInfo = (DynamicObject)curamountandtaxCol.get(i);
                BigDecimal curamountandtax = (BigDecimal)rowInfo.get("billentry.curamountandtax");
                totalAmount = totalAmount.add(curamountandtax);
            }
            totalAmount = totalAmount.divide(new BigDecimal("10000"), 0, 4);
            label.setText(this.moneyFormat(totalAmount.doubleValue()));
        }
    }

    private String moneyFormat(Double v) {
        DecimalFormat formater = new DecimalFormat();
        formater.setMaximumFractionDigits(2);
        formater.setGroupingSize(3);
        formater.setRoundingMode(RoundingMode.HALF_UP);
        return formater.format(v);
    }
}

