/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.order;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.changemodel.common.enums.BatChangeStatusEnum;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.OperatorGroupHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.enums.StatusEnum;

public class BatXPurOrderBillImportPlugin
extends AbstractFormPlugin {
    private Map<String, Object> tempCache = new HashMap<String, Object>();
    private static final String[] selectedProps = new String[]{"id", "billno", "operatorgroup", "operator", "supplier", "billentry.id billentryid", "billentry.seq billentryseq", "billentry.material material", "billentry.materialname materialname", "billentry.auxpty auxpty", "billentry.baseunit baseunit", "billentry.baseqty baseqty", "billentry.unit unit", "billentry.qty qty", "billentry.deliverdate deliverdate"};
    private static final String[] selectedKeys = new String[]{"id", "billno", "operatorgroup", "operator", "supplier", "billentryid", "billentryseq", "material", "materialname", "auxpty", "baseunit", "baseqty", "unit", "qty", "deliverdate"};

    public void initImportData(InitImportDataEventArgs e) {
        IDataModel model = (IDataModel)e.getSource();
        IPageCache pageCache = this.getPageCache();
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        BillImportHelper.billCreTypeFlag((IPageCache)pageCache, (List)sourceDataList);
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null) {
            hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)model.getDataEntityType().getName(), (String)"02");
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map data = e.getSourceData();
        DynamicObject org = this.getBaseDataFromCache(data, "org", "bos_org", null, null);
        if (org == null) {
            return;
        }
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null || !hasPermissionOrg.contains(org.getPkValue())) {
            Object orgs = data.get("org");
            Map propMap = BillImportHelper.format4ImportAndApi(orgs);
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u3010%1$s\u3011\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"BatXPurOrderBillImportPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
            e.setFireAfterImportData(false);
            return;
        }
        Object operatorGroupIsolate = SysParamHelper.getSysParam4pm((Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate");
        Map operatorGroupMap = BillImportHelper.format4ImportAndApi(data.get("h_operatorgroup"));
        Map operatorMap = BillImportHelper.format4ImportAndApi(data.get("h_operator"));
        if (operatorGroupIsolate instanceof Boolean) {
            QFilter operatorgroupOrgFilter;
            DynamicObject operatorGroup = null;
            if (operatorGroupMap != null) {
                operatorgroupOrgFilter = this.getBaseDataOrgFilterFromCache(org, "operatorgroup", "bd_operatorgroup");
                QFilter invalidFilter = new QFilter("entryentity.invalid", "=", (Object)Boolean.FALSE);
                operatorGroup = this.getBaseDataFromCache(data, "h_operatorgroup", "bd_operatorgroup", "id,operatornumber,operatorname,invalid", new QFilter[]{new QFilter((String)operatorGroupMap.get("importprop"), "=", operatorGroupMap.get(operatorGroupMap.get("importprop"))), operatorgroupOrgFilter, invalidFilter});
                if (operatorGroup == null) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u201c%1$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u53ef\u7528\u7684\u91c7\u8d2d\u7ec4\u3002", (String)"BatXPurOrderBillImportPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]), operatorGroupMap.get(operatorGroupMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                }
            }
            if (((Boolean)operatorGroupIsolate).booleanValue()) {
                QFilter qf5;
                Iterator qf4;
                QFilter qf3;
                QFilter qf2;
                Map map;
                if (operatorMap == null) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u91c7\u8d2d\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u586b\u5199\u91c7\u8d2d\u5458\u3002", (String)"BatXPurOrderBillImportPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]), new Object[0]));
                    e.setFireAfterImportData(false);
                }
                if (operatorGroup != null && (map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"id,operatorgrpid", (QFilter[])new QFilter[]{qf2 = new QFilter("operatorid", "=", (Object)UserServiceHelper.getCurrentUserId()), qf3 = new QFilter("opergrptype", "=", (Object)"CGZ"), qf4 = new QFilter("invalid", "=", (Object)Boolean.FALSE), qf5 = new QFilter("operatorgrpid", "=", operatorGroup.getPkValue())})) == null) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u201c%1$s\u201d\u4e0d\u662f\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5728\u7684\u91c7\u8d2d\u7ec4\u3002", (String)"BatXPurOrderBillImportPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]), operatorGroupMap.get(operatorGroupMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                }
            }
            if (operatorGroupMap != null && operatorMap != null && operatorGroup != null) {
                boolean flag = true;
                if (operatorMap.get(operatorMap.get("importprop")) != null) {
                    DynamicObjectCollection entryentity = operatorGroup.getDynamicObjectCollection("entryentity");
                    for (DynamicObject operator : entryentity) {
                        if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) continue;
                        HashMap<String, Object> newOperator = new HashMap<String, Object>();
                        newOperator.put("id", operator.getPkValue());
                        data.put("h_operator", newOperator);
                        flag = false;
                        break;
                    }
                }
                if (flag) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u5458\u201c%1$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u201c%2$s\u201d\u4e0b\u53ef\u7528\u7684\u91c7\u8d2d\u5458\u3002", (String)"BatXPurOrderBillImportPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]), operatorMap.get(operatorMap.get("importprop")), operatorGroupMap.get(operatorGroupMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                }
            } else if (operatorGroupMap == null && operatorMap != null) {
                operatorgroupOrgFilter = this.getBaseDataOrgFilterFromCache(org, "operatorgroup", "bd_operatorgroup");
                QFilter operatorgroupTypeFilter = new QFilter("operatorgrouptype", "=", (Object)"CGZ");
                QFilter invalidFilter = new QFilter("entryentity.invalid", "=", (Object)Boolean.FALSE);
                Map operatorgroups = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,operatornumber,operatorname,invalid", (QFilter[])new QFilter[]{operatorgroupOrgFilter, operatorgroupTypeFilter, invalidFilter});
                boolean flag = true;
                block1: for (DynamicObject operatorGrp : operatorgroups.values()) {
                    DynamicObjectCollection entryentity = operatorGrp.getDynamicObjectCollection("entryentity");
                    for (DynamicObject operator : entryentity) {
                        if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) continue;
                        HashMap<String, Object> newOperator = new HashMap<String, Object>();
                        newOperator.put("id", operator.getPkValue());
                        data.put("h_operator", newOperator);
                        HashMap<String, Object> newOperatorGroup = new HashMap<String, Object>();
                        newOperatorGroup.put("id", operatorGrp.getPkValue());
                        data.put("h_operatorgroup", newOperatorGroup);
                        flag = false;
                        continue block1;
                    }
                }
                if (flag) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u5458\u3010%1$s\u3011\u4e0d\u5728\u8be5\u91c7\u8d2d\u7ec4\u7ec7\u7684\u4f7f\u7528\u8303\u56f4\u3002", (String)"BatXPurOrderBillImportPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]), operatorMap.get(operatorMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                }
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject defaultOperator;
        Map operatorAndGroup;
        DynamicObject org;
        IDataModel model = this.getModel();
        Date changeDate = (Date)model.getValue("changedate");
        if (changeDate == null) {
            this.getModel().setValue("changedate", (Object)System.currentTimeMillis());
        }
        if ((org = (DynamicObject)model.getValue("org")) == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        long userId = UserServiceHelper.getCurrentUserId();
        DynamicObject operator = (DynamicObject)this.getModel().getValue("h_operator");
        if (operator == null && (operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)orgId, (Long)userId)) != null && !operatorAndGroup.isEmpty() && (defaultOperator = (DynamicObject)operatorAndGroup.get("operator")) != null) {
            model.setValue("h_operator", defaultOperator.getPkValue());
            model.setValue("h_operatorgroup", defaultOperator.get("operatorgrpid"));
        }
        model.setValue("billstatus", (Object)StatusEnum.SAVE.getValue());
        DynamicObjectCollection billEntries = (DynamicObjectCollection)model.getValue("entryentity");
        if (billEntries != null) {
            HashSet<String> srcBillNos = new HashSet<String>(8);
            HashSet<Integer> srcEntrySeqs = new HashSet<Integer>(8);
            for (DynamicObject entry : billEntries) {
                Integer xsbillEntrySeq;
                String xsbillNo = entry.getString("xsbillno");
                if (StringUtils.isNotBlank((CharSequence)xsbillNo)) {
                    srcBillNos.add(xsbillNo);
                }
                if ((long)(xsbillEntrySeq = Integer.valueOf(entry.getInt("xsbillentryseq"))).intValue() == 0L) continue;
                srcEntrySeqs.add(xsbillEntrySeq);
            }
            if (srcEntrySeqs.size() > 0 && srcBillNos.size() > 0) {
                HashMap<String, Map> valueMap = new HashMap<String, Map>(8);
                QFilter q1 = new QFilter("billno", "in", srcBillNos);
                QFilter q2 = new QFilter("billentry.seq", "in", srcEntrySeqs);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"pm_purorderbill", (String)String.join((CharSequence)",", selectedProps), (QFilter[])new QFilter[]{q1, q2}, null);){
                    if (ds != null) {
                        for (Row row : ds) {
                            String billno = row.getString("billno");
                            String billentryseq = row.getString("billentryseq");
                            Map map = valueMap.computeIfAbsent(billno + billentryseq, k -> new HashMap(8));
                            for (String key : selectedKeys) {
                                map.put(key, row.get(key));
                            }
                        }
                    }
                }
                HashSet<Long> materialIds = new HashSet<Long>(8);
                HashSet<Long> baseUnitIds = new HashSet<Long>(8);
                for (int i = 0; i < billEntries.size(); ++i) {
                    String xsbillNo = (String)model.getValue("xsbillno", i);
                    Integer xsbillEntrySeq = (Integer)model.getValue("xsbillentryseq", i);
                    Map map = (Map)valueMap.get(xsbillNo + xsbillEntrySeq);
                    if (map == null) continue;
                    model.setValue("xsbillid", map.get("id"), i);
                    model.setValue("xsbillentryid", map.get("billentryid"), i);
                    model.setValue("operator", map.get("operator"), i);
                    model.setValue("operatorgroup", map.get("operatorgroup"), i);
                    model.setValue("supplier", map.get("supplier"), i);
                    DynamicObject material = (DynamicObject)model.getValue("material", i);
                    if (material == null) {
                        Long materialId = (Long)map.get("material");
                        materialIds.add(materialId);
                        model.setValue("material", (Object)materialId, i);
                    }
                    Long unitId = (Long)map.get("unit");
                    Long baseUnitId = (Long)map.get("baseunit");
                    if (baseUnitId != null && baseUnitId != 0L) {
                        baseUnitIds.add(baseUnitId);
                    }
                    model.setValue("unit", (Object)unitId, i);
                    model.setValue("baseunit", (Object)baseUnitId, i);
                    model.setValue("qty", map.get("qty"), i);
                    model.setValue("materialname", map.get("materialname"), i);
                    model.setValue("auxpty", map.get("auxpty"), i);
                    model.setValue("baseqty", map.get("baseqty"), i);
                    BigDecimal afterQty = (BigDecimal)model.getValue("afterqty", i);
                    if (afterQty == null || afterQty.compareTo(BigDecimal.ZERO) == 0) {
                        afterQty = (BigDecimal)map.get("qty");
                        model.setValue("afterqty", (Object)afterQty, i);
                    }
                    model.setValue("deliverdate", map.get("deliverdate"), i);
                    Date afterDeliverDate = (Date)model.getValue("afterdeliverdate", i);
                    if (afterDeliverDate == null) {
                        model.setValue("afterdeliverdate", map.get("deliverdate"), i);
                    }
                    model.setValue("changestatus", (Object)BatChangeStatusEnum.NORMAL.getValue(), i);
                }
                Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialpurchaseinfo", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIds)});
                Map baseUnitIdsMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"id,precision,precisionaccount", (QFilter[])new QFilter[]{new QFilter("id", "in", baseUnitIds)});
                for (int i = 0; i < billEntries.size(); ++i) {
                    DynamicObject material = (DynamicObject)model.getValue("material", i);
                    DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", i);
                    DynamicObject unit = (DynamicObject)model.getValue("unit", i);
                    BigDecimal afterQty = (BigDecimal)model.getValue("afterqty", i);
                    if (material == null || unit == null || baseUnit == null || afterQty == null) continue;
                    DynamicObject master = material.getDynamicObject("masterid");
                    if (master == null && (material = (DynamicObject)materialMap.get(material.getPkValue())) != null) {
                        master = material.getDynamicObject("masterid");
                    }
                    if (master == null || (baseUnit = (DynamicObject)baseUnitIdsMap.get(baseUnit.getPkValue())) == null) continue;
                    BigDecimal afterBaseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)master.getPkValue()), (Long)((Long)unit.getPkValue()), (BigDecimal)afterQty, (DynamicObject)baseUnit);
                    model.setValue("afterbaseqty", (Object)afterBaseQty, i);
                }
            }
        }
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map propMap = BillImportHelper.format4ImportAndApi((Object)sourceData.get(propName));
        if (propMap != null) {
            String importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }

    private QFilter getBaseDataOrgFilterFromCache(DynamicObject org, String propName, String propEntityName) {
        QFilter baseDataOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_" + propName + "OrgFilter");
        if (baseDataOrgFilter == null) {
            baseDataOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)propEntityName, (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_" + propName + "OrgFilter", baseDataOrgFilter);
        }
        return baseDataOrgFilter;
    }
}

