/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupFilterHelper;
import kd.mpscmm.msbd.changemodel.business.helper.BatXBillHelper;
import kd.mpscmm.msbd.changemodel.common.enums.BatChangeStatusEnum;
import kd.scmc.pm.business.helper.AppParameterHelper;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.OperatorGroupHelper;
import kd.scmc.pm.enums.BizCancelStatusEnum;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.CommonUtils;

public class BatXPurOrderBillPlugin
extends AbstractBillPlugIn
implements EntryGridBindDataListener,
BeforeF7SelectListener {
    private final Log log = LogFactory.getLog(BatXPurOrderBillPlugin.class);
    private static final String CONFIRM_OPERATOR = "confirm_operator";
    private static final String CONFIRM_OPERATORGROUP = "confirm_operatorgroup";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit operatorEdit = (BasedataEdit)this.getView().getControl("h_operator");
        if (operatorEdit != null) {
            operatorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"xsbillno"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject operator;
        Map operatorAndGroup;
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        long userId = UserServiceHelper.getCurrentUserId();
        Object h_operator = model.getValue("h_operator");
        if (h_operator == null && (operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)orgId, (Long)userId)) != null && !operatorAndGroup.isEmpty() && (operator = (DynamicObject)operatorAndGroup.get("operator")) != null) {
            model.setValue("h_operator", operator.getPkValue());
            model.setValue("h_operatorgroup", operator.get("operatorgrpid"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBatChangeBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Long userId = UserServiceHelper.getCurrentUserId();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "h_operator": {
                QFilter q1 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                try {
                    Object operatorGroupIsolate = AppParameterHelper.getPmAppParameter((Long)orgId, (String)"foperatorgroupisolate");
                    if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                        QFilter q2 = OperatorGroupFilterHelper.getOperatorGroupByUserForAll((long)UserServiceHelper.getCurrentUserId(), (DynamicObject)org, (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
                        showParameter.getListFilterParameter().getQFilters().add(q1.and(q2));
                        break;
                    }
                    QFilter q3 = new QFilter("operatorgrpid", "in", (Object)OperatorGroupHelper.getOperatorGroupByOrg((Long)orgId));
                    showParameter.getListFilterParameter().getQFilters().add(q1.and(q3));
                }
                catch (Exception ee) {
                    showParameter.getListFilterParameter().getQFilters().add(q1);
                    this.log.error(ee.getMessage());
                }
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBatChangeBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long orgId = (Long)org.getPkValue();
        block10: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            switch (fieldKey) {
                case "afterqty": {
                    this.changeAfterQty((BigDecimal)newValue, rowIndex);
                    continue block10;
                }
                case "h_operator": {
                    DynamicObject operator = (DynamicObject)newValue;
                    if (operator != null) {
                        this.getModel().setValue("h_operatorgroup", operator.get("operatorgrpid"));
                    } else {
                        this.getModel().setValue("h_operatorgroup", null);
                    }
                    Object operatorGroupIsolate = AppParameterHelper.getPmAppParameter((Long)orgId, (String)"foperatorgroupisolate");
                    if (!(operatorGroupIsolate instanceof Boolean) || !((Boolean)operatorGroupIsolate).booleanValue()) continue block10;
                    ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_OPERATOR, (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u91c7\u8d2d\u5458\u201d\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u53d8\u66f4\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"PurOrderBatChangeBillPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, String.valueOf(rowIndex));
                    this.getView().getPageCache().put(CONFIRM_OPERATOR, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
                    this.getView().getPageCache().put(CONFIRM_OPERATORGROUP, oldValue == null ? null : String.valueOf(((DynamicObject)oldValue).get("operatorgrpid")));
                    continue block10;
                }
                case "xsbillno": {
                    if (!StringUtils.isBlank((Object)newValue)) continue block10;
                    this.getPageCache().put("stopChange", "true");
                    this.getModel().setValue("xsbillentryid", null);
                    this.getModel().setValue("xsbillid", null);
                    this.getModel().setValue("xsbillentryseq", null);
                    this.getModel().setValue("operator", null);
                    this.getModel().setValue("operatorgroup", null);
                    this.getModel().setValue("supplier", null);
                    this.getModel().setValue("auxpty", null);
                    this.getModel().setValue("entrycomment", null);
                    this.getModel().setValue("material", null);
                    this.getModel().setValue("materialname", null);
                    this.getModel().setValue("afterqty", (Object)BigDecimal.ZERO);
                    this.getModel().setValue("baseunit", null);
                    this.getModel().setValue("unit", null);
                    this.getModel().setValue("baseqty", null);
                    this.getModel().setValue("qty", (Object)BigDecimal.ZERO);
                    this.getModel().setValue("afterbaseqty", (Object)BigDecimal.ZERO);
                    this.getModel().setValue("baseqty", (Object)BigDecimal.ZERO);
                    this.getModel().setValue("deliverdate", null);
                    this.getModel().setValue("afterdeliverdate", null);
                    this.getModel().setValue("srcbillentity", null);
                    this.getModel().setValue("srcbillentryid", null);
                    this.getModel().setValue("srcbillentryseq", null);
                    this.getModel().setValue("srcbillid", null);
                    this.getModel().setValue("srcbillnumber", null);
                    this.getModel().setValue("entrycomment", null);
                    this.getPageCache().put("stopChange", "false");
                    continue block10;
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (CONFIRM_OPERATOR.equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("entryentity");
                this.getModel().createNewEntryRow("entryentity");
            } else {
                String operatorId = this.getView().getPageCache().get(CONFIRM_OPERATOR);
                String operatorgrpid = this.getView().getPageCache().get(CONFIRM_OPERATORGROUP);
                this.getPageCache().put("stopChange", "true");
                this.getModel().setValue("h_operator", (Object)Long.valueOf(operatorId));
                this.getModel().setValue("h_operatorgroup", (Object)Long.valueOf(operatorgrpid));
                this.getPageCache().put("stopChange", "false");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equalsIgnoreCase("xsbillno")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBatChangeBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long orgId = (Long)org.getPkValue();
            ArrayList<Long> entryPks = new ArrayList<Long>(8);
            Long supplierId = null;
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entrys) {
                entryPks.add(entry.getLong("xsbillentryid"));
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (supplier == null || supplierId != null) continue;
                supplierId = (Long)supplier.getPkValue();
            }
            QFilter q1 = new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue());
            QFilter q2 = new QFilter("entryentity.changestatus", "=", (Object)BatChangeStatusEnum.NORMAL.getValue());
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_batxpurorderbill", (String)"entryentity.xsbillentryid xsbillentryid", (QFilter[])new QFilter[]{q1, q2}, null);){
                if (ds != null) {
                    for (Row row : ds) {
                        entryPks.add(row.getLong("xsbillentryid"));
                    }
                }
            }
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pm_purorderbill_bclayout", (boolean)true);
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            listShowParameter.setUseOrgId(orgId.longValue());
            listShowParameter.setUseOrgIds(Collections.singletonList(orgId));
            filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
            filters.add(new QFilter("changestatus", "not in", Arrays.asList("B", "B1")));
            filters.add(new QFilter("closestatus", "!=", (Object)BizCloseStatusEnum.CLOSE.getValue()));
            filters.add(new QFilter("cancelstatus", "!=", (Object)BizCancelStatusEnum.CANCEL.getValue()));
            filters.add(new QFilter("org", "=", (Object)orgId));
            filters.add(new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE));
            filters.add(new QFilter("inputamount", "=", (Object)Boolean.FALSE));
            filters.add(new QFilter("billentry.rowclosestatus", "!=", (Object)RowCloseStatusEnum.ROWCLOSE.getValue()));
            filters.add(new QFilter("billentry.id", "not in", entryPks));
            if (supplierId != null) {
                filters.add(new QFilter("supplier", "=", (Object)supplierId));
            }
            Object operatorGroupIsolate = AppParameterHelper.getPmAppParameter((Long)orgId, (String)"foperatorgroupisolate");
            DynamicObject operatorGroup = (DynamicObject)this.getModel().getValue("h_operatorgroup");
            if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                if (operatorGroup != null) {
                    filters.add(new QFilter("operatorgroup", "=", operatorGroup.getPkValue()));
                } else {
                    DynamicObject operator;
                    long userId = UserServiceHelper.getCurrentUserId();
                    Map operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)orgId, (Long)userId);
                    if (operatorAndGroup != null && !operatorAndGroup.isEmpty() && (operator = (DynamicObject)operatorAndGroup.get("operator")) != null) {
                        filters.add(new QFilter("operatorgroup", "=", operator.get("operatorgrpid")));
                    }
                }
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "batchange_callback");
            listShowParameter.setCloseCallBack(closeCallBack);
            listShowParameter.setCustomParam("ismergerows", (Object)Boolean.FALSE);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("batchange_callback".equals(actionId) && (returnData = (ListSelectedRowCollection)e.getReturnData()) != null) {
            BatXBillHelper.addEntrysByReturnData((IDataModel)this.getModel(), (ListSelectedRowCollection)returnData);
            this.getView().updateView("entryentity");
        }
    }

    private void changeAfterQty(BigDecimal newValue, int rowIndex) {
        DynamicObject master;
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
        DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
        DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
        DynamicObject dynamicObject = master = material == null ? null : material.getDynamicObject("masterid");
        if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
            model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
        }
        if (baseUnit != null && master != null && unit != null) {
            BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)master.getPkValue()), (DynamicObject)unit, (BigDecimal)newValue, (DynamicObject)baseUnit);
            model.setValue("afterbaseqty", (Object)baseQty, rowIndex);
        }
    }

    private ArrayList<Long> getOperatorGroupByUser(Long userID, Long orgID) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = new QFilter("operatorid", "=", (Object)userID);
        QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
        QFilter qFilter3 = new QFilter("operatorgrpid", "in", (Object)OperatorGroupHelper.getOperatorGroupByOrg((Long)orgID));
        QFilter qFilter4 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            for (int i = 0; i < list.size(); ++i) {
                operatorGroupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
            }
        }
        return operatorGroupList;
    }
}

