/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.order;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.formplugin.AbstractAutoQuotePlugin;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.pojo.AmountPropertyKey;
import kd.scmc.pm.enums.DiscountTypeEnum;

public class PurOrderAutoQuoteBillPlugin
extends AbstractAutoQuotePlugin {
    protected String getMainOrgKey() {
        return "org";
    }

    protected String getQuoteBillEntryNumber() {
        return "billentry";
    }

    protected boolean isAutoQuote() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return false;
        }
        Boolean iSAutoQuote = (Boolean)SysParamHelper.getSysParam4pm((Long)((Long)org.getPkValue()), (String)"isautoquote");
        if (iSAutoQuote == null) {
            return false;
        }
        return iSAutoQuote;
    }

    protected void addSpecialListenFields(Set<String> specialListenKeys) {
        specialListenKeys.add("pricelist");
    }

    protected boolean cancelAutoQuote() {
        Boolean inputMount = (Boolean)this.getModel().getValue("inputamount");
        if (inputMount == null) {
            return false;
        }
        return inputMount;
    }

    protected void afterUpdateView() {
        String stopChangeKey = "stopChange";
        String taxRateKey = "taxrate";
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        int entryRowCount = model.getEntryRowCount("billentry");
        boolean isTax = (Boolean)model.getValue("istax");
        pageCache.put(stopChangeKey, "true");
        for (int i = 0; i < entryRowCount; ++i) {
            boolean isPresent;
            BigDecimal value;
            DynamicObject taxRate = (DynamicObject)model.getValue("taxrateid", i);
            BigDecimal taxRateValue = (BigDecimal)model.getValue("taxrate", i);
            if (taxRate != null && BigDecimalUtil.isBlank((BigDecimal)taxRateValue) && BigDecimalUtil.isNotBlank((BigDecimal)(value = taxRate.getBigDecimal(taxRateKey))) && BigDecimalUtil.isNotBlank((BigDecimal)value)) {
                model.setValue("taxrate", (Object)value, i);
            }
            if (!(isPresent = ((Boolean)model.getValue("ispresent", i)).booleanValue())) continue;
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", i);
                if (BigDecimalUtil.isZero((BigDecimal)priceAndTax)) {
                    model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i);
                    model.setValue("discountrate", (Object)BigDecimal.ZERO, i);
                    continue;
                }
                model.setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), i);
                model.setValue("discountrate", (Object)new BigDecimal(100), i);
                continue;
            }
            BigDecimal price = (BigDecimal)model.getValue("price", i);
            if (BigDecimalUtil.isZero((BigDecimal)price)) {
                model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i);
                model.setValue("discountrate", (Object)BigDecimal.ZERO, i);
                continue;
            }
            model.setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), i);
            model.setValue("discountrate", (Object)new BigDecimal(100), i);
        }
        Map totalAmountMap = AmountHelper.calcAllAmount((DynamicObject)model.getDataEntity(true), (AmountPropertyKey)AmountPropertyKey.getInstance());
        pageCache.put(stopChangeKey, "false");
        this.getView().updateView("billentry");
        for (Map.Entry entry : totalAmountMap.entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }
}

