/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.order;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.business.helper.BillParameterHelper;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.CommonUtils;

public class PurOrderBillListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(PurOrderBillListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        ListShowParameter source = (ListShowParameter)e.getSource();
        String billFormId = source.getBillFormId();
        QFilter[] q = new QFilter[]{new QFilter("number", "=", (Object)billFormId)};
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"number,basedatafield", (QFilter[])q);
        if (loadSingle != null) {
            Boolean isEnableXSPurOrderBill;
            String entity;
            String string = entity = loadSingle.get("basedatafield") instanceof DynamicObject ? loadSingle.getDynamicObject("basedatafield").getString("number") : null;
            if ("pm_xpurorderbill".equals(entity)) {
                Boolean isEnableXSPurOrderBill2 = BillParameterHelper.getIsEnableXSPurOrderBill();
                if (isEnableXSPurOrderBill2 != null && isEnableXSPurOrderBill2.booleanValue()) {
                    e.setCancel(true);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u4f7f\u7528\u201c\u65b0\u8ba2\u5355\u53d8\u66f4\u5904\u7406\u201d\uff08\u91c7\u8d2d\u8ba2\u5355\u5df2\u542f\u7528\u65b0\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u5355\uff09\u3002", (String)"PurOrderBillListPlugin_7", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                }
            } else if ("pm_xspurorderbill".equals(entity) && (isEnableXSPurOrderBill = BillParameterHelper.getIsEnableXSPurOrderBill()) != null && !isEnableXSPurOrderBill.booleanValue()) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u516c\u5171\u8bbe\u7f6e>\u5355\u636e\u53c2\u6570\u201d\u914d\u7f6e\u53c2\u6570\u201c\u542f\u7528\u65b0\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u5355\u201d\u3002", (String)"PurOrderBillListPlugin_6", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = listShowParameter.getBillFormId();
        QFilter[] q = new QFilter[]{new QFilter("number", "=", (Object)billFormId)};
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"number,basedatafield", (QFilter[])q);
        if (loadSingle != null) {
            String entity;
            String string = entity = loadSingle.get("basedatafield") instanceof DynamicObject ? loadSingle.getDynamicObject("basedatafield").getString("number") : null;
            if ("pm_purorderbill".equals(entity)) {
                Boolean isEnableXSPurOrderBill = BillParameterHelper.getIsEnableXSPurOrderBill();
                if (isEnableXSPurOrderBill != null && isEnableXSPurOrderBill.booleanValue()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tblchange", "tblchangelog"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"tblbizchange", "tblbizchangelog", "tblbizchangeresume"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"tblchange", "tblchangelog"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tblbizchange", "tblbizchangelog", "tblbizchangeresume"});
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        AbstractOperate operate = (AbstractOperate)e.getSource();
        String key = operate.getOperateKey();
        OperateOption option = operate.getOption();
        if ("payaccordsetting".equals(key) && !"true".equals(option.getVariableValue("payaccordsetting", ""))) {
            String billFormId = ((ListView)this.getView()).getListModel().getEntityId();
            ListSelectedRowCollection listSelectedData = e.getListSelectedData();
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            HashSet<Long> billIds = new HashSet<Long>(10);
            if (primaryKeyValues != null && primaryKeyValues.length > 0) {
                HashSet<Boolean> isOverPayResult = new HashSet<Boolean>(3);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)billFormId, (String)"isallowoverpay,id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)}, null);){
                    for (Row row : dataSet) {
                        billIds.add(row.getLong("id"));
                        isOverPayResult.add(row.getBoolean("isallowoverpay"));
                    }
                }
                if (billIds.size() != primaryKeyValues.length) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PurOrderBillListPlugin_14", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (isOverPayResult.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurOrderBillListPlugin_11", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                Boolean isOverPay = (Boolean)isOverPayResult.iterator().next();
                String msg = isOverPay != false ? ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5c06\u7531\u201c\u662f\u201d\u66f4\u6539\u4e3a\u201c\u5426\u201d\uff0c\u4e25\u683c\u63a7\u5236\u4ed8\u6b3e\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u5355\u636e\u4ef7\u7a0e\u5408\u8ba1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurOrderBillListPlugin_12", (String)"scmc-pm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5c06\u7531\u201c\u5426\u201d\u66f4\u6539\u4e3a\u201c\u662f\u201d\uff0c\u5141\u8bb8\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u5355\u636e\u4ef7\u7a0e\u5408\u8ba1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurOrderBillListPlugin_13", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener listener = new ConfirmCallBackListener("payaccordsetting", (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
                e.setCancel(true);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String key;
        switch (key = event.getCallBackId()) {
            case "payaccordsetting": {
                if (!event.getResult().equals((Object)MessageBoxResult.Yes)) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("payaccordsetting", "true");
                this.getView().invokeOperation("payaccordsetting", option);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        BillList billList;
        ListSelectedRowCollection selectedRows;
        boolean success;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && (success = operationResult.isSuccess()) && "changelog".equals(args.getOperateKey()) && (selectedRows = (billList = (BillList)this.getView().getControl("billlistap")).getSelectedRows()) != null && selectedRows.size() > 0) {
            ArrayList<Object> scrBillIds = new ArrayList<Object>();
            for (int i = 0; i < selectedRows.size(); ++i) {
                Object srcBillId;
                ListSelectedRow listSelectedRow = selectedRows.get(i);
                if (listSelectedRow == null || listSelectedRow.getPrimaryKeyValue() == null || scrBillIds.contains(srcBillId = listSelectedRow.getPrimaryKeyValue())) continue;
                scrBillIds.add(srcBillId);
            }
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId("pm_xpurorderbilllog");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCustomParam("srcbillids", scrBillIds);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String clickKey;
        switch (clickKey = evt.getItemKey()) {
            case "biz_billexecquery": {
                this.showBillExecForm();
            }
        }
        super.itemClick(evt);
    }

    private void showBillExecForm() {
        ListSelectedRowCollection selectRows = ((IListView)this.getView()).getSelectedRows();
        if (CommonUtils.isNull((Object)selectRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurOrderBillListPlugin_8", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilterID = new QFilter("id", "in", selectRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList()));
        QFilter auditFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.SAVE.getValue());
        DynamicObjectCollection billList = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,biztime,org", (QFilter[])new QFilter[]{qFilterID, auditFilter});
        if (CommonUtils.isNull((Object)billList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6682\u65e0\u6570\u636e\u3002", (String)"PurOrderBillListPlugin_10", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowCount = billList.size();
        ArrayList<Long> ids = new ArrayList<Long>(rowCount);
        ArrayList<Long> orgList = new ArrayList<Long>(rowCount);
        Date minDate = null;
        Date maxDate = null;
        for (DynamicObject bill : billList) {
            ids.add(bill.getLong("id"));
            orgList.add(bill.getLong("org"));
            Date billDate = bill.getDate("biztime");
            if (null == minDate) {
                minDate = billDate;
            } else if (minDate.compareTo(billDate) > 0) {
                minDate = billDate;
            }
            if (null == maxDate) {
                maxDate = billDate;
                continue;
            }
            if (billDate.compareTo(maxDate) <= 0) continue;
            maxDate = billDate;
        }
        if (orgList.stream().distinct().count() > 1L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u8de8\u7ec4\u7ec7\u67e5\u8be2\u3002", (String)"PurOrderBillListPlugin_9", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportShowParameter formParam = new ReportShowParameter();
        formParam.setFormId("pm_purorderbillrpt_new");
        formParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.getCustomParam().put("isFormBill", "1");
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("selectbill", ids);
        filter.addFilterItem("orgfield", orgList.get(0));
        filter.addFilterItem("startdate", (Object)minDate);
        filter.addFilterItem("enddate", (Object)maxDate);
        filter.addFilterItem("billstatusfield", (Object)"A");
        filter.addFilterItem("rowstatusfield", (Object)"C");
        filter.addFilterItem("closestatusfield", (Object)"C");
        formParam.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)formParam);
    }
}

