/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.order;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.MetaDataHelper;
import kd.scmc.pm.business.helper.PurOrderBillHelper;
import kd.scmc.pm.enums.ChangeTypeEnum;
import kd.scmc.pm.enums.DiscountTypeEnum;

public class XPurOrderBillPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
ClickListener,
EntryGridBindDataListener {
    public static final Log logger = LogFactory.getLog(XPurOrderBillPlugin.class);
    public static final String BTN_CHANGEORG = "changeorg";
    public static final String BTN_CHANGESUPPLIER = "changesupplier";
    public static final String BTN_MODIFY_ENTRY = "modify_entry";
    public static final String BTN_MODIFY_PAY = "modify_pay";
    public static final String BTN_MODIFY_DELIVER = "modify_deliver";
    public static final String BTN_DELETEROW_ENTRY = "deleterow";
    public static final String BTN_DELETEROW_PAY = "deleterow_pay";
    public static final String BTN_DELETEROW_DELIVER = "deleterow_deliver";
    public static final String BTN_SEELOG = "seelog";
    private static final String CONFIRM_LINETYPE = "confirm_linetype";
    private static final String CACHE_LINETYPE = "cache_linetype";
    private final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String PRETIMEPOINT_CONM = "A";
    private static final String CONM_PURCONTRACT = "conm_purcontract";
    private String[] xpurfields = new String[]{"biztime", "reason", "comment", "provideraddress", "providerlinkman", "operator", "dept", "linkman", "address"};
    private String[] entryfields = new String[]{"qty", "auxqty", "price", "taxrate", "priceandtax", "entrycomment", "iscontrolqty", "receiveratedown", "receiverateup"};
    private String[] entrybackfields = new String[]{"qty", "auxqty", "taxrateid", "entrycomment", "amount", "amountandtax", "iscontrolqty", "receiveratedown", "receiverateup", "discountrate", "discounttype"};
    private String[] payEntryfields = new String[]{"payname", "paydate", "payrate", "payamount"};
    private String[] deliverEntryfields = new String[]{"plandeliverdate", "planqty", "plancomment"};

    public void registerListener(EventObject e) {
        EntryGrid deliverEntryGrid;
        EntryGrid payEntryGrid;
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((payEntryGrid = (EntryGrid)this.getView().getControl("purbillentry_pay")) != null) {
            payEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((deliverEntryGrid = (EntryGrid)this.getView().getControl("purbillentry_deliver")) != null) {
            deliverEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("purbillentry_pay");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        this.getView().setEnable(Boolean.FALSE, MetaDataHelper.getAllPropertyNameNoEntry((IDataEntityType)dt));
        this.getView().setEnable(Boolean.TRUE, this.xpurfields);
        String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
        String[] billEntry2 = this.entryfields;
        String[] billEntry3 = this.getDifferentFromString(billEntry1, billEntry2);
        for (RowDataEntity row : e.getRows()) {
            int i = row.getRowIndex();
            if (ChangeTypeEnum.UPDATE.getValue().equals(this.getModel().getValue("entrychangetype", i))) {
                Boolean inputMount = (Boolean)this.getModel().getValue("inputamount");
                if (inputMount.booleanValue()) {
                    String[] billEntry4 = this.entrybackfields;
                    billEntry3 = this.getDifferentFromString(billEntry1, billEntry4);
                }
                this.getView().setEnable(Boolean.FALSE, i, billEntry3);
            } else if (ChangeTypeEnum.CANCEL.getValue().equals(this.getModel().getValue("entrychangetype", i))) {
                this.getView().setEnable(Boolean.FALSE, i, billEntry1);
            }
            String changeType = (String)this.getModel().getValue("payentrychangetype", i);
            if (!ChangeTypeEnum.UPDATE.getValue().equals(changeType)) continue;
            this.setPreTimePoint(i);
        }
    }

    public void afterBindData(EventObject e) {
        int i;
        super.beforeBindData(e);
        this.getModel().clearNoDataRow();
        this.getModel().forceClearNoDataRow();
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        this.getView().setEnable(Boolean.FALSE, MetaDataHelper.getAllPropertyNameNoEntry((IDataEntityType)dt));
        this.getView().setEnable(Boolean.TRUE, this.xpurfields);
        String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
        String[] billEntry3 = this.getDifferentFromString(billEntry1, this.entryfields);
        EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
        try (TraceSpan span = Tracer.create((String)"XPurOrderBillPlugin", (String)"afterBindData");){
            EntryData entryData;
            int pageCount;
            if (entryGrid != null && (pageCount = (entryData = entryGrid.getEntryData()).getPageCount()) > 0) {
                int start = entryData.getStartIndex();
                int end = entryData.getEndIndex();
                for (i = start; i < end; ++i) {
                    if (ChangeTypeEnum.UPDATE.getValue().equals(this.getModel().getValue("entrychangetype", i))) {
                        Boolean inputMount = (Boolean)this.getModel().getValue("inputamount");
                        if (inputMount.booleanValue()) {
                            String[] billEntry4 = this.entrybackfields;
                            billEntry3 = this.getDifferentFromString(billEntry1, billEntry4);
                        }
                        this.getView().setEnable(Boolean.FALSE, i, billEntry3);
                        continue;
                    }
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(this.getModel().getValue("entrychangetype", i))) continue;
                    this.getView().setEnable(Boolean.FALSE, i, billEntry1);
                }
            }
        }
        int payEntryCount = this.getModel().getEntryRowCount("purbillentry_pay");
        String[] payEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_pay");
        String[] payEntry3 = this.getDifferentFromString(payEntry1, this.payEntryfields);
        for (int i2 = 0; i2 < payEntryCount; ++i2) {
            String changeType = (String)this.getModel().getValue("payentrychangetype", i2);
            if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                this.getView().setEnable(Boolean.FALSE, i2, payEntry3);
            }
            this.setPreTimePoint(i2);
        }
        int deliverEntryCount = this.getModel().getEntryRowCount("purbillentry_deliver");
        String[] deliverEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_deliver");
        String[] deliverEntry3 = this.getDifferentFromString(deliverEntry1, this.deliverEntryfields);
        for (i = 0; i < deliverEntryCount; ++i) {
            String changeType = (String)this.getModel().getValue("delentrychangetype", i);
            if (!ChangeTypeEnum.UPDATE.getValue().equals(changeType)) continue;
            this.getView().setEnable(Boolean.FALSE, i, deliverEntry3);
        }
        this.getView().setVisible(Boolean.FALSE, this.getUnVisibleField());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getSource() instanceof EntityOperate) {
            if ("unaudit".equals(((EntityOperate)afterDoOperationEventArgs.getSource()).getOperateKey())) {
                this.getView().updateView();
            }
            if ("changedetail".equals(((EntityOperate)afterDoOperationEventArgs.getSource()).getOperateKey())) {
                IDataModel bill = this.getModel();
                Long sourceID = (Long)bill.getValue("sourceid");
                String version = (String)bill.getValue("version");
                QFilter qFilter1 = new QFilter("srcbillid", "=", (Object)sourceID);
                QFilter qFilter2 = new QFilter("xbillid", "=", bill.getValue("id"));
                QFilter qFilter3 = new QFilter("srcbillversion", "=", (Object)version);
                DynamicObject xPurOrderBillLog = BusinessDataServiceHelper.loadSingleFromCache((String)"pm_xpurorderbilllog", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
                if (xPurOrderBillLog == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53d8\u66f4\u65e5\u5fd7\u3002", (String)"XPurOrderBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String xMDJson = (String)xPurOrderBillLog.get("xmdjson_tag");
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("pm_mdlogshow");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCaption("");
                fsp.setCustomParam("mdlog", (Object)xMDJson);
                this.getView().showForm(fsp);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof EntityOperate) {
            String operateKey = ((EntityOperate)args.getSource()).getOperateKey();
            IDataModel bill = this.getModel();
            IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
            if (BTN_MODIFY_ENTRY.equals(operateKey)) {
                EntryGrid entryGrid;
                int[] rows;
                BigDecimal totalAmount = (BigDecimal)bill.getValue("totalamount");
                BigDecimal totalTaxAmount = (BigDecimal)bill.getValue("totaltaxamount");
                BigDecimal totalAllAmount = (BigDecimal)bill.getValue("totalallamount");
                IPageCache pageCache = this.getPageCache();
                String deleteAmountCache = pageCache.get("deleteamount");
                String deleteTaxAmountCache = pageCache.get("deletetaxamount");
                String deleteAllAmountCache = pageCache.get("deleteallamount");
                if (StringUtils.isNotBlank((CharSequence)deleteAmountCache) && StringUtils.isNotBlank((CharSequence)deleteTaxAmountCache) && StringUtils.isNotBlank((CharSequence)deleteAllAmountCache)) {
                    totalAmount = totalAmount.add(new BigDecimal(deleteAmountCache));
                    totalTaxAmount = totalTaxAmount.add(new BigDecimal(deleteTaxAmountCache));
                    totalAllAmount = totalAllAmount.add(new BigDecimal(deleteAllAmountCache));
                    bill.setValue("totalamount", (Object)totalAmount);
                    bill.setValue("totaltaxamount", (Object)totalTaxAmount);
                    bill.setValue("totalallamount", (Object)totalAllAmount);
                }
                if ((rows = (entryGrid = (EntryGrid)this.getView().getControl("billentry")).getSelectRows()).length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"XPurOrderBillPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                for (int i = 0; i < rows.length; ++i) {
                    bill.setValue("entrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), rows[i]);
                }
                String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
                String[] billEntry2 = this.entryfields;
                String[] billEntry3 = this.getDifferentFromString(billEntry1, this.entryfields);
                Boolean inputMount = (Boolean)this.getModel().getValue("inputamount");
                if (inputMount.booleanValue() && "1".equals(this.getPageCache().get("inputamount"))) {
                    String[] billEntry4 = this.entrybackfields;
                    billEntry3 = this.getDifferentFromString(billEntry1, billEntry4);
                    billEntry2 = billEntry4;
                }
                for (int i = 0; i < rows.length; ++i) {
                    this.getView().setEnable(Boolean.FALSE, rows[i], billEntry3);
                    this.getView().setEnable(Boolean.TRUE, rows[i], billEntry2);
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_ENTRY});
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_ENTRY});
            } else if (BTN_MODIFY_PAY.equals(operateKey)) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("purbillentry_pay");
                int[] rows = entryGrid.getSelectRows();
                if (rows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"XPurOrderBillPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                for (int i = 0; i < rows.length; ++i) {
                    bill.setValue("payentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), rows[i]);
                }
                AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
                String[] payEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_pay");
                String[] payEntry3 = this.getDifferentFromString(payEntry1, this.payEntryfields);
                for (int i = 0; i < rows.length; ++i) {
                    this.getView().setEnable(Boolean.FALSE, rows[i], payEntry3);
                    this.getView().setEnable(Boolean.TRUE, rows[i], this.payEntryfields);
                    this.setPreTimePoint(i);
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_PAY});
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_PAY});
            } else if (BTN_MODIFY_DELIVER.equals(operateKey)) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("purbillentry_deliver");
                int[] rows = entryGrid.getSelectRows();
                if (rows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"XPurOrderBillPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                for (int i = 0; i < rows.length; ++i) {
                    bill.setValue("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), rows[i]);
                }
                String[] deliverEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_deliver");
                String[] deliverEntry3 = this.getDifferentFromString(deliverEntry1, this.deliverEntryfields);
                for (int i = 0; i < rows.length; ++i) {
                    this.getView().setEnable(Boolean.FALSE, rows[i], deliverEntry3);
                    this.getView().setEnable(Boolean.TRUE, rows[i], this.deliverEntryfields);
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_DELIVER});
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_DELIVER});
            } else if ("save".equalsIgnoreCase(operateKey) || "submit".equalsIgnoreCase(operateKey)) {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObjectCollection billEntrys = dataEntity.getDynamicObjectCollection("billentry");
                if (billEntrys == null || billEntrys.isEmpty()) {
                    return;
                }
                for (DynamicObject entry : billEntrys) {
                    BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                    BigDecimal amountUp = entry.getBigDecimal("amountup");
                    boolean isControlAmountUp = entry.getBoolean("iscontrolamountup");
                    if (amountAndTax == null || amountUp == null || isControlAmountUp || amountUp.compareTo(amountAndTax) == 0) continue;
                    entry.set("amountup", (Object)amountAndTax);
                }
            }
        }
        super.beforeDoOperation(args);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        IDataModel bill = this.getModel();
        String entryName = e.getEntryProp().getName();
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        int[] rows = e.getRowIndexs();
        if (rows.length > 1) {
            e.setCancel(true);
        }
        if ("billentry".equals(entryName)) {
            if (ChangeTypeEnum.UPDATE.getValue().equals(bill.getValue("entrychangetype", e.getRowIndexs()[0]))) {
                if (((BigDecimal)this.getModel().getValue("receivebaseqty", e.getRowIndexs()[0])).doubleValue() > 0.0 || ((BigDecimal)this.getModel().getValue("invbaseqty", e.getRowIndexs()[0])).doubleValue() > 0.0 || ((BigDecimal)this.getModel().getValue("payablepriceqty", e.getRowIndexs()[0])).doubleValue() > 0.0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u5df2\u7ecf\u53d1\u751f\u4e1a\u52a1\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XPurOrderBillPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]), e.getRowIndexs()[0] + 1));
                } else {
                    BigDecimal deleteAmount = this.ZERO;
                    BigDecimal deleteTaxAmount = this.ZERO;
                    BigDecimal deleteAllAmount = this.ZERO;
                    bill.setValue("entrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue(), e.getRowIndexs()[0]);
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_ENTRY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_ENTRY});
                    String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
                    for (int i = 0; i < rows.length; ++i) {
                        this.getView().setEnable(Boolean.FALSE, rows[i], billEntry1);
                        deleteAmount = deleteAmount.add((BigDecimal)bill.getValue("amount", rows[i]));
                        deleteTaxAmount = deleteTaxAmount.add((BigDecimal)bill.getValue("taxamount", rows[i]));
                        deleteAllAmount = deleteAllAmount.add((BigDecimal)bill.getValue("amountandtax", rows[i]));
                    }
                    IPageCache pageCache = this.getPageCache();
                    pageCache.put("deleteamount", deleteAmount.toString());
                    pageCache.put("deletetaxamount", deleteTaxAmount.toString());
                    pageCache.put("deleteallamount", deleteAllAmount.toString());
                }
                e.setCancel(true);
            } else if (ChangeTypeEnum.ADDNEW.getValue().equals(bill.getValue("entrychangetype", e.getRowIndexs()[0]))) {
                this.getView().setEnable(Boolean.FALSE, e.getRowIndexs()[0], new String[]{"entrychangetype"});
            } else {
                e.setCancel(true);
            }
        } else if ("purbillentry_pay".equals(entryName)) {
            if (ChangeTypeEnum.UPDATE.getValue().equals(bill.getValue("payentrychangetype", e.getRowIndexs()[0]))) {
                if (((BigDecimal)this.getModel().getValue("paidamount", e.getRowIndexs()[0])).doubleValue() > 0.0) {
                    bill.setValue("payentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), e.getRowIndexs()[0]);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ed8\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"XPurOrderBillPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]), e.getRowIndexs()[0] + 1));
                } else if (!StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("pretimepoint", e.getRowIndexs()[0]))) && PRETIMEPOINT_CONM.equals(this.getModel().getValue("pretimepoint", e.getRowIndexs()[0])) && !StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("paysrcbillentity", e.getRowIndexs()[0]))) && CONM_PURCONTRACT.equals(this.getModel().getValue("paysrcbillentity", e.getRowIndexs()[0]))) {
                    bill.setValue("payentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), e.getRowIndexs()[0]);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u9884\u4ed8\u65f6\u70b9\u4e3a\u91c7\u8d2d\u5408\u540c\u4e0d\u80fd\u5220\u884c\u3002", (String)"XPurOrderBillPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]), new Object[0]));
                } else {
                    bill.setValue("payentrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue(), e.getRowIndexs()[0]);
                    this.getView().setEnable(Boolean.TRUE, e.getRowIndexs()[0], new String[]{"payentrychangetype"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_PAY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_PAY});
                    String[] payEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_pay");
                    for (int i = 0; i < rows.length; ++i) {
                        this.getView().setEnable(Boolean.FALSE, rows[i], payEntry1);
                    }
                }
                e.setCancel(true);
            } else if (ChangeTypeEnum.ADDNEW.getValue().equals(bill.getValue("payentrychangetype", e.getRowIndexs()[0]))) {
                this.getView().setEnable(Boolean.FALSE, e.getRowIndexs()[0], new String[]{"payentrychangetype"});
            } else {
                e.setCancel(true);
            }
            AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
        } else if ("purbillentry_deliver".equals(entryName)) {
            if (ChangeTypeEnum.UPDATE.getValue().equals(bill.getValue("delentrychangetype", e.getRowIndexs()[0]))) {
                bill.setValue("delentrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue(), e.getRowIndexs()[0]);
                this.getView().setEnable(Boolean.TRUE, e.getRowIndexs()[0], new String[]{"delentrychangetype"});
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_DELIVER});
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_DELIVER});
                String[] deliverEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_deliver");
                for (int i = 0; i < rows.length; ++i) {
                    this.getView().setEnable(Boolean.FALSE, rows[i], deliverEntry1);
                }
                e.setCancel(true);
            } else if (ChangeTypeEnum.ADDNEW.getValue().equals(bill.getValue("delentrychangetype", e.getRowIndexs()[0]))) {
                this.getView().setEnable(Boolean.FALSE, e.getRowIndexs()[0], new String[]{"delentrychangetype"});
            } else {
                e.setCancel(true);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IDataModel bill = this.getModel();
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rows = e.getRowDataEntities();
        if ("billentry".equals(entryName)) {
            for (RowDataEntity row : rows) {
                bill.setValue("entrychangetype", (Object)ChangeTypeEnum.ADDNEW.getValue(), row.getRowIndex());
                this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"entrychangetype"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_ENTRY});
        } else if ("purbillentry_pay".equals(entryName)) {
            for (RowDataEntity row : rows) {
                bill.setValue("payentrychangetype", (Object)ChangeTypeEnum.ADDNEW.getValue(), row.getRowIndex());
                this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"payentrychangetype"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_PAY});
            AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
        } else if ("purbillentry_deliver".equals(entryName)) {
            for (RowDataEntity row : rows) {
                bill.setValue("delentrychangetype", (Object)ChangeTypeEnum.ADDNEW.getValue(), row.getRowIndex());
                this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"delentrychangetype"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_DELIVER});
        }
    }

    private String[] getDifferentFromString(String[] s1, String[] s2) {
        HashSet<String> hs1 = new HashSet<String>(Arrays.asList(s1));
        HashSet<String> hs2 = new HashSet<String>(Arrays.asList(s2));
        hs1.removeAll(hs2);
        return hs1.toArray(new String[0]);
    }

    private String[] getUnVisibleField() {
        String[] fields = new String[]{};
        return fields;
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int row = evt.getRow();
        if (evt.getSource() instanceof EntryGrid && row != -1) {
            String key = ((EntryGrid)evt.getSource()).getKey();
            if ("billentry".equals(key)) {
                String changeType = (String)this.getModel().getValue("entrychangetype", row);
                if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_ENTRY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_ENTRY});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_ENTRY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_ENTRY});
                }
            } else if ("purbillentry_pay".equals(key)) {
                String changeType = (String)this.getModel().getValue("payentrychangetype", row);
                if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_PAY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_PAY});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_PAY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_PAY});
                }
            } else if ("purbillentry_deliver".equals(key)) {
                String changeType = (String)this.getModel().getValue("delentrychangetype", row);
                if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_DELIVER});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_DELIVER});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_DELIVER});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_DELIVER});
                }
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        block8: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            switch (fieldKey) {
                case "linetype": {
                    this.changeLineType(oldValue, newValue, rowIndex);
                    continue block8;
                }
                case "discounttype": {
                    for (int i = 0; i < changeSet.length; ++i) {
                        if (!DiscountTypeEnum.FIXEDDIS.getValue().equals(changeSet[i].getNewValue())) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e7\u53d8\u66f4\u4e0d\u652f\u6301\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u989d\uff0c\u8bf7\u5207\u6362\u5230\u65b0\u53d8\u66f4\u3002", (String)"XPurOrderBillPlugin_6", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("discounttype", changeSet[i].getOldValue(), changeSet[i].getRowIndex());
                    }
                    continue block8;
                }
            }
        }
    }

    private void setPreTimePoint(int row) {
        Boolean isprepay = (Boolean)this.getModel().getValue("isprepay", row);
        String pretimepoint = (String)this.getModel().getValue("pretimepoint", row);
        String paysrcbillentity = (String)this.getModel().getValue("paysrcbillentity", row);
        if (CONM_PURCONTRACT.equals(paysrcbillentity)) {
            if (isprepay.booleanValue() && PRETIMEPOINT_CONM.equals(pretimepoint)) {
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"payrate"});
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"payamount"});
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"isprepay"});
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"pretimepoint"});
            } else if (!isprepay.booleanValue() || !PRETIMEPOINT_CONM.equals(pretimepoint)) {
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"pretimepoint"});
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (oldValue != null && newValue == null) {
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            this.getPageCache().put("stopChange", "false");
            return;
        }
        if (ChangeTypeEnum.ADDNEW.getValue().equals(this.getModel().getValue("entrychangetype", rowIndex))) {
            ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_LINETYPE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"XPurOrderBillPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, String.valueOf(rowIndex));
            this.getView().getPageCache().put(CACHE_LINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "confirm_linetype": {
                String customVaule = messageBoxClosedEvent.getCustomVaule();
                if (StringUtils.isBlank((CharSequence)customVaule)) {
                    return;
                }
                int rowIndex = Integer.parseInt(customVaule);
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    this.getModel().setValue("material", null, rowIndex);
                    this.getModel().setValue("expenseitem", null, rowIndex);
                    break;
                }
                String lineTypeId = this.getView().getPageCache().get(CACHE_LINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
                this.getView().getPageCache().remove(CACHE_LINETYPE);
            }
        }
    }
}

