/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.plan;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;
import kd.scmc.pm.utils.CommonUtils;

public class BatchSettingPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String BTNOK = "btnok";
    private static final Log log = LogFactory.getLog(BatchSettingPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit operator = (BasedataEdit)this.getView().getControl("entryoperator");
        if (operator != null) {
            operator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        Button btn = (Button)this.getView().getControl(BTNOK);
        btn.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object orgObj = this.getView().getParentView().getModel().getValue("org");
        if (orgObj != null) {
            DynamicObject orgDyObj = (DynamicObject)orgObj;
            Long orgId = (Long)orgDyObj.getPkValue();
            this.getPageCache().put("orgId", String.valueOf(orgId));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "entryoperator": {
                String orgId = this.getPageCache().get("orgId");
                if (CommonUtils.isNull((Object)orgId)) break;
                QFilter q1 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg(Long.parseLong(orgId)));
                QFilter q2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                try {
                    showParameter.getListFilterParameter().getQFilters().add(q1.and(q2));
                    break;
                }
                catch (Exception ee) {
                    log.error(ee.getMessage());
                    showParameter.getListFilterParameter().getQFilters().add(q1);
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        IDataModel model = this.getModel();
        if (btn.getKey().equalsIgnoreCase(BTNOK)) {
            DynamicObject entryOperatorDy = (DynamicObject)model.getValue("entryoperator");
            String purMethod = (String)model.getValue("purmethod");
            Date date = (Date)model.getValue("purdate");
            HashMap<String, Object> returnMap = new HashMap<String, Object>(3);
            if (!CommonUtils.isNull((Object)entryOperatorDy)) {
                returnMap.put("entryoperator", entryOperatorDy);
            }
            if (!CommonUtils.isNull((Object)purMethod)) {
                returnMap.put("purmethod", purMethod);
            }
            if (!CommonUtils.isNull((Object)date)) {
                returnMap.put("purdate", date);
            }
            if (returnMap.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6279\u91cf\u8bbe\u7f6e\u7684\u503c\u3002", (String)"BatchSettingPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private List<Long> getOperatorGroupByOrg(long orgId) {
        QFilter q3;
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "in", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue()), q3 = new QFilter("enable", "in", (Object)EnableStatusEnum.ENABLE.getValue())});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }
}

