/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.refund;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BizCategoryHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.business.pojo.AmountPropertyKey;
import kd.scmc.pm.enums.DiscountTypeEnum;
import kd.scmc.pm.enums.OwnerTypeEnum;

public class PurRefundApplyBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener {
    private Map<String, Object> tempCache = new HashMap<String, Object>();
    private static final Log log = LogFactory.getLog(PurRefundApplyBillPlugin.class);
    private final Long BIZTYPE_REFUND = 688847172015446016L;
    private final Long BIZTYPE_BACKFILL = 688850502762584064L;
    private final Long BIZTYPE_VMIREFUND = 691915699186345984L;
    private final String ADDRESSF7 = "addressf7";
    private final String PROVIDERADDRESSF7 = "provideraddressf7";
    private static final BigDecimal ZERO = BigDecimal.ZERO;

    public void registerListener(EventObject e) {
        BasedataEdit material;
        BasedataEdit providerAddressF7;
        BasedataEdit addressF7;
        BasedataEdit bizType;
        BasedataEdit owner;
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addRowClickListener((RowClickEventListener)this);
        }
        if ((owner = (BasedataEdit)this.getView().getControl("owner")) != null) {
            owner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizType = (BasedataEdit)this.getView().getControl("biztype")) != null) {
            bizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.getControl("address") != null) {
            this.addClickListeners(new String[]{"address"});
        }
        if (this.getControl("provideraddress") != null) {
            this.addClickListeners(new String[]{"provideraddress"});
        }
        if ((addressF7 = (BasedataEdit)this.getControl("addressf7")) != null) {
            addressF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((providerAddressF7 = (BasedataEdit)this.getControl("provideraddressf7")) != null) {
            providerAddressF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        int entryCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryCount; ++i) {
            this.initPayOrg(i);
            this.initOwner(i);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && BizCategoryHelper.isVMI((Long)((Long)bizType.getPkValue()))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"paymode"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"paymode"});
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status) || OperationStatus.EDIT.equals((Object)status)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"biztype"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"biztype"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("batchfillentry".equals(operateKey)) {
            Object value;
            EntryGrid entry = (EntryGrid)this.getControl("billentry");
            String focusField = entry.getEntryState().getFocusField();
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            int focusRow = entry.getEntryState().getFocusRow();
            List<String> fields = Arrays.asList("discounttype", "discountrate");
            if (focusRow > -1 && fields.contains(focusField) && (value = this.getModel().getValue(focusField, focusRow)) != null) {
                for (int i = focusRow; i < this.getModel().getEntryRowCount("billentry"); ++i) {
                    boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                    if (!isPresent) {
                        this.getModel().setValue(focusField, value, i);
                        continue;
                    }
                    if (isTax && focusField.equals("priceandtax")) {
                        this.getModel().setValue(focusField, value, i);
                        BigDecimal priceAndTax = (BigDecimal)this.getModel().getValue("priceandtax", i);
                        if (priceAndTax.compareTo(BigDecimal.ZERO) > 0) {
                            this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), i);
                            this.getModel().setValue("discountrate", (Object)new BigDecimal(100), i);
                            continue;
                        }
                        if (priceAndTax.compareTo(BigDecimal.ZERO) != 0) continue;
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i);
                        this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, i);
                        continue;
                    }
                    if (isTax || !focusField.equals("price")) continue;
                    this.getModel().setValue(focusField, value, i);
                    BigDecimal price = (BigDecimal)this.getModel().getValue("price", i);
                    if (price.compareTo(BigDecimal.ZERO) > 0) {
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), i);
                        this.getModel().setValue("discountrate", (Object)new BigDecimal(100), i);
                        continue;
                    }
                    if (price.compareTo(BigDecimal.ZERO) != 0) continue;
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i);
                    this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, i);
                }
                e.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        block20: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldKey) {
                case "entrysettleorg": {
                    this.changeEntrySettleOrg(newValue, rowIndex);
                    continue block20;
                }
                case "supplier": {
                    this.changeSupplier(newValue);
                    continue block20;
                }
                case "entryinvcorg": 
                case "entryreqorg": {
                    this.changeOwner(rowIndex);
                    continue block20;
                }
                case "price": 
                case "priceandtax": {
                    boolean isPresent = (Boolean)this.getModel().getValue("ispresent", rowIndex);
                    if (!isPresent) continue block20;
                    BigDecimal price = (BigDecimal)newValue;
                    if (BigDecimalUtil.isZero((BigDecimal)price)) {
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                        this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                        continue block20;
                    }
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
                    this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
                    continue block20;
                }
                case "ispresent": {
                    this.changeIsPresent(newValue, rowIndex);
                    this.calcAllAmount();
                    continue block20;
                }
                case "addressf7": {
                    DynamicObject addressF7 = (DynamicObject)changeSet[0].getNewValue();
                    this.getModel().setValue("address", (Object)addressF7.getString("detailaddress"));
                    continue block20;
                }
                case "provideraddressf7": {
                    DynamicObject providerAddressF7 = (DynamicObject)changeSet[0].getNewValue();
                    this.getModel().setValue("provideraddress", (Object)providerAddressF7.getString("detailaddress"));
                    continue block20;
                }
            }
        }
    }

    private void calcAllAmount() {
        IDataModel model = this.getModel();
        Map totalAmountMap = AmountHelper.calcAllAmount((DynamicObject)model.getDataEntity(true), (AmountPropertyKey)AmountPropertyKey.getInstance());
        this.getView().updateView("billentry");
        for (Map.Entry entry : totalAmountMap.entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel model = this.getModel();
        int row = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (!"org".equals(fieldKey) && org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"BillTplPlugin_25", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject supplier = (DynamicObject)model.getValue("supplier");
        DynamicObject providerSupplier = (DynamicObject)model.getValue("providersupplier");
        DynamicObject entryRecOrg = (DynamicObject)model.getValue("entryinvcorg", row);
        switch (fieldKey) {
            case "owner": {
                Map orgRelation;
                String ownerType = (String)model.getValue("ownertype", row);
                if (!OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType)) break;
                List<Long> orgIds = new ArrayList<Long>();
                Long recOrgId = null;
                if (entryRecOrg != null && (orgRelation = OrgHelper.getOrgRelation((Long)(recOrgId = (Long)entryRecOrg.getPkValue()), (String)"10", (String)"05", (String)"fromorg")) != null && orgRelation.get("orgId") != null) {
                    orgIds = (List)orgRelation.get("orgId");
                }
                QFilter filter = null;
                if (orgIds == null || orgIds.isEmpty()) {
                    filter = new QFilter("fisaccounting", "=", (Object)Boolean.TRUE);
                } else {
                    Long recSettleOrg;
                    if (recOrgId != null && recOrgId.equals(recSettleOrg = this.getSettleOrg(recOrgId))) {
                        orgIds.add(recOrgId);
                    }
                    filter = new QFilter("id", "in", orgIds);
                }
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "addressf7": {
                if (supplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurRefundApplyBillPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter id1 = new QFilter("supplierid", "in", (Object)supplier.getPkValue().toString());
                QFilter id2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(id1, id2));
                break;
            }
            case "provideraddressf7": {
                if (providerSupplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurRefundApplyBillPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter id1 = new QFilter("supplierid", "in", (Object)providerSupplier.getPkValue().toString());
                QFilter id2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(id1, id2));
                break;
            }
        }
    }

    public void click(EventObject evt) {
        DynamicObject org;
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ((key.equals("provideraddress") || key.equals("address")) && (org = (DynamicObject)this.getModel().getValue("org")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"BillTplPlugin_25", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (c.getKey().equalsIgnoreCase("provideraddress")) {
            BasedataEdit providerAddressF7 = (BasedataEdit)this.getControl("provideraddressf7");
            providerAddressF7.click();
        } else if (c.getKey().equalsIgnoreCase("address")) {
            BasedataEdit addressF7 = (BasedataEdit)this.getControl("addressf7");
            addressF7.click();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObject org;
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if ("billentry".equals(entryName) && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.initPayOrg(rowIndex);
                this.initOwner(rowIndex);
            }
        }
    }

    private void changeEntrySettleOrg(Object newValue, int rowIndex) {
        Long entrySettleOrgId;
        IDataModel model = this.getModel();
        DynamicObject entrySettleOrg = (DynamicObject)model.getValue("entrysettleorg");
        Long l = entrySettleOrgId = entrySettleOrg == null ? null : (Long)entrySettleOrg.getPkValue();
        if (entrySettleOrgId != null) {
            Long entryPayOrg = OrgHelper.getToOrg((String)"10", (String)"08", (Long)entrySettleOrgId, (boolean)true);
            model.setValue("entrypayorg", (Object)entryPayOrg, rowIndex);
        } else {
            model.setValue("entrypayorg", null, rowIndex);
        }
    }

    private void changeSupplier(Object newValue) {
        IDataModel model = this.getModel();
        String ownerType = (String)model.getValue("ownertype");
        if (OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue().equals(ownerType)) {
            DynamicObject supplier = (DynamicObject)model.getValue("supplier");
            Long supplierId = supplier == null ? null : (Long)supplier.getPkValue();
            int entryRowCount = model.getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                model.setValue("owner", (Object)supplierId, i);
            }
        }
    }

    private void initPayOrg(int rowIndex) {
        DynamicObject entrySettleOrg;
        IDataModel model = this.getModel();
        if (model.getValue("entrysettleorg", rowIndex) == null) {
            return;
        }
        if (model.getValue("entrypayorg", rowIndex) == null && (entrySettleOrg = (DynamicObject)model.getValue("entrysettleorg")) != null) {
            Long entryPayOrg = OrgHelper.getToOrg((String)"10", (String)"08", (Long)((Long)entrySettleOrg.getPkValue()), (boolean)true);
            model.setValue("entrypayorg", (Object)entryPayOrg, rowIndex);
        }
    }

    private void initOwner(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        if (bizType != null && BizCategoryHelper.isVMI((Long)((Long)bizType.getPkValue()))) {
            model.setValue("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue(), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ownertype"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"owner"});
        }
        String ownerType = (String)model.getValue("ownertype", rowIndex);
        if (OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue().equals(ownerType)) {
            DynamicObject supplier = (DynamicObject)model.getValue("supplier");
            model.setValue("owner", supplier == null ? null : supplier.getPkValue(), rowIndex);
        } else if (OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType)) {
            model.setValue("owner", (Object)this.getOrgOwner(rowIndex), rowIndex);
        }
    }

    private void calcTotalAmount() {
        IDataModel model = this.getModel();
        for (Map.Entry entry : AmountHelper.calcTotalAmount((DynamicObject)model.getDataEntity(true)).entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        if (newValue instanceof Boolean) {
            boolean isPresent = (Boolean)newValue;
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            this.getModel().beginInit();
            if (isPresent) {
                IDataModel model = this.getModel();
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
                if (isTax) {
                    if (priceAndTax.compareTo(BigDecimal.ZERO) > 0) {
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
                        this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
                    } else if (priceAndTax.compareTo(BigDecimal.ZERO) == 0) {
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                        this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                    }
                } else if (price.compareTo(BigDecimal.ZERO) > 0) {
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
                    this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
                } else if (price.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                    this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                }
            } else {
                this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
            }
            this.getModel().endInit();
        }
    }

    private void changeOwner(int rowIndex) {
        DynamicObject org;
        IDataModel model = this.getModel();
        String ownerType = (String)model.getValue("ownertype", rowIndex);
        if (OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType) && (org = (DynamicObject)model.getValue("org")) != null) {
            Long orgOwner = this.getOrgOwner(rowIndex);
            model.setValue("owner", (Object)orgOwner, rowIndex);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        DynamicObject org = this.getBaseDataFromCache(e.getSourceData(), "org", "bos_org", null);
        if (org == null) {
            return;
        }
        DynamicObject billtype = this.getBaseDataFromCache(e.getSourceData(), "billtype", "bos_billtype", "billformid");
        Map billtypeMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("billtype"));
        String formId = this.getView().getEntityId();
        DynamicObject billtypeparameter = (DynamicObject)this.tempCache.get("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")));
        if (billtype != null && billtypeparameter == null) {
            billtypeparameter = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)"pm_billtypeparameter", (long)((Long)billtype.getPkValue()));
            this.tempCache.put("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")), billtypeparameter);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        Long lineTypeId;
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection billentrys = (DynamicObjectCollection)model.getValue("billentry");
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        if (org == null) {
            return;
        }
        Long bizTypeId = null;
        if (billType != null && bizType == null) {
            bizTypeId = (Long)this.tempCache.get(billType.getPkValue() + "-biztype");
            if (bizTypeId == null && (bizTypeId = BizTypeHelper.getDefaultBizType((String)"pm_purrefundapplybill", (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter")) != null) {
                this.tempCache.put(billType.getPkValue() + "-biztype", bizTypeId);
            }
            if (bizTypeId != null) {
                model.setValue("biztype", (Object)bizTypeId);
            }
        } else if (bizType != null) {
            bizTypeId = (Long)bizType.getPkValue();
        }
        DynamicObject defaultLineType = null;
        if (bizTypeId != null && (lineTypeId = BizTypeHelper.getDefaultLineType((Long)bizTypeId)) != null) {
            defaultLineType = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype");
        }
        Map totalAmountMap = null;
        if (billentrys != null) {
            for (int i = 0; i < billentrys.size(); ++i) {
                DynamicObject material;
                DynamicObject billentry = (DynamicObject)billentrys.get(i);
                DynamicObject lineType = billentry.getDynamicObject("linetype");
                if (lineType == null && defaultLineType != null) {
                    billentry.set("linetype", (Object)defaultLineType);
                }
                if ((material = billentry.getDynamicObject("material")) == null || material.getDynamicObject("masterid") == null) break;
                billentry.set("auxunit", (Object)material.getDynamicObject("masterid").getDynamicObject("auxptyunit"));
                DynamicObject owner = billentry.getDynamicObject("owner");
                if (bizTypeId != null && BizCategoryHelper.isVMI((Long)bizTypeId)) {
                    model.setValue("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue(), i);
                    model.setValue("owner", model.getValue("supplier"), i);
                } else {
                    model.setValue("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_ORG.getValue(), i);
                    if (owner == null) {
                        model.setValue("owner", (Object)this.getOrgOwner(i), i);
                    }
                }
                boolean isPresent = (Boolean)billentry.get("ispresent");
                boolean isTax = (Boolean)this.getModel().getValue("istax");
                if (!isPresent) continue;
                if (isTax) {
                    BigDecimal priceAndTax = billentry.getBigDecimal("priceandtax");
                    if (priceAndTax.compareTo(BigDecimal.ZERO) > 0) {
                        billentry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                        billentry.set("discountrate", (Object)new BigDecimal("100"));
                    } else {
                        billentry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                        billentry.set("discountrate", (Object)BigDecimal.ZERO);
                    }
                } else {
                    BigDecimal price = billentry.getBigDecimal("price");
                    if (price.compareTo(BigDecimal.ZERO) > 0) {
                        billentry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                        billentry.set("discountrate", (Object)new BigDecimal("100"));
                    } else {
                        billentry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                        billentry.set("discountrate", (Object)BigDecimal.ZERO);
                    }
                }
                billentry.set("amount", (Object)ZERO);
                billentry.set("curamount", (Object)ZERO);
                billentry.set("taxamount", (Object)ZERO);
                billentry.set("curtaxamount", (Object)ZERO);
                billentry.set("amountandtax", (Object)ZERO);
                billentry.set("curamountandtax", (Object)ZERO);
            }
            totalAmountMap = AmountHelper.calcAllAmount((DynamicObject)model.getDataEntity(true), (AmountPropertyKey)AmountPropertyKey.getInstance());
        }
        if (totalAmountMap == null) {
            model.setValue("totalamount", (Object)BigDecimalUtil.ZERO);
            model.setValue("totaltaxamount", (Object)BigDecimalUtil.ZERO);
            model.setValue("totalallamount", (Object)BigDecimalUtil.ZERO);
        } else {
            for (Map.Entry entry : totalAmountMap.entrySet()) {
                model.setValue((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private Long getOrgOwner(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject entryReqOrg = (DynamicObject)model.getValue("entryreqorg", rowIndex);
        DynamicObject entryRecOrg = (DynamicObject)model.getValue("entryinvcorg", rowIndex);
        Long ownerId = null;
        if (entryReqOrg != null && entryRecOrg != null) {
            String owner;
            Long reqOrgId = (Long)entryReqOrg.getPkValue();
            Long recOrgId = (Long)entryRecOrg.getPkValue();
            String ownerCacheKey = reqOrgId + "_" + recOrgId + "owner";
            if (reqOrgId != null && recOrgId != null && StringUtils.isNotBlank((CharSequence)(owner = this.getPageCache().get(ownerCacheKey)))) {
                return Long.valueOf(owner);
            }
            Map orgRelation = OrgHelper.getOrgRelation((Long)recOrgId, (String)"10", (String)"05", (String)"fromorg");
            List orgIds = (List)orgRelation.get("orgId");
            Long reqSettleId = this.getSettleOrg(reqOrgId);
            if (orgIds != null && orgIds.contains(reqSettleId)) {
                ownerId = reqSettleId;
            } else {
                List detailList = (List)orgRelation.get("data");
                if (detailList != null) {
                    for (Map detailMap : detailList) {
                        Boolean isDefault = (Boolean)detailMap.get("isDefault");
                        if (isDefault == null || !isDefault.booleanValue()) continue;
                        ownerId = (Long)detailMap.get("orgId");
                        break;
                    }
                }
            }
            if (ownerId != null) {
                this.getPageCache().put(ownerCacheKey, ownerId.toString());
            }
        }
        return ownerId;
    }

    private Long getSettleOrg(Long orgId) {
        if (orgId != null) {
            String settleOrgValue = this.getPageCache().get(orgId + "settleorg");
            if (StringUtils.isNotBlank((CharSequence)settleOrgValue)) {
                return Long.valueOf(settleOrgValue);
            }
            Map map = OrgHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (map != null && map.get("id") != null) {
                Long settleOrgId = (Long)map.get("id");
                this.getPageCache().put(orgId + "settleorg", settleOrgId.toString());
                return settleOrgId;
            }
        }
        return null;
    }

    private QFilter getBaseDataOrgFilterFromCache(DynamicObject org, String propName, String propEntityName) {
        QFilter baseDataOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_" + propName + "OrgFilter");
        if (baseDataOrgFilter == null) {
            baseDataOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)propEntityName, (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_" + propName + "OrgFilter", baseDataOrgFilter);
        }
        return baseDataOrgFilter;
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select) {
        if (sourceData == null) {
            return null;
        }
        Map propMap = BillImportHelper.format4ImportAndApi((Object)sourceData.get(propName));
        String importProp = null;
        if (propMap != null) {
            importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])new QFilter(importProp, "=", (Object)((String)propMap.get(importProp))).toArray());
            }
            return value;
        }
        return null;
    }
}

