/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.tpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BackCalculationHelper;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.CurrencyHelper;
import kd.scmc.pm.business.helper.PurOrderBillHelper;
import kd.scmc.pm.enums.DiscountTypeEnum;
import kd.scmc.pm.enums.ExchangeTypeEnum;
import kd.scmc.pm.enums.UnitConvertDirEnum;
import kd.scmc.pm.utils.CommonUtils;

public class BackCalculationPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
EntryGridBindDataListener {
    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100);
    private static final String CHANGE_INPUTAMOUNT_CACHE = "changeinputamountcache";
    private static final long CHANGETIME = 500L;

    public void registerListener(EventObject e) {
        Toolbar toolbar;
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addRowClickListener((RowClickEventListener)this);
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((toolbar = (Toolbar)this.getView().getControl("tbmainentry")) != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeInputAmount();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!this.isBackCalculate()) {
            return;
        }
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            String key;
            FormOperate operate = (FormOperate)args.getSource();
            switch (key = operate.getOperateKey()) {
                case "discountamount": {
                    DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                    if (settleCurrency == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u5e01\u3002", (String)"BackCalculationPlugin_10", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    int rowCount = this.getModel().getEntryRowCount("billentry");
                    Boolean isHasRow = Boolean.FALSE;
                    for (int i = 0; i < rowCount; ++i) {
                        BigDecimal amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i);
                        boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                        if (isPresent || amountAndTax.compareTo(BigDecimal.ZERO) <= 0) continue;
                        isHasRow = Boolean.TRUE;
                        break;
                    }
                    if (isHasRow.booleanValue()) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d60\u54c1\u6216\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u4e3a0\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u603b\u6298\u6263\u989d\u3002", (String)"BackCalculationPlugin_11", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                case "gainprice": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5f55\u5165\u91d1\u989d\u201d\u5f00\u5173\u4e3a\u201c\u662f\u201d\u65f6\u4e0d\u652f\u6301\u83b7\u53d6\u4ef7\u683c\uff0c\u8bf7\u628a\u201c\u5f55\u5165\u91d1\u989d\u201d\u5f00\u5173\u7f6e\u4e3a\u201c\u5426\u201d\uff0c\u518d\u8fdb\u884c\u83b7\u53d6\u4ef7\u683c\u3002", (String)"BackCalculationPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        String propName = e.getProperty().getName();
        if (!"inputamount".equals(propName)) {
            if (this.isBackCalculate()) {
                List<String> fields = this.getFieldList(new String[]{"price", "priceandtax"});
                if (this.isReturnOld(propName, fields, valueSet)) {
                    return;
                }
            } else {
                List<String> fields = this.getFieldList(new String[]{"amount", "amountandtax"});
                this.isReturnOld(propName, fields, valueSet);
                return;
            }
        }
        switch (propName) {
            case "auxqty": {
                DynamicObject bill = this.getModel().getDataEntity(true);
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex;
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i]) || !this.isCheckDiscountRate(rowIndex = valueSet[i].getRowIndex(), propName, valueSet[i])) continue;
                    ChangeData changeData = valueSet[i];
                    Object newValue = changeData.getNewValue();
                    this.changeAuxQty(newValue, rowIndex);
                    BackCalculationHelper.backCalculationPrice((DynamicObject)bill, (int[])new int[]{rowIndex});
                }
                this.doRefresh(valueSet);
                this.doRefreshHeadAmount();
                break;
            }
            case "unit": {
                DynamicObject bill = this.getModel().getDataEntity(true);
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex;
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i]) || !this.isCheckDiscountRate(rowIndex = valueSet[i].getRowIndex(), propName, valueSet[i])) continue;
                    ChangeData changeData = valueSet[i];
                    Object newValue = changeData.getNewValue();
                    this.changeUnit(newValue, rowIndex);
                    BackCalculationHelper.backCalculationPrice((DynamicObject)bill, (int[])new int[]{rowIndex});
                }
                this.doRefresh(valueSet);
                this.doRefreshHeadAmount();
                break;
            }
            case "qty": {
                DynamicObject bill = this.getModel().getDataEntity(true);
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex;
                    ChangeData changeData = valueSet[i];
                    Object newValue = changeData.getNewValue();
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i]) || !this.isCheckDiscountRate(rowIndex = valueSet[i].getRowIndex(), propName, valueSet[i])) continue;
                    this.changeQty(newValue, rowIndex);
                    BackCalculationHelper.backCalculationPrice((DynamicObject)bill, (int[])new int[]{rowIndex});
                }
                this.doRefresh(valueSet);
                this.doRefreshHeadAmount();
                break;
            }
            case "taxrateid": {
                DynamicObject bill = this.getModel().getDataEntity(true);
                for (int i = 0; i < valueSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                    int rowIndex = valueSet[i].getRowIndex();
                    this.changeTaxRateID((DynamicObject)valueSet[i].getNewValue(), rowIndex);
                    if (!this.isCheckDiscountRate(rowIndex, propName, valueSet[i])) continue;
                    BackCalculationHelper.backCalculationTaxRate((DynamicObject)bill, (int[])new int[]{rowIndex}, (IDataModel)this.getModel());
                }
                this.doRefresh(valueSet);
                this.doRefreshHeadAmount();
                break;
            }
            case "discounttype": 
            case "discountrate": {
                if ("true".equals(this.getPageCache().get("ispresent"))) {
                    return;
                }
                DynamicObject bill = this.getModel().getDataEntity(true);
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex = valueSet[i].getRowIndex();
                    if (!this.changeDiscountInfo(valueSet[i], rowIndex, propName) || !this.isCheckDiscountRate(rowIndex, propName, valueSet[i])) continue;
                    BackCalculationHelper.backCalculationPrice((DynamicObject)bill, (int[])new int[]{rowIndex});
                }
                this.getPageCache().remove("ispresent");
                this.doRefresh(valueSet);
                this.doRefreshHeadAmount();
                break;
            }
            case "discountamount": {
                if ("true".equals(this.getPageCache().get("ispresent"))) {
                    return;
                }
                DynamicObject bill = this.getModel().getDataEntity(true);
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex = valueSet[i].getRowIndex();
                    if (!this.changeDiscountInfo(valueSet[i], rowIndex, propName) || !this.isCheckDiscountRate(rowIndex, propName, valueSet[i])) continue;
                    BackCalculationHelper.backCalculationPrice((DynamicObject)bill, (int[])new int[]{rowIndex}, (Boolean)Boolean.TRUE);
                }
                this.getPageCache().remove("ispresent");
                this.doRefresh(valueSet);
                this.doRefreshHeadAmount();
                break;
            }
            case "exchangerate": 
            case "exchangetype": {
                if (!CommonUtils.isRealChanged((ChangeData)valueSet[0])) {
                    return;
                }
                DynamicObject bill = this.getModel().getDataEntity(true);
                BackCalculationHelper.backCalculationWholeBillExchangeRate((DynamicObject)bill);
                this.doRefresh(null);
                this.doRefreshHeadAmount();
                break;
            }
            case "istax": {
                DynamicObject bill = this.getModel().getDataEntity(true);
                if (BackCalculationHelper.cheackDiscountRateToEntry((DynamicObject)bill).booleanValue()) {
                    this.changeInputAmount();
                    BackCalculationHelper.backCalculationWholeBillIsTax((DynamicObject)bill, (Boolean)((Boolean)valueSet[0].getNewValue()), (IDataModel)this.getModel());
                } else {
                    this.getPageCache().put("stopChange", "true");
                    this.getModel().setValue(propName, valueSet[0].getOldValue());
                    this.getPageCache().put("stopChange", "false");
                    this.showErrMsg();
                }
                this.doRefresh(null);
                this.doRefreshHeadAmount();
                break;
            }
            case "amount": 
            case "amountandtax": {
                if ("true".equals(this.getPageCache().get("ispresent"))) {
                    return;
                }
                DynamicObject bill = this.getModel().getDataEntity(true);
                for (int i = 0; i < valueSet.length; ++i) {
                    BigDecimal newValue;
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                    int rowIndex = valueSet[i].getRowIndex();
                    BigDecimal oldValue = (BigDecimal)valueSet[i].getOldValue();
                    if (oldValue == null) {
                        oldValue = BigDecimal.ZERO;
                    }
                    if ((newValue = (BigDecimal)valueSet[i].getNewValue()).compareTo(BigDecimal.ZERO) < 0) {
                        if (propName.equals("amount")) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u5206\u5f55\u7b2c%s\u884c\u7684\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"BackCalculationPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]), rowIndex + 1));
                        } else {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u5206\u5f55\u7b2c%s\u884c\u7684\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"BackCalculationPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]), rowIndex + 1));
                        }
                        this.revertEntryValue(valueSet[i], rowIndex, propName);
                        break;
                    }
                    if (!BackCalculationHelper.checkDiscountRateToOther((int[])new int[]{rowIndex}, (IDataModel)this.getModel()).booleanValue()) {
                        this.revertEntryValue(valueSet[i], rowIndex, propName);
                        this.showErrMsg();
                        break;
                    }
                    BackCalculationHelper.backCalculation((DynamicObject)bill, (int[])new int[]{rowIndex}, (String)propName, (IDataModel)this.getModel());
                    BigDecimal totalBalance = BigDecimal.ZERO;
                    BigDecimal balance = newValue.subtract(oldValue);
                    totalBalance = totalBalance.add(balance);
                    if ("amountandtax".equals(propName)) {
                        this.getModel().setValue("totalallamount", (Object)bill.getBigDecimal("totalallamount").add(totalBalance));
                        continue;
                    }
                    this.getModel().setValue("totalamount", (Object)bill.getBigDecimal("totalamount").add(totalBalance));
                }
                this.getPageCache().remove("ispresent");
                this.getView().updateView("purbillentry_pay");
                this.doRefresh(valueSet);
                this.doRefreshHeadAmount();
                break;
            }
            case "settlecurrency": {
                if (!CommonUtils.isRealChanged((ChangeData)valueSet[0])) {
                    return;
                }
                DynamicObject bill = this.getModel().getDataEntity(true);
                String entityName = this.getView().getEntityId();
                Object value = valueSet[0].getNewValue();
                if (BackCalculationHelper.cheackDiscountRateToEntry((DynamicObject)bill).booleanValue()) {
                    DynamicObject oldSettleCurrency = (DynamicObject)valueSet[0].getOldValue();
                    DynamicObject newSettleCurrency = (DynamicObject)valueSet[0].getNewValue();
                    if (oldSettleCurrency != null && newSettleCurrency != null && entityName.equals("pm_purorderbill") && (this.getPageCache().get("changeSupplier") == null || this.getPageCache().get("changeSupplier").equals("0")) && (this.getPageCache().get("gainprice") == null || this.getPageCache().get("gainprice").equals("0"))) {
                        this.getPageCache().put("oldSettleCurrency", String.valueOf(oldSettleCurrency.getPkValue()));
                        this.getPageCache().put("oldSettleCurrencyName", oldSettleCurrency.getString("name"));
                        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("switchsettlecurrency", (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u5207\u6362\u540e\uff0c\u662f\u5426\u6309\u65b0\u65e7\u7ed3\u7b97\u5e01\u95f4\u7684\u6c47\u7387\uff0c\u91cd\u7b97\u5355\u4ef7\u3001\u91d1\u989d\u4fe1\u606f\uff1f", (String)"BackCalculationPlugin_7", (String)"scmc-pm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
                    } else {
                        this.getPageCache().put("changeSupplier", "0");
                        this.getPageCache().put("gainprice", "0");
                        bill = this.getModel().getDataEntity(true);
                        if (((Boolean)this.getModel().getValue("istax")).booleanValue()) {
                            BackCalculationHelper.backCalculsettlecurrency((DynamicObject)bill, (String)"amountandtax", (IDataModel)this.getModel());
                        } else {
                            BackCalculationHelper.backCalculsettlecurrency((DynamicObject)bill, (String)"amount", (IDataModel)this.getModel());
                        }
                    }
                } else {
                    this.getPageCache().put("stopChange", "true");
                    this.getModel().setValue(propName, valueSet[0].getOldValue());
                    this.getPageCache().put("stopChange", "false");
                    this.showErrMsg();
                }
                this.getView().updateView("purbillentry_pay");
                this.doRefresh(null);
                this.doRefreshHeadAmount();
                break;
            }
            case "inputamount": {
                this.changeInputAmount();
                this.getPageCache().put(CHANGE_INPUTAMOUNT_CACHE, String.valueOf(System.currentTimeMillis()));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "discountamount": {
                if (!this.isBackCalculate()) {
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("pm_discountamount");
                HashMap<String, Object> customParams = new HashMap<String, Object>(8);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                customParams.put("currency", settleCurrency.getPkValue());
                formShowParameter.setCustomParams(customParams);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pm_discountamount"));
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        DynamicObject bill = this.getModel().getDataEntity(true);
        DynamicObject newSettleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
        switch (key) {
            case "switchsettlecurrency": {
                String entityId = this.getView().getEntityId();
                if ("Yes".equals(evt.getResultValue())) {
                    Boolean isTax;
                    DynamicObject exRateTable = (DynamicObject)this.getModel().getValue("exratetable");
                    Date bizTime = (Date)this.getModel().getValue("exratedate");
                    boolean isIndirectRate = false;
                    BigDecimal exchange = BigDecimal.ZERO;
                    if (exRateTable != null) {
                        Map exRateMap = CurrencyHelper.getExRateMap((Long)Long.valueOf(this.getPageCache().get("oldSettleCurrency")), (Long)((Long)newSettleCurrency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)bizTime);
                        exchange = (BigDecimal)exRateMap.get("exchangerate");
                        isIndirectRate = ExchangeTypeEnum.isIndirectRate(exRateMap.get("exchangetype"));
                    }
                    if (BigDecimalUtil.isBlank((BigDecimal)exchange)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u67e5\u8be2\u5230\u201c%1$s\u201d\u548c\u201c%2$s\u201d\u95f4\u7684\u6709\u6548\u6c47\u7387\uff0c\u5355\u4ef7\u3001\u91d1\u989d\u4fe1\u606f\u672a\u66f4\u65b0\u3002", (String)"BackCalculationPlugin_8", (String)"scmc-pm-formplugin", (Object[])new Object[0]), this.getPageCache().get("oldSettleCurrencyName"), newSettleCurrency.getString("name")));
                        if (((Boolean)this.getModel().getValue("istax")).booleanValue()) {
                            BackCalculationHelper.backCalculsettlecurrency((DynamicObject)bill, (String)"amountandtax", (IDataModel)this.getModel());
                        } else {
                            BackCalculationHelper.backCalculsettlecurrency((DynamicObject)bill, (String)"amount", (IDataModel)this.getModel());
                        }
                        if ("pm_purorderbill".equals(entityId)) {
                            AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
                        }
                        this.doRefresh(null);
                        this.doRefreshHeadAmount();
                        return;
                    }
                    int amtPrecision = newSettleCurrency.getInt("amtprecision");
                    if ("pm_purorderbill".equals(entityId)) {
                        int entryRowCount = this.getModel().getEntryRowCount("purbillentry_pay");
                        boolean isPayRate = (Boolean)this.getModel().getValue("ispayrate");
                        if (!isPayRate) {
                            for (int i = 0; i < entryRowCount; ++i) {
                                BigDecimal payAmount = (BigDecimal)this.getModel().getValue("payamount", i);
                                payAmount = AmountHelper.convertByExRate((BigDecimal)payAmount, (BigDecimal)exchange, (boolean)isIndirectRate, (int)amtPrecision);
                                this.getModel().setValue("payamount", (Object)payAmount, i);
                            }
                        }
                    }
                    String amountKey = (isTax = (Boolean)this.getModel().getValue("istax")) != null && isTax != false ? "amountandtax" : "amount";
                    DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
                    this.getModel().beginInit();
                    for (int i = 0; i < entries.size(); ++i) {
                        BigDecimal amount = BigDecimalUtil.getNotNull((Object)this.getModel().getValue(amountKey, i));
                        amount = AmountHelper.convertByExRate((BigDecimal)amount, (BigDecimal)exchange, (boolean)isIndirectRate, (int)amtPrecision);
                        this.getModel().setValue(amountKey, (Object)amount, i);
                    }
                    this.getModel().endInit();
                    BackCalculationHelper.backCalculsettlecurrency((DynamicObject)bill, (String)amountKey, (IDataModel)this.getModel());
                    this.doRefresh(null);
                    this.doRefreshHeadAmount();
                } else {
                    if (((Boolean)this.getModel().getValue("istax")).booleanValue()) {
                        BackCalculationHelper.backCalculsettlecurrency((DynamicObject)bill, (String)"amountandtax", (IDataModel)this.getModel());
                    } else {
                        BackCalculationHelper.backCalculsettlecurrency((DynamicObject)bill, (String)"amount", (IDataModel)this.getModel());
                    }
                    this.doRefresh(null);
                    this.doRefreshHeadAmount();
                }
                if (!"pm_purorderbill".equals(entityId)) break;
                AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "pm_discountamount": {
                int i;
                int settleAmtPrecision;
                Map discountMap;
                if (returnData == null || (discountMap = (Map)returnData) == null || discountMap.isEmpty() || discountMap.get("discountamount") == null) break;
                BigDecimal totalDiscountAmount = new BigDecimal(discountMap.get("discountamount").toString());
                BigDecimal remainDiscountAmount = new BigDecimal(discountMap.get("discountamount").toString());
                DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                int n = settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
                if (totalDiscountAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u603b\u6298\u6263\u989d\u5fc5\u987b\u4e3a\u6b63\u6570\u3002", (String)"BackCalculationPlugin_12", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    return;
                }
                int rowCount = this.getModel().getEntryRowCount("billentry");
                for (int i2 = 0; i2 < rowCount; ++i2) {
                    boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i2);
                    BigDecimal amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i2);
                    if (isPresent || amountAndTax.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i2);
                }
                BigDecimal allAmountAndTax = BigDecimal.ZERO;
                ArrayList<Integer> allDistRows = new ArrayList<Integer>(16);
                for (i = 0; i < rowCount; ++i) {
                    BigDecimal amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i);
                    boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                    if (isPresent || amountAndTax.compareTo(BigDecimal.ZERO) <= 0) continue;
                    allAmountAndTax = allAmountAndTax.add(amountAndTax);
                    allDistRows.add(i);
                }
                if (allAmountAndTax.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d60\u54c1\u6216\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u4e3a0\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u603b\u6298\u6263\u989d\u3002", (String)"BackCalculationPlugin_11", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (i = 0; i < allDistRows.size(); ++i) {
                    int rowIndex = (Integer)allDistRows.get(i);
                    BigDecimal amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", rowIndex);
                    BigDecimal rowDistAmount = BigDecimal.ZERO;
                    rowDistAmount = i == allDistRows.size() - 1 ? remainDiscountAmount : totalDiscountAmount.multiply(amountAndTax).divide(allAmountAndTax, settleAmtPrecision, 4);
                    remainDiscountAmount = remainDiscountAmount.subtract(rowDistAmount);
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.FIXEDDIS.getValue(), rowIndex);
                    this.getModel().setValue("discountamount", (Object)rowDistAmount, rowIndex);
                }
                break;
            }
        }
    }

    private void changeInputAmount() {
        this.getPageCache().put("inputamount", "1");
        Boolean inputAmount = (Boolean)this.getModel().getValue("inputamount");
        Boolean isTax = (Boolean)this.getModel().getValue("istax");
        if (isTax.booleanValue() && inputAmount.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"amountandtax"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"priceandtax", "price", "amount"});
        } else if (isTax.booleanValue() && !inputAmount.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"priceandtax"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amount", "price", "amountandtax"});
        } else if (!isTax.booleanValue() && inputAmount.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"amount"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"price", "priceandtax", "amountandtax"});
        } else if (!isTax.booleanValue() && !inputAmount.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"price"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amountandtax", "amount", "priceandtax"});
        }
    }

    private boolean changeDiscountInfo(ChangeData changeData, int rowIndex, String propName) {
        String discountType = (String)this.getModel().getValue("discounttype", rowIndex);
        Boolean inputAmount = (Boolean)this.getModel().getValue("inputamount");
        if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
            this.getPageCache().put("stopChange", "false");
            return true;
        }
        if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            BigDecimal discountRate = (BigDecimal)this.getModel().getValue("discountrate", rowIndex);
            if (discountRate != null && discountRate.compareTo(ONE_HUNDRED) > 0) {
                this.revertEntryValue(changeData, rowIndex, propName);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u7387(%)\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u8303\u56f4\u4e3a\uff1a0\u2264\u5355\u4f4d\u6298\u6263(\u7387)<100\u3002", (String)"BackCalculationPlugin_9", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        return (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) && inputAmount != false;
    }

    private void changeQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal qty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            if (material == null || unit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            model.beginInit();
            if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
            }
            if (baseUnit != null && master != null) {
                Long masterId = (Long)master.getPkValue();
                BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                model.setValue("baseqty", (Object)baseQty, rowIndex);
                if (auxUnit != null) {
                    String unitConvertDir = master.getString("unitconvertdir");
                    if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                        BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                        model.setValue("auxqty", (Object)auxQty, rowIndex);
                    }
                }
            }
            model.endInit();
            this.getView().updateView("baseunit", rowIndex);
            this.getView().updateView("baseqty", rowIndex);
            this.getView().updateView("auxqty", rowIndex);
        }
    }

    private void changeAuxQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal auxQty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            if (material == null || auxUnit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
            }
            if (baseUnit != null && unit != null && master != null) {
                Long masterId = (Long)master.getPkValue();
                String unitConvertDir = master.getString("unitconvertdir");
                if (UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)auxUnit, (BigDecimal)auxQty, (DynamicObject)baseUnit);
                    BigDecimal qty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                    model.beginInit();
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    model.setValue("qty", (Object)qty, rowIndex);
                    model.endInit();
                    this.getView().updateView("baseqty", rowIndex);
                    this.getView().updateView("qty", rowIndex);
                }
            }
        }
    }

    private void changeUnit(Object newValue, int rowIndex) {
        if (newValue instanceof DynamicObject) {
            DynamicObject unit = (DynamicObject)newValue;
            IDataModel model = this.getModel();
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
            int precision = BillQtyAndUnitHelper.getPrecision((DynamicObject)unit);
            int precisionaccount = BillQtyAndUnitHelper.getPrecisionType((DynamicObject)unit);
            qty = qty.setScale(precision, precisionaccount);
            model.beginInit();
            model.setValue("qty", (Object)qty, rowIndex);
            model.endInit();
            if (material != null && qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObject master = material.getDynamicObject("masterid");
                DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
                DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
                if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                    model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
                }
                model.beginInit();
                if (baseUnit != null && master != null) {
                    Long masterId = (Long)master.getPkValue();
                    BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    if (auxUnit != null) {
                        String unitConvertDir = master.getString("unitconvertdir");
                        if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                            BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                            model.setValue("auxqty", (Object)auxQty, rowIndex);
                        }
                    }
                }
                model.endInit();
                this.getView().updateView("baseunit", rowIndex);
                this.getView().updateView("baseqty", rowIndex);
                this.getView().updateView("auxqty", rowIndex);
                this.getView().updateView("qty", rowIndex);
            }
        }
    }

    private boolean changeTaxRateID(DynamicObject taxRateID, int rowIndex) {
        IDataModel model = this.getModel();
        if (taxRateID != null) {
            model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)0, rowIndex);
        }
        return true;
    }

    private boolean isCheckDiscountRate(int rowIndex, String propName, ChangeData changeData) {
        Boolean result = Boolean.TRUE;
        if (!BackCalculationHelper.checkDiscountRateToOther((int[])new int[]{rowIndex}, (IDataModel)this.getModel()).booleanValue()) {
            this.revertEntryValue(changeData, rowIndex, propName);
            this.showErrMsg();
            result = Boolean.FALSE;
        }
        return result;
    }

    private void showErrMsg() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u4ef7\u683c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BackCalculationPlugin_6", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
    }

    private void revertEntryValue(ChangeData changeData, int rowIndex, String propName) {
        this.getPageCache().put("stopChange", "true");
        this.getModel().setValue(propName, changeData.getOldValue(), rowIndex);
        this.getPageCache().put("stopChange", "false");
    }

    private void doRefresh(ChangeData[] valueSet) {
        boolean batchRefresh = false;
        if (valueSet == null) {
            this.getView().updateView("billentry");
        } else {
            if (valueSet.length > BigDecimal.TEN.intValue()) {
                batchRefresh = true;
            }
            if (batchRefresh) {
                this.getView().updateView("billentry");
            } else {
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex = valueSet[i].getRowIndex();
                    this.updateEntryAmountField(rowIndex);
                }
            }
        }
    }

    private void updateEntryAmountField(int rowIndex) {
        IFormView view = this.getView();
        view.updateView("price", rowIndex);
        view.updateView("priceandtax", rowIndex);
        view.updateView("amount", rowIndex);
        view.updateView("taxamount", rowIndex);
        view.updateView("discountrate", rowIndex);
        view.updateView("discountamount", rowIndex);
        view.updateView("amountandtax", rowIndex);
        view.updateView("curamount", rowIndex);
        view.updateView("curtaxamount", rowIndex);
        view.updateView("curamountandtax", rowIndex);
    }

    private void doRefreshHeadAmount() {
        this.getView().updateView("totalallamount");
        this.getView().updateView("totaltaxamount");
        this.getView().updateView("totalamount");
    }

    private boolean isBackCalculate() {
        Boolean inputamount = Boolean.FALSE;
        if (this.getControl("inputamount") != null) {
            inputamount = (Boolean)this.getModel().getValue("inputamount");
        }
        return inputamount;
    }

    private boolean isReturnOld(String propName, List<String> fields, ChangeData[] valueSet) {
        String startTimeStr;
        if (fields != null && fields.contains(propName) && (startTimeStr = this.getPageCache().get(CHANGE_INPUTAMOUNT_CACHE)) != null && Long.valueOf(startTimeStr) != null) {
            this.getPageCache().remove(CHANGE_INPUTAMOUNT_CACHE);
            long startTime = Long.parseLong(startTimeStr);
            long endTime = System.currentTimeMillis();
            if (endTime - startTime < 500L) {
                for (int i = 0; i < valueSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                    int rowIndex = valueSet[i].getRowIndex();
                    Object oldValue = valueSet[i].getOldValue();
                    this.getModel().setValue(propName, oldValue, rowIndex);
                }
                return true;
            }
        }
        return false;
    }

    private List<String> getFieldList(String[] strings) {
        ArrayList<String> fields = null;
        if (strings != null) {
            fields = new ArrayList<String>(strings.length);
            for (String str : strings) {
                fields.add(str);
            }
        }
        return fields;
    }
}

