/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.tpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.operation.entryrowop.model.EntryRowOpArgs;
import kd.bos.ext.scmc.plugin.operation.IEntryRowOpFormPlugin;
import kd.bos.form.IFormView;
import kd.scmc.pm.business.helper.AmountHelper;

public class BillEntryRowSplitOpFormPlugin
implements IEntryRowOpFormPlugin {
    private Integer unitPrecision = 10;
    private List<String> amountFields = new ArrayList<String>(8);

    public void calQtyTypeFields(EntryRowOpArgs args) {
        super.calQtyTypeFields(args);
        String entryKey = args.getEntryKey();
        List newRowIndex = args.getNewRowIndex();
        int srcRowIndex = args.getSrcRowIndex();
        IFormView view = args.getView();
        IDataModel model = view.getModel();
        String entityName = model.getDataEntityType().getName();
        this.initAmountFields(entityName);
        BigDecimal qty = (BigDecimal)model.getValue("qty", srcRowIndex);
        if (qty == null || BigDecimal.ZERO.compareTo(qty) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u884c\u672a\u586b\u5199\u6570\u91cf, \u62c6\u5206\u884c\u6570\u91cf\u91d1\u989d\u7b49\u5b57\u6bb5\u65e0\u6cd5\u8ba1\u7b97\u3002", (String)"BillEntryRowOpFormPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
        }
        Map<Integer, BigDecimal> rowIndexQtyMapping = this.getRowIndexQtyMapping(model, entryKey, "qty", "unit", srcRowIndex, newRowIndex);
        Map<Integer, BigDecimal> rowIndexAuxQtyMapping = this.getRowIndexQtyMapping(model, entryKey, "auxqty", "auxunit", srcRowIndex, newRowIndex);
        DynamicObject oldEntryInfo = (DynamicObject)OrmUtils.clone((IDataEntityBase)model.getEntryRowEntity(entryKey, srcRowIndex), (boolean)false, (boolean)false);
        this.setQtyValue(model, srcRowIndex, newRowIndex, rowIndexQtyMapping, "qty");
        if (!entityName.isEmpty() && "pm_purapplybill".equals(entityName)) {
            Map<Integer, BigDecimal> rowIndexApplyQtyMapping = this.getRowIndexQtyMapping(model, entryKey, "applyqty", "unit", srcRowIndex, newRowIndex);
            this.setQtyValue(model, srcRowIndex, newRowIndex, rowIndexApplyQtyMapping, "applyqty");
            model.beginInit();
            this.reCalLastRowAmount(model, srcRowIndex, newRowIndex, oldEntryInfo);
            model.endInit();
            view.updateView("totalallamount");
        }
        model.beginInit();
        this.setQtyValue(model, srcRowIndex, newRowIndex, rowIndexAuxQtyMapping, "auxqty");
        model.endInit();
        if (!entityName.isEmpty() && "pm_purorderbill".equals(entityName)) {
            Map<Integer, BigDecimal> amountUpMapping = this.setAmountUp(model, entryKey, "amountup", srcRowIndex, newRowIndex);
            model.beginInit();
            this.setQtyValue(model, srcRowIndex, newRowIndex, amountUpMapping, "amountup");
            this.reCalLastRowAmount(model, srcRowIndex, newRowIndex, oldEntryInfo);
            model.endInit();
            view.updateView("totaltaxamount");
            view.updateView("totalallamount");
            view.updateView("totalamount");
        }
        view.updateView(entryKey);
    }

    private Map<Integer, BigDecimal> setAmountUp(IDataModel model, String entryKey, String fieldKey, Integer srcRowIndex, List<Integer> newRowIndex) {
        int rowCount = newRowIndex.size() + 1;
        HashMap<Integer, BigDecimal> rowQtyMap = new HashMap<Integer, BigDecimal>(rowCount);
        DynamicObjectCollection billEntry = model.getDataEntity().getDynamicObjectCollection(entryKey);
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        Integer settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
        if (billEntry.isEmpty() || newRowIndex.isEmpty()) {
            return rowQtyMap;
        }
        DynamicObject entry = (DynamicObject)billEntry.get(srcRowIndex.intValue());
        if (entry == null) {
            return rowQtyMap;
        }
        BigDecimal amountUp = entry.getBigDecimal(fieldKey);
        if (amountUp == null || BigDecimal.ZERO.compareTo(amountUp) == 0) {
            return rowQtyMap;
        }
        BigDecimal average = amountUp.divide(new BigDecimal(rowCount), (int)settleAmtPrecision, RoundingMode.DOWN);
        BigDecimal multiply = average.multiply(new BigDecimal(newRowIndex.size()));
        BigDecimal lastRowAmount = amountUp.subtract(multiply);
        rowQtyMap.put(srcRowIndex, average);
        for (int i = 0; i < newRowIndex.size() - 1; ++i) {
            rowQtyMap.put(newRowIndex.get(i), average);
        }
        rowQtyMap.put(newRowIndex.get(newRowIndex.size() - 1), lastRowAmount);
        return rowQtyMap;
    }

    private void reCalLastRowAmount(IDataModel model, Integer srcRowIndex, List<Integer> newRowIndex, DynamicObject oldEntryInfo) {
        BigDecimal taxRate;
        Integer lastRow = newRowIndex.get(newRowIndex.size() - 1);
        for (String amountField : this.amountFields) {
            if (!oldEntryInfo.containsProperty(amountField)) continue;
            BigDecimal srcAmountValue = oldEntryInfo.getBigDecimal(amountField);
            BigDecimal newValue = (BigDecimal)model.getValue(amountField, srcRowIndex.intValue());
            if (srcAmountValue == null || BigDecimal.ZERO.compareTo(srcAmountValue) == 0 || newValue == null || BigDecimal.ZERO.compareTo(newValue) == 0) continue;
            this.dealLastLineField(model, srcAmountValue, srcRowIndex, newRowIndex, amountField);
            BigDecimal adjustedValue = (BigDecimal)model.getValue(amountField, lastRow.intValue());
            if (adjustedValue.compareTo(BigDecimal.ZERO) >= 0) continue;
            srcAmountValue = srcAmountValue.subtract(newValue);
            for (Integer rowIndex : newRowIndex) {
                if (srcAmountValue.compareTo(BigDecimal.ZERO) <= 0) {
                    model.setValue(amountField, (Object)BigDecimal.ZERO, rowIndex.intValue());
                }
                srcAmountValue = srcAmountValue.subtract((BigDecimal)model.getValue(amountField, rowIndex.intValue()));
            }
        }
        boolean taxRateZero = false;
        if (oldEntryInfo.containsProperty("taxrate") && ((taxRate = (BigDecimal)model.getValue("taxrate", lastRow.intValue())) == null || BigDecimal.ZERO.compareTo(taxRate) == 0)) {
            taxRateZero = true;
        }
        boolean isTax = false;
        if (model.getDataEntity().containsProperty("istax")) {
            isTax = (Boolean)model.getValue("istax");
        }
        if (taxRateZero && isTax && oldEntryInfo.containsProperty("amount") && oldEntryInfo.containsProperty("amountandtax")) {
            BigDecimal amountAndTax = (BigDecimal)model.getValue("amountandtax", lastRow.intValue());
            model.setValue("amount", (Object)amountAndTax, lastRow.intValue());
        }
        for (Map.Entry entry : AmountHelper.calcTotalAmount((DynamicObject)model.getDataEntity(true)).entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    private void dealLastLineField(IDataModel model, BigDecimal srcValue, Integer srcRowIndex, List<Integer> newRowIndex, String fieldKey) {
        BigDecimal srcAmount = (BigDecimal)model.getValue(fieldKey, srcRowIndex.intValue());
        BigDecimal lastAmount = srcValue.subtract(srcAmount.multiply(new BigDecimal(newRowIndex.size())));
        model.setValue(fieldKey, (Object)lastAmount, newRowIndex.get(newRowIndex.size() - 1).intValue());
    }

    private void initAmountFields(String entityName) {
        if (entityName.isEmpty()) {
            return;
        }
        if ("pm_purapplybill".equals(entityName)) {
            this.amountFields.add("amount");
            this.amountFields.add("taxamount");
            this.amountFields.add("amountandtax");
        }
        if ("pm_purorderbill".equals(entityName)) {
            this.amountFields.add("amount");
            this.amountFields.add("curamount");
            this.amountFields.add("taxamount");
            this.amountFields.add("curtaxamount");
            this.amountFields.add("amountandtax");
            this.amountFields.add("curamountandtax");
            this.amountFields.add("discountamount");
        }
    }

    private Map<Integer, BigDecimal> getRowIndexQtyMapping(IDataModel model, String entryKey, String qtyFieldKey, String unitKey, Integer srcRowIndex, List<Integer> newRowIndex) {
        int rowCount = newRowIndex.size() + 1;
        HashMap<Integer, BigDecimal> rowQtyMap = new HashMap<Integer, BigDecimal>(rowCount);
        DynamicObjectCollection billEntry = model.getDataEntity().getDynamicObjectCollection(entryKey);
        if (billEntry.isEmpty() || newRowIndex.isEmpty()) {
            return rowQtyMap;
        }
        DynamicObject entry = (DynamicObject)billEntry.get(srcRowIndex.intValue());
        BigDecimal srcQty = entry.getBigDecimal(qtyFieldKey);
        if (srcQty == null || BigDecimal.ZERO.compareTo(srcQty) == 0) {
            return rowQtyMap;
        }
        DynamicObject unit = entry.getDynamicObject(unitKey);
        if (unit != null) {
            this.unitPrecision = unit.getInt("precision");
        }
        BigDecimal average = srcQty.divide(new BigDecimal(rowCount), (int)this.unitPrecision, RoundingMode.DOWN);
        BigDecimal multiply = average.multiply(new BigDecimal(newRowIndex.size()));
        BigDecimal lastRowQty = srcQty.subtract(multiply);
        rowQtyMap.put(srcRowIndex, average);
        for (int i = 0; i < newRowIndex.size() - 1; ++i) {
            rowQtyMap.put(newRowIndex.get(i), average);
        }
        rowQtyMap.put(newRowIndex.get(newRowIndex.size() - 1), lastRowQty);
        return rowQtyMap;
    }

    private void setQtyValue(IDataModel model, Integer srcRowIndex, List<Integer> newRowIndex, Map<Integer, BigDecimal> rowQtyMap, String qtyFieldKey) {
        if (rowQtyMap.isEmpty()) {
            return;
        }
        model.setValue(qtyFieldKey, (Object)rowQtyMap.get(srcRowIndex), srcRowIndex.intValue());
        for (Integer rowIndex : newRowIndex) {
            model.setValue(qtyFieldKey, (Object)rowQtyMap.get(rowIndex), rowIndex.intValue());
        }
    }
}

