/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.tpl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.common.enums.UnitConvertDirEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.BizCategoryHelper;
import kd.scmc.pm.business.helper.CurrencyHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.business.pojo.AmountPropertyKey;
import kd.scmc.pm.enums.DiscountTypeEnum;
import kd.scmc.pm.enums.ExchangeTypeEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.enums.SupplierFunction;

public class BillTplImportPlugin
extends AbstractFormPlugin {
    private final BigDecimal ZERO = BigDecimal.ZERO;
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        BillImportHelper.billCreTypeFlag((IPageCache)pageCache, (List)sourceDataList);
        IDataModel model = (IDataModel)e.getSource();
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null) {
            hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)model.getDataEntityType().getName(), (String)"02");
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        QFilter operatorgroupOrgFilter;
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype) && !BillImportHelper.isAPI((String)billcretype)) {
            return;
        }
        Map data = e.getSourceData();
        DynamicObject org = this.getBaseDataFromCache(data, "org", "bos_org", null, null);
        if (org == null) {
            return;
        }
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null || !hasPermissionOrg.contains(org.getPkValue())) {
            Object orgs = data.get("org");
            Map propMap = BillImportHelper.format4ImportAndApi(orgs);
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"BillTplImportPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
            e.setFireAfterImportData(false);
            return;
        }
        if (BillImportHelper.isImport((String)billcretype)) {
            Map supplierMap;
            DynamicObject billtype = this.getBaseDataFromCache(data, "billtype", "bos_billtype", "billformid", null);
            if (billtype == null) {
                return;
            }
            String formId = this.getView().getFormShowParameter().getFormId();
            if (!billtype.getDynamicObject("billformid").getPkValue().equals(formId)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u7b26\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BillTplImportPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
            }
            Map billtypeMap = BillImportHelper.format4ImportAndApi(data.get("billtype"));
            DynamicObject billtypeparameter = (DynamicObject)this.tempCache.get("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")));
            if (billtype != null && billtypeparameter == null) {
                billtypeparameter = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)"pm_billtypeparameter", (long)((Long)billtype.getPkValue()));
                this.tempCache.put("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")), billtypeparameter);
            }
            if ((supplierMap = BillImportHelper.format4ImportAndApi(data.get("supplier"))) != null) {
                if (!this.validSupplier(e, "supplier", SupplierFunction.PURCHASE, org)) {
                    return;
                }
                DynamicObject bizType = this.getBaseDataFromCache(data, "biztype", "bd_biztype", null, null);
                DynamicObject supplier = this.getSupplier(data, supplierMap, "supplier", org);
                if (bizType != null && BizCategoryHelper.isVMI((Long)((Long)bizType.getPkValue())) && supplier != null && !supplier.getBoolean("enablevmi")) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u201c%1$s\u201d\u4e0d\u662f\u53efVMI\u7684\u4f9b\u5e94\u5546\u3002", (String)"BillTplImportPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]), supplierMap.get(supplierMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
            }
            if (!this.validSupplier(e, "providersupplier", SupplierFunction.DELIVER, org)) {
                return;
            }
            if (!this.validSupplier(e, "invoicesupplier", SupplierFunction.INVOICE, org)) {
                return;
            }
            if (!this.validSupplier(e, "receivesupplier", SupplierFunction.RECEIVE, org)) {
                return;
            }
        }
        Map operatorGroupMap = BillImportHelper.format4ImportAndApi(data.get("operatorgroup"));
        Map operatorMap = BillImportHelper.format4ImportAndApi(data.get("operator"));
        if (operatorGroupMap != null && operatorMap != null) {
            operatorgroupOrgFilter = this.getBaseDataOrgFilterFromCache(org, "operatorgroup", "bd_operatorgroup");
            QFilter invalidFilter = new QFilter("entryentity.invalid", "=", (Object)Boolean.FALSE);
            DynamicObject operatorGroup = this.getBaseDataFromCache(data, "operatorgroup", "bd_operatorgroup", "id,operatornumber,operatorname,invalid", new QFilter[]{new QFilter((String)operatorGroupMap.get("importprop"), "=", operatorGroupMap.get(operatorGroupMap.get("importprop"))), operatorgroupOrgFilter, invalidFilter});
            if (operatorGroup != null && operatorMap.get(operatorMap.get("importprop")) != null) {
                DynamicObjectCollection entryentity = operatorGroup.getDynamicObjectCollection("entryentity");
                for (DynamicObject operator : entryentity) {
                    if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) continue;
                    HashMap<String, Object> newOperator = new HashMap<String, Object>();
                    newOperator.put("id", operator.getPkValue());
                    data.put("operator", newOperator);
                    break;
                }
            }
        } else if (operatorMap != null) {
            operatorgroupOrgFilter = this.getBaseDataOrgFilterFromCache(org, "operatorgroup", "bd_operatorgroup");
            QFilter operatorgroupTypeFilter = new QFilter("operatorgrouptype", "=", (Object)"CGZ");
            QFilter invalidFilter = new QFilter("entryentity.invalid", "=", (Object)Boolean.FALSE);
            Map operatorgroups = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,operatornumber,operatorname,invalid", (QFilter[])new QFilter[]{operatorgroupOrgFilter, operatorgroupTypeFilter, invalidFilter});
            boolean flag = true;
            block1: for (DynamicObject operatorGroup : operatorgroups.values()) {
                DynamicObjectCollection entryentity = operatorGroup.getDynamicObjectCollection("entryentity");
                for (DynamicObject operator : entryentity) {
                    if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) continue;
                    HashMap<String, Object> newOperator = new HashMap<String, Object>();
                    newOperator.put("id", operator.getPkValue());
                    data.put("operator", newOperator);
                    HashMap<String, Object> newOperatorGroup = new HashMap<String, Object>();
                    newOperatorGroup.put("id", operatorGroup.getPkValue());
                    data.put("operatorgroup", newOperatorGroup);
                    flag = false;
                    continue block1;
                }
            }
            if (flag) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5458\u201c%1$s\u201d\u4e0d\u5728\u8be5\u91c7\u8d2d\u7ec4\u7ec7\u7684\u4f7f\u7528\u8303\u56f4\u5185\u3002", (String)"BillTplImportPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]), operatorMap.get(operatorMap.get("importprop"))));
                e.setFireAfterImportData(false);
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        String billCreType = this.getPageCache().get("billcretype");
        if (BillImportHelper.isImport((String)billCreType)) {
            String exchangeType;
            Long settleCurrencyId;
            Long currencyId;
            Long exRateTableId;
            Date bizTime;
            model.setValue("billcretype", (Object)"1");
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (org == null) {
                return;
            }
            DynamicObject dept = (DynamicObject)model.getValue("dept");
            if (dept == null) {
                DynamicObject operator = (DynamicObject)model.getValue("operator");
                Long deptID = this.getMainDeptByOperatorFromCache(operator);
                model.setValue("dept", (Object)deptID);
            }
            if ((bizTime = (Date)model.getValue("biztime")) == null) {
                model.setValue("biztime", (Object)System.currentTimeMillis());
            }
            model.setValue("billstatus", (Object)StatusEnum.SAVE.getValue());
            Date exRateDate = (Date)model.getValue("exratedate");
            if (exRateDate == null) {
                exRateDate = (Date)model.getValue("biztime");
                model.setValue("exratedate", (Object)exRateDate);
            }
            DynamicObject exRateTable = (DynamicObject)model.getValue("exratetable");
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
            BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
            DynamicObject supplier = (DynamicObject)model.getValue("supplier");
            if (supplier != null) {
                if (model.getValue("providersupplier") == null) {
                    model.setValue("providersupplier", (Object)SupplierHelper.getOtherSupplierId((DynamicObject)supplier, (String)"deliversupplierid"));
                }
                if (model.getValue("invoicesupplier") == null) {
                    model.setValue("invoicesupplier", (Object)SupplierHelper.getOtherSupplierId((DynamicObject)supplier, (String)"invoicesupplierid"));
                }
                if (model.getValue("receivesupplier") == null) {
                    model.setValue("receivesupplier", (Object)SupplierHelper.getOtherSupplierId((DynamicObject)supplier, (String)"receivingsupplierid"));
                }
            }
            if (exRateTable == null) {
                exRateTableId = this.getCurrencyOrExRateTableFromCache((Long)org.getPkValue(), org.getPkValue() + "-exRateMap", "exchangeRateTableID");
                if (exRateTableId != null) {
                    model.setValue("exratetable", (Object)exRateTableId);
                }
            } else {
                exRateTableId = (Long)exRateTable.getPkValue();
            }
            if (currency == null) {
                currencyId = this.getCurrencyOrExRateTableFromCache((Long)org.getPkValue(), org.getPkValue() + "-currencyMap", "baseCurrencyID");
                if (currencyId != null) {
                    model.setValue("currency", (Object)currencyId);
                }
            } else {
                currencyId = (Long)currency.getPkValue();
            }
            if (settleCurrency == null) {
                settleCurrencyId = currencyId;
                model.setValue("settlecurrency", (Object)settleCurrencyId);
                exChangeRate = BigDecimal.ONE;
                model.setValue("exchangerate", (Object)exChangeRate);
                exchangeType = ExchangeTypeEnum.DIRECT.getValue();
                model.setValue("exchangetype", (Object)exchangeType);
            } else {
                settleCurrencyId = (Long)settleCurrency.getPkValue();
            }
            Map exRateMap = CurrencyHelper.getExRateMap((Long)settleCurrencyId, (Long)currencyId, (Long)exRateTableId, (Date)exRateDate);
            BigDecimal exRate = (BigDecimal)exRateMap.get("exchangerate");
            exchangeType = (String)exRateMap.get("exchangetype");
            model.setValue("exchangetype", (Object)exchangeType);
            if (BigDecimalUtil.isBlank((BigDecimal)exChangeRate)) {
                model.setValue("exchangerate", (Object)exRate);
            }
            DynamicObjectCollection billEntries = (DynamicObjectCollection)model.getValue("billentry");
            Map totalAmountMap = null;
            if (billEntries != null) {
                for (DynamicObject billEntry : billEntries) {
                    DynamicObject taxRateId;
                    Object discountType;
                    DynamicObject auxptyUnit;
                    int index = billEntry.getInt("seq") - 1;
                    DynamicObject material = billEntry.getDynamicObject("material");
                    if (material == null || material.getDynamicObject("masterid") == null) continue;
                    DynamicObject materialMasterID = material.getDynamicObject("masterid");
                    model.setValue("materialmasterid", materialMasterID.getPkValue(), index);
                    boolean isDisposable = materialMasterID.getBoolean("isdisposable");
                    if (StringUtils.isBlank((Object)billEntry.get("materialname")) || !isDisposable) {
                        billEntry.set("materialname", (Object)materialMasterID.getLocaleString("name").toString());
                    }
                    billEntry.set("baseunit", (Object)material.getDynamicObject("masterid").getDynamicObject("baseunit"));
                    DynamicObject unit = billEntry.getDynamicObject("unit");
                    DynamicObject baseUnit = billEntry.getDynamicObject("baseunit");
                    if (unit == null) {
                        unit = material.getDynamicObject("purchaseunit");
                        billEntry.set("unit", (Object)unit);
                    }
                    if (unit != null && baseUnit != null) {
                        if (unit.getPkValue().equals(baseUnit.getPkValue())) {
                            billEntry.set("baseqty", (Object)billEntry.getBigDecimal("qty"));
                        } else {
                            billEntry.set("baseqty", (Object)BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)material.getDynamicObject("masterid").getPkValue()), (DynamicObject)unit, (BigDecimal)billEntry.getBigDecimal("qty"), (DynamicObject)baseUnit));
                        }
                    }
                    if ((auxptyUnit = materialMasterID.getDynamicObject("auxptyunit")) == null) {
                        billEntry.set("auxunit", null);
                        billEntry.set("auxqty", null);
                    } else {
                        billEntry.set("auxunit", (Object)auxptyUnit);
                    }
                    DynamicObject auxUnit = billEntry.getDynamicObject("auxunit");
                    BigDecimal qty = billEntry.getBigDecimal("qty");
                    BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
                    if (auxUnit == null) {
                        billEntry.set("auxqty", (Object)BigDecimal.ZERO);
                    } else {
                        BigDecimal auxQty = billEntry.getBigDecimal("auxqty");
                        String unitConvertDir = materialMasterID.getString("unitconvertdir");
                        if (BigDecimalUtil.isBlank((BigDecimal)auxQty)) {
                            if (kd.scmc.pm.enums.UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || kd.scmc.pm.enums.UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                                auxQty = BillQuantityHelper.getDesQtyConv((Long)((Long)materialMasterID.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                                billEntry.set("auxqty", (Object)auxQty);
                            }
                        } else if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isBlank((BigDecimal)baseQty) && UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir)) {
                            baseQty = BillQuantityHelper.getDesQtyConv((Long)((Long)materialMasterID.getPkValue()), (DynamicObject)auxUnit, (BigDecimal)auxQty, (DynamicObject)baseUnit);
                            billEntry.set("baseqty", (Object)baseQty);
                        }
                    }
                    if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)baseQty)) {
                        qty = BillQuantityHelper.getDesQtyConv((Long)((Long)materialMasterID.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                        billEntry.set("qty", (Object)qty);
                    } else if (BigDecimalUtil.isBlank((BigDecimal)baseQty) && BigDecimalUtil.isNotBlank((BigDecimal)qty)) {
                        baseQty = BillQuantityHelper.getDesQtyConv((Long)((Long)materialMasterID.getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                        billEntry.set("baseqty", (Object)baseQty);
                    }
                    Boolean isuseauxpty = materialMasterID.getBoolean("isuseauxpty");
                    if (Boolean.FALSE.equals(isuseauxpty)) {
                        billEntry.set("auxpty", null);
                    }
                    BigDecimal disCountRate = billEntry.getBigDecimal("discountrate");
                    if (billEntry.getString("discounttype").equals(DiscountTypeEnum.DISRATE.getValue())) {
                        if (BigDecimalUtil.largeThan((BigDecimal)disCountRate, (BigDecimal)BigDecimalUtil.HUNDRED)) {
                            billEntry.set("discountrate", (Object)new BigDecimal(100));
                        } else if (!BigDecimalUtil.largeZero((BigDecimal)disCountRate)) {
                            billEntry.set("discountrate", (Object)this.ZERO);
                        }
                    }
                    if ((discountType = billEntry.get("discounttype")).equals(DiscountTypeEnum.NULL.getValue())) {
                        billEntry.set("discountrate", (Object)this.ZERO);
                    }
                    if ((taxRateId = billEntry.getDynamicObject("taxrateid")) == null) {
                        billEntry.set("taxrate", (Object)this.ZERO);
                        continue;
                    }
                    BigDecimal taxRate = taxRateId.getBigDecimal("taxrate");
                    billEntry.set("taxrate", (Object)taxRate);
                }
                totalAmountMap = AmountHelper.calcAllAmount((DynamicObject)model.getDataEntity(true), (AmountPropertyKey)AmountPropertyKey.getInstance());
            }
            if (totalAmountMap == null) {
                model.setValue("totalamount", (Object)this.ZERO);
                model.setValue("totaltaxamount", (Object)this.ZERO);
                model.setValue("totalallamount", (Object)this.ZERO);
            } else {
                for (Map.Entry entry : totalAmountMap.entrySet()) {
                    model.setValue((String)entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private Long getMainDeptByOperatorFromCache(DynamicObject operator) {
        Long deptID = null;
        if (operator != null) {
            Long operatorID = (Long)operator.getPkValue();
            deptID = (Long)this.tempCache.get("operator&" + operatorID + "&dept");
            if (deptID == null) {
                Long userID;
                operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operatorID, (String)"bd_operator", (String)"id,operatorid");
                Long l = userID = operator.get("operatorid") != null ? (Long)((DynamicObject)operator.get("operatorid")).getPkValue() : null;
                if (userID != null) {
                    deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                    this.tempCache.put("operator&" + operatorID + "&dept", deptID);
                }
            }
        }
        return deptID;
    }

    private Long getCurrencyOrExRateTableFromCache(Long orgId, String cacheKey, String currencyKey) {
        Map exRateMap = (Map)this.tempCache.get(cacheKey);
        if (exRateMap == null && (exRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId)) != null) {
            this.tempCache.put(cacheKey, exRateMap);
        }
        if (exRateMap != null) {
            return (Long)exRateMap.get(currencyKey);
        }
        return null;
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map propMap = BillImportHelper.format4ImportAndApi((Object)sourceData.get(propName));
        if (propMap != null) {
            String importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }

    private QFilter getBaseDataOrgFilterFromCache(DynamicObject org, String propName, String propEntityName) {
        QFilter baseDataOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_" + propName + "OrgFilter");
        if (baseDataOrgFilter == null) {
            baseDataOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)propEntityName, (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_" + propName + "OrgFilter", baseDataOrgFilter);
        }
        return baseDataOrgFilter;
    }

    private DynamicObject getSupplier(Map<String, Object> dataMap, Map<?, ?> supplierMap, String key, DynamicObject org) {
        return this.getBaseDataFromCache(dataMap, key, "bd_supplier", "id,enablevmi,bizfunction", new QFilter[]{new QFilter((String)supplierMap.get("importprop"), "=", supplierMap.get(supplierMap.get("importprop")))});
    }

    private boolean validSupplier(BeforeImportDataEventArgs e, String key, SupplierFunction function, DynamicObject org) {
        String supplierPrefix;
        switch (function) {
            case PURCHASE: {
                supplierPrefix = ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546", (String)"BillTplImportPlugin_7", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
                break;
            }
            case DELIVER: {
                supplierPrefix = ResManager.loadKDString((String)"\u4f9b\u8d27\u4f9b\u5e94\u5546", (String)"BillTplImportPlugin_8", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
                break;
            }
            case INVOICE: {
                supplierPrefix = ResManager.loadKDString((String)"\u7ed3\u7b97\u4f9b\u5e94\u5546", (String)"BillTplImportPlugin_9", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
                break;
            }
            case RECEIVE: {
                supplierPrefix = ResManager.loadKDString((String)"\u6536\u6b3e\u4f9b\u5e94\u5546", (String)"BillTplImportPlugin_10", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
                break;
            }
            default: {
                supplierPrefix = "";
            }
        }
        Map data = e.getSourceData();
        Map supplierMap = BillImportHelper.format4ImportAndApi(data.get(key));
        if (supplierMap == null) {
            return true;
        }
        Object importValue = supplierMap.get(supplierMap.get("importprop"));
        DynamicObject supplier = this.getSupplier(data, supplierMap, key, org);
        if (supplier == null) {
            this.cancel(e, String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u4e0d\u5728\u8be5\u91c7\u8d2d\u7ec4\u7ec7\u7684\u4f7f\u7528\u8303\u56f4\u5185\u3002", (String)"BillTplImportPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]), supplierPrefix, importValue));
            return false;
        }
        boolean validResult = SupplierHelper.validBizFunction((DynamicObject)supplier, (SupplierFunction)function);
        if (!validResult) {
            this.cancel(e, String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u6ca1\u6709%3$s\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BillTplImportPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]), supplierPrefix, importValue, function.getName()));
        }
        return validResult;
    }

    private void cancel(BeforeImportDataEventArgs e, String message) {
        e.setCancel(true);
        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), message);
        e.setFireAfterImportData(false);
    }
}

