/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.formplugin.quote;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.pm.business.helper.PurPriceHelper;

public class PurQuoteStrategyListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(PurQuoteStrategyListPlugin.class);
    private static final String ISINIT_KEY = "HASINIT";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List FilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : FilterColumns) {
            if (!"isnewmode".equals(filterColumn.getFieldName()) || filterColumn.getDefaultValues() != null && filterColumn.getDefaultValues().size() != 0) continue;
            if (PurPriceHelper.isNewMode()) {
                filterColumn.setDefaultValues(Collections.singletonList("1"));
                this.getPageCache().put(ISINIT_KEY, "1");
                break;
            }
            filterColumn.setDefaultValues(Collections.singletonList("0"));
            this.getPageCache().put(ISINIT_KEY, "0");
            break;
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.getPageCache().remove(ISINIT_KEY);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if ("1".equals(this.getPageCache().get(ISINIT_KEY))) {
            e.getQFilters().add(new QFilter("isnewmode", "=", (Object)Boolean.TRUE));
        } else if ("0".equals(this.getPageCache().get(ISINIT_KEY))) {
            e.getQFilters().add(new QFilter("isnewmode", "=", (Object)Boolean.FALSE));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        try (TraceSpan span = Tracer.create((String)"SalQuoteStrategyListPlugin", (String)("beforeDoOperation: " + args.getSource()));){
            String opKey;
            if (args.getSource() instanceof FormOperate && "copy".equals(opKey = ((FormOperate)args.getSource()).getOperateKey())) {
                BillList billList = (BillList)this.getControl("billlistap");
                if (billList.getSelectedRows() != null && billList.getSelectedRows().size() > 1) {
                    Object firstPrimaryKey = billList.getSelectedRows().get(0).getPrimaryKeyValue();
                    ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
                    for (int i = 1; i < listSelectedRows.size(); ++i) {
                        if (firstPrimaryKey.equals(listSelectedRows.get(i).getPrimaryKeyValue())) continue;
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PurQuoteStrategyListPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                ListSelectedRow listSelectedRow = billList.getCurrentSelectedRowInfo();
                DynamicObject currRowData = BusinessDataServiceHelper.loadSingle((Object)listSelectedRow.getPrimaryKeyValue(), (String)"plat_quotestrategy", (String)"isnewmode");
                if (PurPriceHelper.isNewMode() && !this.isDimensionMode(currRowData)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7981\u7528\u4f9b\u5e94\u94fe\u53c2\u6570\u201c\u91c7\u8d2d\u4ef7\u683c\u542f\u7528\u4ef7\u683c\u6a21\u578b\u201d\u3002", (String)"PurQuoteCopyParamValidator_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else if (!PurPriceHelper.isNewMode() && this.isDimensionMode(currRowData)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u542f\u7528\u4f9b\u5e94\u94fe\u53c2\u6570\u201c\u91c7\u8d2d\u4ef7\u683c\u542f\u7528\u4ef7\u683c\u6a21\u578b\u201d\u3002", (String)"PurQuoteCopyParamValidator_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
        super.beforeDoOperation(args);
    }

    private boolean isDimensionMode(DynamicObject quoteBill) {
        return quoteBill.getBoolean("isnewmode");
    }
}

