/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.custom.ext.bizextplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.sdk.scmc.pm.extpoint.IXPurOrderCasePlugin;

public class XSPurOrder2PurApplyWriteBackImpl
implements IXPurOrderCasePlugin {
    public boolean activeSynBillInfo(List<Long> changeBillIds, String changeBillEntity) {
        if (CommonUtils.isNull((Object)changeBillEntity) || CommonUtils.isNull(changeBillIds)) {
            return false;
        }
        if (!changeBillEntity.equals("pm_xpurorderbill") && !changeBillEntity.equals("pm_xspurorderbill")) {
            return false;
        }
        return XSPurOrder2PurApplyWriteBackImpl.baseqtyWriteBackPurApply(changeBillIds, changeBillEntity);
    }

    private static boolean baseqtyWriteBackPurApply(List<Long> xSPurOrderID, String billEntity) {
        QFilter qFilter4;
        if (CommonUtils.isNull(xSPurOrderID) || CommonUtils.isNull((Object)billEntity)) {
            return false;
        }
        QFilter qFilter1 = new QFilter("id", "in", xSPurOrderID);
        QFilter qFilter7 = new QFilter("sourcebillid", "!=", (Object)0L);
        String selectFields = "id,sourcebillid,billentry.id as entryid,billentry.entrysrcid as entrysrcid,billentry.entrychangetype as entrychangetype,billentry.baseqty as baseqty";
        QFilter qFilter = new QFilter("billentry.entrysrcid", "!=", (Object)0L);
        DynamicObjectCollection xSPurOrderDyobjs = QueryServiceHelper.query((String)"pm_xspurorderbill", (String)selectFields, (QFilter[])new QFilter[]{qFilter1, qFilter, qFilter7});
        if (CommonUtils.isNull((Object)xSPurOrderDyobjs)) {
            return false;
        }
        List<Object> purEntryIDs = XSPurOrder2PurApplyWriteBackImpl.getBillFieldValue(xSPurOrderDyobjs, "entrysrcid");
        if (CommonUtils.isNull(purEntryIDs)) {
            return false;
        }
        selectFields = "billentry.id as entryid,billentry.srcbillid as srcbillid,billentry.srcbillentity as srcbillentity ,billentry.srcbillnumber as srcbillnumber,billentry.srcbillentryid as srcbillentryid,billentry.seq as seq,billentry.baseqty as baseqty";
        QFilter qFilter2 = new QFilter("billentry.id", "in", purEntryIDs);
        QFilter qFilter3 = new QFilter("billentry.srcbillid", "!=", (Object)0L);
        DynamicObjectCollection purBillEntryObjs = QueryServiceHelper.query((String)"pm_purorderbill", (String)selectFields, (QFilter[])new QFilter[]{qFilter2, qFilter3, qFilter4 = new QFilter("billentry.srcbillentity", "=", (Object)"pm_purapplybill")});
        if (CommonUtils.isNull((Object)purBillEntryObjs)) {
            return false;
        }
        Map<Object, Map<Object, List<BigDecimal>>> quantityDiffInfoMap = XSPurOrder2PurApplyWriteBackImpl.calculatedDifference(xSPurOrderDyobjs, purBillEntryObjs, "entrysrcid");
        if (CommonUtils.isNull(quantityDiffInfoMap)) {
            return false;
        }
        List<Object> srcBillIDs = XSPurOrder2PurApplyWriteBackImpl.getBillFieldValue(purBillEntryObjs, "srcbillid");
        QFilter billIDFilter = new QFilter("id", "in", srcBillIDs);
        selectFields = "id,closestatus, entryid, rowclosestatus,qty , orderqty ,closer,closedate, rowclosestatus , baseunit, unit, orderbaseqty,material,joinbaseqty, joinqty,baseqty";
        DynamicObject[] srcOrderDyobs = BusinessDataServiceHelper.load((String)"pm_purapplybill", (String)selectFields, (QFilter[])new QFilter[]{billIDFilter});
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>();
        for (DynamicObject srcOrderDyobj : srcOrderDyobs) {
            DynamicObjectCollection srcBillEntrys;
            Object pkValue = srcOrderDyobj.getPkValue();
            Map<Object, List<BigDecimal>> entryQuantityMap = quantityDiffInfoMap.get(pkValue);
            if (CommonUtils.isNull(entryQuantityMap) || CommonUtils.isNull((Object)(srcBillEntrys = srcOrderDyobj.getDynamicObjectCollection("billentry")))) continue;
            boolean closeBill = true;
            for (DynamicObject srcBillEntry : srcBillEntrys) {
                Object billEntryID = srcBillEntry.getPkValue();
                List<BigDecimal> entryQuantityList = entryQuantityMap.get(billEntryID);
                BigDecimal entryQuantity = new BigDecimal(0);
                if (!CommonUtils.isNull(entryQuantityList)) {
                    for (BigDecimal bigDecimal : entryQuantityList) {
                        entryQuantity = bigDecimal.add(entryQuantity);
                    }
                }
                String rowCloseStatus = (String)srcBillEntry.get("rowclosestatus");
                if (entryQuantity.compareTo(new BigDecimal(0)) == 0) {
                    if (!rowCloseStatus.equals("A")) continue;
                    closeBill = false;
                    continue;
                }
                BigDecimal baseQty = (BigDecimal)srcBillEntry.get("baseqty");
                DynamicObject baseunit = (DynamicObject)srcBillEntry.get("baseunit");
                DynamicObject unit = (DynamicObject)srcBillEntry.get("unit");
                DynamicObject material = (DynamicObject)srcBillEntry.get("material");
                DynamicObject masterid = material.getDynamicObject("masterid");
                Long materialmasterid = (Long)masterid.getPkValue();
                BigDecimal joinBaseQty = (BigDecimal)srcBillEntry.get("joinbaseqty");
                joinBaseQty = joinBaseQty.add(entryQuantity);
                srcBillEntry.set("joinbaseqty", (Object)joinBaseQty);
                BigDecimal newJoinQty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseunit, joinBaseQty, unit);
                srcBillEntry.set("joinqty", (Object)newJoinQty);
                BigDecimal orderBaseQty = (BigDecimal)srcBillEntry.get("orderbaseqty");
                orderBaseQty = orderBaseQty.add(entryQuantity);
                srcBillEntry.set("orderbaseqty", (Object)orderBaseQty);
                BigDecimal newOrderQty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseunit, orderBaseQty, unit);
                srcBillEntry.set("orderqty", (Object)newOrderQty);
                if (orderBaseQty.compareTo(baseQty) < 0) {
                    srcBillEntry.set("rowclosestatus", (Object)"A");
                    closeBill = false;
                    continue;
                }
                srcBillEntry.set("rowclosestatus", (Object)"B");
            }
            if (closeBill) {
                srcOrderDyobj.set("closestatus", (Object)"B");
                srcOrderDyobj.set("closer", (Object)1L);
                srcOrderDyobj.set("closedate", (Object)new Date());
            } else {
                srcOrderDyobj.set("closestatus", (Object)"A");
                srcOrderDyobj.set("closer", null);
                srcOrderDyobj.set("closedate", null);
            }
            objectList.add(srcOrderDyobj);
        }
        if (!CommonUtils.isNull(objectList)) {
            SaveServiceHelper.update((DynamicObject[])objectList.toArray(new DynamicObject[0]));
            return true;
        }
        return false;
    }

    private static List<Object> getBillFieldValue(DynamicObjectCollection PurOrderDyobjs, String propertyName) {
        ArrayList<Object> billIDs = new ArrayList<Object>();
        if (CommonUtils.isNull((Object)PurOrderDyobjs) || CommonUtils.isNull((Object)propertyName)) {
            return billIDs;
        }
        for (DynamicObject purOrderDyobj : PurOrderDyobjs) {
            billIDs.add(purOrderDyobj.get(propertyName));
        }
        return billIDs;
    }

    private static Map<Object, Map<Object, List<BigDecimal>>> calculatedDifference(DynamicObjectCollection xSPurOrderDyobjs, DynamicObjectCollection purBillEntryObjs, String entrySrcId) {
        HashMap<Object, Map<Object, List<BigDecimal>>> quantityDiffInfoMap = new HashMap<Object, Map<Object, List<BigDecimal>>>(purBillEntryObjs.size());
        block0: for (DynamicObject xSPurOrderDyobj : xSPurOrderDyobjs) {
            Object srcEntryID = xSPurOrderDyobj.get(entrySrcId);
            String changeType = (String)xSPurOrderDyobj.get("entrychangetype");
            if (CommonUtils.isNull((Object)changeType) || changeType.equals("A") || CommonUtils.isNull((Object)srcEntryID)) continue;
            for (DynamicObject purBillEntry : purBillEntryObjs) {
                ArrayList<BigDecimal> quantityDiffList;
                Object purBillEntryID = purBillEntry.get("entryid");
                if (!srcEntryID.equals(purBillEntryID)) continue;
                Object srcBillID = purBillEntry.get("srcbillid");
                if (CommonUtils.isNull((Object)srcBillID)) continue block0;
                BigDecimal xs_baseqty = (BigDecimal)xSPurOrderDyobj.get("baseqty");
                BigDecimal pur_baseqty = (BigDecimal)purBillEntry.get("baseqty");
                BigDecimal quantityDiff = changeType.equals("C") ? pur_baseqty.negate() : xs_baseqty.subtract(pur_baseqty);
                if (quantityDiff.compareTo(new BigDecimal(0)) == 0) continue block0;
                HashMap<Object, ArrayList<BigDecimal>> objectIntegerMap = (HashMap<Object, ArrayList<BigDecimal>>)quantityDiffInfoMap.get(srcBillID);
                if (CommonUtils.isNull((Object)objectIntegerMap)) {
                    objectIntegerMap = new HashMap<Object, ArrayList<BigDecimal>>();
                }
                if (CommonUtils.isNull((Object)(quantityDiffList = (ArrayList<BigDecimal>)objectIntegerMap.get(purBillEntry.get("srcbillentryid"))))) {
                    quantityDiffList = new ArrayList<BigDecimal>();
                }
                quantityDiffList.add(quantityDiff);
                objectIntegerMap.put(purBillEntry.get("srcbillentryid"), quantityDiffList);
                quantityDiffInfoMap.put(srcBillID, objectIntegerMap);
                continue block0;
            }
        }
        return quantityDiffInfoMap;
    }
}

