/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.custom.ext.bizextplugin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.sdk.scmc.pm.extpoint.IXPurOrderCasePlugin;

public class XSPurOrderSynOrderStatusImpl
implements IXPurOrderCasePlugin {
    private static final Log logger = LogFactory.getLog(XSPurOrderSynOrderStatusImpl.class);

    public boolean activeSynOrderBillStatus(DynamicObject srcBill) {
        DynamicObjectCollection billEntry = srcBill.getDynamicObjectCollection("billentry");
        boolean flag = true;
        int size = billEntry.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject row = (DynamicObject)billEntry.get(i);
            DynamicObject lineType = row.getDynamicObject("linetype");
            String number = lineType.getString("number");
            if ("010".equals(number) || "030".equals(number) || "020-2".equals(number)) {
                BigDecimal qtyDown = null;
                BigDecimal qty = null;
                if ("010".equals(number)) {
                    qtyDown = row.getBigDecimal("receivebaseqtydown");
                    qty = row.getBigDecimal("invbaseqty");
                } else if ("030".equals(number)) {
                    qtyDown = row.getBigDecimal("receivebaseqtydown");
                    qty = row.getBigDecimal("receivebaseqty");
                } else if ("020-2".equals(number)) {
                    qtyDown = row.getBigDecimal("amountandtax");
                    qty = row.getBigDecimal("performamount");
                }
                if (qty == null || qtyDown == null) continue;
                if (qty.compareTo(qtyDown) >= 0) {
                    row.set("rowclosestatus", (Object)RowCloseStatusEnum.ROWCLOSE.getValue());
                    continue;
                }
                row.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
                flag = false;
                continue;
            }
            String rowCloseStatus = row.getString("rowclosestatus");
            if (!RowCloseStatusEnum.UNROWCLOSE.getValue().equals(rowCloseStatus)) continue;
            flag = false;
        }
        logger.info("\u6574\u5355\u662f\u5426\u5b8c\u5168\u5173\u95ed:{}", (Object)flag);
        if (flag) {
            srcBill.set("closestatus", (Object)"B");
            srcBill.set("closer", (Object)UserServiceHelper.getCurrentUserId());
            srcBill.set("closedate", (Object)TimeServiceHelper.now());
        } else {
            srcBill.set("closestatus", (Object)"A");
            srcBill.set("closer", null);
            srcBill.set("closedate", null);
        }
        return true;
    }
}

