/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.pojo.AmountInfo;
import kd.scmc.pm.business.pojo.AmountPropertyKey;
import kd.scmc.pm.enums.ChangeTypeEnum;
import kd.scmc.pm.enums.DiscountTypeEnum;
import kd.scmc.pm.enums.ExchangeTypeEnum;

public class AmountHelper {
    private static final String CUR_AMTPRECISION = "amtprecision";
    private static final String CUR_PRICEPRECISION = "priceprecision";
    private static final String DEFAULT_CHANGE_TYPE = "entrychangetype";
    private static final String DEFAULT_BILL_ENTRY = "billentry";

    public static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill) {
        return AmountHelper.calcTotalAmount(bill, DEFAULT_CHANGE_TYPE);
    }

    public static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill, Map<String, String> fieldMapping) {
        return AmountHelper.calcTotalAmount(bill, fieldMapping, DEFAULT_CHANGE_TYPE);
    }

    public static AmountInfo getAmount(AmountInfo amountInfo) {
        return AmountHelper.getAmount(amountInfo, Boolean.FALSE);
    }

    public static AmountInfo getAmount(AmountInfo amountInfo, Boolean isCalDiscountRate) {
        boolean isTax = amountInfo.isTax();
        BigDecimal qty = amountInfo.getQty();
        BigDecimal price = amountInfo.getPrice();
        BigDecimal priceAndTax = amountInfo.getPriceAndTax();
        BigDecimal taxRate = BigDecimalUtil.div100((BigDecimal)amountInfo.getTaxRate());
        String discountType = amountInfo.getDiscountType();
        BigDecimal discountRate = amountInfo.getDiscountRate();
        int settleAmtPrecision = amountInfo.getSettleAmtPrecision();
        int settlePricePrecision = 10;
        AmountPropertyKey propertyKey = amountInfo.getPropertyKey();
        if (propertyKey == null) {
            propertyKey = AmountPropertyKey.getInstance();
        }
        BigDecimal amount = BigDecimalUtil.ZERO;
        BigDecimal taxAmount = BigDecimalUtil.ZERO;
        BigDecimal discountAmount = BigDecimalUtil.ZERO;
        if (isCalDiscountRate == null) {
            isCalDiscountRate = Boolean.FALSE;
        }
        if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
            discountRate = BigDecimal.ZERO;
            discountAmount = amountInfo.getDiscountAmount();
        }
        BigDecimal amountAndTax = BigDecimalUtil.ZERO;
        if (BigDecimalUtil.isNotBlank((BigDecimal)qty)) {
            if (isTax && BigDecimalUtil.isNotBlank((BigDecimal)priceAndTax)) {
                price = priceAndTax.divide(BigDecimalUtil.ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
                if (StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue())) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    if (BigDecimalUtil.isBlank((BigDecimal)discountRate)) {
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        discountRate = BigDecimalUtil.div100((BigDecimal)discountRate);
                        discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        amountAndTax = BigDecimal.ONE.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank((BigDecimal)discountRate)) {
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        discountAmount = qty.multiply(discountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        amountAndTax = priceAndTax.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank((BigDecimal)discountAmount)) {
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        discountAmount = discountAmount.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        discountRate = discountAmount.divide(qty, settlePricePrecision, RoundingMode.HALF_UP);
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        amountAndTax = amountAndTax.subtract(discountAmount);
                    }
                    amountInfo.setDiscountRate(discountRate);
                    amountInfo.put(propertyKey.getDiscountRate(), discountRate);
                }
                taxAmount = amountAndTax.divide(BigDecimalUtil.ONE.add(taxRate), 10, RoundingMode.HALF_UP).multiply(taxRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else if (!isTax && BigDecimalUtil.isNotBlank((BigDecimal)price)) {
                priceAndTax = price.multiply(BigDecimalUtil.ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP);
                if (StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue())) {
                    amount = qty.multiply(price).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    if (BigDecimalUtil.isBlank((BigDecimal)discountRate)) {
                        amount = qty.multiply(price).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        discountRate = BigDecimalUtil.div100((BigDecimal)discountRate);
                        discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        amount = qty.multiply(price).multiply(BigDecimalUtil.ONE.subtract(discountRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank((BigDecimal)discountRate)) {
                        amount = qty.multiply(price).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        discountAmount = qty.multiply(discountRate).multiply(BigDecimalUtil.ONE.add(taxRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        amount = qty.multiply(price.subtract(discountRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank((BigDecimal)discountAmount)) {
                        amount = qty.multiply(price).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        discountAmount = discountAmount.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        discountRate = discountAmount.divide(qty, settlePricePrecision, RoundingMode.HALF_UP).divide(BigDecimalUtil.ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
                        amount = qty.multiply(price.subtract(discountRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                    amountInfo.setDiscountRate(discountRate);
                    amountInfo.put(propertyKey.getDiscountRate(), discountRate);
                }
                taxAmount = amount.multiply(taxRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmount);
                amountAndTax = amountAndTax.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else {
                priceAndTax = BigDecimalUtil.ZERO;
                price = BigDecimalUtil.ZERO;
            }
            AmountHelper.setCurrencyAmount(isTax, amount, taxAmount, amountAndTax, amountInfo, propertyKey);
        } else {
            if (isTax && BigDecimalUtil.isNotBlank((BigDecimal)priceAndTax)) {
                priceAndTax = priceAndTax.setScale(settlePricePrecision, RoundingMode.HALF_UP);
                price = priceAndTax.divide(BigDecimalUtil.ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
            } else if (!isTax && BigDecimalUtil.isNotBlank((BigDecimal)price)) {
                price = price.setScale(settlePricePrecision, RoundingMode.HALF_UP);
                priceAndTax = price.multiply(BigDecimalUtil.ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP);
            } else {
                priceAndTax = BigDecimalUtil.ZERO;
                price = BigDecimalUtil.ZERO;
            }
            amountInfo.put(propertyKey.getCurAmount(), BigDecimalUtil.ZERO);
            amountInfo.put(propertyKey.getCurTaxAmount(), BigDecimalUtil.ZERO);
            amountInfo.put(propertyKey.getCurAmountAndTax(), BigDecimalUtil.ZERO);
        }
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setAmount(amount);
        amountInfo.setDiscountAmount(discountAmount);
        amountInfo.setTaxAmount(taxAmount);
        amountInfo.setAmountAndTax(amountAndTax);
        if (isTax) {
            amountInfo.put(propertyKey.getPrice(), price);
        } else {
            amountInfo.put(propertyKey.getPriceAndTax(), priceAndTax);
        }
        amountInfo.put(propertyKey.getAmount(), amount);
        amountInfo.put(propertyKey.getDiscountAmount(), discountAmount);
        amountInfo.put(propertyKey.getTaxAmount(), taxAmount);
        amountInfo.put(propertyKey.getAmountAndTax(), amountAndTax);
        return amountInfo;
    }

    public static AmountInfo getAmount(Boolean isTax, BigDecimal qty, BigDecimal price, BigDecimal priceAndTax, BigDecimal taxRate, String discountType, BigDecimal discountRate, BigDecimal exRate, Integer settlePricePrecision, Integer settleAmtPrecision, Integer currencyAmtPrecision, Boolean isIndirectExRate, AmountPropertyKey propertyKey) {
        AmountInfo amountInfo = new AmountInfo();
        if (isTax != null) {
            amountInfo.setTax(isTax);
        }
        if (qty != null) {
            amountInfo.setQty(qty);
        }
        if (price != null) {
            amountInfo.setPrice(price);
        }
        if (priceAndTax != null) {
            amountInfo.setPriceAndTax(priceAndTax);
        }
        if (taxRate != null) {
            amountInfo.setTaxRate(taxRate);
        }
        if (!StringUtils.isEmpty((CharSequence)discountType)) {
            amountInfo.setDiscountType(discountType);
        }
        if (discountRate != null) {
            amountInfo.setDiscountRate(discountRate);
        }
        if (exRate != null) {
            amountInfo.setExChangeRate(exRate);
        }
        if (settlePricePrecision != null) {
            amountInfo.setSettlePricePrecision(settlePricePrecision);
        }
        if (settleAmtPrecision != null) {
            amountInfo.setSettleAmtPrecision(settleAmtPrecision);
        }
        if (currencyAmtPrecision != null) {
            amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
        }
        if (isIndirectExRate != null) {
            amountInfo.setIndirectExRate(isIndirectExRate);
        }
        if (propertyKey != null) {
            amountInfo.setPropertyKey(propertyKey);
        }
        return AmountHelper.getAmount(amountInfo);
    }

    public static AmountInfo getAmount(Boolean isTax, BigDecimal qty, BigDecimal price, BigDecimal priceAndTax, BigDecimal taxRate, String discountType, BigDecimal discountRate, BigDecimal discountAmount, BigDecimal exRate, Integer settlePricePrecision, Integer settleAmtPrecision, Integer currencyAmtPrecision, Boolean isIndirectExRate, AmountPropertyKey propertyKey, Boolean isCalDiscountRate) {
        AmountInfo amountInfo = new AmountInfo();
        if (isTax != null) {
            amountInfo.setTax(isTax);
        }
        if (qty != null) {
            amountInfo.setQty(qty);
        }
        if (price != null) {
            amountInfo.setPrice(price);
        }
        if (priceAndTax != null) {
            amountInfo.setPriceAndTax(priceAndTax);
        }
        if (taxRate != null) {
            amountInfo.setTaxRate(taxRate);
        }
        if (!StringUtils.isEmpty((CharSequence)discountType)) {
            amountInfo.setDiscountType(discountType);
        }
        if (discountRate != null) {
            amountInfo.setDiscountRate(discountRate);
        }
        if (discountAmount != null) {
            amountInfo.setDiscountAmount(discountAmount);
        }
        if (exRate != null) {
            amountInfo.setExChangeRate(exRate);
        }
        if (settlePricePrecision != null) {
            amountInfo.setSettlePricePrecision(settlePricePrecision);
        }
        if (settleAmtPrecision != null) {
            amountInfo.setSettleAmtPrecision(settleAmtPrecision);
        }
        if (currencyAmtPrecision != null) {
            amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
        }
        if (isIndirectExRate != null) {
            amountInfo.setIndirectExRate(isIndirectExRate);
        }
        if (propertyKey != null) {
            amountInfo.setPropertyKey(propertyKey);
        }
        return AmountHelper.getAmount(amountInfo, isCalDiscountRate);
    }

    public static Map<String, BigDecimal> calcAllAmount(DynamicObject bill, AmountPropertyKey propertyKey) {
        HashMap<String, BigDecimal> totalAmountMap = new HashMap<String, BigDecimal>(8);
        if (bill == null) {
            return totalAmountMap;
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(DEFAULT_BILL_ENTRY);
        if (entry == null || entry.isEmpty()) {
            return totalAmountMap;
        }
        if (propertyKey == null) {
            propertyKey = AmountPropertyKey.getInstance();
        }
        Map<String, DynamicProperty> headPropertyMap = AmountHelper.getAmountProperties(bill, propertyKey.getHeadPropertyKeyArray());
        Map<String, DynamicProperty> entryPropertyMap = AmountHelper.getAmountProperties((DynamicObject)entry.get(0), propertyKey.getEntryPropertyKeyArray());
        if (headPropertyMap.isEmpty() || entryPropertyMap.isEmpty()) {
            return totalAmountMap;
        }
        Boolean isTax = (Boolean)AmountHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getIsTax()));
        BigDecimal exRate = (BigDecimal)AmountHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getExChangeRate()));
        DynamicObject settleCurrency = (DynamicObject)AmountHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getSettleCurrency()));
        Integer settleAmtPrecision = settleCurrency == null ? null : Integer.valueOf(settleCurrency.getInt(CUR_AMTPRECISION));
        Integer settlePricePrecision = settleCurrency == null ? null : Integer.valueOf(settleCurrency.getInt(CUR_PRICEPRECISION));
        DynamicObject currency = (DynamicObject)AmountHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getCurrency()));
        Integer currencyAmtPrecision = currency == null ? null : Integer.valueOf(currency.getInt(CUR_AMTPRECISION));
        String exchangeType = (String)AmountHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getExchangeType()));
        boolean isDirectRate = ExchangeTypeEnum.isIndirectRate((Object)exchangeType);
        BigDecimal totalAmount = BigDecimalUtil.ZERO;
        BigDecimal totalTaxAmount = BigDecimalUtil.ZERO;
        BigDecimal totalAllAmount = BigDecimalUtil.ZERO;
        for (DynamicObject row : entry) {
            BigDecimal qty = (BigDecimal)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getQty()));
            BigDecimal price = (BigDecimal)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getPrice()));
            BigDecimal priceAndTax = (BigDecimal)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getPriceAndTax()));
            BigDecimal taxRate = (BigDecimal)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getTaxRate()));
            String discountType = (String)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getDiscountType()));
            BigDecimal discountRate = (BigDecimal)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getDiscountRate()));
            AmountInfo amountInfo = AmountHelper.getAmount(isTax, qty, price, priceAndTax, taxRate, discountType, discountRate, exRate, settlePricePrecision, settleAmtPrecision, currencyAmtPrecision, isDirectRate, propertyKey);
            AmountHelper.batchSetAmountValue(row, entryPropertyMap, amountInfo.getAmountKV());
            String changeType = (String)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getChangeType()));
            if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
            totalAmount = totalAmount.add(amountInfo.getAmount());
            totalTaxAmount = totalTaxAmount.add(amountInfo.getTaxAmount());
            totalAllAmount = totalAllAmount.add(amountInfo.getAmountAndTax());
        }
        AmountHelper.mapPutNotNull(totalAmountMap, propertyKey.getTotalAmount(), totalAmount);
        AmountHelper.mapPutNotNull(totalAmountMap, propertyKey.getTotalTaxAmount(), totalTaxAmount);
        AmountHelper.mapPutNotNull(totalAmountMap, propertyKey.getTotalAllAmount(), totalAllAmount);
        return totalAmountMap;
    }

    public static Map<String, BigDecimal> calcAmount(DynamicObject bill, AmountPropertyKey propertyKey, int index) {
        return AmountHelper.calcAmount(bill, propertyKey, index, Boolean.FALSE);
    }

    public static Map<String, BigDecimal> calcAmount(DynamicObject bill, AmountPropertyKey propertyKey, int index, Boolean isCalDiscountRate) {
        HashMap<String, BigDecimal> totalAmountMap = new HashMap<String, BigDecimal>(8);
        if (bill == null) {
            return totalAmountMap;
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(DEFAULT_BILL_ENTRY);
        if (entry == null || entry.size() - 1 < index) {
            return totalAmountMap;
        }
        if (propertyKey == null) {
            propertyKey = AmountPropertyKey.getInstance();
        }
        DynamicObject row = (DynamicObject)entry.get(index);
        Map<String, DynamicProperty> headPropertyMap = AmountHelper.getAmountProperties(bill, propertyKey.getHeadPropertyKeyArray());
        Map<String, DynamicProperty> entryPropertyMap = AmountHelper.getAmountProperties(row, propertyKey.getEntryPropertyKeyArray());
        if (headPropertyMap.isEmpty() || entryPropertyMap.isEmpty()) {
            return totalAmountMap;
        }
        Boolean isTax = (Boolean)AmountHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getIsTax()));
        BigDecimal exRate = (BigDecimal)AmountHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getExChangeRate()));
        DynamicObject settleCurrency = (DynamicObject)AmountHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getSettleCurrency()));
        Integer settleAmtPrecision = settleCurrency == null ? null : Integer.valueOf(settleCurrency.getInt(CUR_AMTPRECISION));
        Integer settlePricePrecision = settleCurrency == null ? null : Integer.valueOf(settleCurrency.getInt(CUR_PRICEPRECISION));
        DynamicObject currency = (DynamicObject)AmountHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getCurrency()));
        Integer currencyAmtPrecision = currency == null ? null : Integer.valueOf(currency.getInt(CUR_AMTPRECISION));
        String exchangeType = (String)AmountHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getExchangeType()));
        boolean isDirectRate = ExchangeTypeEnum.isIndirectRate((Object)exchangeType);
        BigDecimal qty = (BigDecimal)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getQty()));
        BigDecimal price = (BigDecimal)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getPrice()));
        BigDecimal priceAndTax = (BigDecimal)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getPriceAndTax()));
        BigDecimal taxRate = (BigDecimal)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getTaxRate()));
        String discountType = (String)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getDiscountType()));
        BigDecimal discountRate = (BigDecimal)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getDiscountRate()));
        BigDecimal discountAmount = (BigDecimal)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getDiscountAmount()));
        AmountInfo amountInfo = AmountHelper.getAmount(isTax, qty, price, priceAndTax, taxRate, discountType, discountRate, discountAmount, exRate, settlePricePrecision, settleAmtPrecision, currencyAmtPrecision, isDirectRate, propertyKey, isCalDiscountRate);
        AmountHelper.batchSetAmountValue(row, entryPropertyMap, amountInfo.getAmountKV());
        String changeType = (String)AmountHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getChangeType()));
        if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
            AmountHelper.mapPutNotNull(totalAmountMap, propertyKey.getAmount(), amountInfo.getAmount());
            AmountHelper.mapPutNotNull(totalAmountMap, propertyKey.getTaxAmount(), amountInfo.getTaxAmount());
            AmountHelper.mapPutNotNull(totalAmountMap, propertyKey.getAmountAndTax(), amountInfo.getAmountAndTax());
        }
        return totalAmountMap;
    }

    public static BigDecimal convertByExRate(BigDecimal money, BigDecimal exRate, boolean isIndirectRate, int amtPrecision) {
        return AmountHelper.convertByExRate(money, exRate, isIndirectRate, amtPrecision, RoundingMode.HALF_UP);
    }

    public static BigDecimal convertByExRate(BigDecimal money, BigDecimal exRate, boolean isIndirectRate, int amtPrecision, RoundingMode roundingMode) {
        if (BigDecimalUtil.isZero((BigDecimal)exRate)) {
            isIndirectRate = false;
        }
        if (isIndirectRate) {
            return money.divide(exRate, amtPrecision, roundingMode);
        }
        return money.multiply(exRate).setScale(amtPrecision, roundingMode);
    }

    private static void setCurrencyAmount(boolean isTax, BigDecimal amount, BigDecimal taxAmount, BigDecimal amountAndTax, AmountInfo amountInfo, AmountPropertyKey propertyKey) {
        BigDecimal exChangeRate = amountInfo.getExChangeRate();
        BigDecimal curAmount = BigDecimalUtil.ZERO;
        BigDecimal curAmountAndTax = BigDecimalUtil.ZERO;
        BigDecimal curTaxAmount = BigDecimal.ZERO;
        if (!BigDecimalUtil.isZero((BigDecimal)exChangeRate)) {
            int currencyAmtPrecision = amountInfo.getCurrencyAmtPrecision();
            boolean indirectRate = amountInfo.getIndirectExRate();
            curTaxAmount = AmountHelper.convertByExRate(taxAmount, exChangeRate, indirectRate, currencyAmtPrecision);
            if (isTax) {
                curAmountAndTax = AmountHelper.convertByExRate(amountAndTax, exChangeRate, indirectRate, currencyAmtPrecision);
                curAmount = curAmountAndTax.subtract(curTaxAmount);
            } else {
                curAmount = AmountHelper.convertByExRate(amount, exChangeRate, indirectRate, currencyAmtPrecision);
                curAmountAndTax = curAmount.add(curTaxAmount);
            }
            amountInfo.setCurAmount(curAmount);
            amountInfo.setCurTaxAmount(curTaxAmount);
            amountInfo.setCurAmountAndTax(curAmountAndTax);
        }
        amountInfo.put(propertyKey.getCurAmount(), curAmount);
        amountInfo.put(propertyKey.getCurTaxAmount(), curTaxAmount);
        amountInfo.put(propertyKey.getCurAmountAndTax(), curAmountAndTax);
    }

    private static void batchSetAmountValue(DynamicObject dynamicObject, Map<String, DynamicProperty> propertyMap, Map<String, Object> amountKV) {
        if (amountKV == null || amountKV.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : amountKV.entrySet()) {
            AmountHelper.setValueFast(dynamicObject, propertyMap.get(entry.getKey()), entry.getValue());
        }
    }

    private static void setValueFast(DynamicObject dynamicObject, DynamicProperty property, Object value) {
        if (property == null) {
            return;
        }
        property.setValueFast((Object)dynamicObject, value);
    }

    private static Object getValueFast(DynamicObject dynamicObject, DynamicProperty property) {
        if (property == null) {
            return null;
        }
        return property.getValueFast((Object)dynamicObject);
    }

    private static Map<String, DynamicProperty> getAmountProperties(DynamicObject dynamicObject, String[] propertyKeys) {
        HashMap<String, DynamicProperty> propertyMap = new HashMap<String, DynamicProperty>(16);
        DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
        for (String propertyKey : propertyKeys) {
            AmountHelper.mapPutNotNull(propertyMap, propertyKey, dynamicObjectType.getProperty(propertyKey));
        }
        return propertyMap;
    }

    private static <T> void mapPutNotNull(Map<String, T> map, String key, T value) {
        if (key == null || value == null) {
            return;
        }
        map.put(key, value);
    }

    private static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill, String changeTypeField) {
        HashMap<String, String> fieldMapping = new HashMap<String, String>(8);
        fieldMapping.put("totalamount", "amount");
        fieldMapping.put("totaltaxamount", "taxamount");
        fieldMapping.put("totalallamount", "amountandtax");
        fieldMapping.put("curtotalamount", "curamount");
        fieldMapping.put("curtotalallamount", "curamountandtax");
        return AmountHelper.calcTotalAmount(bill, fieldMapping, changeTypeField);
    }

    private static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill, Map<String, String> fieldMapping, String changeTypeField) {
        HashMap<String, BigDecimal> calcResult = new HashMap<String, BigDecimal>(8);
        DynamicObjectType billType = bill.getDynamicObjectType();
        Map<String, String> filteredMapping = AmountHelper.mappingFilter(billType, fieldMapping);
        if (filteredMapping.isEmpty()) {
            return calcResult;
        }
        for (String headField : filteredMapping.keySet()) {
            calcResult.put(headField, BigDecimal.ZERO);
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(DEFAULT_BILL_ENTRY);
        if (entry == null || entry.isEmpty()) {
            return calcResult;
        }
        DynamicObjectType entryType = ((DynamicObject)entry.get(0)).getDynamicObjectType();
        Map<String, DynamicProperty> entryFieldProperties = AmountHelper.getEntryFieldProperties(entryType, filteredMapping);
        if (entryFieldProperties.isEmpty()) {
            return calcResult;
        }
        DynamicProperty changeTypeProp = entryType.getProperty(changeTypeField);
        for (DynamicObject row : entry) {
            if (changeTypeProp != null && kd.mpscmm.msbd.common.enums.ChangeTypeEnum.isCancel((String)((String)changeTypeProp.getValueFast((Object)row)))) continue;
            for (Map.Entry<String, DynamicProperty> propertyEntry : entryFieldProperties.entrySet()) {
                String headKey = propertyEntry.getKey();
                calcResult.put(headKey, ((BigDecimal)calcResult.get(headKey)).add(BigDecimalUtil.getNotNull((Object)propertyEntry.getValue().getValueFast((Object)row))));
            }
        }
        return calcResult;
    }

    private static Map<String, DynamicProperty> getEntryFieldProperties(DynamicObjectType entryType, Map<String, String> filteredMapping) {
        HashMap<String, DynamicProperty> entryFieldProperties = new HashMap<String, DynamicProperty>(8);
        for (Map.Entry<String, String> entry : filteredMapping.entrySet()) {
            DynamicProperty property = entryType.getProperty(entry.getValue());
            if (property == null) continue;
            entryFieldProperties.put(entry.getKey(), property);
        }
        return entryFieldProperties;
    }

    private static Map<String, String> mappingFilter(DynamicObjectType billType, Map<String, String> fieldMapping) {
        HashMap<String, String> filteredMapping = new HashMap<String, String>(8);
        for (Map.Entry<String, String> entry : fieldMapping.entrySet()) {
            String key = entry.getKey();
            if (billType.getProperty(key) == null) continue;
            filteredMapping.put(key, entry.getValue());
        }
        return filteredMapping;
    }
}

