/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.changemodel.common.enums.BatChangeStatusEnum;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.PurOrderBillHelper;
import kd.scmc.pm.business.pojo.AmountPropertyKey;
import kd.scmc.pm.enums.UnitConvertDirEnum;

public class BatXPurOrderBillOpHelper {
    private static final String[] purOrderProps = new String[]{"billstatus", "billno", "changestatus", "cancelstatus", "closestatus", "isvirtualbill", "changedate", "changer", "version", "closer", "closestatus", "closedate", "paycondition", "ispayrate", "biztime", "linetype", "rowclosestatus", "joinbaseqty", "joinpayablepriceqty", "performamount", "amountandtax", "iscontrolamountup", "auxunit", "auxqty", "receivebaseqtyup", "receiverateup", "receiveqtyup", "receiveratedown", "receiveqtydown", "receivebaseqtydown", "iscontrolqty", "invbaseqty", "receivebaseqty", "rowclosestatus", "isprepay", "payamount", "payrate", "joinpayamount", "payentrychangetype"};
    private static final Log log = LogFactory.getLog(BatXPurOrderBillOpHelper.class);

    public static List<String> modifySrcData(Map<Long, DynamicObject> changeEntryMap, List<DynamicObject> srcBills) {
        ArrayList<String> errMsg = new ArrayList<String>();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        for (DynamicObject srcBill : srcBills) {
            DynamicObjectCollection entrys = srcBill.getDynamicObjectCollection("billentry");
            boolean isAllEntryQtyZero = true;
            if (entrys != null) {
                for (DynamicObject entry : entrys) {
                    if (changeEntryMap.containsKey(entry.getPkValue())) {
                        Long entryPk = (Long)entry.getPkValue();
                        DynamicObject changeEntry = changeEntryMap.get(entryPk);
                        DynamicObjectCollection deliverEntrys = entry.getDynamicObjectCollection("purbillentry_deliver");
                        if (deliverEntrys != null && deliverEntrys.size() > 0) {
                            if (BigDecimal.ZERO.compareTo(changeEntry.getBigDecimal("afterqty")) == 0) {
                                deliverEntrys.clear();
                            } else {
                                BigDecimal qty = entry.getBigDecimal("qty");
                                BigDecimal afterQty = changeEntry.getBigDecimal("afterqty");
                                if (afterQty.compareTo(qty) > 0) {
                                    DynamicObject deliverEntry = (DynamicObject)deliverEntrys.get(deliverEntrys.size() - 1);
                                    if (deliverEntry != null) {
                                        BigDecimal planQty = deliverEntry.getBigDecimal("planqty");
                                        planQty = afterQty.subtract(qty).add(planQty);
                                        deliverEntry.set("planqty", (Object)planQty);
                                    }
                                } else if (afterQty.compareTo(qty) < 0) {
                                    DynamicObject deliverEntry;
                                    BigDecimal subtractQty = qty.subtract(afterQty);
                                    for (int i = deliverEntrys.size() - 1; i >= 0; --i) {
                                        deliverEntry = (DynamicObject)deliverEntrys.get(i);
                                        if (deliverEntry == null) continue;
                                        BigDecimal planQty = deliverEntry.getBigDecimal("planqty");
                                        if (subtractQty.compareTo(planQty) >= 0) {
                                            deliverEntry.set("planqty", (Object)BigDecimal.ZERO);
                                            subtractQty = subtractQty.subtract(planQty);
                                            continue;
                                        }
                                        deliverEntry.set("planqty", (Object)planQty.subtract(subtractQty));
                                        break;
                                    }
                                    Iterator it = deliverEntrys.iterator();
                                    while (it.hasNext()) {
                                        deliverEntry = (DynamicObject)it.next();
                                        if (BigDecimal.ZERO.compareTo(deliverEntry.getBigDecimal("planqty")) != 0) continue;
                                        it.remove();
                                    }
                                }
                            }
                        }
                        entry.set("qty", changeEntry.get("afterqty"));
                        BigDecimal baseQty = (BigDecimal)changeEntry.get("afterbaseqty");
                        entry.set("baseqty", (Object)baseQty);
                        DynamicObject material = entry.getDynamicObject("material");
                        DynamicObject masterMaterial = material.getDynamicObject("masterid");
                        if (masterMaterial == null) continue;
                        String unitConvertDir = masterMaterial.getString("unitconvertdir");
                        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                        DynamicObject auxUnit = entry.getDynamicObject("auxunit");
                        if (auxUnit != null && (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir))) {
                            BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterMaterial.getPkValue(), baseUnit, baseQty, auxUnit);
                            entry.set("auxqty", (Object)auxQty);
                        }
                        entry.set("receiveqtyup", (Object)BigDecimal.ZERO);
                        entry.set("receiveqtydown", (Object)BigDecimal.ZERO);
                        entry.set("receivebaseqtyup", (Object)BigDecimal.ZERO);
                        entry.set("receivebaseqtydown", (Object)BigDecimal.ZERO);
                        PurOrderBillHelper.setDefaultReceiveQty(entry);
                        entry.set("deliverdate", changeEntry.get("afterdeliverdate"));
                        changeEntry.set("changestatus", (Object)BatChangeStatusEnum.VALID.getValue());
                    }
                    if (BigDecimal.ZERO.compareTo(entry.getBigDecimal("qty")) == 0) continue;
                    isAllEntryQtyZero = false;
                }
                PurOrderBillHelper.calcAllAmount(srcBill);
                AmountPlanHelper.changeAmountConditionForDynamicObject((CommonContext)PurOrderBillHelper.getPayPlanCommonText("pm_purorderbill"), (DynamicObject)srcBill);
                for (DynamicObject entry : entrys) {
                    Boolean isControlAmountUp;
                    if (!changeEntryMap.containsKey(entry.getPkValue()) || !Boolean.FALSE.equals(isControlAmountUp = Boolean.valueOf(entry.getBoolean("iscontrolamountup")))) continue;
                    entry.set("amountup", (Object)entry.getBigDecimal("amountandtax"));
                }
                DynamicObjectCollection payEntrys = srcBill.getDynamicObjectCollection("purbillentry_pay");
                if (payEntrys != null) {
                    boolean isHasNoErr = true;
                    for (int i = 0; i < payEntrys.size(); ++i) {
                        DynamicObject entry = (DynamicObject)payEntrys.get(i);
                        BigDecimal payAmount = entry.getBigDecimal("payamount");
                        BigDecimal joinPayAmount = entry.getBigDecimal("joinpayamount");
                        if (payAmount == null || joinPayAmount == null || payAmount.compareTo(joinPayAmount) >= 0) continue;
                        isHasNoErr = false;
                        String errorMsg = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355%1$s\uff0c\u4ed8\u6b3e\u8ba1\u5212\u7b2c%2$s\u884c\u53d8\u66f4\u540e\u7684\u201c\u4ed8\u6b3e\u91d1\u989d\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u201d\u3002", (String)"BatXPurOrderBillOpHelper_0", (String)"scmc-pm-business", (Object[])new Object[0]), srcBill.getString("billno"), i + 1);
                        errMsg.add(errorMsg);
                    }
                    if (isAllEntryQtyZero && isHasNoErr) {
                        payEntrys.clear();
                    }
                }
            }
            srcBill.set("changer", (Object)user);
            srcBill.set("changedate", (Object)TimeServiceHelper.now());
            String version = srcBill.getString("version");
            if (version == null || version.length() == 0 || version.equals("0") || version.startsWith("0.") || version.startsWith("1.")) {
                version = "1";
            }
            int newVersion = 1;
            try {
                newVersion = Integer.parseInt(version) + 1;
            }
            catch (NumberFormatException ee) {
                log.warn((Throwable)ee);
            }
            srcBill.set("version", (Object)String.valueOf(newVersion));
            srcBill.set("changestatus", (Object)BizChangeStatusEnum.CHANGED.getValue());
        }
        return errMsg;
    }

    public static String getSrcBillProps() {
        AmountPropertyKey prop = AmountPropertyKey.getInstance();
        String[] entryProps = prop.getEntryPropertyKeyArray();
        String[] headProps = prop.getHeadPropertyKeyArray();
        ArrayList<String> propList = new ArrayList<String>(Arrays.asList(purOrderProps));
        propList.addAll(Arrays.asList(entryProps));
        propList.addAll(Arrays.asList(headProps));
        return String.join((CharSequence)",", propList);
    }
}

