/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BillQtyAndUnitHelper {
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;
    private static final String UNIT_PRECISION = "precision";
    private static final String UNIT_PRECISIONTYPE = "precisionaccount";
    private static final String CONV_NUMERATOR = "numerator";
    private static final String CONV_DENOMINATOR = "denominator";

    public static BigDecimal getDesQtyConv(Long materialId, Long srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(ZERO) != 0) {
            Long desUnitID = (Long)desUnit.getPkValue();
            if (srcUnit.equals(desUnitID)) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnitID);
                if (muConv != null) {
                    int numberator = muConv.getInt(CONV_NUMERATOR);
                    int denominator = muConv.getInt(CONV_DENOMINATOR);
                    if (denominator != 0) {
                        desQty = srcQty.multiply(new BigDecimal(numberator)).divide(new BigDecimal(denominator), BillQtyAndUnitHelper.getPrecision(desUnit), BillQtyAndUnitHelper.getPrecisionType(desUnit));
                    }
                }
            }
        }
        return desQty;
    }

    public static BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
                if (muConv != null) {
                    int numberator = muConv.getInt(CONV_NUMERATOR);
                    int denominator = muConv.getInt(CONV_DENOMINATOR);
                    if (denominator != 0) {
                        desQty = srcQty.multiply(new BigDecimal(numberator)).divide(new BigDecimal(denominator), BillQtyAndUnitHelper.getPrecision(desUnit), BillQtyAndUnitHelper.getPrecisionType(desUnit));
                    }
                }
            }
        }
        return desQty;
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = ZERO;
        } else if (srcUnitId.equals(desUnitId)) {
            unitRate = ONE;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            if (muConv != null && muConv.getInt(CONV_DENOMINATOR) != 0) {
                unitRate = new BigDecimal(muConv.getInt(CONV_NUMERATOR)).divide(new BigDecimal(muConv.getInt(CONV_DENOMINATOR)), 10, 4);
            }
        }
        if (unitRate == null) {
            unitRate = ZERO;
        }
        return unitRate;
    }

    public static int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt(UNIT_PRECISION);
        }
        return precision;
    }

    public static int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isNotBlank((Object)unit.get(UNIT_PRECISIONTYPE))) {
            String precisionAccount;
            switch (precisionAccount = unit.getString(UNIT_PRECISIONTYPE)) {
                case "1": {
                    precisionType = 4;
                    break;
                }
                case "2": {
                    precisionType = 1;
                    break;
                }
                case "3": {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }

    public static RoundingMode getUnitRoundingMode(DynamicObject unit) {
        RoundingMode roundingMode;
        String precisionAccount;
        if (unit == null || StringUtils.isBlank((Object)unit.get(UNIT_PRECISIONTYPE))) {
            return RoundingMode.HALF_UP;
        }
        switch (precisionAccount = unit.getString(UNIT_PRECISIONTYPE)) {
            case "2": {
                roundingMode = RoundingMode.DOWN;
                break;
            }
            case "3": {
                roundingMode = RoundingMode.UP;
                break;
            }
            default: {
                roundingMode = RoundingMode.HALF_UP;
            }
        }
        return roundingMode;
    }

    public static RoundingMode getUnitRoundingMode(String precisionAccount) {
        RoundingMode roundingMode;
        switch (precisionAccount) {
            case "2": {
                roundingMode = RoundingMode.DOWN;
                break;
            }
            case "3": {
                roundingMode = RoundingMode.UP;
                break;
            }
            default: {
                roundingMode = RoundingMode.HALF_UP;
            }
        }
        return roundingMode;
    }
}

