/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.utils.CommonUtils;

public class BillRowCloseOpHelper {
    public static boolean upSrcBillJoinBaseQty(DynamicObject noticeBillDynamic, List<String> rows, String closeORunClose) {
        if (CommonUtils.isNull((Object)noticeBillDynamic) || CommonUtils.isNull(rows) || CommonUtils.isNull((Object)closeORunClose)) {
            return false;
        }
        DynamicObjectCollection noticeBillEntryDys = noticeBillDynamic.getDynamicObjectCollection("billentry");
        String rowCloseType = null;
        if ("rowclose".equals(closeORunClose)) {
            rowCloseType = RowCloseStatusEnum.ROWCLOSE.getValue();
        } else if ("rowunclose".equals(closeORunClose)) {
            rowCloseType = RowCloseStatusEnum.UNROWCLOSE.getValue();
        } else {
            return false;
        }
        Map<Object, Map<Object, BigDecimal>> quantityDiffInfoMap = BillRowCloseOpHelper.getNoticeReduce(noticeBillEntryDys, rows, rowCloseType);
        List<Object> srcBillIDs = BillRowCloseOpHelper.getBillFieldValue(noticeBillEntryDys, "srcbillid", rows);
        List<Object> srcBillEntryIDs = BillRowCloseOpHelper.getBillFieldValue(noticeBillEntryDys, "srcbillentryid", rows);
        if (quantityDiffInfoMap.size() == 0 || srcBillIDs.size() == 0 || srcBillEntryIDs.size() == 0) {
            return false;
        }
        QFilter srcBillIDFilter = new QFilter("id", "in", srcBillIDs);
        QFilter srcBillEntryIDFilter = new QFilter("billentry.id", "in", srcBillEntryIDs);
        DynamicObject[] srcBillDynamics = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"id,billentry.joinbaseqty,billentry.baseunit,billentry.unit,billentry.material,billentry.joinqty,billentry.id,billentry.receiptnoticbaseqty,billentry.receivebaseqtyup", (QFilter[])new QFilter[]{srcBillIDFilter, srcBillEntryIDFilter});
        if (CommonUtils.isNull((Object)srcBillDynamics)) {
            return false;
        }
        ArrayList<DynamicObject> srcBillObjList = new ArrayList<DynamicObject>();
        for (DynamicObject srcBillDynamic : srcBillDynamics) {
            Map<Object, BigDecimal> srcBillEntryMap = quantityDiffInfoMap.get(srcBillDynamic.getPkValue());
            if (CommonUtils.isNull(srcBillEntryMap)) continue;
            DynamicObjectCollection srcOrderBillEntryDys = srcBillDynamic.getDynamicObjectCollection("billentry");
            for (DynamicObject srcBillEyDyObj : srcOrderBillEntryDys) {
                BigDecimal bigDecimals = srcBillEntryMap.get(srcBillEyDyObj.getPkValue());
                if (CommonUtils.isNull((Object)bigDecimals)) continue;
                BigDecimal srcJoinBaseQty = srcBillEyDyObj.getBigDecimal("joinbaseqty");
                srcJoinBaseQty = "rowclose".equals(closeORunClose) ? srcJoinBaseQty.subtract(bigDecimals) : srcJoinBaseQty.add(bigDecimals);
                BigDecimal receiveQtyUp = srcBillEyDyObj.getBigDecimal("receivebaseqtyup");
                if ("rowunclose".equals(closeORunClose) && receiveQtyUp.compareTo(srcJoinBaseQty) < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u6e38\u91c7\u8d2d\u8ba2\u5355\u5206\u5f55\u672a\u53d1\u751f\u6570\u91cf\u65e0\u6cd5\u6ee1\u8db3\u56de\u9000\u8981\u6c42\uff0c\u4e0d\u80fd\u8fdb\u884c\u884c\u53cd\u5173\u95ed\u3002", (String)"BillRowCloseOpHelper_0", (String)"scmc-pm-business", (Object[])new Object[0]));
                }
                srcBillEyDyObj.set("joinbaseqty", (Object)srcJoinBaseQty);
                DynamicObject baseunit = (DynamicObject)srcBillEyDyObj.get("baseunit");
                DynamicObject unit = (DynamicObject)srcBillEyDyObj.get("unit");
                DynamicObject material = (DynamicObject)srcBillEyDyObj.get("material");
                DynamicObject masterid = material.getDynamicObject("masterid");
                Long materialmasterid = (Long)masterid.getPkValue();
                BigDecimal newJoinQty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseunit, srcJoinBaseQty, unit);
                srcBillEyDyObj.set("joinqty", (Object)newJoinQty);
            }
            srcBillObjList.add(srcBillDynamic);
        }
        if (!CommonUtils.isNull(srcBillObjList)) {
            SaveServiceHelper.update((DynamicObject[])srcBillObjList.toArray(new DynamicObject[0]));
            return true;
        }
        return false;
    }

    private static List<Object> getBillFieldValue(DynamicObjectCollection billDyobjs, String propertyName, List<String> rows) {
        ArrayList<Object> billIDs = new ArrayList<Object>();
        if (CommonUtils.isNull((Object)billDyobjs) || CommonUtils.isNull((Object)propertyName) || CommonUtils.isNull(rows)) {
            return billIDs;
        }
        for (DynamicObject billDyobj : billDyobjs) {
            int seq = billDyobj.getInt("seq");
            String rowSeq = String.valueOf(seq - 1);
            if (!rows.contains(rowSeq)) continue;
            billIDs.add(billDyobj.get(propertyName));
        }
        return billIDs;
    }

    private static Map<Object, Map<Object, BigDecimal>> getNoticeReduce(DynamicObjectCollection billDyObjs, List<String> rows, String rowCloseType) {
        HashMap<Object, Map<Object, BigDecimal>> quantityDiffInfoMap = new HashMap<Object, Map<Object, BigDecimal>>(billDyObjs.size());
        if (CommonUtils.isNull((Object)billDyObjs) || CommonUtils.isNull(rows) || CommonUtils.isNull((Object)rowCloseType)) {
            return quantityDiffInfoMap;
        }
        for (DynamicObject billDyObj : billDyObjs) {
            BigDecimal bigDecimals;
            String rowSeq;
            int seq = billDyObj.getInt("seq");
            String srcBillEntity = billDyObj.getString("srcbillentity");
            if (!"pm_purorderbill".equals(srcBillEntity) || !rows.contains(rowSeq = String.valueOf(seq - 1))) continue;
            Object srcBillID = billDyObj.get("srcbillid");
            Object srcBillEntryID = billDyObj.get("srcbillentryid");
            if (CommonUtils.isNull((Object)srcBillID) || CommonUtils.isNull((Object)srcBillEntryID)) continue;
            BigDecimal baseQty = billDyObj.getBigDecimal("baseqty");
            BigDecimal joinBaseQty = billDyObj.getBigDecimal("joinbaseqty");
            if (CommonUtils.isNull((Object)baseQty) || CommonUtils.isNull((Object)joinBaseQty)) continue;
            HashMap<Object, BigDecimal> srcBillEntryMap = (HashMap<Object, BigDecimal>)quantityDiffInfoMap.get(srcBillID);
            if (CommonUtils.isNull((Object)srcBillEntryMap)) {
                srcBillEntryMap = new HashMap<Object, BigDecimal>();
            }
            if (CommonUtils.isNull((Object)(bigDecimals = (BigDecimal)srcBillEntryMap.get(srcBillEntryID)))) {
                bigDecimals = new BigDecimal(0);
            }
            bigDecimals = bigDecimals.add(baseQty.subtract(joinBaseQty));
            srcBillEntryMap.put(srcBillEntryID, bigDecimals);
            quantityDiffInfoMap.put(srcBillID, srcBillEntryMap);
        }
        return quantityDiffInfoMap;
    }
}

