/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.consts.BizTypeConst;
import kd.scmc.pm.enums.BizCategoryEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.CommonUtils;

public class BizTypeHelper {
    public static QFilter getMaterialQFilterByBizCategory(String bizCategory) {
        QFilter qFilter = null;
        if (!BizCategoryEnum.BZ.getValue().equals(bizCategory) && !BizCategoryEnum.WW.getValue().equals(bizCategory)) {
            if (BizCategoryEnum.FY.getValue().equals(bizCategory)) {
                qFilter = new QFilter("masterid.materialtype", "=", (Object)"7");
            } else if (BizCategoryEnum.ZC.getValue().equals(bizCategory)) {
                qFilter = new QFilter("masterid.materialtype", "=", (Object)"8");
                qFilter.and("masterid.enableasset", "=", (Object)"1");
            } else if (BizCategoryEnum.VMI.getValue().equals(bizCategory)) {
                qFilter = new QFilter("masterid.enablevmi", "=", (Object)"1");
            } else if (BizCategoryEnum.ZY.getValue().equals(bizCategory) || BizCategoryEnum.FX.getValue().equals(bizCategory) || BizCategoryEnum.JS.getValue().equals(bizCategory) || BizCategoryEnum.ST.getValue().equals(bizCategory)) {
                // empty if block
            }
        }
        return qFilter;
    }

    public static QFilter getMaterialMasteridQFilterByBizCategory(String bizCategory) {
        QFilter qFilter = null;
        if (!BizCategoryEnum.BZ.getValue().equals(bizCategory) && !BizCategoryEnum.WW.getValue().equals(bizCategory)) {
            if (BizCategoryEnum.FY.getValue().equals(bizCategory)) {
                qFilter = new QFilter("materialtype", "=", (Object)"7");
            } else if (BizCategoryEnum.ZC.getValue().equals(bizCategory)) {
                qFilter = new QFilter("materialtype", "=", (Object)"8");
                qFilter.and("enableasset", "=", (Object)"1");
            } else if (BizCategoryEnum.VMI.getValue().equals(bizCategory)) {
                qFilter = new QFilter("enablevmi", "=", (Object)"1");
            } else if (BizCategoryEnum.ZY.getValue().equals(bizCategory) || BizCategoryEnum.FX.getValue().equals(bizCategory) || BizCategoryEnum.JS.getValue().equals(bizCategory) || BizCategoryEnum.ST.getValue().equals(bizCategory)) {
                // empty if block
            }
        }
        return qFilter;
    }

    public static List<Long> getBizTypeIdByEntity(String formId) {
        ArrayList<Long> bizTypeIds = null;
        QFilter q1 = new QFilter("billentity.billform", "=", (Object)formId);
        QFilter q2 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter q3 = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] bizTypes = BusinessDataServiceHelper.load((String)"bd_biztype", (String)BizTypeConst.getAllSelector(), (QFilter[])new QFilter[]{q1, q2, q3}, (String)"number");
        if (bizTypes != null && bizTypes.length > 0) {
            bizTypeIds = new ArrayList<Long>(bizTypes.length);
            for (DynamicObject bizType : bizTypes) {
                bizTypeIds.add((Long)bizType.getPkValue());
            }
        }
        return bizTypeIds;
    }

    public static void setDefBizTypeAndLineType(DynamicObject bill) {
        DynamicObject billType = bill.getDynamicObject("billtype");
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (CommonUtils.isNull((Object)billType)) {
            return;
        }
        if (CommonUtils.isNull((Object)bizType)) {
            bizType = kd.mpscmm.msbd.business.helper.BizTypeHelper.getDefaultBizTypeObject((String)bill.getDataEntityType().getName(), (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter");
            bill.set("biztype", (Object)bizType);
        }
        if (bizType != null) {
            DynamicObject lineType = kd.mpscmm.msbd.business.helper.BizTypeHelper.getDefaultLineTypeObject((Long)((Long)bizType.getPkValue()));
            if (CommonUtils.isNull((Object)lineType)) {
                return;
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null) {
                return;
            }
            entrys.forEach(dym -> {
                if (CommonUtils.isNull((Object)dym.getDynamicObject("linetype"))) {
                    dym.set("linetype", (Object)lineType);
                }
            });
        }
    }
}

