/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;
import kd.scmc.pm.utils.CommonUtils;

public class OperatorGroupHelper {
    private static final Log log = LogFactory.getLog(OperatorGroupHelper.class);

    public static Map<String, DynamicObject> getDefaultOperatorAndGroupByOrg(Long orgId, Long userId) {
        QFilter qFilter04;
        QFilter qFilter03;
        QFilter qFilter02;
        Map<Object, DynamicObject> operatorGroupDynamicObjectMap = OperatorGroupHelper.getOperatorGroupDynamicObjectMap(orgId);
        HashMap<String, DynamicObject> defaultOperatorAndGroup = new HashMap<String, DynamicObject>(4);
        if (operatorGroupDynamicObjectMap == null || operatorGroupDynamicObjectMap.size() == 0) {
            return defaultOperatorAndGroup;
        }
        QFilter qFilter01 = new QFilter("operatorgrpid", "in", operatorGroupDynamicObjectMap.keySet());
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype,invalid", (QFilter[])new QFilter[]{qFilter01, qFilter02 = new QFilter("opergrptype", "=", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue()), qFilter03 = new QFilter("operatorid", "=", (Object)userId), qFilter04 = new QFilter("invalid", "=", (Object)Boolean.FALSE)});
        if (loadFromCache != null && !loadFromCache.isEmpty()) {
            for (DynamicObject operator : loadFromCache.values()) {
                if (operator == null) continue;
                defaultOperatorAndGroup.put("operator", operator);
                defaultOperatorAndGroup.put("operatorgroup", operatorGroupDynamicObjectMap.get(operator.get("operatorgrpid")));
                break;
            }
            log.info("orgId=" + orgId + "\uff0cuserId=" + userId + "\uff0c\u4e1a\u52a1\u5458\uff1a");
        }
        return defaultOperatorAndGroup;
    }

    public static List<Long> getOperatorGroupByOrg(Long orgId) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        Map<Object, DynamicObject> map = OperatorGroupHelper.getOperatorGroupDynamicObjectMap(orgId);
        if (!CommonUtils.isNull(map)) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(map.values());
            for (DynamicObject dynamicObject : list) {
                operatorGroupList.add((Long)dynamicObject.getPkValue());
            }
        }
        return operatorGroupList;
    }

    public static Map<Object, DynamicObject> getOperatorGroupDynamicObjectMap(Long orgId) {
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
        QFilter qFilter3 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        return BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
    }

    public static List<Long> getOperatorGroupByOrg(Long orgId, String grpType) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)grpType);
        QFilter qFilter3 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            for (DynamicObject dynamicObject : list) {
                operatorGroupList.add((Long)dynamicObject.getPkValue());
            }
        }
        return operatorGroupList;
    }
}

