/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BillTypeHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.business.helper.MaterialHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.AppParameterHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.CurrencyHelper;
import kd.scmc.pm.enums.BizCancelStatusEnum;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.ChangeStatusEnum;
import kd.scmc.pm.enums.ChangeTypeEnum;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.RowTerminateStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.enums.UnitConvertDirEnum;

public class PurApplyBillHelper {
    private static final Log log = LogFactory.getLog(PurApplyBillHelper.class);
    private static final String ENTITYNAME = "msbd_puropermaterctrl";
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;

    public static List<DynamicObject> completeBillInfo(List<DynamicObject> bills) {
        if (kd.scmc.pm.utils.CommonUtils.isNull(bills)) {
            return bills;
        }
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(8);
        for (DynamicObject bill : bills) {
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            DynamicObject billType = bill.getDynamicObject("billtype");
            if (billType == null) {
                billType = BillTypeHelper.getDefaultBillTypeObject((String)"pm_purapplybill");
                if (billType == null) continue;
                bill.set("billtype", (Object)billType);
            }
            PurApplyBillHelper.setDefaultHeadStatusAndDate(bill);
            PurApplyBillHelper.setDefaultBizType(bill);
            if (bill.getDynamicObject("bizuser") == null) {
                bill.set("bizuser", (Object)UserServiceHelper.getCurrentUser((String)"name"));
            }
            PurApplyBillHelper.setDefaultDept(bill);
            if (bill.getDynamicObject("currency") == null) {
                bill.set("currency", (Object)CurrencyHelper.getCurrency((Long)org.getPkValue()));
            }
            PurApplyBillHelper.setDefaultOtherInfo(bill);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                PurApplyBillHelper.setDefaultLineType(bill, entry, cacheMap);
                PurApplyBillHelper.setDefaultMaterialInfo(entry);
                PurApplyBillHelper.setDefaultQty(entry);
                PurApplyBillHelper.setDefaultOperatorGroup(bill, entry);
                PurApplyBillHelper.setDefaultEntryOrg(bill, entry, cacheMap);
                PurApplyBillHelper.setDefaultEntryStatusAndDate(bill, entry);
            }
            PurApplyBillHelper.calcuAmount(bill);
        }
        return bills;
    }

    private static void setDefaultHeadStatusAndDate(DynamicObject bill) {
        Date bizTime;
        String billStatus = bill.getString("billstatus");
        if (CommonUtils.isNull((Object)billStatus)) {
            bill.set("billstatus", (Object)StatusEnum.SAVE.getValue());
        }
        if (CommonUtils.isNull((Object)(bizTime = bill.getDate("biztime")))) {
            bill.set("biztime", (Object)new Date());
        }
        if (billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            bill.set("auditor", null);
            bill.set("auditdate", null);
            bill.set("closer", null);
            bill.set("closedate", null);
            bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
            bill.set("canceler", null);
            bill.set("canceldate", null);
            bill.set("cancelstatus", (Object)BizCancelStatusEnum.UNCANCEL.getValue());
            bill.set("changer", null);
            bill.set("changedate", null);
            bill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
        } else {
            if (kd.scmc.pm.utils.CommonUtils.isNull((Object)bill.getString("closestatus"))) {
                bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
                bill.set("closer", null);
                bill.set("closedate", null);
            }
            if (kd.scmc.pm.utils.CommonUtils.isNull((Object)bill.getString("cancelstatus"))) {
                bill.set("cancelstatus", (Object)BizCancelStatusEnum.UNCANCEL.getValue());
                bill.set("canceler", null);
                bill.set("canceldate", null);
            }
            if (kd.scmc.pm.utils.CommonUtils.isNull((Object)bill.getString("changestatus"))) {
                bill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
                bill.set("changer", null);
                bill.set("changedate", null);
            }
        }
    }

    private static void setDefaultBizType(DynamicObject bill) {
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (bizType == null) {
            DynamicObject billType = bill.getDynamicObject("billtype");
            bizType = BizTypeHelper.getDefaultBizTypeObject((String)"pm_purapplybill", (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter");
            bill.set("biztype", (Object)bizType);
        }
    }

    private static void setDefaultDept(DynamicObject bill) {
        DynamicObject dept = bill.getDynamicObject("dept");
        DynamicObject applyer = bill.getDynamicObject("bizuser");
        if (dept == null) {
            if (applyer == null) {
                dept = OrgHelper.getDefaultDepartmentObject();
                bill.set("dept", (Object)dept);
            } else {
                dept = OrgHelper.getDefaultDepartmentObject((Long)((Long)applyer.getPkValue()));
                bill.set("dept", (Object)dept);
            }
        }
    }

    private static void setDefaultOtherInfo(DynamicObject bill) {
        String subVersion;
        String billStatus = bill.getString("billstatus");
        String version = bill.getString("version");
        if (version == null || billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            bill.set("version", (Object)"1");
        }
        if ((subVersion = bill.getString("subversion")) == null || billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            bill.set("subversion", (Object)"1");
        }
    }

    private static void setDefaultLineType(DynamicObject bill, DynamicObject entry, Map<String, Object> cacheMap) {
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (bizType != null && entry.get("linetype") == null) {
            DynamicObject defLineType;
            String cacheKey = String.valueOf(bizType.getPkValue()) + "linetype";
            if (PurApplyBillHelper.isCache(cacheMap, cacheKey)) {
                defLineType = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                defLineType = BizTypeHelper.getDefaultLineTypeObject((Long)((Long)bizType.getPkValue()));
                cacheMap.put(cacheKey, defLineType);
            }
            entry.set("linetype", (Object)defLineType);
        }
    }

    private static void setDefaultMaterialInfo(DynamicObject entry) {
        DynamicObject auxptyUnit;
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject masterMaterial = material.getDynamicObject("masterid");
        if (masterMaterial == null) {
            return;
        }
        entry.set("materialmasterid", (Object)masterMaterial);
        if (masterMaterial.getBoolean("isdisposable")) {
            if (StringUtils.isEmpty((CharSequence)entry.getString("materialname"))) {
                entry.set("materialname", (Object)masterMaterial.getString("name"));
            }
        } else {
            entry.set("materialname", (Object)masterMaterial.getString("name"));
        }
        entry.set("baseunit", (Object)masterMaterial.getDynamicObject("baseunit"));
        if (entry.getDynamicObject("unit") == null) {
            entry.set("unit", (Object)material.getDynamicObject("purchaseunit"));
        }
        if ((auxptyUnit = masterMaterial.getDynamicObject("auxptyunit")) == null) {
            entry.set("auxunit", null);
            entry.set("auxqty", null);
        } else if (entry.getDynamicObject("auxunit") == null) {
            entry.set("auxunit", (Object)auxptyUnit);
        }
        Boolean isuseauxpty = masterMaterial.getBoolean("isuseauxpty");
        if (Boolean.FALSE.equals(isuseauxpty)) {
            entry.set("auxpty", null);
        }
    }

    private static void setDefaultQty(DynamicObject entry) {
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject masterMaterial = material.getDynamicObject("masterid");
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal applyQty = entry.getBigDecimal("applyqty");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        DynamicObject unit = entry.getDynamicObject("unit");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        if (BigDecimalUtil.isBlank((BigDecimal)applyQty)) {
            return;
        }
        if (BigDecimalUtil.isBlank((BigDecimal)qty)) {
            qty = applyQty;
            entry.set("qty", (Object)qty);
        }
        if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)baseQty)) {
            qty = MaterialHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit, (boolean)true);
            entry.set("qty", (Object)qty);
        } else if (BigDecimalUtil.isBlank((BigDecimal)baseQty) && BigDecimalUtil.isNotBlank((BigDecimal)qty)) {
            baseQty = MaterialHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit, (boolean)true);
            entry.set("baseqty", (Object)baseQty);
        }
        DynamicObject auxUnit = entry.getDynamicObject("auxunit");
        if (auxUnit == null) {
            entry.set("auxqty", (Object)BigDecimal.ZERO);
        } else {
            BigDecimal auxQty = entry.getBigDecimal("auxqty");
            if (BigDecimalUtil.isBlank((BigDecimal)auxQty)) {
                String unitConvertDir = masterMaterial.getString("unitconvertdir");
                if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterMaterial.getPkValue(), baseUnit, baseQty, auxUnit);
                    entry.set("auxqty", (Object)auxQty);
                }
            }
        }
    }

    private static void setDefaultOperatorGroup(DynamicObject bill, DynamicObject entry) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject operator = entry.getDynamicObject("entryoperator");
        DynamicObject operatorGroup = entry.getDynamicObject("entryoperatorgroup");
        long userId = UserServiceHelper.getCurrentUserId();
        if (0L == userId) {
            return;
        }
        Map operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)((Long)org.getPkValue()), (Long)userId, (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
        if (!operatorAndGroup.isEmpty()) {
            if (operator == null) {
                entry.set("entryoperator", operatorAndGroup.get("entryoperator"));
            }
            if (operatorGroup == null) {
                entry.set("entryoperatorgroup", operatorAndGroup.get("entryoperatorgroup"));
            }
        }
    }

    private static void setDefaultEntryOrg(DynamicObject bill, DynamicObject entry, Map<String, Object> cacheMap) {
        DynamicObject recDept;
        DynamicObject recOrg;
        DynamicObject reqDept;
        DynamicObject reqOrg;
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject purDept = (DynamicObject)entry.get("entrypurdept");
        if (purDept == null && org != null) {
            String cacheKey = String.valueOf(org.getPkValue()) + "entrypurdept";
            if (PurApplyBillHelper.isCache(cacheMap, cacheKey)) {
                purDept = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                purDept = OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)"15", (String)"01", (String)"toorg");
                cacheMap.put(cacheKey, purDept);
            }
            entry.set("entrypurdept", (Object)purDept);
        }
        if ((reqOrg = (DynamicObject)entry.get("entryreqorg")) == null && org != null) {
            String cacheKey = String.valueOf(org.getPkValue()) + "entryreqorg";
            if (PurApplyBillHelper.isCache(cacheMap, cacheKey)) {
                reqOrg = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                reqOrg = OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)"", (String)"02", (String)"fromorg");
                cacheMap.put(cacheKey, reqOrg);
            }
            entry.set("entryreqorg", (Object)reqOrg);
        }
        if ((reqDept = (DynamicObject)entry.get("entryreqdept")) == null && reqOrg != null) {
            String cacheKey = String.valueOf(reqOrg.getPkValue()) + "entryreqdept";
            if (PurApplyBillHelper.isCache(cacheMap, cacheKey)) {
                reqDept = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                reqDept = OrgHelper.getOrgForFormDefObjValue((Long)((Long)reqOrg.getPkValue()), (String)"15", (String)"01", (String)"toorg");
                cacheMap.put(cacheKey, reqDept);
            }
            entry.set("entryreqdept", (Object)reqDept);
        }
        if ((recOrg = (DynamicObject)entry.get("entryrecorg")) == null && org != null) {
            String cacheKey = String.valueOf(org.getPkValue()) + "entryrecorg";
            if (PurApplyBillHelper.isCache(cacheMap, cacheKey)) {
                recOrg = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                recOrg = OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)"02", (String)"05", (String)"toorg");
                cacheMap.put(cacheKey, recOrg);
            }
            entry.set("entryrecorg", (Object)recOrg);
        }
        if ((recDept = (DynamicObject)entry.get("entryrecdept")) == null && recOrg != null) {
            String cacheKey = String.valueOf(recOrg.getPkValue()) + "entryrecdept";
            if (PurApplyBillHelper.isCache(cacheMap, cacheKey)) {
                recDept = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                recDept = OrgHelper.getOrgForFormDefObjValue((Long)((Long)recOrg.getPkValue()), (String)"15", (String)"01", (String)"toorg");
                cacheMap.put(cacheKey, recDept);
            }
            entry.set("entryrecdept", (Object)recDept);
        }
        entry.set("entrypurog", (Object)org);
    }

    private static void setDefaultEntryStatusAndDate(DynamicObject bill, DynamicObject entry) {
        Date reqdate;
        Date deliverDate;
        String billStatus = bill.getString("billstatus");
        String rowCloseStatus = entry.getString("rowclosestatus");
        String rowTerminateStatus = entry.getString("rowterminatestatus");
        if (billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            entry.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            entry.set("rowterminatestatus", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue());
        } else {
            if (StringUtils.isEmpty((CharSequence)rowCloseStatus)) {
                entry.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            }
            if (StringUtils.isEmpty((CharSequence)rowTerminateStatus)) {
                entry.set("rowterminatestatus", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue());
            }
        }
        entry.set("entrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
        Date bizTime = bill.getDate("biztime");
        Date purDate = entry.getDate("purdate");
        if (purDate == null) {
            entry.set("purdate", (Object)bizTime);
        }
        if ((deliverDate = entry.getDate("deliverdate")) == null) {
            entry.set("deliverdate", (Object)bizTime);
        }
        if ((reqdate = entry.getDate("reqdate")) == null) {
            entry.set("reqdate", (Object)bizTime);
        }
    }

    public static DynamicObject calcAllAmount(DynamicObject bill) {
        PurApplyBillHelper.calcuAmount(bill);
        return bill;
    }

    public static void calcuAmount(DynamicObject bill) {
        BigDecimal totalAmountAndTax = BigDecimal.ZERO;
        boolean isTax = bill.getBoolean("istax");
        DynamicObject currency = bill.getDynamicObject("currency");
        int amountPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        int pricePrecision = 10;
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            BigDecimal qty = entry.getBigDecimal("qty");
            BigDecimal price = entry.getBigDecimal("price");
            BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
            DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
            if (taxRateId == null) {
                DynamicObject master;
                DynamicObject material = entry.getDynamicObject("material");
                if (material != null && (master = material.getDynamicObject("masterid")) != null && master.getDynamicObject("taxrate") != null && (taxRateId = master.getDynamicObject("taxrate")) != null) {
                    taxRateId = BusinessDataServiceHelper.loadSingleFromCache((Object)taxRateId.getPkValue(), (String)"bd_taxrate", (String)"id, taxrate,activedate,expdate");
                    entry.set("taxrateid", (Object)taxRateId);
                    entry.set("taxrate", (Object)taxRateId.getBigDecimal("taxrate"));
                }
            } else {
                entry.set("taxrate", (Object)taxRateId.getBigDecimal("taxrate"));
            }
            BigDecimal taxRate = entry.getBigDecimal("taxrate");
            if (qty == null) continue;
            Map<String, Object> amountMap = PurApplyBillHelper.getAmount(qty, isTax, price, priceAndTax, taxRate, amountPrecision, pricePrecision);
            BigDecimal amount = (BigDecimal)amountMap.get("amount");
            BigDecimal taxAmount = (BigDecimal)amountMap.get("taxamount");
            BigDecimal amountAndTax = (BigDecimal)amountMap.get("amountandtax");
            entry.set("price", amountMap.get("price"));
            entry.set("priceandtax", amountMap.get("priceandtax"));
            entry.set("amount", (Object)amount);
            entry.set("taxamount", (Object)taxAmount);
            entry.set("amountandtax", (Object)amountAndTax);
            totalAmountAndTax = totalAmountAndTax.add(amountAndTax);
        }
        bill.set("totalallamount", (Object)totalAmountAndTax);
    }

    public static List<DynamicObject> batchSetPurApplyDefValue(List<DynamicObject> bills) {
        if (kd.scmc.pm.utils.CommonUtils.isNull(bills)) {
            return bills;
        }
        HashMap materFitOpeMap = new HashMap();
        HashMap<String, Boolean> orgIsUpApplyMap = new HashMap<String, Boolean>();
        DynamicObject currentUser = null;
        for (DynamicObject bill : bills) {
            DynamicObject material;
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) {
                log.info("\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\u3002");
                continue;
            }
            DynamicObject dept = bill.getDynamicObject("dept");
            DynamicObject applyer = bill.getDynamicObject("bizuser");
            if (applyer == null) {
                if (currentUser == null) {
                    long currentUserId = UserServiceHelper.getCurrentUserId();
                    currentUser = BusinessDataServiceHelper.loadSingleFromCache((Object)currentUserId, (String)"bos_user");
                }
                applyer = currentUser;
                bill.set("bizuser", (Object)applyer);
            }
            if (dept == null && applyer != null) {
                dept = OrgHelper.getDefaultDepartmentObject((Long)((Long)applyer.getPkValue()));
                bill.set("dept", (Object)dept);
            }
            Long orgId = (Long)org.getPkValue();
            DynamicObject currency = bill.getDynamicObject("currency");
            if (currency == null) {
                currency = CurrencyHelper.getCurrency(orgId);
                bill.set("currency", (Object)currency);
            }
            int amountPrecision = currency == null ? 10 : currency.getInt("amtprecision");
            int pricePrecision = 10;
            boolean isTax = bill.getBoolean("istax");
            BigDecimal totalAmountAndTax = BigDecimal.ZERO;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            HashSet<Long> materialNumber = new HashSet<Long>(entrys.size());
            boolean isUpApply = false;
            String entityName = bill.getDataEntityType().getName();
            if (!entityName.equals("pm_purplanbill")) {
                if (orgIsUpApplyMap.containsKey(orgId + "Operator")) {
                    isUpApply = (Boolean)orgIsUpApplyMap.get(orgId + "Operator");
                } else {
                    Object isUpApplyObj = AppParameterHelper.getPmAppParameter(orgId, "purapplyfitoperator");
                    if (isUpApplyObj instanceof Boolean) {
                        isUpApply = (Boolean)isUpApplyObj;
                        orgIsUpApplyMap.put(orgId + "Operator", (Boolean)isUpApplyObj);
                    }
                }
                if (isUpApply) {
                    Map<Long, Map<String, Object>> operatorMap;
                    for (Object billEntry : entrys) {
                        material = billEntry.getDynamicObject("material");
                        material = material == null ? null : material.getDynamicObject("masterid");
                        if (material == null) continue;
                        String materialID = String.valueOf(material.getPkValue());
                        String OperatorKey = orgId + materialID;
                        if (materFitOpeMap.containsKey(OperatorKey)) continue;
                        materialNumber.add((Long)material.getPkValue());
                    }
                    if (materialNumber.size() > 0 && (operatorMap = PurApplyBillHelper.getMaterialFitOperatorNew(orgId, materialNumber)) != null && operatorMap.size() > 0) {
                        Object billEntry;
                        billEntry = operatorMap.entrySet().iterator();
                        while (billEntry.hasNext()) {
                            Map.Entry operatorMaps = (Map.Entry)billEntry.next();
                            materFitOpeMap.put(String.valueOf(orgId) + operatorMaps.getKey(), operatorMaps.getValue());
                        }
                    }
                }
            }
            for (DynamicObject entry : entrys) {
                material = entry.getDynamicObject("material");
                BigDecimal qty = entry.getBigDecimal("qty");
                BigDecimal applyQty = entry.getBigDecimal("applyqty");
                if (material != null) {
                    DynamicObject masterMaterial = entry.getDynamicObject("materialmasterid");
                    if (masterMaterial == null && (masterMaterial = material.getDynamicObject("masterid")) != null) {
                        entry.set("materialmasterid", (Object)masterMaterial);
                    }
                    DynamicObject masterIdObj = material.getDynamicObject("masterid");
                    if (isUpApply && masterIdObj != null && materFitOpeMap.size() > 0 && !entityName.equals("pm_purplanbill")) {
                        Map OpeAOpeGroupMap;
                        String masterId = String.valueOf(masterIdObj.getPkValue());
                        String OperatorKey = orgId + masterId;
                        DynamicObject entryoperator = entry.getDynamicObject("entryoperator");
                        DynamicObject entryoperatorgroup = entry.getDynamicObject("entryoperatorgroup");
                        if (entryoperator == null && entryoperatorgroup == null && (OpeAOpeGroupMap = (Map)materFitOpeMap.get(OperatorKey)) != null) {
                            entry.set("entryoperator_id", OpeAOpeGroupMap.get("operator"));
                            entry.set("entryoperatorgroup_id", OpeAOpeGroupMap.get("operatorgroup"));
                        }
                    }
                    DynamicObject unit = entry.getDynamicObject("unit");
                    DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                    BigDecimal baseQty = entry.getBigDecimal("baseqty");
                    if (unit == null && (unit = material.getDynamicObject("purchaseunit")) != null) {
                        entry.set("unit", (Object)unit);
                    }
                    if (!(unit == null || baseUnit == null || baseQty == null || masterMaterial == null || qty != null && BigDecimal.ZERO.compareTo(qty) != 0 || applyQty != null && BigDecimal.ZERO.compareTo(applyQty) != 0 || (qty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterMaterial.getPkValue(), baseUnit, baseQty, unit)) == null)) {
                        entry.set("qty", (Object)qty);
                        entry.set("applyqty", (Object)qty);
                    }
                }
                BigDecimal price = entry.getBigDecimal("price");
                BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
                BigDecimal taxRate = entry.getBigDecimal("taxrate");
                if (qty == null) continue;
                Map<String, Object> amountMap = PurApplyBillHelper.getAmount(qty, isTax, price, priceAndTax, taxRate, amountPrecision, pricePrecision);
                BigDecimal amount = (BigDecimal)amountMap.get("amount");
                BigDecimal taxAmount = (BigDecimal)amountMap.get("taxamount");
                BigDecimal amountAndTax = (BigDecimal)amountMap.get("amountandtax");
                entry.set("price", amountMap.get("price"));
                entry.set("priceandtax", amountMap.get("priceandtax"));
                entry.set("amount", (Object)amount);
                entry.set("taxamount", (Object)taxAmount);
                entry.set("amountandtax", (Object)amountAndTax);
                totalAmountAndTax = totalAmountAndTax.add(amountAndTax);
            }
            bill.set("totalallamount", (Object)totalAmountAndTax);
        }
        return bills;
    }

    private static Map<String, Object> getAmount(BigDecimal qty, boolean isTax, BigDecimal price, BigDecimal priceAndTax, BigDecimal taxRate, Integer settlePrecision, Integer pricePrecision) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal amount = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        BigDecimal hundred = new BigDecimal("100");
        BigDecimal bigDecimal = taxRate = taxRate == null ? ZERO : taxRate.divide(hundred);
        if (qty != null && qty.compareTo(ZERO) != 0) {
            if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), (int)pricePrecision, RoundingMode.HALF_UP);
                amountAndTax = qty.multiply(priceAndTax).setScale((int)settlePrecision, RoundingMode.HALF_UP);
                taxAmount = amountAndTax.divide(ONE.add(taxRate), (int)settlePrecision, RoundingMode.HALF_UP).multiply(taxRate).setScale((int)settlePrecision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmount).setScale((int)settlePrecision, RoundingMode.HALF_UP);
            } else if (price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate)).setScale((int)pricePrecision, RoundingMode.HALF_UP);
                amount = qty.multiply(price).setScale((int)settlePrecision, RoundingMode.HALF_UP);
                taxAmount = amount.multiply(taxRate).setScale((int)settlePrecision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmount).setScale((int)settlePrecision, RoundingMode.HALF_UP);
            }
        }
        map.put("price", price);
        map.put("priceandtax", priceAndTax);
        map.put("amount", amount);
        map.put("taxamount", taxAmount);
        map.put("amountandtax", amountAndTax);
        return map;
    }

    @Deprecated
    public static Map<String, Map<String, Object>> getMaterialFitOperator(Long orgPkValue, Set<String> materialIDSet) {
        if (orgPkValue == null || materialIDSet == null || materialIDSet.size() == 0) {
            return null;
        }
        HashMap<String, Map<String, Object>> materFitOpeMap = new HashMap<String, Map<String, Object>>(materialIDSet.size());
        QFilter qFilter = new QFilter("controldimension", "=", (Object)"OPER_MATER");
        QFilter qFilterNumber = new QFilter("entryentity.material.masterid.number", "in", materialIDSet);
        QFilter qFilterOrg = new QFilter("org", "=", (Object)orgPkValue);
        QFilter qFilterControlType = new QFilter("controltype", "=", (Object)"ALLOW");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        Map pur0perMaters = BusinessDataServiceHelper.loadFromCache((String)ENTITYNAME, (String)"id,org,entryentity.seq,entryentity.material,entryentity.operator,entryentity.operatorgroup", (QFilter[])new QFilter[]{qFilter.and(qFilterOrg).and(qFilterEnable).and(qFilterStatus).and(qFilterControlType).and(qFilterNumber)}, (String)"audittime");
        if (pur0perMaters == null || pur0perMaters.isEmpty()) {
            return materFitOpeMap;
        }
        for (DynamicObject dynamicObject : pur0perMaters.values()) {
            DynamicObjectCollection entryEntity;
            DynamicObject orgObj;
            if (dynamicObject == null || (orgObj = dynamicObject.getDynamicObject("org")) == null || !orgObj.getPkValue().equals(orgPkValue) || (entryEntity = dynamicObject.getDynamicObjectCollection("entryentity")) == null) continue;
            for (int j = entryEntity.size() - 1; j >= 0; --j) {
                String materialIDNum;
                DynamicObject operatorGroup;
                DynamicObject operator;
                DynamicObject entryObj = (DynamicObject)entryEntity.get(j);
                DynamicObject material = entryObj.getDynamicObject("material");
                if (material == null || material.get("masterid") == null || (operator = entryObj.getDynamicObject("operator")) == null) continue;
                Object pkValue1 = operator.getPkValue();
                boolean invalid = operator.getBoolean("invalid");
                if (invalid || (operatorGroup = entryObj.getDynamicObject("operatorgroup")) == null || operatorGroup.get("enable").equals("0")) continue;
                DynamicObjectCollection dynamicObjectCollection = operatorGroup.getDynamicObjectCollection("entryentity");
                for (DynamicObject object : dynamicObjectCollection) {
                    Object pkValue = object.getPkValue();
                    if (!pkValue1.equals(pkValue)) continue;
                    invalid = object.getBoolean("invalid");
                    break;
                }
                if (invalid || materFitOpeMap.containsKey(materialIDNum = (String)material.get("masterid.number"))) continue;
                HashMap<String, Object> OpeAOpeGroupMap = new HashMap<String, Object>(2);
                if (!materialIDSet.contains(materialIDNum)) continue;
                OpeAOpeGroupMap.put("operator", operator.getPkValue());
                OpeAOpeGroupMap.put("operatorgroup", operatorGroup.getPkValue());
                materFitOpeMap.put(materialIDNum, OpeAOpeGroupMap);
            }
        }
        return materFitOpeMap;
    }

    public static Map<Long, Map<String, Object>> getMaterialFitOperatorNew(Long orgPkValue, Set<Long> materialIDSet) {
        if (orgPkValue == null || materialIDSet == null || materialIDSet.size() == 0) {
            return null;
        }
        HashMap<Long, Map<String, Object>> materFitOpeMap = new HashMap<Long, Map<String, Object>>(materialIDSet.size());
        String selectField = "id,org,entryentity.seq,entryentity.material,entryentity.operator,entryentity.operatorgroup";
        QFilter qFilter = new QFilter("controldimension", "=", (Object)"OPER_MATER");
        QFilter qFilterOrg = new QFilter("org", "=", (Object)orgPkValue);
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterControlType = new QFilter("controltype", "=", (Object)"ALLOW");
        QFilter qFilterNumber = new QFilter("entryentity.material.masterid", "in", materialIDSet);
        QFilter operatorgroup = new QFilter("entryentity.operatorgroup.enable", "!=", (Object)"0");
        QFilter operator = new QFilter("entryentity.operator.invalid", "!=", (Object)Boolean.TRUE);
        QFilter[] qFilters = new QFilter[]{qFilter, qFilterOrg, qFilterEnable, qFilterStatus, qFilterControlType, qFilterNumber, operatorgroup, operator};
        String orderBy = "audittime";
        Map pur0perMaters = BusinessDataServiceHelper.loadFromCache((String)ENTITYNAME, (String)selectField, (QFilter[])qFilters, (String)orderBy);
        if (pur0perMaters == null || pur0perMaters.isEmpty()) {
            return materFitOpeMap;
        }
        for (DynamicObject dynamicObject : pur0perMaters.values()) {
            DynamicObjectCollection entryEntity;
            DynamicObject orgObj;
            if (dynamicObject == null || (orgObj = dynamicObject.getDynamicObject("org")) == null || !orgPkValue.equals(orgObj.getPkValue()) || (entryEntity = dynamicObject.getDynamicObjectCollection("entryentity")) == null) continue;
            for (int j = entryEntity.size() - 1; j >= 0; --j) {
                DynamicObject entryObj = (DynamicObject)entryEntity.get(j);
                DynamicObject material = entryObj.getDynamicObject("material");
                if (material == null || material.get("masterid") == null) continue;
                Long materialMID = (Long)material.get("masterid.id");
                DynamicObject operatorDo = entryObj.getDynamicObject("operator");
                if (operatorDo == null) continue;
                Long operatorDoID = (Long)operatorDo.getPkValue();
                DynamicObject operatorGroupDo = entryObj.getDynamicObject("operatorgroup");
                Long operatorGroupDoID = (Long)operatorGroupDo.getPkValue();
                if (materFitOpeMap.containsKey(materialMID)) continue;
                HashMap<String, Long> OpeAOpeGroupMap = new HashMap<String, Long>(2);
                if (!materialIDSet.contains(materialMID)) continue;
                OpeAOpeGroupMap.put("operator", operatorDoID);
                OpeAOpeGroupMap.put("operatorgroup", operatorGroupDoID);
                materFitOpeMap.put(materialMID, OpeAOpeGroupMap);
            }
        }
        return materFitOpeMap;
    }

    private static boolean isCache(Map<String, Object> map, String key) {
        return map.containsKey(key);
    }
}

