/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class PurApplyMalHelper {
    private static final Log log = LogFactory.getLog(PurApplyMalHelper.class);
    public static final String MAL_PURCHASE_OP_KEY = "malpurchase";
    public static final String MAL_PLAN_ID_KEY = "malPlanIds";
    public static final String SHOW_MAL_ORDER_OP_KEY = "showmalorder";
    public static final String MAL_ORDER_KEY = "mal_order";
    public static final String SELECTED_ROWS_KEY = "selectedRows";

    public static void beforeMalPurchase(EventObject args, DynamicObject bill, int[] selectedRows) {
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        Long billId = (Long)bill.getPkValue();
        if (0L == billId) {
            return;
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null || entry.isEmpty()) {
            return;
        }
        ArrayList<String> selectedEntryIds = new ArrayList<String>(selectedRows.length);
        for (int selectedRow : selectedRows) {
            Long entryId = (Long)((DynamicObject)entry.get(selectedRow)).getPkValue();
            if (0L == entryId) continue;
            selectedEntryIds.add(entryId.toString());
        }
        if (!selectedEntryIds.isEmpty()) {
            HashMap<String, List<String>> selectedIdMap = new HashMap<String, List<String>>(2);
            selectedIdMap.put(billId.toString(), selectedEntryIds);
            PurApplyMalHelper.beforeMalPurchase(args, selectedIdMap);
        }
    }

    public static void beforeMalPurchase(EventObject args, Map<String, List<String>> paramMap) {
        PurApplyMalHelper.addCustomParam(args, SELECTED_ROWS_KEY, SerializationUtils.toJsonString(paramMap));
    }

    public static Map<String, Object> malPurchase(OperateOption option, ExtendedDataEntity[] dataEntities) {
        Map<String, List<String>> selectedEntryIdMap = PurApplyMalHelper.getSelectedEntryIdMap(option);
        HashMap<String, List<Map<String, Object>>> param = new HashMap<String, List<Map<String, Object>>>(dataEntities.length << 1);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            Long billId = (Long)bill.getPkValue();
            PurApplyMalHelper.buildMalPlanParam(param, bill, selectedEntryIdMap.get(billId.toString()));
        }
        if (param.isEmpty()) {
            return null;
        }
        Map<String, Object> serviceResult = PurApplyMalHelper.pushMalPlan(param);
        if (serviceResult == null) {
            return null;
        }
        Boolean success = (Boolean)serviceResult.get("success");
        if (success == null || !success.booleanValue()) {
            return serviceResult;
        }
        List result = (List)serviceResult.get("result");
        if (result == null || result.isEmpty()) {
            return null;
        }
        option.setVariableValue(MAL_PLAN_ID_KEY, PurApplyMalHelper.longCollection2Str(result));
        return serviceResult;
    }

    public static FormShowParameter getMalPurchaseShowParameter(EventObject e) {
        String malPlanIdStr = PurApplyMalHelper.getCustomParam(e, MAL_PLAN_ID_KEY);
        if (malPlanIdStr == null) {
            return null;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam(MAL_PLAN_ID_KEY, PurApplyMalHelper.string2LongList(malPlanIdStr));
        showParameter.setFormId("mal_purchase");
        Map<String, List<String>> selectedEntryIdMap = PurApplyMalHelper.getSelectedEntryIdMap(e);
        if (selectedEntryIdMap != null && !selectedEntryIdMap.isEmpty()) {
            HashSet<String> srcEntryIds = new HashSet<String>(16);
            for (List<String> value : selectedEntryIdMap.values()) {
                srcEntryIds.addAll(value);
            }
            showParameter.setCustomParam("srcentryids", srcEntryIds);
        }
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        return showParameter;
    }

    public static Set<Long> getMalOrderIds(Set<String> billIds, OperateOption option) {
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u8c03\u7528\u4e0b\u67e5\u534f\u540c\u5546\u57ce\u8ba2\u5355id\u63a5\u53e3 \u53c2\u6570\uff1a" + billIds);
        Set malOrderIds = (Set)DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"MalPushPlanService", (String)"queryMalOrderBySrcBillIds", (Object[])new Object[]{billIds});
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u8c03\u7528\u4e0b\u67e5\u534f\u540c\u5546\u57ce\u8ba2\u5355id\u63a5\u53e3 \u8fd4\u56de\u503c\uff1a" + malOrderIds);
        if (malOrderIds != null && !malOrderIds.isEmpty()) {
            option.setVariableValue(MAL_ORDER_KEY, PurApplyMalHelper.longCollection2Str(malOrderIds));
        }
        return malOrderIds;
    }

    public static FormShowParameter getMalOrderShowParameter(EventObject args) {
        String malOrderIdStr = PurApplyMalHelper.getCustomParam(args, MAL_ORDER_KEY);
        if (malOrderIdStr == null) {
            return null;
        }
        return PurApplyMalHelper.getMalOrderShowParameter(PurApplyMalHelper.string2LongList(malOrderIdStr));
    }

    public static void addCustomParam(EventObject eventObject, String key, String value) {
        Object source = eventObject.getSource();
        if (source instanceof FormOperate) {
            ((FormOperate)source).getOption().setVariableValue(key, value);
        }
    }

    public static String getCustomParam(EventObject eventObject, String key) {
        Object source = eventObject.getSource();
        if (source instanceof FormOperate) {
            return PurApplyMalHelper.getCustomParam(((FormOperate)source).getOption(), key);
        }
        return null;
    }

    private static void buildMalPlanParam(Map<String, List<Map<String, Object>>> param, DynamicObject bill, List<String> selectedEntryIds) {
        Long billId = (Long)bill.getPkValue();
        if (0L == billId) {
            return;
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null || entry.isEmpty()) {
            return;
        }
        List<Map<String, Object>> list = selectedEntryIds == null || selectedEntryIds.isEmpty() ? PurApplyMalHelper.getAllEntryParam(entry) : PurApplyMalHelper.getSelectedEntryParam(entry, selectedEntryIds);
        if (list.isEmpty()) {
            return;
        }
        param.put(billId.toString(), list);
    }

    private static List<Map<String, Object>> getSelectedEntryParam(DynamicObjectCollection entry, List<String> selectedEntryIds) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(selectedEntryIds.size());
        for (DynamicObject row : entry) {
            Long entryId = (Long)row.getPkValue();
            if (!selectedEntryIds.contains(entryId.toString())) continue;
            list.add(PurApplyMalHelper.malPlanParamFieldMap(row));
        }
        return list;
    }

    private static List<Map<String, Object>> getAllEntryParam(DynamicObjectCollection entry) {
        return entry.stream().map(PurApplyMalHelper::malPlanParamFieldMap).collect(Collectors.toList());
    }

    private static Map<String, Object> malPlanParamFieldMap(DynamicObject row) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(4);
        fieldMap.put("entryid", row.getPkValue());
        fieldMap.put("joinqty", row.get("joinqty"));
        return fieldMap;
    }

    private static Map<String, Object> pushMalPlan(Map<String, List<Map<String, Object>>> param) {
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u8c03\u7528\u5546\u57ce\u91c7\u8d2d\u8ba1\u5212\u5fae\u670d\u52a1 \u53c2\u6570\uff1a" + param);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"MalPushPlanService", (String)"pushMalPlan", (Object[])new Object[]{param});
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u8c03\u7528\u5546\u57ce\u91c7\u8d2d\u8ba1\u5212\u5fae\u670d\u52a1 \u8fd4\u56de\u503c\uff1a" + result);
        return result;
    }

    private static FormShowParameter getMalOrderShowParameter(List<Long> malOrderIds) {
        String malOrderName = MAL_ORDER_KEY;
        if (malOrderIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)malOrderIds.get(0));
            showParameter.setFormId(malOrderName);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            return showParameter;
        }
        ListShowParameter showParameter = new ListShowParameter();
        LinkQueryPkIdCollection ids = new LinkQueryPkIdCollection();
        for (Long malOrderId : malOrderIds) {
            ids.addLinkQueryPkId((Object)malOrderId);
        }
        showParameter.setLinkQueryPkIdCollection(ids);
        showParameter.setBillFormId(malOrderName);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    private static String longCollection2Str(Collection<Long> collection) {
        return collection.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    private static List<Long> string2LongList(String str) {
        return Arrays.stream(str.split(",")).map(Long::parseLong).collect(Collectors.toList());
    }

    private static Map<String, List<String>> getSelectedEntryIdMap(OperateOption option) {
        String param = PurApplyMalHelper.getCustomParam(option, SELECTED_ROWS_KEY);
        if (param == null) {
            return new HashMap<String, List<String>>(2);
        }
        return (Map)SerializationUtils.fromJsonString((String)param, Map.class);
    }

    private static Map<String, List<String>> getSelectedEntryIdMap(EventObject e) {
        String param = PurApplyMalHelper.getCustomParam(e, SELECTED_ROWS_KEY);
        if (param == null) {
            return new HashMap<String, List<String>>(2);
        }
        return (Map)SerializationUtils.fromJsonString((String)param, Map.class);
    }

    private static String getCustomParam(OperateOption option, String key) {
        return option.getVariableValue(key, null);
    }
}

