/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.business.helper.BillTypeHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OwnerHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.mpscmm.msbd.common.enums.UnitConvertDirEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.CurrencyHelper;
import kd.scmc.pm.business.helper.MaterialHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.business.pojo.AmountPropertyKey;
import kd.scmc.pm.enums.BizCancelStatusEnum;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.ChangeStatusEnum;
import kd.scmc.pm.enums.ChangeTypeEnum;
import kd.scmc.pm.enums.DiscountTypeEnum;
import kd.scmc.pm.enums.ExchangeTypeEnum;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;
import kd.scmc.pm.enums.PayModeEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.RowTerminateStatusEnum;
import kd.scmc.pm.enums.StatusEnum;

public class PurOrderBillHelper {
    private static final Log log = LogFactory.getLog(PurOrderBillHelper.class);
    private static final String PMAPPID = "/JJVO8XV9MVB";
    private static final String PMVIEWTYPE = "02";

    public static CommonContext getPayPlanCommonText(String entityId) {
        CommonContext commonContext = CommonContext.get();
        commonContext.setEntityId(entityId);
        Map propertyMapping = commonContext.getProperytMapping();
        propertyMapping.putAll(PurOrderBillHelper.getPlanCommonFieldMapping());
        return commonContext;
    }

    public static Map<String, String> getPlanCommonFieldMapping() {
        HashMap<String, String> properytMapping = new HashMap<String, String>();
        properytMapping.put("appid", PMAPPID);
        properytMapping.put("viewtype", PMVIEWTYPE);
        properytMapping.put("plantype", "purchase");
        properytMapping.put("totalallamount", "totalallamount");
        properytMapping.put("amountcondition", "paycondition");
        properytMapping.put("settlecurrency", "settlecurrency");
        properytMapping.put("ispayrate", "ispayrate");
        properytMapping.put("biztime", "biztime");
        properytMapping.put("entrynum", "purbillentry_pay");
        properytMapping.put("amount", "payamount");
        properytMapping.put("changetype", "payentrychangetype");
        properytMapping.put("rate", "payrate");
        properytMapping.put("itemname", "payname");
        properytMapping.put("isprepay", "isprepay");
        properytMapping.put("amountdate", "paydate");
        return properytMapping;
    }

    public static List<DynamicObject> completeBillInfo(List<DynamicObject> bills) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(8);
        if (bills == null || bills.size() == 0) {
            return null;
        }
        for (DynamicObject bill : bills) {
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            DynamicObject billType = bill.getDynamicObject("billtype");
            if (billType == null) {
                billType = BillTypeHelper.getDefaultBillTypeObject((String)"pm_purorderbill");
                if (billType == null) continue;
                bill.set("billtype", (Object)billType);
            }
            PurOrderBillHelper.setDefaultHeadStatus(bill);
            PurOrderBillHelper.setDefaultBizType(bill);
            PurOrderBillHelper.setDefaultOperatorGroup(bill);
            PurOrderBillHelper.setDefaultDept(bill);
            PurOrderBillHelper.setDefaultSettleOrg(bill, cacheMap);
            SupplierHelper.setDefaultSupplier(bill);
            PurOrderBillHelper.setDefaultFinancialInfo(bill);
            PurOrderBillHelper.setDefaultOtherInfo(bill);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                PurOrderBillHelper.setDefaultEntryStatus(bill, entry);
                PurOrderBillHelper.setDefaultLineType(bill, entry, cacheMap);
                PurOrderBillHelper.setDefaultMaterialInfo(entry);
                PurOrderBillHelper.setDefaultEntryOrg(bill, entry, cacheMap);
                PurOrderBillHelper.setDefaultQty(entry);
                PurOrderBillHelper.setDefaultReceiveInfo(bill, entry, cacheMap);
            }
            PurOrderBillHelper.calcuAmount(bill);
            AmountPlanHelper.changeAmountConditionForDynamicObject((CommonContext)PurOrderBillHelper.getPayPlanCommonText("pm_purorderbill"), (DynamicObject)bill);
            DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("purbillentry_pay");
            for (DynamicObject entry : payEntrys) {
                entry.set("payentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
                Boolean isPreRec = entry.getBoolean("isprepay");
                if (isPreRec == null) {
                    entry.set("isprepay", (Object)Boolean.FALSE);
                }
                if (isPreRec != null && !isPreRec.booleanValue()) {
                    entry.set("pretimepoint", (Object)"");
                    continue;
                }
                String pretimepoint = entry.getString("pretimepoint");
                if (!kd.bos.util.StringUtils.isEmpty((String)pretimepoint)) continue;
                entry.set("pretimepoint", (Object)"B");
            }
            result.add(bill);
        }
        return result;
    }

    public static DynamicObject calcAllAmount(DynamicObject bill) {
        Map<String, BigDecimal> totalAmountMap = AmountHelper.calcAllAmount(bill, AmountPropertyKey.getInstance());
        for (Map.Entry<String, BigDecimal> entry : totalAmountMap.entrySet()) {
            bill.set(entry.getKey(), (Object)entry.getValue());
        }
        return PurOrderBillHelper.calcAmountPlan(bill);
    }

    public static DynamicObject calcTotalAmount(DynamicObject bill) {
        for (Map.Entry<String, BigDecimal> entry : AmountHelper.calcTotalAmount(bill).entrySet()) {
            bill.set(entry.getKey(), (Object)entry.getValue());
        }
        return bill;
    }

    public static DynamicObject calcAmountPlan(DynamicObject bill) {
        AmountPlanHelper.calAmountPlanForDynamicObject((CommonContext)PurOrderBillHelper.getPayPlanCommonText("pm_purorderbill"), (DynamicObject)bill);
        return bill;
    }

    public static void calcuAmount(DynamicObject bill) {
        String billStatus = bill.getString("billstatus");
        bill.set("inputamount", (Object)Boolean.FALSE);
        AmountPropertyKey amountPropertyKey = AmountPropertyKey.getInstance();
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
        amountMap.put("totalamount", BigDecimalUtil.ZERO);
        amountMap.put("totaltaxamount", BigDecimalUtil.ZERO);
        amountMap.put("totalallamount", BigDecimalUtil.ZERO);
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            PurOrderBillHelper.calcuEntryAmount(bill, entry, i, amountMap, amountPropertyKey);
            if (!StatusEnum.AUDIT.getValue().equals(billStatus) && !StatusEnum.SUBMIT.getValue().equals(billStatus)) continue;
            BigDecimal amountup = entry.getBigDecimal("amountup");
            Boolean isControlAmountUp = entry.getBoolean("iscontrolamountup");
            if (!BigDecimalUtil.isBlank((BigDecimal)amountup) && !Boolean.FALSE.equals(isControlAmountUp)) continue;
            entry.set("amountup", (Object)entry.getBigDecimal("amountandtax"));
        }
        bill.set("totalamount", amountMap.get("totalamount"));
        bill.set("totaltaxamount", amountMap.get("totaltaxamount"));
        bill.set("totalallamount", amountMap.get("totalallamount"));
    }

    private static void setDefaultHeadStatus(DynamicObject bill) {
        Date bizTime;
        String billStatus = bill.getString("billstatus");
        if (CommonUtils.isNull((Object)billStatus)) {
            bill.set("billstatus", (Object)StatusEnum.SAVE.getValue());
        }
        if (CommonUtils.isNull((Object)(bizTime = bill.getDate("biztime")))) {
            bill.set("biztime", (Object)new Date());
        }
        if (billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            bill.set("auditor", null);
            bill.set("auditdate", null);
            bill.set("closer", null);
            bill.set("closedate", null);
            bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
            bill.set("canceler", null);
            bill.set("canceldate", null);
            bill.set("cancelstatus", (Object)BizCancelStatusEnum.UNCANCEL.getValue());
            bill.set("changer", null);
            bill.set("changedate", null);
            bill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
        } else {
            if (CommonUtils.isNull((Object)bill.getString("closestatus"))) {
                bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
                bill.set("closer", null);
                bill.set("closedate", null);
            }
            if (CommonUtils.isNull((Object)bill.getString("cancelstatus"))) {
                bill.set("cancelstatus", (Object)BizCancelStatusEnum.UNCANCEL.getValue());
                bill.set("canceler", null);
                bill.set("canceldate", null);
            }
            if (CommonUtils.isNull((Object)bill.getString("changestatus"))) {
                bill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
                bill.set("changer", null);
                bill.set("changedate", null);
            }
        }
    }

    private static void setDefaultBizType(DynamicObject bill) {
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (bizType == null) {
            DynamicObject billType = bill.getDynamicObject("billtype");
            bizType = BizTypeHelper.getDefaultBizTypeObject((String)"pm_purorderbill", (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter");
            bill.set("biztype", (Object)bizType);
        }
    }

    private static void setDefaultDept(DynamicObject bill) {
        DynamicObject user;
        DynamicObject dept = bill.getDynamicObject("dept");
        DynamicObject operator = bill.getDynamicObject("operator");
        if (dept == null && operator != null && (user = operator.getDynamicObject("operatorid")) != null) {
            dept = kd.mpscmm.msbd.business.helper.OrgHelper.getDefaultDepartmentObject((Long)((Long)user.getPkValue()));
            bill.set("dept", (Object)dept);
        }
    }

    private static void setDefaultOperatorGroup(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject operator = bill.getDynamicObject("operator");
        DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
        long userId = UserServiceHelper.getCurrentUserId();
        if (0L == userId) {
            return;
        }
        if (operator == null) {
            Map operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)((Long)org.getPkValue()), (Long)userId, (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
            if (!operatorAndGroup.isEmpty()) {
                bill.set("operator", operatorAndGroup.get("operator"));
                if (operatorGroup == null) {
                    bill.set("operatorgroup", operatorAndGroup.get("operatorgroup"));
                }
            }
        } else if (operatorGroup == null) {
            operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.get("operatorgrpid"), (String)"bd_operatorgroup");
            bill.set("operatorgroup", (Object)operatorGroup);
        }
    }

    private static void setDefaultSettleOrg(DynamicObject bill, Map<String, Object> cacheMap) {
        Long orgId = (Long)bill.getDynamicObject("org").getPkValue();
        DynamicObject settleOrg = bill.getDynamicObject("settleorg");
        if (orgId != null && settleOrg == null) {
            String settleCacheKey = orgId + "settleorg";
            if (PurOrderBillHelper.isCached(cacheMap, settleCacheKey)) {
                settleOrg = (DynamicObject)cacheMap.get(settleCacheKey);
            } else {
                settleOrg = kd.mpscmm.msbd.business.helper.OrgHelper.getOrgForFormDefObjValue((Long)orgId, (String)PMVIEWTYPE, (String)"10", (String)"toorg");
                cacheMap.put(settleCacheKey, settleOrg);
            }
            bill.set("settleorg", (Object)settleOrg);
        }
    }

    private static void setDefaultFinancialInfo(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        DynamicObject exRateTable = bill.getDynamicObject("exratetable");
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        Date exRateTime = bill.getDate("exratedate");
        String exchangeType = bill.getString("exchangetype");
        Boolean isTax = bill.getBoolean("istax");
        if (currency == null) {
            currency = CurrencyHelper.getCurrency((Long)org.getPkValue());
            bill.set("currency", (Object)currency);
        }
        if (settleCurrency == null) {
            settleCurrency = currency;
            bill.set("settlecurrency", (Object)currency);
        }
        if (exRateTable == null) {
            exRateTable = PurOrderBillHelper.getExRateTable((Long)org.getPkValue());
            bill.set("exratetable", (Object)exRateTable);
        }
        if (exRateTime == null) {
            exRateTime = bill.getDate("biztime");
            bill.set("exratedate", (Object)exRateTime);
        }
        if (isTax == null) {
            bill.set("istax", (Object)Boolean.TRUE);
        }
        if (currency != null && exRateTable != null) {
            BigDecimal exRate = null;
            if (StringUtils.isEmpty((CharSequence)exchangeType)) {
                Map exRateMap = kd.mpscmm.msbd.business.helper.CurrencyHelper.getExChangeRateMap((Long)((Long)settleCurrency.getPkValue()), (Long)((Long)currency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)exRateTime);
                exRate = (BigDecimal)exRateMap.get("exchangerate");
                exchangeType = (String)exRateMap.get("exchangetype");
                bill.set("exchangetype", (Object)exchangeType);
            }
            if (BigDecimalUtil.isBlank((BigDecimal)exchangeRate)) {
                exchangeRate = exRate != null ? exRate : kd.mpscmm.msbd.business.helper.CurrencyHelper.getExChangeRate((Long)((Long)settleCurrency.getPkValue()), (Long)((Long)currency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)exRateTime, (String)exchangeType);
                bill.set("exchangerate", (Object)exchangeRate);
            }
        }
        if (bill.getString("paymode") == null) {
            bill.set("paymode", (Object)PayModeEnum.CREDIT.getValue());
        }
    }

    private static void setDefaultOtherInfo(DynamicObject bill) {
        String subVersion;
        bill.set("inputamount", (Object)Boolean.FALSE);
        Boolean supplyTrans = bill.getBoolean("supplytrans");
        if (supplyTrans == null) {
            bill.set("supplytrans", (Object)Boolean.FALSE);
        }
        String billStatus = bill.getString("billstatus");
        String version = bill.getString("version");
        if (version == null || billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            bill.set("version", (Object)"1");
        }
        if ((subVersion = bill.getString("subversion")) == null || billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            bill.set("subversion", (Object)"1");
        }
    }

    private static void calcuEntryAmount(DynamicObject bill, DynamicObject entry, int i, Map<String, BigDecimal> amountMap, AmountPropertyKey amountPropertyKey) {
        Map<String, BigDecimal> entryAmountMap;
        DynamicObject supplier = bill.getDynamicObject("supplier");
        DynamicObject currency = bill.getDynamicObject("currency");
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        Integer settlePricePrecision = settleCurrency == null ? null : Integer.valueOf(settleCurrency.getInt("priceprecision"));
        String exchangeType = bill.getString("exchangetype");
        Boolean isTax = bill.getBoolean("istax");
        BigDecimal amount = entry.getBigDecimal("amount");
        BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
        BigDecimal taxAmount = entry.getBigDecimal("taxamount");
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
        if (taxRateId == null) {
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject defaultTaxRate = MaterialHelper.getDefaultTaxRate(supplier, material);
            if (defaultTaxRate != null) {
                entry.set("taxrateid", (Object)defaultTaxRate);
                entry.set("taxrate", (Object)defaultTaxRate.getBigDecimal("taxrate"));
            }
        } else {
            entry.set("taxrate", (Object)taxRateId.getBigDecimal("taxrate"));
        }
        Boolean isPresent = entry.getBoolean("ispresent");
        if (Boolean.TRUE.equals(isPresent)) {
            if (isTax.booleanValue()) {
                if (BigDecimalUtil.isZero((BigDecimal)entry.getBigDecimal("priceandtax"))) {
                    entry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                    entry.set("discountrate", (Object)BigDecimalUtil.ZERO);
                } else {
                    entry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                    entry.set("discountrate", (Object)BigDecimalUtil.HUNDRED);
                }
            } else if (BigDecimalUtil.isZero((BigDecimal)entry.getBigDecimal("price"))) {
                entry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                entry.set("discountrate", (Object)BigDecimalUtil.ZERO);
            } else {
                entry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                entry.set("discountrate", (Object)BigDecimalUtil.HUNDRED);
            }
        }
        if ((BigDecimalUtil.isBlank((BigDecimal)amount) || BigDecimalUtil.isBlank((BigDecimal)amountAndTax)) && !(entryAmountMap = AmountHelper.calcAmount(bill, amountPropertyKey, i)).isEmpty()) {
            amount = entryAmountMap.get(amountPropertyKey.getAmount());
            taxAmount = entryAmountMap.get(amountPropertyKey.getTaxAmount());
            amountAndTax = entryAmountMap.get(amountPropertyKey.getAmountAndTax());
        }
        if (amount != null) {
            BigDecimal totalAmount = amountMap.get("totalamount");
            amountMap.put("totalamount", totalAmount.add(amount));
        }
        if (taxAmount != null) {
            BigDecimal totalTaxAmount = amountMap.get("totaltaxamount");
            amountMap.put("totaltaxamount", totalTaxAmount.add(taxAmount));
        }
        if (amountAndTax != null) {
            BigDecimal totalAmountAndTax = amountMap.get("totalallamount");
            amountMap.put("totalallamount", totalAmountAndTax.add(amountAndTax));
        }
        BigDecimal curAmountAndTax = entry.getBigDecimal("curamountandtax");
        BigDecimal curAmount = entry.getBigDecimal("curamount");
        BigDecimal curTaxAmount = entry.getBigDecimal("curtaxamount");
        if (!BigDecimalUtil.isBlank((BigDecimal)exchangeRate) && (BigDecimalUtil.isBlank((BigDecimal)curAmountAndTax) || BigDecimalUtil.isBlank((BigDecimal)curAmount) || BigDecimalUtil.isBlank((BigDecimal)curTaxAmount))) {
            int currencyAmtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
            boolean indirectRate = ExchangeTypeEnum.isIndirectRate((Object)exchangeType);
            curTaxAmount = AmountHelper.convertByExRate(taxAmount, exchangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
            if (isTax.booleanValue()) {
                curAmountAndTax = AmountHelper.convertByExRate(amountAndTax, exchangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                curAmount = curAmountAndTax.subtract(curTaxAmount);
            } else {
                curAmount = AmountHelper.convertByExRate(amount, exchangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                curAmountAndTax = curAmount.add(curTaxAmount);
            }
            entry.set("curamountandtax", (Object)curAmountAndTax);
            entry.set("curamount", (Object)curAmount);
            entry.set("curtaxamount", (Object)curTaxAmount);
        }
    }

    private static void setDefaultEntryOrg(DynamicObject bill, DynamicObject entry, Map<String, Object> cacheMap) {
        DynamicObject payOrg;
        DynamicObject settleDept;
        DynamicObject entrySettleOrg;
        DynamicObject recDept;
        DynamicObject recOrg;
        DynamicObject reqDept;
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject reqOrg = (DynamicObject)entry.get("entryreqorg");
        if (reqOrg == null) {
            String cacheKey = String.valueOf(org.getPkValue()) + "entryreqorg";
            if (PurOrderBillHelper.isCached(cacheMap, cacheKey)) {
                reqOrg = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                reqOrg = kd.mpscmm.msbd.business.helper.OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)"", (String)PMVIEWTYPE, (String)"fromorg");
                cacheMap.put(cacheKey, reqOrg);
            }
            entry.set("entryreqorg", (Object)reqOrg);
        }
        if ((reqDept = (DynamicObject)entry.get("entryreqdept")) == null && reqOrg != null) {
            String cacheKey = String.valueOf(reqOrg.getPkValue()) + "entryreqdept";
            if (PurOrderBillHelper.isCached(cacheMap, cacheKey)) {
                reqDept = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                reqDept = kd.mpscmm.msbd.business.helper.OrgHelper.getOrgForFormDefObjValue((Long)((Long)reqOrg.getPkValue()), (String)"15", (String)"01", (String)"toorg");
                cacheMap.put(cacheKey, reqDept);
            }
            entry.set("entryreqdept", (Object)reqDept);
        }
        if ((recOrg = (DynamicObject)entry.get("entryrecorg")) == null) {
            String cacheKey = String.valueOf(org.getPkValue()) + "entryrecorg";
            if (PurOrderBillHelper.isCached(cacheMap, cacheKey)) {
                recOrg = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                recOrg = kd.mpscmm.msbd.business.helper.OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)PMVIEWTYPE, (String)"05", (String)"toorg");
                cacheMap.put(cacheKey, recOrg);
            }
            entry.set("entryrecorg", (Object)recOrg);
        }
        if ((recDept = (DynamicObject)entry.get("entryrecdept")) == null && recOrg != null) {
            String cacheKey = String.valueOf(recOrg.getPkValue()) + "entryrecdept";
            if (PurOrderBillHelper.isCached(cacheMap, cacheKey)) {
                recDept = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                recDept = kd.mpscmm.msbd.business.helper.OrgHelper.getOrgForFormDefObjValue((Long)((Long)recOrg.getPkValue()), (String)"15", (String)"01", (String)"toorg");
                cacheMap.put(cacheKey, recDept);
            }
            entry.set("entryrecdept", (Object)recDept);
        }
        if ((entrySettleOrg = entry.getDynamicObject("entrysettleorg")) == null) {
            String cacheKey = String.valueOf(org.getPkValue()) + "entrysettleorg";
            if (PurOrderBillHelper.isCached(cacheMap, cacheKey)) {
                entrySettleOrg = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                entrySettleOrg = kd.mpscmm.msbd.business.helper.OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)PMVIEWTYPE, (String)"10", (String)"toorg");
                cacheMap.put(cacheKey, entrySettleOrg);
            }
            entry.set("entrysettleorg", (Object)entrySettleOrg);
        }
        if ((settleDept = (DynamicObject)entry.get("entrysettledept")) == null && entrySettleOrg != null) {
            String cacheKey = String.valueOf(entrySettleOrg.getPkValue()) + "entrysettledept";
            if (PurOrderBillHelper.isCached(cacheMap, cacheKey)) {
                settleDept = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                settleDept = kd.mpscmm.msbd.business.helper.OrgHelper.getOrgForFormDefObjValue((Long)((Long)entrySettleOrg.getPkValue()), (String)"15", (String)"01", (String)"toorg");
                cacheMap.put(cacheKey, settleDept);
            }
            entry.set("entrysettledept", (Object)settleDept);
        }
        if ((payOrg = (DynamicObject)entry.get("entrypayorg")) == null && entrySettleOrg != null) {
            String cacheKey = String.valueOf(entrySettleOrg.getPkValue()) + "entrypayorg";
            if (PurOrderBillHelper.isCached(cacheMap, cacheKey)) {
                payOrg = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                payOrg = kd.mpscmm.msbd.business.helper.OrgHelper.getOrgForFormDefObjValue((Long)((Long)entrySettleOrg.getPkValue()), (String)"10", (String)"08", (String)"toorg");
                cacheMap.put(cacheKey, payOrg);
            }
            entry.set("entrypayorg", (Object)payOrg);
        }
        entry.set("entrypurorg", (Object)org);
    }

    private static void setDefaultMaterialInfo(DynamicObject entry) {
        Boolean isPresent;
        DynamicObject auxptyUnit;
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject masterMaterial = material.getDynamicObject("masterid");
        if (masterMaterial == null) {
            return;
        }
        entry.set("materialmasterid", (Object)masterMaterial);
        if (masterMaterial.getBoolean("isdisposable")) {
            if (StringUtils.isEmpty((CharSequence)entry.getString("materialname"))) {
                entry.set("materialname", (Object)masterMaterial.getString("name"));
            }
        } else {
            entry.set("materialname", (Object)masterMaterial.getString("name"));
        }
        entry.set("baseunit", (Object)masterMaterial.getDynamicObject("baseunit"));
        if (entry.getDynamicObject("unit") == null) {
            entry.set("unit", (Object)material.getDynamicObject("purchaseunit"));
        }
        if ((auxptyUnit = masterMaterial.getDynamicObject("auxptyunit")) == null) {
            entry.set("auxunit", null);
            entry.set("auxqty", null);
        } else {
            entry.set("auxunit", (Object)auxptyUnit);
        }
        Boolean isuseauxpty = masterMaterial.getBoolean("isuseauxpty");
        if (Boolean.FALSE.equals(isuseauxpty)) {
            entry.set("auxpty", null);
        }
        if ((isPresent = Boolean.valueOf(entry.getBoolean("ispresent"))) == null) {
            entry.set("ispresent", (Object)Boolean.FALSE);
        }
    }

    public static void setDefaultReceiveQty(DynamicObject entry) {
        DynamicObject material = entry.getDynamicObject("material");
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        DynamicObject unit = entry.getDynamicObject("unit");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal receiveqtyup = entry.getBigDecimal("receiveqtyup");
        BigDecimal receiveqtydown = entry.getBigDecimal("receiveqtydown");
        BigDecimal receivebaseqtyup = entry.getBigDecimal("receivebaseqtyup");
        BigDecimal receivebaseqtydown = entry.getBigDecimal("receivebaseqtydown");
        if (BigDecimalUtil.isNotBlank((BigDecimal)receiveqtyup) && BigDecimalUtil.isNotBlank((BigDecimal)receiveqtydown) && BigDecimalUtil.isNotBlank((BigDecimal)receivebaseqtyup) && BigDecimalUtil.isNotBlank((BigDecimal)receivebaseqtydown)) {
            return;
        }
        BigDecimal receiveRateUp = entry.getBigDecimal("receiverateup");
        BigDecimal receiveRateDown = entry.getBigDecimal("receiveratedown");
        boolean isControlQty = entry.getBoolean("iscontrolqty");
        if (isControlQty) {
            if (BigDecimalUtil.isBlank((BigDecimal)receiveRateUp)) {
                receiveRateUp = material.getBigDecimal("receiverateup");
                entry.set("receiverateup", (Object)receiveRateUp);
            }
            if (BigDecimalUtil.isBlank((BigDecimal)receiveRateDown)) {
                receiveRateDown = material.getBigDecimal("receiveratedown");
                entry.set("receiveratedown", (Object)receiveRateDown);
            }
            BigDecimal receiveQtyUp = BigDecimalUtil.getByGrowRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(BillQtyAndUnitHelper.getPrecision(unit), BillQtyAndUnitHelper.getUnitRoundingMode(unit));
            BigDecimal receiveQtyDown = BigDecimalUtil.getByReduceRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateDown)).setScale(BillQtyAndUnitHelper.getPrecision(unit), BillQtyAndUnitHelper.getUnitRoundingMode(unit));
            BigDecimal receiveBaseQtyUp = BigDecimalUtil.getByGrowRate((BigDecimal)baseQty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(BillQtyAndUnitHelper.getPrecision(baseUnit), BillQtyAndUnitHelper.getUnitRoundingMode(baseUnit));
            BigDecimal receiveBaseQtyDown = BigDecimalUtil.getByReduceRate((BigDecimal)baseQty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateDown)).setScale(BillQtyAndUnitHelper.getPrecision(baseUnit), BillQtyAndUnitHelper.getUnitRoundingMode(baseUnit));
            entry.set("receiveqtyup", (Object)receiveQtyUp);
            entry.set("receiveqtydown", (Object)receiveQtyDown);
            entry.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
            entry.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
        } else {
            entry.set("receiveqtyup", (Object)qty);
            entry.set("receiveqtydown", (Object)qty);
            entry.set("receivebaseqtyup", (Object)baseQty);
            entry.set("receivebaseqtydown", (Object)baseQty);
        }
    }

    private static void setDefaultReceiveDay(DynamicObject entry) {
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            log.info("\u7269\u6599\u4e3a\u7a7a");
            return;
        }
        if (entry.getBoolean("iscontrolday")) {
            int receiveDayUp = entry.getInt("receivedayup");
            int receiveDayDown = entry.getInt("receivedaydown");
            if (receiveDayUp == 0) {
                receiveDayUp = material.getInt("receivedayup");
                entry.set("receivedayup", (Object)receiveDayUp);
            }
            if (receiveDayDown == 0) {
                receiveDayDown = material.getInt("receivedaydown");
                entry.set("receivedaydown", (Object)receiveDayDown);
            }
        }
    }

    private static void setDefaultLineType(DynamicObject bill, DynamicObject entry, Map<String, Object> cacheMap) {
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (bizType != null && entry.get("linetype") == null) {
            DynamicObject defLineType;
            String cacheKey = String.valueOf(bizType.getPkValue()) + "linetype";
            if (PurOrderBillHelper.isCached(cacheMap, cacheKey)) {
                defLineType = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                defLineType = BizTypeHelper.getDefaultLineTypeObject((Long)((Long)bizType.getPkValue()));
                cacheMap.put(cacheKey, defLineType);
            }
            entry.set("linetype", (Object)defLineType);
        }
    }

    private static void setDefaultEntryStatus(DynamicObject bill, DynamicObject entry) {
        String billStatus = bill.getString("billstatus");
        String rowCloseStatus = entry.getString("rowclosestatus");
        String rowTerminateStatus = entry.getString("rowterminatestatus");
        if (billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            entry.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            entry.set("rowterminatestatus", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue());
        } else {
            if (StringUtils.isEmpty((CharSequence)rowCloseStatus)) {
                entry.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            }
            if (StringUtils.isEmpty((CharSequence)rowTerminateStatus)) {
                entry.set("rowterminatestatus", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue());
            }
        }
        entry.set("entrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
        DynamicObjectCollection deliverEntrys = entry.getDynamicObjectCollection("purbillentry_deliver");
        for (DynamicObject dEntry : deliverEntrys) {
            dEntry.set("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
        }
    }

    public static void setDefaultQty(DynamicObject entry) {
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject masterMaterial = material.getDynamicObject("masterid");
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        DynamicObject unit = entry.getDynamicObject("unit");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        DynamicObject auxUnit = entry.getDynamicObject("auxunit");
        if (auxUnit == null) {
            entry.set("auxqty", (Object)BigDecimal.ZERO);
        } else {
            BigDecimal auxQty = entry.getBigDecimal("auxqty");
            String unitConvertDir = masterMaterial.getString("unitconvertdir");
            if (BigDecimalUtil.isBlank((BigDecimal)auxQty)) {
                if (kd.scmc.pm.enums.UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || kd.scmc.pm.enums.UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    if (BigDecimalUtil.isBlank((BigDecimal)baseQty) && BigDecimalUtil.isNotBlank((BigDecimal)qty)) {
                        baseQty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                        entry.set("baseqty", (Object)baseQty);
                    }
                    auxQty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                    entry.set("auxqty", (Object)auxQty);
                }
            } else if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isBlank((BigDecimal)baseQty) && UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir)) {
                baseQty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)auxUnit, (BigDecimal)auxQty, (DynamicObject)baseUnit);
                entry.set("baseqty", (Object)baseQty);
            }
        }
        if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)baseQty)) {
            qty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
            entry.set("qty", (Object)qty);
        } else if (BigDecimalUtil.isBlank((BigDecimal)baseQty) && BigDecimalUtil.isNotBlank((BigDecimal)qty)) {
            baseQty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
            entry.set("baseqty", (Object)baseQty);
        }
    }

    private static void setDefaultReceiveInfo(DynamicObject bill, DynamicObject entry, Map<String, Object> cacheMap) {
        Date deliverDate;
        PurOrderBillHelper.setDefaultOwner(bill, entry, cacheMap);
        Date promiseDate = entry.getDate("promisedate");
        if (promiseDate == null) {
            entry.set("promisedate", (Object)new Date());
        }
        if ((deliverDate = entry.getDate("deliverdate")) == null) {
            entry.set("deliverdate", (Object)bill.getDate("biztime"));
        }
        PurOrderBillHelper.setDefaultReceiveQty(entry);
        PurOrderBillHelper.setDefaultReceiveDay(entry);
    }

    private static void setDefaultOwner(DynamicObject bill, DynamicObject entry, Map<String, Object> cacheMap) {
        DynamicObject bizType = bill.getDynamicObject("biztype");
        DynamicObject supplier = bill.getDynamicObject("supplier");
        if (StringUtils.isEmpty((CharSequence)entry.getString("ownertype"))) {
            if (bizType != null && ("130".equals(bizType.getString("number")) || "1301".equals(bizType.getString("number")))) {
                entry.set("ownertype", (Object)"bd_supplier");
            } else {
                entry.set("ownertype", (Object)"bos_org");
            }
        }
        if (entry.get("owner") == null) {
            if (bizType != null && ("130".equals(bizType.getString("number")) || "1301".equals(bizType.getString("number")))) {
                entry.set("owner", (Object)supplier);
            } else {
                DynamicObject entryReqOrg = (DynamicObject)entry.get("entryreqorg");
                DynamicObject entryRecOrg = (DynamicObject)entry.get("entryrecorg");
                if (entryReqOrg != null && entryRecOrg != null && entryReqOrg.getPkValue() != null && entryRecOrg.getPkValue() != null) {
                    Long entryReqOrgId = (Long)entryReqOrg.getPkValue();
                    Long entryRecOrgId = (Long)entryRecOrg.getPkValue();
                    String ownerCacheKey = entryReqOrgId + "&" + entryRecOrgId + "&owner";
                    if (PurOrderBillHelper.isCached(cacheMap, ownerCacheKey)) {
                        entry.set("owner", cacheMap.get(ownerCacheKey));
                        return;
                    }
                    Long ownerId = OwnerHelper.getDefaultOwner((Long)entryReqOrgId, (Long)entryRecOrgId);
                    if (ownerId == null) {
                        cacheMap.put(ownerCacheKey, null);
                    } else {
                        DynamicObject owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bos_org");
                        cacheMap.put(ownerCacheKey, owner);
                        entry.set("owner", (Object)owner);
                    }
                }
            }
        }
    }

    @Deprecated
    public static List<DynamicObject> batchSetPurOrderDefValue(List<DynamicObject> bills) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        HashMap<String, DynamicObject> bizSettleOrg4PurMap = new HashMap<String, DynamicObject>();
        HashMap<String, Object> payOrgDefault4PurMap = new HashMap<String, Object>();
        HashMap<String, Long> bizSettleOrgMap = new HashMap<String, Long>();
        HashMap<String, DynamicObject> bizOwnerMap = new HashMap<String, DynamicObject>();
        AmountPropertyKey amountPropertyKey = AmountPropertyKey.getInstance();
        if (bills == null || bills.size() == 0) {
            return null;
        }
        for (DynamicObject bill : bills) {
            DynamicObject billType;
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) {
                log.info("\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a");
                continue;
            }
            Long orgId = (Long)org.getPkValue();
            DynamicObject operator = bill.getDynamicObject("operator");
            DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
            if (operator == null || operatorGroup == null) {
                PurOrderBillHelper.initOperatorGroup(orgId, operator, operatorGroup, bill);
            }
            if ((billType = bill.getDynamicObject("billtype")) == null) {
                log.info("\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a");
                continue;
            }
            DynamicObject bizType = bill.getDynamicObject("biztype");
            if (bizType == null) {
                bizType = PurOrderBillHelper.getDefaultBizType(billType);
                bill.set("biztype", (Object)bizType);
            }
            DynamicObject settleOrg = PurOrderBillHelper.initSettleOrg(orgId, bill, bizSettleOrg4PurMap);
            DynamicObject payOrg = PurOrderBillHelper.getPayOrgDefault(settleOrg, payOrgDefault4PurMap);
            DynamicObject supplier = bill.getDynamicObject("supplier");
            SupplierHelper.setDefaultSupplier(bill);
            DynamicObject currency = bill.getDynamicObject("currency");
            DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
            DynamicObject exRateTable = bill.getDynamicObject("exratetable");
            BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
            Date exRateTime = bill.getDate("exratedate");
            String exchangeType = bill.getString("exchangetype");
            if (currency == null) {
                currency = CurrencyHelper.getCurrency(orgId);
                bill.set("currency", (Object)currency);
            }
            if (settleCurrency == null) {
                settleCurrency = currency;
                bill.set("settlecurrency", (Object)currency);
            }
            if (exRateTable == null) {
                exRateTable = PurOrderBillHelper.getExRateTable(orgId);
                bill.set("exratetable", (Object)exRateTable);
            }
            if (currency != null && exRateTable != null) {
                BigDecimal exRate = null;
                if (StringUtils.isEmpty((CharSequence)exchangeType)) {
                    Map<String, Object> exRateMap = CurrencyHelper.getExRateMap((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exRateTable.getPkValue(), exRateTime);
                    exRate = (BigDecimal)exRateMap.get("exchangerate");
                    exchangeType = (String)exRateMap.get("exchangetype");
                    bill.set("exchangetype", (Object)exchangeType);
                }
                if (BigDecimalUtil.isBlank((BigDecimal)exchangeRate)) {
                    exchangeRate = exRate != null ? exRate : CurrencyHelper.getExRate((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exRateTable.getPkValue(), exRateTime, exchangeType);
                    bill.set("exchangerate", (Object)exchangeRate);
                }
            }
            boolean isTax = bill.getBoolean("istax");
            BigDecimal totalAmount = BigDecimalUtil.ZERO;
            BigDecimal totalTaxAmount = BigDecimalUtil.ZERO;
            BigDecimal totalAmountAndTax = BigDecimalUtil.ZERO;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
            DynamicObject defLineType = null;
            for (int i = 0; i < entries.size(); ++i) {
                Map<String, BigDecimal> entryAmountMap;
                DynamicObject entry = (DynamicObject)entries.get(i);
                if (bizType != null && entry.get("linetype") == null) {
                    Long lineTypeId;
                    if (defLineType == null && (lineTypeId = BizTypeHelper.getDefaultLineType((Long)((Long)bizType.getPkValue()))) != null) {
                        defLineType = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype");
                    }
                    if (defLineType != null) {
                        entry.set("linetype", defLineType);
                    }
                }
                if (entry.get("entrysettleorg") == null) {
                    entry.set("entrysettleorg", (Object)settleOrg);
                }
                if (entry.get("entrypayorg") == null) {
                    entry.set("entrypayorg", (Object)payOrg);
                }
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject masterMaterial = entry.getDynamicObject("materialmasterid");
                if (masterMaterial == null && material != null && (masterMaterial = material.getDynamicObject("masterid")) != null) {
                    entry.set("materialmasterid", (Object)masterMaterial);
                }
                PurOrderBillHelper.initOwner(orgId, bizType, supplier, entry, bizSettleOrgMap, bizOwnerMap);
                PurOrderBillHelper.initQty(entry);
                PurOrderBillHelper.initMaterialControlDay(entry);
                BigDecimal amount = entry.getBigDecimal("amount");
                BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                BigDecimal taxAmount = entry.getBigDecimal("taxamount");
                BigDecimal qty = entry.getBigDecimal("qty");
                if ((BigDecimalUtil.isBlank((BigDecimal)amount) || BigDecimalUtil.isBlank((BigDecimal)amountAndTax)) && BigDecimalUtil.isNotBlank((BigDecimal)qty) && !(entryAmountMap = AmountHelper.calcAmount(bill, amountPropertyKey, i)).isEmpty()) {
                    amount = entryAmountMap.get(amountPropertyKey.getAmount());
                    taxAmount = entryAmountMap.get(amountPropertyKey.getTaxAmount());
                    amountAndTax = entryAmountMap.get(amountPropertyKey.getAmountAndTax());
                }
                if (amount != null) {
                    totalAmount = totalAmount.add(amount);
                }
                if (taxAmount != null) {
                    totalTaxAmount = totalTaxAmount.add(taxAmount);
                }
                if (amountAndTax != null) {
                    totalAmountAndTax = totalAmountAndTax.add(amountAndTax);
                }
                BigDecimal curAmountAndTax = entry.getBigDecimal("curamountandtax");
                BigDecimal curAmount = entry.getBigDecimal("curamount");
                BigDecimal curTaxAmount = entry.getBigDecimal("curtaxamount");
                if (BigDecimalUtil.isZero((BigDecimal)exchangeRate) || !BigDecimalUtil.isBlank((BigDecimal)curAmountAndTax) && !BigDecimalUtil.isBlank((BigDecimal)curAmount) && !BigDecimalUtil.isBlank((BigDecimal)curTaxAmount)) continue;
                int currencyAmtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
                boolean indirectRate = ExchangeTypeEnum.isIndirectRate((Object)exchangeType);
                curTaxAmount = AmountHelper.convertByExRate(taxAmount, exchangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                if (isTax) {
                    curAmountAndTax = AmountHelper.convertByExRate(amountAndTax, exchangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                    curAmount = curAmountAndTax.subtract(curTaxAmount);
                } else {
                    curAmount = AmountHelper.convertByExRate(amount, exchangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                    curAmountAndTax = curAmount.add(curTaxAmount);
                }
                entry.set("curamountandtax", (Object)curAmountAndTax);
                entry.set("curamount", (Object)curAmount);
                entry.set("curtaxamount", (Object)curTaxAmount);
            }
            bill.set("totalamount", (Object)totalAmount);
            bill.set("totaltaxamount", (Object)totalTaxAmount);
            bill.set("totalallamount", (Object)totalAmountAndTax);
            AmountPlanHelper.changeAmountConditionForDynamicObject((CommonContext)PurOrderBillHelper.getPayPlanCommonText("pm_purorderbill"), (DynamicObject)bill);
            DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("purbillentry_pay");
            for (DynamicObject entry : payEntrys) {
                Boolean isPreRec = entry.getBoolean("isprepay");
                if (isPreRec != null && !isPreRec.booleanValue()) {
                    entry.set("pretimepoint", (Object)"");
                    continue;
                }
                String pretimepoint = entry.getString("pretimepoint");
                if (!kd.bos.util.StringUtils.isEmpty((String)pretimepoint)) continue;
                entry.set("pretimepoint", (Object)"B");
            }
            result.add(bill);
        }
        return result;
    }

    private static void initOperatorGroup(Long orgId, DynamicObject operator, DynamicObject operatorGroup, DynamicObject bill) {
        long userId = UserServiceHelper.getCurrentUserId();
        if (0L == userId) {
            return;
        }
        Map operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)orgId, (Long)userId, (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
        if (operatorAndGroup.isEmpty()) {
            return;
        }
        if (operator == null) {
            bill.set("operator", operatorAndGroup.get("operator"));
        }
        if (operatorGroup == null) {
            bill.set("operatorgroup", operatorAndGroup.get("operatorgroup"));
        }
    }

    private static void initQty(DynamicObject entry) {
        boolean isControlQty;
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            log.info("\u7269\u6599\u4e3a\u7a7a");
            return;
        }
        DynamicObject master = material.getDynamicObject("masterid");
        if (master == null) {
            log.info("\u4e3b\u7269\u6599\u4e3a\u7a7a");
            return;
        }
        DynamicObject unit = entry.getDynamicObject("unit");
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isBlank((BigDecimal)baseQty)) {
            log.info("\u6570\u91cf\u90fd\u6ca1\u503c");
            return;
        }
        if (baseUnit == null) {
            baseUnit = master.getDynamicObject("baseunit");
            entry.set("baseunit", (Object)baseUnit);
        }
        if (unit == null) {
            unit = material.getDynamicObject("purchaseunit");
            entry.set("unit", (Object)unit);
        }
        if (unit == null || baseUnit == null) {
            log.info("\u5355\u4f4d\u6ca1\u503c");
            return;
        }
        if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)baseQty)) {
            qty = PurOrderBillHelper.getDesQtyConv((Long)master.getPkValue(), baseUnit, baseQty, unit);
            entry.set("qty", (Object)qty);
        } else if (BigDecimalUtil.isBlank((BigDecimal)baseQty) && BigDecimalUtil.isNotBlank((BigDecimal)qty)) {
            baseQty = PurOrderBillHelper.getDesQtyConv((Long)master.getPkValue(), unit, qty, baseUnit);
            entry.set("baseqty", (Object)baseQty);
        }
        BigDecimal receiveqtyup = entry.getBigDecimal("receiveqtyup");
        BigDecimal receiveqtydown = entry.getBigDecimal("receiveqtydown");
        BigDecimal receivebaseqtyup = entry.getBigDecimal("receivebaseqtyup");
        BigDecimal receivebaseqtydown = entry.getBigDecimal("receivebaseqtydown");
        if (BigDecimalUtil.isNotBlank((BigDecimal)receiveqtyup) && BigDecimalUtil.isNotBlank((BigDecimal)receiveqtydown) && BigDecimalUtil.isNotBlank((BigDecimal)receivebaseqtyup) && BigDecimalUtil.isNotBlank((BigDecimal)receivebaseqtydown)) {
            return;
        }
        BigDecimal receiveRateUp = entry.getBigDecimal("receiverateup");
        BigDecimal receiveRateDown = entry.getBigDecimal("receiveratedown");
        boolean iscontrolqty = entry.getBoolean("iscontrolqty");
        if ((BigDecimalUtil.isNotBlank((BigDecimal)receiveRateUp) || BigDecimalUtil.isNotBlank((BigDecimal)receiveRateDown)) && BigDecimalUtil.isNotBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)baseQty)) {
            BigDecimal receiveQtyUp = BigDecimalUtil.getByGrowRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(BillQtyAndUnitHelper.getPrecision(unit), BillQtyAndUnitHelper.getUnitRoundingMode(unit));
            BigDecimal receiveQtyDown = BigDecimalUtil.getByReduceRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateDown)).setScale(BillQtyAndUnitHelper.getPrecision(unit), BillQtyAndUnitHelper.getUnitRoundingMode(unit));
            BigDecimal receiveBaseQtyUp = BigDecimalUtil.getByGrowRate((BigDecimal)baseQty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(BillQtyAndUnitHelper.getPrecision(baseUnit), BillQtyAndUnitHelper.getUnitRoundingMode(baseUnit));
            BigDecimal receiveBaseQtyDown = BigDecimalUtil.getByReduceRate((BigDecimal)baseQty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateDown)).setScale(BillQtyAndUnitHelper.getPrecision(baseUnit), BillQtyAndUnitHelper.getUnitRoundingMode(baseUnit));
            entry.set("receiveqtyup", (Object)receiveQtyUp);
            entry.set("receiveqtydown", (Object)receiveQtyDown);
            entry.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
            entry.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
            return;
        }
        if (!iscontrolqty && BigDecimalUtil.isBlank((BigDecimal)receiveRateUp) && BigDecimalUtil.isBlank((BigDecimal)receiveRateDown) && BigDecimalUtil.isNotBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)baseQty) && (isControlQty = material.getBoolean("iscontrolqty"))) {
            receiveRateUp = material.getBigDecimal("receiverateup");
            receiveRateDown = material.getBigDecimal("receiveratedown");
            if (receiveRateUp != null && receiveRateDown != null) {
                BigDecimal receiveQtyUp = BigDecimalUtil.getByGrowRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(BillQtyAndUnitHelper.getPrecision(unit), BillQtyAndUnitHelper.getUnitRoundingMode(unit));
                BigDecimal receiveQtyDown = BigDecimalUtil.getByReduceRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateDown)).setScale(BillQtyAndUnitHelper.getPrecision(unit), BillQtyAndUnitHelper.getUnitRoundingMode(unit));
                BigDecimal receiveBaseQtyUp = BigDecimalUtil.getByGrowRate((BigDecimal)baseQty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(BillQtyAndUnitHelper.getPrecision(baseUnit), BillQtyAndUnitHelper.getUnitRoundingMode(baseUnit));
                BigDecimal receiveBaseQtyDown = BigDecimalUtil.getByReduceRate((BigDecimal)baseQty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateDown)).setScale(BillQtyAndUnitHelper.getPrecision(baseUnit), BillQtyAndUnitHelper.getUnitRoundingMode(baseUnit));
                entry.set("iscontrolqty", (Object)Boolean.TRUE);
                entry.set("receiverateup", (Object)receiveRateUp);
                entry.set("receiveratedown", (Object)receiveRateDown);
                entry.set("receiveqtyup", (Object)receiveQtyUp);
                entry.set("receiveqtydown", (Object)receiveQtyDown);
                entry.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
                entry.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
                return;
            }
        }
        entry.set("receiveqtyup", (Object)qty);
        entry.set("receiveqtydown", (Object)qty);
        entry.set("receivebaseqtyup", (Object)baseQty);
        entry.set("receivebaseqtydown", (Object)baseQty);
    }

    private static void initMaterialControlDay(DynamicObject entry) {
        boolean isControlDay;
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            log.info("\u7269\u6599\u4e3a\u7a7a");
            return;
        }
        int receiveDayUp = entry.getInt("receivedayup");
        int receiveDayDown = entry.getInt("receivedaydown");
        if ((receiveDayUp == 0 || receiveDayDown == 0) && (isControlDay = material.getBoolean("iscontrolday"))) {
            receiveDayUp = material.getInt("receivedayup");
            receiveDayDown = material.getInt("receivedaydown");
            entry.set("receivedayup", (Object)receiveDayUp);
            entry.set("receivedaydown", (Object)receiveDayDown);
            entry.set("iscontrolday", (Object)isControlDay);
        }
    }

    private static void initOwner(Long orgId, DynamicObject bizType, DynamicObject supplier, DynamicObject entry, Map<String, Long> bizSettleOrgMap, Map<String, DynamicObject> bizOwnerMap) {
        if (entry.get("owner") == null) {
            if (bizType != null && ("130".equals(bizType.getString("number")) || "1301".equals(bizType.getString("number")))) {
                entry.set("ownertype", (Object)"bd_supplier");
                entry.set("owner", (Object)supplier);
                return;
            }
            entry.set("ownertype", (Object)"bos_org");
            DynamicObject entryReqOrg = (DynamicObject)entry.get("entryreqorg");
            DynamicObject entryRecOrg = (DynamicObject)entry.get("entryrecorg");
            if (entryReqOrg != null && entryRecOrg != null && entryReqOrg.getPkValue() != null && entryRecOrg.getPkValue() != null) {
                Map<String, Object> orgRelation;
                Long entryReqOrgId = (Long)entryReqOrg.getPkValue();
                Long entryRecOrgId = (Long)entryRecOrg.getPkValue();
                String ownerCacheKey = entryReqOrgId + "&" + entryRecOrgId + "&owner";
                Set<String> bizOwnerKeySet = bizOwnerMap.keySet();
                if (bizOwnerKeySet.contains(ownerCacheKey)) {
                    entry.set("owner", (Object)bizOwnerMap.get(ownerCacheKey));
                    return;
                }
                Long ownerId = null;
                String settleCacheKey = entryReqOrgId + "&settleorg4org";
                Long reqSettleId = bizSettleOrgMap.get(settleCacheKey);
                if (reqSettleId == null) {
                    Map<String, Object> reqSettleMap = OrgHelper.getCompanyByOrg(entryReqOrgId, Boolean.FALSE, Boolean.TRUE);
                    if (reqSettleMap != null) {
                        reqSettleId = (Long)reqSettleMap.get("id");
                        if (reqSettleId == null) {
                            bizSettleOrgMap.put(settleCacheKey, 0L);
                        } else {
                            bizSettleOrgMap.put(settleCacheKey, reqSettleId);
                        }
                    } else {
                        bizSettleOrgMap.put(settleCacheKey, 0L);
                    }
                }
                if ((orgRelation = OrgHelper.getOrgRelation(entryRecOrgId, "10", "05", "fromorg")) != null) {
                    List settleOrg4Rec = (List)orgRelation.get("orgId");
                    if (reqSettleId != null && settleOrg4Rec != null && settleOrg4Rec.contains(reqSettleId)) {
                        ownerId = reqSettleId;
                    } else {
                        List detailList = (List)orgRelation.get("data");
                        if (detailList != null) {
                            for (Map detailMap : detailList) {
                                Boolean isDefault = (Boolean)detailMap.get("isDefault");
                                if (isDefault == null || !isDefault.booleanValue()) continue;
                                ownerId = (Long)detailMap.get("orgId");
                                break;
                            }
                        }
                    }
                }
                if (ownerId == null) {
                    bizOwnerMap.put(ownerCacheKey, null);
                } else {
                    DynamicObject owner = BusinessDataServiceHelper.loadSingleFromCache(ownerId, (String)"bos_org");
                    bizOwnerMap.put(ownerCacheKey, owner);
                    entry.set("owner", (Object)owner);
                }
            }
        }
    }

    protected static DynamicObject getDefaultBizType(DynamicObject billType) {
        DynamicObject bizType = null;
        Long bizTypeId = BizTypeHelper.getDefaultBizType((String)"pm_purorderbill", (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter");
        if (bizTypeId != null) {
            bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)bizTypeId, (String)"bd_biztype");
        }
        return bizType;
    }

    private static DynamicObject initSettleOrg(Long orgId, DynamicObject bill, Map<String, DynamicObject> bizSettleOrg4PurMap) {
        DynamicObject settleOrg = bill.getDynamicObject("settleorg");
        if (orgId != null && settleOrg == null) {
            String settleCacheKey = orgId + "&settleorg4pur";
            Set<String> bizSettleOrg4PurKeySet = bizSettleOrg4PurMap.keySet();
            if (bizSettleOrg4PurKeySet.contains(settleCacheKey)) {
                DynamicObject load = bizSettleOrg4PurMap.get(settleCacheKey);
                bill.set("settleorg", (Object)load);
                return load;
            }
            Long settleOrgId = OrgHelper.getOrgForFormDefValue(orgId, PMVIEWTYPE, "10", "toorg");
            if (settleOrgId == null || settleOrgId == 0L) {
                bizSettleOrg4PurMap.put(settleCacheKey, null);
                return null;
            }
            DynamicObject load = BusinessDataServiceHelper.loadSingleFromCache((Object)settleOrgId, (String)"bos_org");
            bizSettleOrg4PurMap.put(settleCacheKey, load);
            bill.set("settleorg", (Object)load);
            return load;
        }
        return settleOrg;
    }

    private static DynamicObject getExRateTable(Long orgId) {
        Map<String, Long> map;
        if (orgId != null && (map = CurrencyHelper.getCurrencyAndExRateTable(orgId)) != null && map.get("exchangeRateTableID") != null) {
            DynamicObject exRateTable = BusinessDataServiceHelper.loadSingleFromCache((Object)map.get("exchangeRateTableID"), (String)"bd_exratetable");
            return exRateTable;
        }
        return null;
    }

    private static BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = BigDecimalUtil.ZERO;
        if (materialId == null || srcUnit == null || desUnit == null || srcQty == null) {
            return BigDecimalUtil.ZERO;
        }
        if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            desQty = srcQty;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null) {
                int numerator = muConv.getInt("numerator");
                int denominator = muConv.getInt("denominator");
                if (denominator != 0) {
                    int unitPrecision = desUnit.getInt("precision");
                    RoundingMode unitPrecisionType = BillQtyAndUnitHelper.getUnitRoundingMode(desUnit);
                    desQty = srcQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), unitPrecision, unitPrecisionType);
                }
            }
        }
        return desQty;
    }

    private static DynamicObject getPayOrgDefault(DynamicObject settleOrg, Map<String, Object> payOrgDefault4PurMap) {
        if (settleOrg == null) {
            return null;
        }
        Object settleOrgID = settleOrg.getPkValue();
        if (settleOrgID == null) {
            return null;
        }
        String settleOrgKey = settleOrgID + "PayOrg";
        if (PurOrderBillHelper.isCached(payOrgDefault4PurMap, settleOrgKey)) {
            return (DynamicObject)payOrgDefault4PurMap.get(settleOrgKey);
        }
        DynamicObject payOrg = kd.mpscmm.msbd.business.helper.OrgHelper.getOrgForFormDefObjValue((Long)((Long)settleOrgID), (String)"10", (String)"08", (String)"toorg");
        if (payOrg == null) {
            payOrgDefault4PurMap.put(settleOrgKey, null);
            return null;
        }
        payOrgDefault4PurMap.put(settleOrgKey, payOrg);
        return payOrg;
    }

    private static boolean isCached(Map<String, Object> map, String key) {
        return map.containsKey(key);
    }

    public static void getPrePayAmountSum(DynamicObject[] srcBills, OperateOption operateOption) {
        if (srcBills != null && srcBills.length > 0) {
            for (DynamicObject srcBill : srcBills) {
                DynamicObjectCollection payBillEntrys = srcBill.getDynamicObjectCollection("purbillentry_pay");
                BigDecimal sum = BigDecimal.ZERO;
                if (payBillEntrys != null && !payBillEntrys.isEmpty()) {
                    for (DynamicObject row : payBillEntrys) {
                        String preTimePoint;
                        String string = preTimePoint = row.getString("pretimepoint") == null ? "" : row.getString("pretimepoint");
                        boolean isPrePay = row.getBoolean("isprepay");
                        if (!isPrePay || !StringUtils.isBlank((CharSequence)preTimePoint) && !"B".equals(preTimePoint)) continue;
                        BigDecimal sumPayamount = row.getBigDecimal("payamount") == null ? BigDecimal.ZERO : row.getBigDecimal("payamount");
                        sum = sum.add(sumPayamount);
                    }
                }
                operateOption.setVariableValue(PurOrderBillHelper.getBillPayMountKey((Long)srcBill.getPkValue()), sum.toString());
            }
        }
    }

    public static void compareAndExcuteEvent(HashSet<Long> srcBillIds, String entityNo, OperateOption operateOption) {
        if (srcBillIds == null || srcBillIds.isEmpty()) {
            return;
        }
        Map<Long, BigDecimal> srcBeforeChangeAmountMap = PurOrderBillHelper.getSrcBeforeChangePrePayAmount(operateOption);
        QFilter isPrePay = new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE);
        QFilter payTime = new QFilter("purbillentry_pay.pretimepoint", "in", (Object)new String[]{"B", " "});
        QFilter idFilter = new QFilter("id", "in", srcBillIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)PurOrderBillHelper.class.getName(), (String)entityNo, (String)"id,isallowoverpay,purbillentry_pay.payamount as payamount", (QFilter[])new QFilter[]{isPrePay, payTime, idFilter}, null);
        DataSet billPayAmountSumDataSet = dataSet.groupBy(new String[]{"id", "isallowoverpay"}).sum("payamount").finish();
        HashMap<Long, BigDecimal> afterChangePayAmountSum = new HashMap<Long, BigDecimal>(10);
        HashSet<Long> isallowoverpayIds = new HashSet<Long>(10);
        for (Row row : billPayAmountSumDataSet) {
            Long id = row.getLong("id");
            Boolean isallowoverpay = row.getBoolean("isallowoverpay");
            if (isallowoverpay != null && isallowoverpay.booleanValue()) {
                isallowoverpayIds.add(id);
            }
            BigDecimal sumPayamount = row.getBigDecimal("payamount") == null ? BigDecimal.ZERO : row.getBigDecimal("payamount");
            afterChangePayAmountSum.put(id, sumPayamount);
        }
        if (!isallowoverpayIds.isEmpty()) {
            for (Long id : isallowoverpayIds) {
                srcBeforeChangeAmountMap.remove(id);
                afterChangePayAmountSum.remove(id);
            }
            if (srcBeforeChangeAmountMap.isEmpty() && afterChangePayAmountSum.isEmpty()) {
                return;
            }
        }
        HashSet<Long> prePayChangedSrcBillIds = new HashSet<Long>(10);
        prePayChangedSrcBillIds.addAll(PurOrderBillHelper.getPrePayChanged(srcBeforeChangeAmountMap, afterChangePayAmountSum));
        prePayChangedSrcBillIds.addAll(PurOrderBillHelper.getPrePayChanged(afterChangePayAmountSum, srcBeforeChangeAmountMap));
        if (prePayChangedSrcBillIds.isEmpty()) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("entityno", entityNo);
        param.put("billids", SerializationUtils.toJsonString(prePayChangedSrcBillIds));
        EventServiceHelper.triggerEventSubscribe((String)"PrePayAmountChangeEvent", (String)SerializationUtils.toJsonString(param));
    }

    private static HashSet<Long> getPrePayChanged(Map<Long, BigDecimal> srcBeforeChangeAmountMap, Map<Long, BigDecimal> afterChangePayAmountSum) {
        HashSet<Long> result = new HashSet<Long>(10);
        for (Map.Entry<Long, BigDecimal> entry : srcBeforeChangeAmountMap.entrySet()) {
            BigDecimal afterAmount;
            BigDecimal srcBeforeAmount;
            Long srcBillId = entry.getKey();
            BigDecimal bigDecimal = srcBeforeAmount = entry.getValue() == null ? BigDecimal.ZERO : entry.getValue();
            if (srcBillId == null || srcBeforeAmount.compareTo(afterAmount = afterChangePayAmountSum.get(srcBillId) == null ? BigDecimal.ZERO : afterChangePayAmountSum.get(srcBillId)) == 0) continue;
            result.add(srcBillId);
        }
        return result;
    }

    private static Map<Long, BigDecimal> getSrcBeforeChangePrePayAmount(OperateOption operateOption) {
        Map variables = operateOption.getVariables();
        HashMap<Long, BigDecimal> srcBillIdAndAmount = new HashMap<Long, BigDecimal>(10);
        if (variables == null || variables.isEmpty()) {
            return srcBillIdAndAmount;
        }
        for (Map.Entry entry : variables.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null || key.indexOf("sumprepayamount") == -1) continue;
            srcBillIdAndAmount.put(Long.parseLong(key.substring(0, key.indexOf("sumprepayamount"))), new BigDecimal((String)entry.getValue()));
        }
        return srcBillIdAndAmount;
    }

    public static String getBillPayMountKey(Long billId) {
        return billId + "sumprepayamount";
    }
}

