/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class QuotaHelper {
    public static Map<String, Long> queryQuotaAssignFromDB(HashSet<Long> purOrgIds, HashSet<Long> materialIds) {
        HashMap<String, Long> uniqueKeyAndPkMap = new HashMap<String, Long>();
        QFilter filter = new QFilter("org", "in", purOrgIds);
        filter.and(new QFilter("material", "in", materialIds));
        DynamicObjectCollection quotaAssigns = QueryServiceHelper.query((String)"pm_quotaassign", (String)"material,org,id", (QFilter[])new QFilter[]{filter}, (String)"org");
        for (DynamicObject quotaAssign : quotaAssigns) {
            Long material = quotaAssign.getLong("material");
            Long org = quotaAssign.getLong("org");
            Long id = quotaAssign.getLong("id");
            uniqueKeyAndPkMap.put(QuotaHelper.getUniqueKey(org, material), id);
        }
        return uniqueKeyAndPkMap;
    }

    public static String getUniqueKey(Long purOrgId, Long materialId) {
        purOrgId = purOrgId == null ? Long.valueOf(0L) : purOrgId;
        materialId = materialId == null ? Long.valueOf(0L) : materialId;
        return purOrgId + "_" + materialId;
    }

    public static String getUniqueKey(DynamicObject purOrg, DynamicObject material) {
        Long purOrgId = purOrg == null ? Long.valueOf(0L) : (Long)purOrg.getPkValue();
        Long materialId = material == null ? Long.valueOf(0L) : (Long)material.getPkValue();
        return QuotaHelper.getUniqueKey(purOrgId, materialId);
    }

    public static String queryQuotaParam() throws Exception {
        try {
            DBRoute scmRoute = new DBRoute("scm");
            SqlBuilder quotaParamSql = new SqlBuilder();
            quotaParamSql.append("select fquotapattern from t_pm_quotapattern ", new Object[0]);
            DataSet paramRows = DB.queryDataSet((String)"quotaparam", (DBRoute)scmRoute, (SqlBuilder)quotaParamSql);
            String quotaPattern = "";
            for (Row row : paramRows) {
                quotaPattern = row.getString("fquotapattern");
            }
            return quotaPattern;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

