/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class ReqSumSchemeHelper {
    public static boolean judgeReqToReqBotpRule() {
        List ruleElements = ConvertMetaServiceHelper.loadRules((String)"pm_requirapplybill", (String)"pm_requirapplybill");
        if (ruleElements == null || ruleElements.isEmpty()) {
            return false;
        }
        int size = ruleElements.size();
        for (int i = 0; i < size; ++i) {
            ConvertRuleElement ruleElement = (ConvertRuleElement)ruleElements.get(i);
            if (!ruleElement.isEnabled() || !ruleElement.isVisibled()) continue;
            return true;
        }
        return false;
    }

    public static String[] convertStrToArray(String str) {
        String[] strArray = null;
        if (str != null && !"".equals(str)) {
            strArray = str.split(",");
        }
        return strArray;
    }

    public static Long getDefaultReqSumScheme() {
        Long defaultID = ReqSumSchemeHelper.getDefaultRequireSumScheme();
        if (defaultID == null) {
            defaultID = 0L;
        }
        return defaultID;
    }

    public static Long getDefaultRequireSumScheme() {
        Long defaultID = null;
        QFilter q1 = new QFilter("enable", "=", (Object)"1");
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"pm_reqsumscheme", (String)"id,isdefault,enable", (QFilter[])new QFilter[]{q1});
        if (loadFromCache != null && !loadFromCache.isEmpty()) {
            int i = 0;
            for (DynamicObject dyn : loadFromCache.values()) {
                boolean isDefault = dyn.getBoolean("isdefault");
                if (isDefault) {
                    defaultID = (Long)dyn.getPkValue();
                    return defaultID;
                }
                if (i == 0) {
                    defaultID = (Long)dyn.getPkValue();
                }
                ++i;
            }
        }
        return defaultID;
    }

    public static List<Long> getReqSumPathList(Long org) {
        QFilter qFilter = new QFilter("org", "=", (Object)org);
        qFilter.and("enable", "=", (Object)"1");
        ArrayList<Long> bizListColl = new ArrayList<Long>(16);
        try (DataSet bizList = QueryServiceHelper.queryDataSet((String)"ReqSumSchemeHelper", (String)"pm_reqpathsettings", (String)"id", (QFilter[])qFilter.toArray(), null);){
            for (Row row : bizList) {
                bizListColl.add(row.getLong("id"));
            }
        }
        return bizListColl;
    }

    public static List<Long> getPurReqEntryIdList(Set<Long> reqIdList) {
        QFilter filter = new QFilter("id", "in", reqIdList);
        ArrayList<Long> bizListColl = new ArrayList<Long>(16);
        try (DataSet bizList = QueryServiceHelper.queryDataSet((String)"ReqSumSchemeHelper", (String)"pm_requirapplybill", (String)"id,billentry.id", (QFilter[])filter.toArray(), null);){
            for (Row row : bizList) {
                bizListColl.add(row.getLong("billentry.id"));
            }
        }
        return bizListColl;
    }

    public static Map<Long, Long> getPurReqEntryIdMap(Set<Long> reqIdList) {
        QFilter filter = new QFilter("id", "in", reqIdList);
        HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(16);
        try (DataSet bizList = QueryServiceHelper.queryDataSet((String)"ReqSumSchemeHelper", (String)"pm_requirapplybill", (String)"id,billentry.id", (QFilter[])filter.toArray(), null);){
            for (Row row : bizList) {
                sourceIdMap.put(row.getLong("billentry.id"), row.getLong("id"));
            }
        }
        return sourceIdMap;
    }

    public static Set<Long> getReqSumOrgSet(Long org, Long reqPath) {
        QFilter qFilter = new QFilter("org", "=", (Object)org);
        qFilter.and("id", "=", (Object)reqPath);
        return ReqSumSchemeHelper.getReqSumOrgSet(qFilter, org);
    }

    private static Set<Long> getReqSumOrgSet(QFilter qFilter, Long org) {
        String entryField = "entryentity".concat(".").concat("bdorg");
        HashSet<Long> bizListColl = new HashSet<Long>(16);
        try (DataSet bizList = QueryServiceHelper.queryDataSet((String)"ReqSumSchemeHelper", (String)"pm_reqpathsettings", (String)entryField, (QFilter[])qFilter.toArray(), null);){
            for (Row row : bizList) {
                bizListColl.add(row.getLong(entryField));
            }
        }
        bizListColl.add(org);
        return bizListColl;
    }
}

