/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.LastUpdateBillHelper;
import kd.scmc.pm.enums.SourceListTypeEnum;

public class SourceListHelper {
    private static final Log log = LogFactory.getLog(SourceListHelper.class);

    public static List<DynamicObject> completeBillInfo(List<DynamicObject> bills, Map<String, Object> param) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        if (bills == null || bills.size() == 0) {
            return null;
        }
        for (DynamicObject bill : bills) {
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject currentUserDO = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
            if (org == null) continue;
            if (CommonUtils.isNull((Object)bill.getString("status"))) {
                bill.set("status", (Object)"A");
            }
            if (CommonUtils.isNull((Object)bill.getString("enable"))) {
                bill.set("enable", (Object)"1");
            }
            if (bill.getString("status").equals("A") || bill.getString("status").equals("B")) {
                bill.set("auditor", null);
                bill.set("audittime", null);
                bill.set("disabler", null);
                bill.set("disabledate", null);
                bill.set("enable", (Object)"1");
                bill.set("disabler", null);
                bill.set("disabledate", null);
            }
            if (bill.getString("status").equals("C")) {
                if (bill.get("auditor") == null) {
                    bill.set("auditor", (Object)currentUserDO);
                }
                if (bill.get("audittime") == null) {
                    bill.set("audittime", (Object)TimeServiceHelper.now());
                }
                if (bill.getString("enable").equals("1")) {
                    bill.set("disabler", null);
                    bill.set("disabledate", null);
                }
                if (bill.getString("enable").equals("0")) {
                    if (bill.get("disabler") == null) {
                        bill.set("disabler", (Object)currentUserDO);
                    }
                    if (bill.get("disabledate") == null) {
                        bill.set("disabledate", (Object)TimeServiceHelper.now());
                    }
                }
            }
            if (bill.get("lastupdateuser") == null) {
                bill.set("lastupdateuser", (Object)currentUserDO);
            }
            if (bill.get("lastupdatetime") == null) {
                bill.set("lastupdatetime", (Object)LastUpdateBillHelper.getCurrentDate());
            }
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn : dynamicObjectCollection) {
                if (CommonUtils.isNull((Object)dyn.getString("type"))) {
                    dyn.set("type", (Object)"A");
                }
                if (!dyn.getBoolean("isvmi")) {
                    dyn.set("isvmi", (Object)Boolean.FALSE);
                }
                if (CommonUtils.isNull((Object)dyn.getDate("expirydate"))) {
                    Date expirydate = SourceListHelper.convertStrToDate("2099-12-31");
                    dyn.set("expirydate", (Object)expirydate);
                }
                dyn.set("billcontrol", (Object)"A");
                if (CommonUtils.isNull((Object)"srctype")) {
                    dyn.set("srctype", (Object)"A");
                }
                if (SourceListTypeEnum.MATERIAL.getValue().equals(dyn.getString("type"))) {
                    DynamicObject master;
                    DynamicObject material = dyn.getDynamicObject("material");
                    if (material == null) continue;
                    if (dyn.getDynamicObject("purchaseunit") == null) {
                        dyn.set("purchaseunit", (Object)material.getDynamicObject("purchaseunit"));
                    }
                    if ((master = material.getDynamicObject("masterid")) == null) continue;
                    DynamicObject purchaseUint = material.getDynamicObject("purchaseunit");
                    dyn.set("purchaseunit", (Object)purchaseUint);
                    dyn.set("baseunit", (Object)master.getDynamicObject("baseunit"));
                    dyn.set("materialmasterid", (Object)master);
                    DynamicObject purchaseunit = dyn.getDynamicObject("purchaseunit");
                    DynamicObject baseUnit = dyn.getDynamicObject("baseunit");
                    BigDecimal maxbillqty = dyn.getBigDecimal("maxbillqty");
                    BigDecimal minbillqty = dyn.getBigDecimal("minbillqty");
                    dyn.set("maxbillbaseqty", (Object)SourceListHelper.calcBaseQty(master, purchaseunit, baseUnit, maxbillqty));
                    dyn.set("minbillbaseqty", (Object)SourceListHelper.calcBaseQty(master, purchaseunit, baseUnit, minbillqty));
                    String packqtykey = param.get("packqtykey") == null ? "packingqty" : (String)param.get("packqtykey");
                    BigDecimal packQtyKeyQty = dyn.getBigDecimal(packqtykey);
                    if (packqtykey.equals("packingqty")) {
                        long packQtyLong = 0L;
                        packQtyLong = packQtyKeyQty.compareTo(BigDecimal.ZERO) > 0 && packQtyKeyQty.compareTo(BigDecimal.ONE) < 0 ? 1L : packQtyKeyQty.setScale(0, RoundingMode.DOWN).longValue();
                        dyn.set("packagebatchqty", (Object)packQtyLong);
                    } else {
                        dyn.set("packingqty", (Object)packQtyKeyQty);
                    }
                    dyn.set("packingbaseqty", (Object)SourceListHelper.calcBaseQty(master, purchaseunit, baseUnit, packQtyKeyQty));
                }
                if (SourceListTypeEnum.MATERIALGROUP.getValue().equals(dyn.getString("type"))) {
                    dyn.set("packagebatchqty", (Object)BigDecimal.ZERO);
                    dyn.set("packingqty", (Object)BigDecimal.ZERO);
                    dyn.set("packingbaseqty", (Object)BigDecimal.ZERO);
                }
                result.add(dyn);
            }
        }
        return result;
    }

    private static BigDecimal calcBaseQty(DynamicObject master, DynamicObject unit, DynamicObject baseUnit, BigDecimal qty) {
        return BillQtyAndUnitHelper.getDesQtyConv((Long)master.getPkValue(), unit, qty, baseUnit);
    }

    private static Date convertStrToDate(String bizDate) {
        SimpleDateFormat simpleFomate = new SimpleDateFormat("yyyy-MM-dd");
        Date bizTime = null;
        try {
            bizTime = simpleFomate.parse(bizDate);
        }
        catch (ParseException e) {
            String msg = e.getMessage();
            log.error("\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38\uff01\uff01\uff01" + msg);
        }
        return bizTime;
    }
}

