/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.InvoiceBiztypeHelper;
import kd.mpscmm.msbd.common.utils.MetadataUtils;
import kd.scmc.pm.enums.SupplierFunction;

public class SupplierHelper {
    public static final String BIZ_FUNCTION_KEY = "bizfunction";
    public static final String PURCHASE_HOLD = "purchasehold";
    public static final String INVOICE_HOLD = "invoicehold";
    public static final String PAY_HOLD = "payhold";
    public static final String DELIVER_SUPPLIER_KEY = "deliversupplierid";
    public static final String INVOICE_SUPPLIER_KEY = "invoicesupplierid";
    public static final String RECEIVING_SUPPLIER_KEY = "receivingsupplierid";
    public static final String SETTLE_CURRENCY_KEY = "settlementcyid";

    public static String getDefaultAddressString(DynamicObject supplier) {
        ILocaleString defaultAddress = SupplierHelper.getDefaultAddressLocaleString(supplier);
        if (defaultAddress != null) {
            return defaultAddress.toString();
        }
        return null;
    }

    public static ILocaleString getDefaultAddressLocaleString(DynamicObject supplier) {
        return SupplierHelper.getDetailAddress(SupplierHelper.getDefaultAddressObj(supplier));
    }

    public static Long getDefaultAddressId(DynamicObject supplier) {
        DynamicObject defaultAddress = SupplierHelper.getDefaultAddress(supplier, "id,default,invalid");
        if (defaultAddress == null) {
            return null;
        }
        return defaultAddress.getLong("id");
    }

    public static DynamicObject getDefaultAddress(DynamicObject supplier, String selectProperties) {
        QFilter invalid;
        QFilter supplierId;
        DynamicObject[] load;
        if (supplier != null && StringUtils.isNotBlank((Object)supplier.getPkValue()) && (load = BusinessDataServiceHelper.load((String)"bd_address", (String)selectProperties, (QFilter[])new QFilter[]{supplierId = new QFilter("supplierid", "=", (Object)supplier.getPkValue().toString()), invalid = new QFilter("invalid", "=", (Object)Boolean.FALSE)}, (String)"default desc", (int)1)) != null && load.length > 0) {
            return load[0];
        }
        return null;
    }

    public static DynamicObject getDefaultAddressObj(DynamicObject supplier) {
        return SupplierHelper.getDefaultAddress(supplier, "id,default,invalid,detailaddress");
    }

    public static DynamicObject getDefaultLinkManObj(DynamicObject supplier) {
        Long defaultLinkManId = SupplierHelper.getDefaultLinkManId(supplier);
        if (defaultLinkManId == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)defaultLinkManId, (String)"bd_supplierlinkman");
    }

    public static Long getDefaultLinkManId(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        Long defaultLinkManId = null;
        DynamicObjectCollection linkmans = supplier.getDynamicObjectCollection("entry_linkman");
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                return (Long)linkman.getPkValue();
            }
            if (defaultLinkManId != null || invalid) continue;
            defaultLinkManId = (Long)linkman.getPkValue();
        }
        return defaultLinkManId;
    }

    public static Long getDefaultSettleTypeId(DynamicObject supplier) {
        DynamicObject settleType = SupplierHelper.getDefaultSettleTypeObj(supplier);
        if (settleType == null) {
            return null;
        }
        return (Long)settleType.getPkValue();
    }

    public static DynamicObject getDefaultSettleTypeObj(DynamicObject supplier) {
        DynamicObject settleType;
        if (supplier != null && (settleType = supplier.getDynamicObject("settlementtypeid")) != null) {
            return settleType;
        }
        QFilter isDefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isEnable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isDefault.and(isEnable);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"id,isdefault,enable", (QFilter[])filter.toArray());
    }

    public static DynamicObject getDefaultSettleCurrency(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.getDynamicObject(SETTLE_CURRENCY_KEY);
    }

    private static DynamicObject getDefaultReceiveSupplier(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.getDynamicObject(RECEIVING_SUPPLIER_KEY);
    }

    private static DynamicObject getDefaultInvoiceSupplier(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.getDynamicObject(INVOICE_SUPPLIER_KEY);
    }

    private static DynamicObject getDefaultDeliverSupplier(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        return supplier.getDynamicObject(DELIVER_SUPPLIER_KEY);
    }

    public static ILocaleString getDetailAddress(DynamicObject address) {
        if (address == null) {
            return null;
        }
        return address.getLocaleString("detailaddress");
    }

    public static DynamicObject getOtherSupplier(DynamicObject supplier, String otherSupplierKey) {
        if (otherSupplierKey == null) {
            return null;
        }
        switch (otherSupplierKey) {
            case "deliversupplierid": {
                return SupplierHelper.getDefaultDeliverSupplier(supplier);
            }
            case "invoicesupplierid": {
                return SupplierHelper.getDefaultInvoiceSupplier(supplier);
            }
            case "receivingsupplierid": {
                return SupplierHelper.getDefaultReceiveSupplier(supplier);
            }
        }
        return null;
    }

    public static Long getOtherSupplierId(DynamicObject supplier, String otherSupplierKey) {
        DynamicObject otherSupplier = SupplierHelper.getOtherSupplier(supplier, otherSupplierKey);
        if (otherSupplier != null) {
            return (Long)otherSupplier.getPkValue();
        }
        return null;
    }

    public static QFilter getPurchaseFilter() {
        return QFilter.like((String)BIZ_FUNCTION_KEY, (String)SupplierFunction.PURCHASE.getValue());
    }

    public static QFilter getInvoiceFilter() {
        return QFilter.like((String)BIZ_FUNCTION_KEY, (String)SupplierFunction.INVOICE.getValue());
    }

    public static QFilter getReceiveFilter() {
        return QFilter.like((String)BIZ_FUNCTION_KEY, (String)SupplierFunction.RECEIVE.getValue());
    }

    public static QFilter getDeliverFilter() {
        return QFilter.like((String)BIZ_FUNCTION_KEY, (String)SupplierFunction.DELIVER.getValue());
    }

    public static boolean validBizFunction(DynamicObject supplier, SupplierFunction function) {
        String bizFunction;
        if (supplier == null) {
            return false;
        }
        if (!MetadataUtils.checkProperty((DynamicObject)supplier, (String)BIZ_FUNCTION_KEY)) {
            supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier", (String)"id,bizfunction");
        }
        if ((bizFunction = SupplierHelper.getBizFunction(supplier)) == null) {
            return false;
        }
        return function != null && bizFunction.contains(function.getValue());
    }

    public static boolean isPurchaseHold(DynamicObject supplier) {
        return supplier != null && supplier.getBoolean(PURCHASE_HOLD);
    }

    public static void nullToDefault(DynamicObject dynamicObject, DynamicObject defaultValue, String ... supplierKeys) {
        if (supplierKeys == null) {
            return;
        }
        for (String supplierKey : supplierKeys) {
            if (supplierKey == null || dynamicObject.getDynamicObject(supplierKey) != null) continue;
            dynamicObject.set(supplierKey, (Object)defaultValue);
        }
    }

    private static String getBizFunction(DynamicObject supplier) {
        return supplier.getString(BIZ_FUNCTION_KEY);
    }

    public static String getDefaultAddress(DynamicObject supplier) {
        return SupplierHelper.getDefaultAddressString(supplier);
    }

    public static Long getDefaultLinkMan(DynamicObject supplier) {
        return SupplierHelper.getDefaultLinkManId(supplier);
    }

    public static Long getDefaultSettleType(DynamicObject supplier) {
        return SupplierHelper.getDefaultSettleTypeId(supplier);
    }

    public static Set<Long> getAllLinkMans(DynamicObject supplier) {
        HashSet<Long> ids = new HashSet<Long>(8);
        if (supplier == null) {
            return ids;
        }
        DynamicObjectCollection linkmans = supplier.getDynamicObjectCollection("entry_linkman");
        for (DynamicObject linkman : linkmans) {
            boolean invalid = linkman.getBoolean("invalid");
            if (invalid) continue;
            ids.add((Long)linkman.getPkValue());
        }
        return ids;
    }

    @Deprecated
    public static Long getOtherSupplier(DynamicObject supplier, String otherSupplierKey, String fieldKey) {
        if (supplier == null) {
            return null;
        }
        DynamicObject otherSupplier = supplier.getDynamicObject(otherSupplierKey);
        if (otherSupplier != null) {
            return (Long)otherSupplier.getPkValue();
        }
        String bizfunction = supplier.getString(BIZ_FUNCTION_KEY);
        if (StringUtils.isBlank((CharSequence)bizfunction)) {
            return null;
        }
        switch (otherSupplierKey) {
            case "deliversupplierid": {
                if (!supplier.getBoolean(PURCHASE_HOLD) && bizfunction.contains("1")) break;
                return null;
            }
            case "invoicesupplierid": {
                if (!supplier.getBoolean(INVOICE_HOLD) && bizfunction.contains("2")) break;
                return null;
            }
            case "receivingsupplierid": {
                if (!supplier.getBoolean(PAY_HOLD) && bizfunction.contains("3")) break;
                return null;
            }
        }
        return (Long)supplier.getPkValue();
    }

    public static QFilter getBizfunctionAndHoldFilter(String fieldKey) {
        if (fieldKey.equals("providersupplier") || fieldKey.equals("supplier")) {
            QFilter purchasehold = new QFilter(PURCHASE_HOLD, "=", (Object)Boolean.FALSE);
            QFilter bizfunction = QFilter.like((String)BIZ_FUNCTION_KEY, (String)"1");
            return purchasehold.and(bizfunction);
        }
        if (fieldKey.equals("invoicesupplier")) {
            QFilter invoicehold = new QFilter(INVOICE_HOLD, "=", (Object)Boolean.FALSE);
            QFilter bizfunction = QFilter.like((String)BIZ_FUNCTION_KEY, (String)"2");
            return invoicehold.and(bizfunction);
        }
        if (fieldKey.equals("receivesupplier")) {
            QFilter payhold = new QFilter(PAY_HOLD, "=", (Object)Boolean.FALSE);
            QFilter bizfunction = QFilter.like((String)BIZ_FUNCTION_KEY, (String)"3");
            return payhold.and(bizfunction);
        }
        return null;
    }

    public static DynamicObject getInvoiceType(DynamicObject supplier, String appNmuber) {
        if (supplier != null) {
            Object invoicetype = supplier.get("invoicecategory");
            Long invoicetypeId = 0L;
            if (invoicetype != null) {
                invoicetypeId = (Long)((DynamicObject)invoicetype).getPkValue();
            }
            return InvoiceBiztypeHelper.getInvoiceBizType((Long)invoicetypeId, (String)appNmuber);
        }
        return null;
    }

    protected static void setDefaultSupplier(DynamicObject bill) {
        DynamicObject supplier = bill.getDynamicObject("supplier");
        if (supplier != null) {
            DynamicObject payCond;
            DynamicObject providerSupplier;
            if (bill.getDynamicObject("linkman") == null) {
                bill.set("linkman", (Object)SupplierHelper.getDefaultLinkManObj(supplier));
            }
            if (StringUtils.isBlank((CharSequence)bill.getString("address"))) {
                bill.set("address", (Object)SupplierHelper.getDefaultAddressString(supplier));
            }
            if ((providerSupplier = bill.getDynamicObject("providersupplier")) == null) {
                providerSupplier = SupplierHelper.getOtherSupplierObj(supplier, DELIVER_SUPPLIER_KEY, SupplierFunction.DELIVER);
                bill.set("providersupplier", (Object)providerSupplier);
            }
            if (providerSupplier != null) {
                DynamicObject providerLinkman = bill.getDynamicObject("providerlinkman");
                String providerAddress = bill.getString("provideraddress");
                if (providerLinkman == null || StringUtils.isBlank((CharSequence)providerAddress)) {
                    if (providerLinkman == null) {
                        bill.set("providerlinkman", (Object)SupplierHelper.getDefaultLinkManObj(providerSupplier));
                    }
                    if (StringUtils.isBlank((CharSequence)providerAddress)) {
                        bill.set("provideraddress", (Object)SupplierHelper.getDefaultAddressString(providerSupplier));
                    }
                }
            }
            if (bill.get("invoicesupplier") == null) {
                bill.set("invoicesupplier", (Object)SupplierHelper.getOtherSupplierObj(supplier, INVOICE_SUPPLIER_KEY, SupplierFunction.INVOICE));
            }
            if (bill.get("receivesupplier") == null) {
                bill.set("receivesupplier", (Object)SupplierHelper.getOtherSupplierObj(supplier, RECEIVING_SUPPLIER_KEY, SupplierFunction.RECEIVE));
            }
            if (bill.getDynamicObject("paycondition") == null && (payCond = supplier.getDynamicObject("paycond")) != null && Boolean.TRUE.equals((payCond = BusinessDataServiceHelper.loadSingleFromCache((Object)payCond.getPkValue(), (String)"bd_paycondition", (String)"id,orderbill")).getBoolean("orderbill"))) {
                bill.set("paycondition", (Object)payCond);
            }
            if (bill.getDynamicObject("settletype") == null) {
                bill.set("settletype", (Object)SupplierHelper.getDefaultSettleTypeObj(supplier));
            }
            if (bill.getDynamicObject("settlecurrency") == null) {
                DynamicObject settlementCurrency = supplier.getDynamicObject(SETTLE_CURRENCY_KEY);
                bill.set("settlecurrency", (Object)settlementCurrency);
            }
            if (bill.getDynamicObject("invoicebiztype") == null) {
                bill.set("invoicebiztype", (Object)SupplierHelper.getInvoiceType(supplier, "pm"));
            }
        }
    }

    public static DynamicObject getOtherSupplierObj(DynamicObject supplier, String otherSupplierKey, SupplierFunction function) {
        DynamicObject otherCus = supplier.getDynamicObject(otherSupplierKey);
        if (otherCus != null ? SupplierHelper.validBizFunction(otherCus = BusinessDataServiceHelper.loadSingleFromCache((Object)otherCus.getPkValue(), (String)"bd_supplier", (String)"id,bizfunction,entry_linkman.isdefault_linkman, entry_linkman.invalid"), function) : SupplierHelper.validBizFunction(otherCus, function)) {
            return otherCus;
        }
        return null;
    }

    public static DynamicObject getOtherSupplierObj(DynamicObject supplier, String otherSupplierKey) {
        DynamicObject otherCus = supplier.getDynamicObject(otherSupplierKey);
        if (otherCus != null) {
            otherCus = BusinessDataServiceHelper.loadSingleFromCache((Object)otherCus.getPkValue(), (String)"bd_supplier", (String)"id,bizfunction");
            return otherCus;
        }
        return supplier;
    }
}

