/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.service.customMSvalidation;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.business.pojo.InvokeResult;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotaSchemaInParamDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsInDetailDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsInParamterDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.SourceInDetailDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.SourceInParamterDTO;

public class CustomMSValidationUtils {
    private static final Log log = LogFactory.getLog(CustomMSValidationUtils.class);

    public static InvokeResult checkQuotaCalculate(Object dto) {
        InvokeResult checkoutHeadInfo;
        Object obj;
        SimpleDateFormat simpleFomate = new SimpleDateFormat("yyyy-MM-dd");
        if (dto instanceof QuotamsInParamterDTO) {
            obj = (QuotamsInParamterDTO)dto;
            checkoutHeadInfo = CustomMSValidationUtils.checkoutHeadInfo(((QuotamsInParamterDTO)obj).getPurchaseOrgId(), ((QuotamsInParamterDTO)obj).getBizDate());
            if (!checkoutHeadInfo.isSuccess()) {
                return checkoutHeadInfo;
            }
            List<QuotamsInDetailDTO> billentry = ((QuotamsInParamterDTO)obj).getBillentry();
            if (billentry == null || billentry.size() == 0) {
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u952e\u503c\u4e3a\u201cbillentry\u201d\u7684\u53c2\u6570\u3002", (String)"CustomMSValidationUtils_0", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
            for (QuotamsInDetailDTO quotamsInDetailDTO : billentry) {
                Long materialId = quotamsInDetailDTO.getMaterialId();
                if (materialId == null) {
                    return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_1", (String)"scmc-pm-business", (Object[])new Object[0]));
                }
                Long srcBillEntryId = quotamsInDetailDTO.getSrcBillEntryId();
                if (srcBillEntryId == null) {
                    return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u539f\u5355\u5206\u5f55ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_2", (String)"scmc-pm-business", (Object[])new Object[0]));
                }
                Long srcBillId = quotamsInDetailDTO.getSrcBillId();
                if (srcBillId == null) {
                    return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u539f\u5355ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_3", (String)"scmc-pm-business", (Object[])new Object[0]));
                }
                BigDecimal surplusBaseQty = quotamsInDetailDTO.getSurplusBaseQty();
                if (surplusBaseQty != null) continue;
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5269\u4f59\u6570\u91cf\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_4", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
        }
        if (dto instanceof QuotaSchemaInParamDTO) {
            obj = (QuotaSchemaInParamDTO)dto;
            checkoutHeadInfo = CustomMSValidationUtils.checkoutHeadInfo(((QuotaSchemaInParamDTO)obj).getPurchaseOrgId(), ((QuotaSchemaInParamDTO)obj).getBizDate());
            if (!checkoutHeadInfo.isSuccess()) {
                return checkoutHeadInfo;
            }
            Long materialId = ((QuotaSchemaInParamDTO)obj).getMaterialId();
            if (materialId == null) {
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_1", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
            Long srcBillEntryId = ((QuotaSchemaInParamDTO)obj).getSrcBillEntryId();
            if (srcBillEntryId == null) {
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u539f\u5355\u5206\u5f55ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_2", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
            Long srcBillId = ((QuotaSchemaInParamDTO)obj).getSrcBillId();
            if (srcBillId == null) {
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u539f\u5355ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_3", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
        }
        if (dto instanceof SourceInParamterDTO) {
            obj = (SourceInParamterDTO)dto;
            Long purchaseOrgId = ((SourceInParamterDTO)obj).getPurchaseOrgId();
            if (purchaseOrgId == null) {
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91c7\u8d2d\u7ec4\u7ec7ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_5", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
            Long supplierId = ((SourceInParamterDTO)obj).getSupplierId();
            if (supplierId == null) {
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4f9b\u5e94\u5546ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_6", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
            List<SourceInDetailDTO> billentry = ((SourceInParamterDTO)obj).getBillentry();
            if (billentry == null || billentry.size() == 0) {
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u952e\u503c\u4e3a\u201cbillentry\u201d\u7684\u53c2\u6570\u3002", (String)"CustomMSValidationUtils_0", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
            for (SourceInDetailDTO sourceInDetailDTO : billentry) {
                String bizDate = sourceInDetailDTO.getBizDate();
                if (bizDate == null) {
                    return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e1a\u52a1\u65e5\u671f\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_7", (String)"scmc-pm-business", (Object[])new Object[0]));
                }
                try {
                    simpleFomate.parse(bizDate);
                }
                catch (ParseException e) {
                    log.error(e.getMessage());
                    return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e1a\u52a1\u65e5\u671f\u53c2\u6570\uff0c\u683c\u5f0f\u4e3ayyyy-MM-dd\u3002", (String)"CustomMSValidationUtils_8", (String)"scmc-pm-business", (Object[])new Object[0]));
                }
                Long materialId = sourceInDetailDTO.getMaterialId();
                if (materialId == null) {
                    return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_1", (String)"scmc-pm-business", (Object[])new Object[0]));
                }
                Long srcBillEntryId = sourceInDetailDTO.getSrcBillEntryId();
                if (srcBillEntryId == null) {
                    return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u539f\u5355\u5206\u5f55ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_2", (String)"scmc-pm-business", (Object[])new Object[0]));
                }
                Long srcBillId = sourceInDetailDTO.getSrcBillId();
                if (srcBillId != null) continue;
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u539f\u5355ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_3", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
        }
        return InvokeResult.success();
    }

    public static InvokeResult checkSourceSupplier(Object dto) {
        if (dto instanceof SourceInParamterDTO) {
            SourceInParamterDTO obj = (SourceInParamterDTO)dto;
            Long purchaseOrgId = obj.getPurchaseOrgId();
            if (purchaseOrgId == null) {
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91c7\u8d2d\u7ec4\u7ec7ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_5", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
            String bizDate = obj.getBizDate();
            if (bizDate == null || "".equals(bizDate)) {
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e1a\u52a1\u65e5\u671f\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_7", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
            List<Long> materialIds = obj.getMaterialIds();
            if (materialIds == null || materialIds.size() == 0) {
                return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_1", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
        }
        return InvokeResult.success();
    }

    private static InvokeResult checkoutHeadInfo(Long purchaseOrgId, String bizDate) {
        SimpleDateFormat simpleFomate = new SimpleDateFormat("yyyy-MM-dd");
        if (purchaseOrgId == null) {
            return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91c7\u8d2d\u7ec4\u7ec7ID\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_5", (String)"scmc-pm-business", (Object[])new Object[0]));
        }
        if (bizDate == null) {
            return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e1a\u52a1\u65e5\u671f\u53c2\u6570\u201d\u3002", (String)"CustomMSValidationUtils_7", (String)"scmc-pm-business", (Object[])new Object[0]));
        }
        try {
            simpleFomate.parse(bizDate);
        }
        catch (ParseException e) {
            log.error(e.getMessage());
            return InvokeResult.failure(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e1a\u52a1\u65e5\u671f\u53c2\u6570\uff0c\u683c\u5f0f\u4e3ayyyy-MM-dd\u3002", (String)"CustomMSValidationUtils_8", (String)"scmc-pm-business", (Object[])new Object[0]));
        }
        return InvokeResult.success();
    }
}

