/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.service.quotamodel.quotacalculateservice;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.business.pojo.InvokeResult;
import kd.scmc.pm.business.service.quotamodel.QuotaExtPlugin;
import kd.scmc.pm.business.service.quotamodel.QuotaStrategyImpl;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateResultDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsInDetailDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsInParamterDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsOutParamterDTO;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.StatusEnum;

public abstract class QuotaCalculateService {
    private static final Log log = LogFactory.getLog(QuotaCalculateService.class);
    private static final String BD_MEASUREUNITS = "bd_measureunits";
    private static final String BD_MEASUREUNITS_ID = "id";
    private static final String BD_MATERIALPURCHASEINFO_MASTERID = "masterid";
    private static final int zero = 0;
    private static final int CONTAINER_SIZE = 16;
    private static final int QUOTA_NUM = 100000;
    private static final String BDMATERIAL_MASTERID = "material.masterid.id";

    public QuotaCalculateDTO queryQuotaCalculateRawdata(List<Long> applyBillEntryId, Object orgId, Date bizTime, IFormView view) throws KDBizException {
        QFilter qFilter = new QFilter("billentry.id", "in", applyBillEntryId);
        ArrayList selectlistFields = new ArrayList(16);
        Collections.addAll(selectlistFields, BD_MEASUREUNITS_ID, "billno", "org", "billentry.id", "billentry.seq");
        Collections.addAll(selectlistFields, "billentry.material", "billentry.qty", "billentry.joinqty", "billentry.unit", "billentry.baseqty", "billentry.joinbaseqty", "billentry.reqdate", "billentry.baseunit", "billentry.auxqty", "billentry.auxunit");
        String selectFields = selectlistFields.stream().collect(Collectors.joining(","));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pm_purapplybill", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"billentry.reqdate asc");
        HashSet<Long> unitColl = new HashSet<Long>(rows.size());
        for (DynamicObject row : rows) {
            Long unitId = row.getLong("billentry.unit");
            Long baseUnitId = row.getLong("billentry.baseunit");
            Long auxUnitId = row.getLong("billentry.auxunit");
            unitColl.add(unitId);
            unitColl.add(baseUnitId);
            if (auxUnitId == null || auxUnitId == 0L) continue;
            unitColl.add(auxUnitId);
        }
        QFilter qFilter1 = new QFilter(BD_MEASUREUNITS_ID, "in", unitColl);
        Map units = BusinessDataServiceHelper.loadFromCache((String)BD_MEASUREUNITS, (QFilter[])new QFilter[]{qFilter1});
        HashSet<Long> set = new HashSet<Long>(rows.size());
        for (DynamicObject line : rows) {
            Long materialId = line.getLong("billentry.material");
            set.add(materialId);
        }
        QFilter qFilter5 = new QFilter(BD_MEASUREUNITS_ID, "in", set);
        DynamicObjectCollection materialbill = QueryServiceHelper.query((String)"bd_materialpurchaseinfo", (String)"id,masterid", (QFilter[])new QFilter[]{qFilter5});
        HashSet<Long> materialset = new HashSet<Long>(16);
        HashMap<Long, Long> materialmap = new HashMap<Long, Long>(16);
        for (DynamicObject line : materialbill) {
            Long bdmaterialId = line.getLong(BD_MEASUREUNITS_ID);
            Long materialId = line.getLong(BD_MATERIALPURCHASEINFO_MASTERID);
            materialset.add(materialId);
            materialmap.put(bdmaterialId, materialId);
        }
        QFilter qFilter2 = new QFilter("org", "=", orgId);
        qFilter2.and(BDMATERIAL_MASTERID, "in", materialset);
        DynamicObject[] quotaAssignColl = this.getExtQuotaAssign(view, materialset);
        if (quotaAssignColl == null) {
            quotaAssignColl = BusinessDataServiceHelper.load((String)"pm_quotaassign", (String)this.getquotaAssinFields(), (QFilter[])new QFilter[]{qFilter2});
        }
        QuotaCalculateDTO acceptQuotaCalculateRawdata = QuotaCalculateDTO.acceptQuotaCalculateRawdata(rows, units, quotaAssignColl, bizTime, materialmap);
        return acceptQuotaCalculateRawdata;
    }

    private DynamicObject[] getExtQuotaAssign(IFormView view, Set<Long> materialset) {
        DynamicObject[] extQuotaAssings = new DynamicObject[]{};
        QuotaExtPlugin extPlugin = this.getExtPluginInstance();
        if (extPlugin == null) {
            return null;
        }
        Map<String, Object> extQuotaInfo = extPlugin.getOtherQueryQuotaInfo(view);
        if (extQuotaInfo == null) {
            return null;
        }
        QFilter extQuotaFilter = (QFilter)extQuotaInfo.get("quotafilter");
        if (extQuotaFilter == null) {
            return null;
        }
        Set<Object> extMaterials = (HashSet)extQuotaInfo.get("materials");
        if (extMaterials == null || extMaterials.isEmpty()) {
            extMaterials = materialset;
        }
        DataSet queryQuotaDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_quota", (String)"id as quotaid", (QFilter[])new QFilter[]{extQuotaFilter}, null);
        QFilter materialFilter = new QFilter(BDMATERIAL_MASTERID, "in", (Object)extMaterials);
        DataSet queryQuotaAssignDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_quotaassign", (String)"id as quotaassignid,quota as quotaid", (QFilter[])new QFilter[]{materialFilter}, null);
        DataSet assingidDataSet = queryQuotaDataSet.join(queryQuotaAssignDataSet, JoinType.INNER).on("quotaid", "quotaid").select(new String[0], new String[]{"quotaassignid"}).finish();
        HashSet assignIdSet = new HashSet(extMaterials.size());
        assingidDataSet.forEach(row -> assignIdSet.add(row.getLong("quotaassignid")));
        if (assignIdSet.isEmpty()) {
            return extQuotaAssings;
        }
        extQuotaAssings = BusinessDataServiceHelper.load((String)"pm_quotaassign", (String)this.getquotaAssinFields(), (QFilter[])new QFilter[]{new QFilter(BD_MEASUREUNITS_ID, "in", assignIdSet)});
        return extQuotaAssings;
    }

    protected QuotaExtPlugin getExtPluginInstance() {
        QuotaExtPlugin plugin = null;
        DynamicObject pluginObj = QueryServiceHelper.queryOne((String)"pm_quotaplugin", (String)"pluginname", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        if (pluginObj != null) {
            String pluginname = pluginObj.getString("pluginname");
            try {
                Class<?> aClass = Class.forName(pluginname);
                Object expPlugin = aClass.newInstance();
                if (expPlugin instanceof QuotaExtPlugin) {
                    plugin = (QuotaExtPlugin)expPlugin;
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return plugin;
    }

    public QuotaCalculateDTO quotaCalculateService(QuotaCalculateDTO quotaCalculateRawdata) throws KDBizException {
        Date bizTime = quotaCalculateRawdata.getBizTime();
        DynamicObjectCollection purApplyBillColl = quotaCalculateRawdata.getPurApplyBillColl();
        Map<Object, DynamicObject> units = quotaCalculateRawdata.getUnits();
        DynamicObject[] quotaAssignColl = quotaCalculateRawdata.getQuotaAssignColl();
        QuotaCalculateService invokeQuotaServiceFixed = QuotaStrategyImpl.invokeQuotaServiceImpl("A");
        QuotaCalculateService invokeQuotaServiceSuperme = QuotaStrategyImpl.invokeQuotaServiceImpl("B");
        QuotaCalculateService invokeQuotaServiceDynamic = QuotaStrategyImpl.invokeQuotaServiceImpl("C");
        HashMap<Long, DynamicObject> quotaAssignPack = new HashMap<Long, DynamicObject>(quotaAssignColl.length);
        for (DynamicObject quotaAssign : quotaAssignColl) {
            DynamicObject material = quotaAssign.getDynamicObject("material");
            DynamicObject masterid = material.getDynamicObject(BD_MATERIALPURCHASEINFO_MASTERID);
            Long materialmasterid = (Long)masterid.getPkValue();
            quotaAssignPack.put(materialmasterid, quotaAssign);
        }
        QuotaCalculateDTO quotaCalculateDTO = null;
        ArrayList<QuotaCalculateResultDTO> calculateResult = new ArrayList<QuotaCalculateResultDTO>(16);
        Map<Long, Long> materialmap = quotaCalculateRawdata.getMaterialmap();
        HashMap<Long, Map<Long, BigDecimal>> currentBatchQuotaQty = new HashMap<Long, Map<Long, BigDecimal>>(10);
        for (Object purApplyEntry : purApplyBillColl) {
            Long bdmaterialId = purApplyEntry.getLong("billentry.material");
            Long materialId = materialmap.get(bdmaterialId);
            DynamicObject quotaAssign = (DynamicObject)quotaAssignPack.get(materialId);
            if (quotaAssign == null) continue;
            DynamicObject quotaSchema = quotaAssign.getDynamicObject("quota");
            String quotaType = quotaSchema.getString("quotatype");
            QuotaCalculateDTO acceptQuotaCalculateSingle = QuotaCalculateDTO.acceptQuotaCalculateSingle((DynamicObject)purApplyEntry, quotaAssign, units, bizTime);
            if (quotaType == null || "".equals(quotaType)) {
                log.error("\u914d\u989d\u65b9\u6848\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u60a8\u90a3\u8fb9\u8fdb\u884c\u6838\u5b9e\u64cd\u4f5c");
                quotaCalculateDTO = QuotaCalculateDTO.invokeFailure();
                return quotaCalculateDTO;
            }
            List<QuotaCalculateResultDTO> quotaCalculateResultDTOS = null;
            if ("A".equals(quotaType)) {
                quotaCalculateResultDTOS = invokeQuotaServiceFixed.quotaCalculateServiceImpl(acceptQuotaCalculateSingle);
                calculateResult.addAll(quotaCalculateResultDTOS);
            }
            if ("B".equals(quotaType)) {
                quotaCalculateResultDTOS = invokeQuotaServiceSuperme.quotaCalculateServiceImpl(acceptQuotaCalculateSingle);
                calculateResult.addAll(quotaCalculateResultDTOS);
            }
            if ("C".equals(quotaType)) {
                Map oneMaterialCurrentAllotQty = (Map)currentBatchQuotaQty.get(materialId);
                if (oneMaterialCurrentAllotQty != null) {
                    acceptQuotaCalculateSingle.setCurrentBatchQuotaQty(oneMaterialCurrentAllotQty);
                }
                quotaCalculateResultDTOS = invokeQuotaServiceDynamic.quotaCalculateServiceImpl(acceptQuotaCalculateSingle);
                calculateResult.addAll(quotaCalculateResultDTOS);
            }
            currentBatchQuotaQty = this.rebuildCurrentBatchQuotaQty(currentBatchQuotaQty, materialId, quotaCalculateResultDTOS);
        }
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        for (DynamicObject row : purApplyBillColl) {
            Long billId = row.getLong(BD_MEASUREUNITS_ID);
            Long entryId = row.getLong("billentry".concat(".").concat(BD_MEASUREUNITS_ID));
            Long materialId = row.getLong("billentry.material");
            block3: for (DynamicObject quotaData : quotaAssignColl) {
                DynamicObject material = quotaData.getDynamicObject("material");
                if (!materialId.equals(material.getPkValue())) continue;
                DynamicObject quota = quotaData.getDynamicObject("quota");
                DynamicObjectCollection entries = quota.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    if (bizTime.before(entry.getDate("effectdate")) || bizTime.after(entry.getDate("expirydate"))) continue;
                    map.put(entryId, billId);
                    continue block3;
                }
            }
        }
        HashSet<Long> set = new HashSet<Long>(map.size());
        for (Long billId : map.values()) {
            set.add(billId);
        }
        quotaCalculateDTO = QuotaCalculateDTO.acceptQuotaCalculateResult(calculateResult, set.size(), map.size(), calculateResult.size());
        return quotaCalculateDTO;
    }

    private HashMap<Long, Map<Long, BigDecimal>> rebuildCurrentBatchQuotaQty(HashMap<Long, Map<Long, BigDecimal>> currentBatchQuotaQty, Long materialId, List<QuotaCalculateResultDTO> quotaCalculateResultDTOS) {
        if (quotaCalculateResultDTOS == null) {
            return currentBatchQuotaQty;
        }
        if (currentBatchQuotaQty == null) {
            currentBatchQuotaQty = new HashMap(10);
        }
        for (QuotaCalculateResultDTO result : quotaCalculateResultDTOS) {
            BigDecimal baseqty = result.getBaseqty();
            DynamicObject supplier = result.getSupplier();
            DynamicObject material = result.getMaterial();
            if (baseqty == null || baseqty.compareTo(BigDecimal.ZERO) == 0 || supplier == null || material == null) continue;
            Map<Long, BigDecimal> currentSupplierAndQtyMap = currentBatchQuotaQty.get(materialId);
            if (currentSupplierAndQtyMap == null) {
                currentSupplierAndQtyMap = new HashMap<Long, BigDecimal>(5);
                currentSupplierAndQtyMap.put((Long)supplier.getPkValue(), baseqty);
            } else {
                BigDecimal batchAllotQty = currentSupplierAndQtyMap.get(supplier.getPkValue()) == null ? BigDecimal.ZERO : currentSupplierAndQtyMap.get(supplier.getPkValue());
                batchAllotQty = batchAllotQty.add(baseqty);
                currentSupplierAndQtyMap.put((Long)supplier.getPkValue(), batchAllotQty);
            }
            currentBatchQuotaQty.put(materialId, currentSupplierAndQtyMap);
        }
        return currentBatchQuotaQty;
    }

    private String getquotaAssinFields() {
        ArrayList selectQuotaAssignFields = new ArrayList(16);
        Collections.addAll(selectQuotaAssignFields, "org", "quota", "material");
        String selectField = selectQuotaAssignFields.stream().collect(Collectors.joining(","));
        return selectField;
    }

    public String validateQuotas(Set<Long> purApplyBillid, DynamicObject purOrg) throws KDBizException {
        DynamicObject[] materialNums;
        QFilter qFilter1 = new QFilter("billentry".concat(".").concat(BD_MEASUREUNITS_ID), "in", purApplyBillid);
        ArrayList selectlistFields = new ArrayList();
        Collections.addAll(selectlistFields, BD_MEASUREUNITS_ID, "billentry.id", "billentry.seq", "billentry.material");
        String selectFields = selectlistFields.stream().collect(Collectors.joining(","));
        DynamicObjectCollection billColl = QueryServiceHelper.query((String)"pm_purapplybill", (String)selectFields, (QFilter[])new QFilter[]{qFilter1});
        LinkedHashSet<Long> set = new LinkedHashSet<Long>(16);
        for (DynamicObject line : billColl) {
            Long materialId = line.getLong("billentry.material");
            set.add(materialId);
        }
        QFilter qFilter5 = new QFilter(BD_MEASUREUNITS_ID, "in", set);
        DynamicObjectCollection materialbill = QueryServiceHelper.query((String)"bd_materialpurchaseinfo", (String)"id,masterid", (QFilter[])new QFilter[]{qFilter5});
        LinkedHashSet<Long> materialset = new LinkedHashSet<Long>(16);
        HashMap<Long, Long> materialmap = new HashMap<Long, Long>(16);
        for (DynamicObject line : materialbill) {
            Long bdmaterialId = line.getLong(BD_MEASUREUNITS_ID);
            Long materialId = line.getLong(BD_MATERIALPURCHASEINFO_MASTERID);
            materialset.add(materialId);
            materialmap.put(bdmaterialId, materialId);
        }
        Long orgId = (Long)purOrg.getPkValue();
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(BDMATERIAL_MASTERID, "in", materialset);
        DynamicObject[] quotaAssignColl = BusinessDataServiceHelper.load((String)"pm_quotaassign", (String)this.getquotaAssinFields(), (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> materialNumMap = new HashMap<String, String>(billColl.size());
        HashMap<String, String> QuotaMap = new HashMap<String, String>(quotaAssignColl.length);
        LocalDateTime todayStart = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        Date date = Date.from(todayStart.atZone(ZoneId.systemDefault()).toInstant());
        HashSet<Long> materialSet = new HashSet<Long>();
        for (DynamicObject row : billColl) {
            boolean isAssign = false;
            Long materialIdTemp = row.getLong("billentry.material");
            Long materialId = (Long)materialmap.get(materialIdTemp);
            for (DynamicObject quotaAssign : quotaAssignColl) {
                if (!materialId.equals(quotaAssign.getLong(BDMATERIAL_MASTERID))) continue;
                isAssign = true;
                DynamicObject quota = quotaAssign.getDynamicObject("quota");
                String number = quota.getString("number");
                if (!quota.get("status").equals(StatusEnum.AUDIT.getValue())) {
                    QuotaMap.put(number, ResManager.loadKDString((String)"\u672a\u5ba1\u6838", (String)"QuotaCalculateService_0", (String)"scmc-pm-business", (Object[])new Object[0]));
                    continue;
                }
                if (quota.get("enable").equals(EnableStatusEnum.DISABLE.getValue())) {
                    QuotaMap.put(number, ResManager.loadKDString((String)"\u5df2\u7981\u7528", (String)"QuotaCalculateService_1", (String)"scmc-pm-business", (Object[])new Object[0]));
                    continue;
                }
                boolean isInvalid = false;
                DynamicObjectCollection entries = quota.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    if (date.before(entry.getDate("effectdate")) || date.after(entry.getDate("expirydate"))) continue;
                    isInvalid = true;
                }
                if (isInvalid) continue;
                QuotaMap.put(number, ResManager.loadKDString((String)"\u5df2\u8fc7\u671f", (String)"QuotaCalculateService_2", (String)"scmc-pm-business", (Object[])new Object[0]));
            }
            if (isAssign) continue;
            materialSet.add(materialId);
        }
        QFilter qFilter2 = new QFilter(BD_MATERIALPURCHASEINFO_MASTERID, "in", materialSet);
        for (DynamicObject materialNum : materialNums = BusinessDataServiceHelper.load((String)"bd_materialpurchaseinfo", (String)BD_MATERIALPURCHASEINFO_MASTERID, (QFilter[])new QFilter[]{qFilter2})) {
            String number = materialNum.getDynamicObject(BD_MATERIALPURCHASEINFO_MASTERID).getString("number");
            materialNumMap.put(number, ResManager.loadKDString((String)"\u6240\u9009\u7269\u6599\u672a\u8fdb\u884c\u914d\u989d\u5206\u914d\u3002", (String)"QuotaCalculateService_3", (String)"scmc-pm-business", (Object[])new Object[0]));
        }
        StringBuilder ErrMsg = new StringBuilder();
        if (materialNumMap != null && materialNumMap.size() > 0) {
            materialNumMap.forEach((k, v) -> ErrMsg.append(ResManager.loadKDString((String)"\u7269\u6599\uff1a", (String)"QuotaCalculateService_4", (String)"scmc-pm-business", (Object[])new Object[0])).append((String)k).append((String)v).append('\n'));
        }
        if (QuotaMap != null && QuotaMap.size() > 0) {
            QuotaMap.forEach((k, v) -> ErrMsg.append(ResManager.loadKDString((String)"\u914d\u989d\u65b9\u6848\uff1a", (String)"QuotaCalculateService_5", (String)"scmc-pm-business", (Object[])new Object[0])).append((String)k).append((String)v).append('\n'));
        }
        return ErrMsg.toString();
    }

    public InvokeResult invokeQuotaCalculateMSService(QuotamsInParamterDTO dto) throws KDBizException {
        String number;
        HashSet<String> tipset;
        Long orgId = dto.getPurchaseOrgId();
        String bizDateTemp = dto.getBizDate();
        LocalDate bizDate = LocalDate.parse(bizDateTemp);
        List<QuotamsInDetailDTO> billdto = dto.getBillentry();
        if (billdto.size() > 100000) {
            return InvokeResult.failure(String.format(ResManager.loadKDString((String)"\u6570\u636e\u91cf\u4e0d\u80fd\u5927\u4e8e %d\uff0c\u8bf7\u7f29\u5c0f\u6570\u636e\u8303\u56f4\u3002", (String)"QuotaCalculateService_6", (String)"scmc-pm-business", (Object[])new Object[0]), 100000));
        }
        HashSet materialSet = new HashSet(billdto.size());
        billdto.forEach(paradto -> materialSet.add(paradto.getMaterialId()));
        log.info("pm_\u63a5\u53d7\u53c2\u6570\u7ec4\u7ec7ID" + orgId);
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(BDMATERIAL_MASTERID, "in", materialSet);
        DynamicObject[] quotaAssignColl = BusinessDataServiceHelper.load((String)"pm_quotaassign", (String)this.getquotaAssinFields(), (QFilter[])new QFilter[]{qFilter});
        log.info("\u6839\u636epm_\u53c2\u6570\u7ec4\u7ec7ID:" + orgId + ";pm_\u4e3b\u6570\u636e\u7269\u6599ID:" + materialSet + ";\u67e5\u8be2\u83b7\u53d6\u5230\u7684\u914d\u989d\u5206\u914d\u65b9\u6848\u5982\u4e0b:" + SerializationUtils.toJsonString((Object)quotaAssignColl));
        HashMap<Long, DynamicObject> quotaAssignPack = new HashMap<Long, DynamicObject>(quotaAssignColl.length);
        for (DynamicObject quotaAssign : quotaAssignColl) {
            DynamicObject material = quotaAssign.getDynamicObject("material");
            DynamicObject[] masterid = material.getDynamicObject(BD_MATERIALPURCHASEINFO_MASTERID);
            Long materialmasterid = (Long)masterid.getPkValue();
            quotaAssignPack.put(materialmasterid, quotaAssign);
        }
        HashSet surplusMaterialId = new HashSet(materialSet.size());
        surplusMaterialId.addAll(materialSet);
        quotaAssignPack.forEach((materialid, value) -> surplusMaterialId.remove(materialid));
        QFilter materialFilter = new QFilter(BD_MEASUREUNITS_ID, "in", materialSet);
        DynamicObject[] bdMaterialRow = BusinessDataServiceHelper.load((String)"bd_material", (String)"number,name,baseunit", (QFilter[])new QFilter[]{materialFilter});
        HashMap<Long, DynamicObject> baseUnitPack = new HashMap<Long, DynamicObject>(bdMaterialRow.length);
        HashMap<Long, String> materialname = new HashMap<Long, String>(bdMaterialRow.length);
        for (DynamicObject bdMaterial : bdMaterialRow) {
            Long materialId = (Long)bdMaterial.getPkValue();
            DynamicObject baseUnit = bdMaterial.getDynamicObject("baseunit");
            String string = bdMaterial.getString("number");
            baseUnitPack.put(materialId, baseUnit);
            materialname.put(materialId, string);
        }
        QuotaCalculateService invokeQuotaServiceFixed = QuotaStrategyImpl.invokeQuotaServiceImpl("A");
        QuotaCalculateService invokeQuotaServiceSuperme = QuotaStrategyImpl.invokeQuotaServiceImpl("B");
        QuotaCalculateService invokeQuotaServiceDynamic = QuotaStrategyImpl.invokeQuotaServiceImpl("C");
        ArrayList<QuotamsOutParamterDTO> quotaOutParamter = new ArrayList<QuotamsOutParamterDTO>(16);
        HashSet<String> invalidQuotaSchemaNumber = new HashSet<String>();
        for (QuotamsInDetailDTO quotamsInDetailDTO : billdto) {
            List<QuotamsOutParamterDTO> quotaCalculateMServiceImpl;
            Long materialId = quotamsInDetailDTO.getMaterialId();
            DynamicObject quotaAssign = (DynamicObject)quotaAssignPack.get(materialId);
            DynamicObject baseUnit = (DynamicObject)baseUnitPack.get(materialId);
            if (quotaAssign == null) continue;
            DynamicObject quotaSchema = quotaAssign.getDynamicObject("quota");
            String quotaType = quotaSchema.getString("quotatype");
            if (quotaType == null || "".equals(quotaType)) {
                String errormsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%d\u201d\u7684\u914d\u989d\u65b9\u6848\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u914d\u989d\u670d\u52a1\u8ba1\u7b97\u3002", (String)"QuotaCalculateService_7", (String)"scmc-pm-business", (Object[])new Object[0]), materialId);
                log.error(errormsg);
                return InvokeResult.failure(errormsg);
            }
            QuotaCalculateDTO invokeQuotaMSCalculate = QuotaCalculateDTO.invokeQuotaMSCalculate(orgId, quotamsInDetailDTO, quotaAssign, bizDate, baseUnit);
            if ("A".equals(quotaType)) {
                quotaCalculateMServiceImpl = invokeQuotaServiceFixed.quotaCalculateMServiceImpl(invokeQuotaMSCalculate);
                if (quotaCalculateMServiceImpl.size() == 0) {
                    invalidQuotaSchemaNumber.add(quotaSchema.getString("number"));
                } else {
                    quotaOutParamter.addAll(quotaCalculateMServiceImpl);
                }
            }
            if ("B".equals(quotaType)) {
                quotaCalculateMServiceImpl = invokeQuotaServiceSuperme.quotaCalculateMServiceImpl(invokeQuotaMSCalculate);
                if (quotaCalculateMServiceImpl.size() == 0) {
                    invalidQuotaSchemaNumber.add(quotaSchema.getString("number"));
                } else {
                    quotaOutParamter.addAll(quotaCalculateMServiceImpl);
                }
            }
            if (!"C".equals(quotaType)) continue;
            quotaCalculateMServiceImpl = invokeQuotaServiceDynamic.quotaCalculateMServiceImpl(invokeQuotaMSCalculate);
            if (quotaCalculateMServiceImpl.size() == 0) {
                invalidQuotaSchemaNumber.add(quotaSchema.getString("number"));
                continue;
            }
            quotaOutParamter.addAll(quotaCalculateMServiceImpl);
        }
        if (surplusMaterialId.size() == materialSet.size()) {
            tipset = new HashSet<String>(16);
            for (Long id : materialSet) {
                number = (String)materialname.get(id);
                tipset.add(number);
            }
            log.info(String.format("All_failure\u7269\u6599\uff1a%s\u4e0d\u5b58\u5728\u914d\u989d\u5206\u914d\uff0c\u65e0\u6cd5\u8fdb\u884c\u914d\u989d\u670d\u52a1\u8ba1\u7b97\u3002", tipset));
            return InvokeResult.failure(String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u4e0d\u5b58\u5728\u914d\u989d\u5206\u914d\uff0c\u65e0\u6cd5\u8fdb\u884c\u914d\u989d\u670d\u52a1\u8ba1\u7b97\u3002", (String)"QuotaCalculateService_8", (String)"scmc-pm-business", (Object[])new Object[0]), tipset));
        }
        if (surplusMaterialId.size() == 0) {
            if (quotaOutParamter.size() <= 0 && invalidQuotaSchemaNumber.size() > 0) {
                return InvokeResult.failure(String.format(ResManager.loadKDString((String)"\u914d\u989d\u65b9\u6848:%s\u5df2\u8fc7\u671f\u3002", (String)"QuotaCalculateService_9", (String)"scmc-pm-business", (Object[])new Object[0]), invalidQuotaSchemaNumber));
            }
            if (invalidQuotaSchemaNumber.size() <= 0 && quotaOutParamter.size() > 0) {
                return InvokeResult.success(quotaOutParamter);
            }
            return InvokeResult.success(quotaOutParamter, String.format(ResManager.loadKDString((String)"\u914d\u989d\u65b9\u6848:%s\u5df2\u8fc7\u671f\u3002", (String)"QuotaCalculateService_9", (String)"scmc-pm-business", (Object[])new Object[0]), invalidQuotaSchemaNumber));
        }
        tipset = new HashSet(16);
        for (Long id : surplusMaterialId) {
            number = (String)materialname.get(id);
            tipset.add(number);
        }
        log.info(String.format("Part_failure\u7269\u6599\uff1a%s\u4e0d\u5b58\u5728\u914d\u989d\u5206\u914d\uff0c\u65e0\u6cd5\u8fdb\u884c\u914d\u989d\u670d\u52a1\u8ba1\u7b97\u3002", tipset));
        String string = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u4e0d\u5b58\u5728\u914d\u989d\u5206\u914d\uff0c\u65e0\u6cd5\u8fdb\u884c\u914d\u989d\u670d\u52a1\u8ba1\u7b97\u3002", (String)"QuotaCalculateService_8", (String)"scmc-pm-business", (Object[])new Object[0]), tipset);
        if (quotaOutParamter.size() <= 0 && invalidQuotaSchemaNumber.size() > 0) {
            return InvokeResult.failure(String.format(ResManager.loadKDString((String)"\u914d\u989d\u65b9\u6848:%s\u5df2\u8fc7\u671f\u3002", (String)"QuotaCalculateService_9", (String)"scmc-pm-business", (Object[])new Object[0]), invalidQuotaSchemaNumber).concat(string));
        }
        if (invalidQuotaSchemaNumber.size() <= 0 && quotaOutParamter.size() > 0) {
            return InvokeResult.success(quotaOutParamter, string);
        }
        return InvokeResult.success(quotaOutParamter, String.format(ResManager.loadKDString((String)"\u914d\u989d\u65b9\u6848:%s\u5df2\u8fc7\u671f\u3002", (String)"QuotaCalculateService_9", (String)"scmc-pm-business", (Object[])new Object[0]), invalidQuotaSchemaNumber).concat(string));
    }

    public abstract List<QuotaCalculateResultDTO> quotaCalculateServiceImpl(QuotaCalculateDTO var1) throws KDBizException;

    public abstract List<QuotamsOutParamterDTO> quotaCalculateMServiceImpl(QuotaCalculateDTO var1) throws KDBizException;
}

