/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.service.quotamodel.quotacalculateserviceimpl;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.QuotaCalculImpHelper;
import kd.scmc.pm.business.service.quotamodel.QuotaExtPlugin;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateResultDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsInDetailDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsOutParamterDTO;
import kd.scmc.pm.business.service.quotamodel.quotacalculateservice.QuotaCalculateService;

public class DynamicQuotaCalculateImpl
extends QuotaCalculateService {
    private static final Log log = LogFactory.getLog(DynamicQuotaCalculateImpl.class);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String BILLNO = "billno";
    private static final int zero = 0;

    @Override
    public List<QuotaCalculateResultDTO> quotaCalculateServiceImpl(QuotaCalculateDTO quotaCalculateRawdata) throws KDBizException {
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355:" + quotaCalculateRawdata.getPurApplyEntry().getString(BILLNO) + ",\u5f00\u59cb\u6309\u7167\u52a8\u6001\u914d\u989d\u8fdb\u884c\u8ba1\u7b97.");
        DynamicObject purApplyEntry = quotaCalculateRawdata.getPurApplyEntry();
        DynamicObject quotaAssign = quotaCalculateRawdata.getQuotaAssign();
        DynamicObject quotaSchema = quotaAssign.getDynamicObject("quota");
        Map<Object, DynamicObject> units = quotaCalculateRawdata.getUnits();
        Date bizTime = quotaCalculateRawdata.getBizTime();
        Long billId = purApplyEntry.getLong("id");
        Long entryId = purApplyEntry.getLong("billentry.id");
        Long orgid = purApplyEntry.getLong("org");
        Long materialId = purApplyEntry.getLong("billentry.material");
        DynamicObject material = quotaAssign.getDynamicObject("material");
        DynamicObject masterid = material.getDynamicObject("masterid");
        Long materialmasterid = (Long)masterid.getPkValue();
        Long unitId = purApplyEntry.getLong("billentry.unit");
        Long baseUnitId = purApplyEntry.getLong("billentry.baseunit");
        Long auxUnitId = purApplyEntry.getLong("billentry.auxunit");
        DynamicObject resultUnit = units.get(unitId);
        DynamicObject baseUnit = units.get(baseUnitId);
        DynamicObject auxUnit = null;
        if (auxUnitId != null && auxUnitId != 0L) {
            auxUnit = units.get(auxUnitId);
        }
        BigDecimal qty = purApplyEntry.getBigDecimal("billentry.qty");
        BigDecimal joinQty = purApplyEntry.getBigDecimal("billentry.joinqty");
        BigDecimal remainQty = qty.subtract(joinQty);
        BigDecimal baseQty = purApplyEntry.getBigDecimal("billentry.baseqty");
        BigDecimal baseJoinQty = purApplyEntry.getBigDecimal("billentry.joinbaseqty");
        BigDecimal baseRemainQty = baseQty.subtract(baseJoinQty);
        BigDecimal auxQty = purApplyEntry.getBigDecimal("billentry.auxqty");
        BigDecimal remainAuxQty = auxQty.multiply(baseRemainQty).divide(baseQty, BillQtyAndUnitHelper.getPrecision(auxUnit), BillQtyAndUnitHelper.getPrecisionType(auxUnit));
        DynamicObjectCollection entries = quotaSchema.getDynamicObjectCollection("entryentity");
        ArrayList<QuotaCalculateResultDTO> calculateResult = new ArrayList<QuotaCalculateResultDTO>(16);
        BigDecimal allBillBaseQty = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> allSupplierAndQtyMap = new HashMap(10);
        QuotaExtPlugin extPluginInstance = this.getExtPluginInstance();
        if (extPluginInstance != null) {
            HashMap<Long, BigDecimal> extSupplierAndQtyMap = extPluginInstance.calculateHistoryPurchaseBillQty(billId, orgid, material, quotaSchema);
            if (extSupplierAndQtyMap != null) {
                allSupplierAndQtyMap = extSupplierAndQtyMap;
            }
        } else {
            allSupplierAndQtyMap = QuotaCalculImpHelper.calculateHistoryPurchaseBillQty(orgid, material, quotaSchema, resultUnit);
        }
        Map<Long, BigDecimal> currentBatchQuotaQty = quotaCalculateRawdata.getCurrentBatchQuotaQty();
        if (currentBatchQuotaQty != null) {
            allSupplierAndQtyMap = this.mergeCurrentAllotQty(allSupplierAndQtyMap, currentBatchQuotaQty);
        }
        if (allSupplierAndQtyMap != null && allSupplierAndQtyMap.size() > 0) {
            for (BigDecimal oneSupQty : allSupplierAndQtyMap.values()) {
                allBillBaseQty = allBillBaseQty.add(oneSupQty);
            }
        }
        for (DynamicObject entry : entries) {
            if (bizTime.before(entry.getDate("effectdate")) || bizTime.after(entry.getDate("expirydate"))) continue;
            DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
            ArrayList<QuotaCalculateDTO> dto = new ArrayList<QuotaCalculateDTO>(subEntries.size());
            for (int i = 0; i < subEntries.size(); ++i) {
                DynamicObject subEntry = (DynamicObject)subEntries.get(i);
                DynamicObject supplier = subEntry.getDynamicObject("supplier");
                int rank = subEntry.getInt("supplyrank");
                BigDecimal targetRate = subEntry.getBigDecimal("quotarate");
                BigDecimal historyRate = ZERO;
                if (ZERO.compareTo(allBillBaseQty) == 0) {
                    historyRate = ZERO;
                } else if (supplier != null && allSupplierAndQtyMap != null && allSupplierAndQtyMap.size() > 0) {
                    Long supplierId = (Long)supplier.getPkValue();
                    BigDecimal supplierQty = allSupplierAndQtyMap.get(supplierId);
                    if (supplierQty == null) {
                        supplierQty = ZERO;
                    }
                    historyRate = supplierQty.divide(allBillBaseQty, 2, 4).multiply(BigDecimal.valueOf(100L));
                }
                BigDecimal surplusRate = targetRate.subtract(historyRate);
                QuotaCalculateDTO acceptDynamicQuota = QuotaCalculateDTO.acceptDynamicQuota(supplier, rank, surplusRate, targetRate);
                dto.add(acceptDynamicQuota);
            }
            List<QuotaCalculateDTO> sortDynamicQuota = QuotaCalculateDTO.sortDynamicQuota(dto);
            for (int i = 0; i < sortDynamicQuota.size() && baseRemainQty.compareTo(ZERO) > 0; ++i) {
                QuotaCalculateDTO quotaCalculateDTO = sortDynamicQuota.get(i);
                DynamicObject supplier = quotaCalculateDTO.getSupplier();
                Long supplierid = (Long)supplier.getPkValue();
                Integer supplyrank = quotaCalculateDTO.getRank();
                BigDecimal targetRate = quotaCalculateDTO.getTargetRate();
                QuotaCalculateDTO sourceDTO = QuotaCalculImpHelper.calculateQuotaQty(supplierid, orgid, materialId, baseRemainQty, baseUnit, materialmasterid);
                BigDecimal quotaBaseQty = sourceDTO.getQuotaBaseQty();
                BigDecimal maxbillqty = sourceDTO.getMaxbillqty();
                BigDecimal minbillqty = sourceDTO.getMinbillqty();
                BigDecimal packagebatchqty = sourceDTO.getPackagebatchqty();
                BigDecimal supplierquotaQty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseUnit, quotaBaseQty, resultUnit);
                maxbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseUnit, maxbillqty, resultUnit);
                minbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseUnit, minbillqty, resultUnit);
                if (remainAuxQty.compareTo(ZERO) > 0) {
                    remainAuxQty = QuotaCalculImpHelper.changeAuxQty(material, auxUnit, resultUnit, supplierquotaQty);
                }
                BigDecimal surplusAuxQty = remainAuxQty;
                QuotaCalculateResultDTO acceptGenerateResult = QuotaCalculateResultDTO.acceptGenerateResult(material, supplier, supplierquotaQty, resultUnit, surplusAuxQty, auxUnit, quotaSchema, targetRate, supplyrank, remainQty, billId, entryId, quotaBaseQty, maxbillqty, minbillqty, packagebatchqty, baseUnit);
                calculateResult.add(acceptGenerateResult);
                remainQty = remainQty.subtract(supplierquotaQty);
                baseRemainQty = baseRemainQty.subtract(quotaBaseQty);
                remainAuxQty = remainAuxQty.subtract(surplusAuxQty);
            }
        }
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355:" + quotaCalculateRawdata.getPurApplyEntry().getString(BILLNO) + ",\u7ed3\u675f\u52a8\u6001\u914d\u989d\u8fdb\u884c\u8ba1\u7b97.");
        return calculateResult;
    }

    private HashMap<Long, BigDecimal> mergeCurrentAllotQty(HashMap<Long, BigDecimal> allSupplierAndQtyMap, Map<Long, BigDecimal> currentBatchQuotaQty) {
        if (allSupplierAndQtyMap == null) {
            return (HashMap)currentBatchQuotaQty;
        }
        if (allSupplierAndQtyMap == null || allSupplierAndQtyMap.isEmpty()) {
            allSupplierAndQtyMap = new HashMap(10);
            allSupplierAndQtyMap.putAll(currentBatchQuotaQty);
        } else {
            for (Map.Entry<Long, BigDecimal> entry : currentBatchQuotaQty.entrySet()) {
                Long supplierID = entry.getKey();
                BigDecimal currentAllotQty = entry.getValue();
                BigDecimal allotQtyDB = allSupplierAndQtyMap.get(supplierID);
                if (allotQtyDB == null) {
                    allSupplierAndQtyMap.put(supplierID, currentAllotQty);
                    continue;
                }
                allSupplierAndQtyMap.put(supplierID, allotQtyDB.add(currentAllotQty));
            }
        }
        return allSupplierAndQtyMap;
    }

    @Override
    public List<QuotamsOutParamterDTO> quotaCalculateMServiceImpl(QuotaCalculateDTO quotaMSCalculate) throws KDBizException {
        DynamicObject quotaAssign = quotaMSCalculate.getQuotaAssign();
        DynamicObject quotaSchema = quotaAssign.getDynamicObject("quota");
        DynamicObject material = quotaAssign.getDynamicObject("material");
        DynamicObject masterid = material.getDynamicObject("masterid");
        Long materialmasterid = (Long)masterid.getPkValue();
        Long quotaId = (Long)quotaSchema.getPkValue();
        String quotaPattern = quotaSchema.getString("quotatype");
        QuotamsInDetailDTO quotaMSTemplate = quotaMSCalculate.getQuotaMSTemplate();
        Long srcBillId = quotaMSTemplate.getSrcBillId();
        Long srcBillEntryId = quotaMSTemplate.getSrcBillEntryId();
        Long materialId = quotaMSTemplate.getMaterialId();
        BigDecimal baseRemainQty = quotaMSTemplate.getSurplusBaseQty();
        LocalDate quotaDate = quotaMSCalculate.getQuotaTime();
        LocalDateTime todaystart = LocalDateTime.of(quotaDate, LocalTime.MIN);
        Date bizDate = Date.from(todaystart.atZone(ZoneId.systemDefault()).toInstant());
        Long orgId = quotaMSCalculate.getOrgId();
        DynamicObject baseUnit = quotaMSCalculate.getBaseUnit();
        Long baseUnitId = (Long)baseUnit.getPkValue();
        DynamicObjectCollection entries = quotaSchema.getDynamicObjectCollection("entryentity");
        ArrayList<QuotamsOutParamterDTO> calculateResult = new ArrayList<QuotamsOutParamterDTO>(16);
        BigDecimal allBillBaseQty = QuotaCalculImpHelper.calculateMSHistoryPurchaseBillQty(orgId, material, quotaSchema, baseUnit, quotaDate);
        for (DynamicObject entry : entries) {
            if (bizDate.before(entry.getDate("effectdate")) || bizDate.after(entry.getDate("expirydate"))) continue;
            DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
            ArrayList<QuotaCalculateDTO> dto = new ArrayList<QuotaCalculateDTO>(subEntries.size());
            for (int i = 0; i < subEntries.size(); ++i) {
                DynamicObject subEntry = (DynamicObject)subEntries.get(i);
                DynamicObject supplier = subEntry.getDynamicObject("supplier");
                int rank = subEntry.getInt("supplyrank");
                BigDecimal targetRate = subEntry.getBigDecimal("quotarate");
                BigDecimal historyRate = null;
                historyRate = ZERO.compareTo(allBillBaseQty) == 0 ? ZERO : QuotaCalculImpHelper.calculateMSHistoryQuotaRate(orgId, material, quotaSchema, supplier, baseUnit, allBillBaseQty, quotaDate);
                BigDecimal surplusRate = targetRate.subtract(historyRate);
                QuotaCalculateDTO acceptDynamicQuota = QuotaCalculateDTO.acceptDynamicQuota(supplier, rank, surplusRate, targetRate);
                dto.add(acceptDynamicQuota);
            }
            List<QuotaCalculateDTO> sortDynamicQuota = QuotaCalculateDTO.sortDynamicQuota(dto);
            for (int i = 0; i < sortDynamicQuota.size() && baseRemainQty.compareTo(ZERO) > 0; ++i) {
                QuotaCalculateDTO quotaCalculateDTO = sortDynamicQuota.get(i);
                DynamicObject supplier = quotaCalculateDTO.getSupplier();
                Long supplierid = (Long)supplier.getPkValue();
                BigDecimal quotaPercentage = quotaCalculateDTO.getTargetRate();
                QuotaCalculateDTO sourceDTO = QuotaCalculImpHelper.calculateMSQuotaQty(supplierid, orgId, materialId, baseRemainQty, baseUnit, bizDate, materialmasterid);
                BigDecimal quotaBaseQty = sourceDTO.getQuotaBaseQty();
                BigDecimal maxbillqty = sourceDTO.getMaxbillqty();
                BigDecimal minbillqty = sourceDTO.getMinbillqty();
                BigDecimal packagebatchqty = sourceDTO.getPackagebatchqty();
                QuotamsOutParamterDTO acceptResult = QuotamsOutParamterDTO.acceptResult(supplierid, orgId, materialId, srcBillId, srcBillEntryId, quotaBaseQty, baseUnitId, baseRemainQty, quotaId, quotaPattern, quotaPercentage, maxbillqty, minbillqty, packagebatchqty);
                calculateResult.add(acceptResult);
                baseRemainQty = baseRemainQty.subtract(quotaBaseQty);
            }
        }
        return calculateResult;
    }
}

