/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.service.quotamodel.quotacalculateserviceimpl;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.QuotaCalculImpHelper;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateResultDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsInDetailDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsOutParamterDTO;
import kd.scmc.pm.business.service.quotamodel.quotacalculateservice.QuotaCalculateService;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class FixedQuotaCalculateImpl
extends QuotaCalculateService {
    private static final Log log = LogFactory.getLog(FixedQuotaCalculateImpl.class);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String BILLNO = "billno";
    private static final String HUNDRED = "100";
    private static final int zero = 0;

    @Override
    public List<QuotaCalculateResultDTO> quotaCalculateServiceImpl(QuotaCalculateDTO quotaCalculateRawdata) throws KDBizException {
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355:" + quotaCalculateRawdata.getPurApplyEntry().getString(BILLNO) + ",\u5f00\u59cb\u6309\u7167\u56fa\u5b9a\u914d\u989d\u8fdb\u884c\u8ba1\u7b97.");
        DynamicObject purApplyEntry = quotaCalculateRawdata.getPurApplyEntry();
        DynamicObject quotaAssign = quotaCalculateRawdata.getQuotaAssign();
        DynamicObject quotaSchema = quotaAssign.getDynamicObject("quota");
        Map<Object, DynamicObject> units = quotaCalculateRawdata.getUnits();
        Date bizTime = quotaCalculateRawdata.getBizTime();
        Long billId = purApplyEntry.getLong("id");
        Long entryId = purApplyEntry.getLong("billentry".concat(".").concat("id"));
        Long orgid = purApplyEntry.getLong("org");
        Long materialId = purApplyEntry.getLong("billentry.material");
        DynamicObject material = quotaAssign.getDynamicObject("material");
        DynamicObject masterid = material.getDynamicObject("masterid");
        Long materialmasterid = (Long)masterid.getPkValue();
        Long unitId = purApplyEntry.getLong("billentry.unit");
        Long baseUnitId = purApplyEntry.getLong("billentry.baseunit");
        Long auxUnitId = purApplyEntry.getLong("billentry.auxunit");
        DynamicObject resultUnit = units.get(unitId);
        DynamicObject baseUnit = units.get(baseUnitId);
        DynamicObject auxUnit = null;
        if (auxUnitId != null && auxUnitId != 0L) {
            auxUnit = units.get(auxUnitId);
        }
        BigDecimal qty = purApplyEntry.getBigDecimal("billentry.qty");
        BigDecimal joinQty = purApplyEntry.getBigDecimal("billentry.joinqty");
        BigDecimal remainQty = qty.subtract(joinQty);
        BigDecimal baseQty = purApplyEntry.getBigDecimal("billentry.baseqty");
        BigDecimal baseJoinQty = purApplyEntry.getBigDecimal("billentry.joinbaseqty");
        BigDecimal baseRemainQty = baseQty.subtract(baseJoinQty);
        BigDecimal auxQty = purApplyEntry.getBigDecimal("billentry.auxqty");
        BigDecimal remainAuxQty = auxQty.multiply(baseRemainQty).divide(baseQty, BillQtyAndUnitHelper.getPrecision(auxUnit), BillQtyAndUnitHelper.getPrecisionType(auxUnit));
        DynamicObjectCollection entries = quotaSchema.getDynamicObjectCollection("entryentity");
        ArrayList<QuotaCalculateResultDTO> calculateResult = new ArrayList<QuotaCalculateResultDTO>(16);
        block0: for (DynamicObject entry : entries) {
            if (bizTime.before(entry.getDate("effectdate")) || bizTime.after(entry.getDate("expirydate"))) continue;
            DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
            BigDecimal auxSumQty = ZERO;
            BigDecimal sumbasequotaQty = ZERO;
            BigDecimal sumquotaQty = ZERO;
            ArrayListValuedHashMap mapSuppierRow = new ArrayListValuedHashMap(subEntries.size());
            for (int i = 0; i < subEntries.size(); ++i) {
                DynamicObject subEntry = (DynamicObject)subEntries.get(i);
                int rank = subEntry.getInt("supplyrank");
                mapSuppierRow.put((Object)rank, (Object)subEntry);
            }
            Map asMap = mapSuppierRow.asMap();
            for (Map.Entry rankRowEntrty : asMap.entrySet()) {
                Collection rowEntrtyTemp = (Collection)rankRowEntrty.getValue();
                List rowEntrty = (List)rowEntrtyTemp;
                baseRemainQty = baseRemainQty.subtract(sumbasequotaQty);
                remainQty = remainQty.subtract(sumquotaQty);
                remainAuxQty = remainAuxQty.subtract(auxSumQty);
                sumbasequotaQty = ZERO;
                sumquotaQty = ZERO;
                auxSumQty = ZERO;
                if (baseRemainQty.compareTo(ZERO) <= 0) continue block0;
                for (int i = 0; i < rowEntrty.size(); ++i) {
                    DynamicObject row = (DynamicObject)rowEntrty.get(i);
                    DynamicObject supplier = row.getDynamicObject("supplier");
                    Long supplierid = (Long)supplier.getPkValue();
                    BigDecimal allotQty = ZERO;
                    BigDecimal allotBaseQty = ZERO;
                    BigDecimal allotAuxQty = ZERO;
                    if (i == rowEntrty.size() - 1) {
                        allotQty = remainQty.subtract(sumquotaQty);
                        allotBaseQty = baseRemainQty.subtract(sumbasequotaQty);
                        allotAuxQty = remainAuxQty.subtract(auxSumQty);
                    } else {
                        allotQty = remainQty.multiply(row.getBigDecimal("quotarate")).divide(new BigDecimal(HUNDRED), BillQtyAndUnitHelper.getPrecision(resultUnit), BillQtyAndUnitHelper.getPrecisionType(resultUnit));
                        allotBaseQty = baseRemainQty.multiply(row.getBigDecimal("quotarate")).divide(new BigDecimal(HUNDRED), BillQtyAndUnitHelper.getPrecision(baseUnit), BillQtyAndUnitHelper.getPrecisionType(baseUnit));
                        allotAuxQty = remainAuxQty.multiply(row.getBigDecimal("quotarate")).divide(new BigDecimal(HUNDRED), BillQtyAndUnitHelper.getPrecision(auxUnit), BillQtyAndUnitHelper.getPrecisionType(auxUnit));
                    }
                    Integer supplyrank = (Integer)row.get("supplyrank");
                    QuotaCalculateDTO sourceDTO = QuotaCalculImpHelper.calculateQuotaQty(supplierid, orgid, materialId, allotBaseQty, baseUnit, materialmasterid);
                    BigDecimal quotaBaseQty = sourceDTO.getQuotaBaseQty();
                    BigDecimal maxbillqty = sourceDTO.getMaxbillqty();
                    BigDecimal minbillqty = sourceDTO.getMinbillqty();
                    BigDecimal packagebatchqty = sourceDTO.getPackagebatchqty();
                    if (quotaBaseQty != null && quotaBaseQty.compareTo(ZERO) <= 0) continue;
                    BigDecimal quotaQty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseUnit, quotaBaseQty, resultUnit);
                    maxbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseUnit, maxbillqty, resultUnit);
                    minbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, baseUnit, minbillqty, resultUnit);
                    BigDecimal quotarate = row.getBigDecimal("quotarate");
                    if (remainAuxQty.compareTo(ZERO) > 0) {
                        allotAuxQty = QuotaCalculImpHelper.changeAuxQty(material, auxUnit, resultUnit, quotaQty);
                    }
                    QuotaCalculateResultDTO acceptGenerateResult = QuotaCalculateResultDTO.acceptGenerateResult(material, supplier, quotaQty, resultUnit, allotAuxQty, auxUnit, quotaSchema, quotarate, supplyrank, allotQty, billId, entryId, quotaBaseQty, maxbillqty, minbillqty, packagebatchqty, baseUnit);
                    calculateResult.add(acceptGenerateResult);
                    if (quotaBaseQty != null) {
                        sumbasequotaQty = sumbasequotaQty.add(quotaBaseQty);
                    }
                    sumquotaQty = sumquotaQty.add(quotaQty);
                    auxSumQty = auxSumQty.add(allotAuxQty);
                }
            }
        }
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355:" + quotaCalculateRawdata.getPurApplyEntry().getString(BILLNO) + ",\u7ed3\u675f\u6309\u7167\u56fa\u5b9a\u914d\u989d\u8fdb\u884c\u8ba1\u7b97.");
        return calculateResult;
    }

    @Override
    public List<QuotamsOutParamterDTO> quotaCalculateMServiceImpl(QuotaCalculateDTO quotaMSCalculate) throws KDBizException {
        DynamicObject quotaAssign = quotaMSCalculate.getQuotaAssign();
        DynamicObject quotaSchema = quotaAssign.getDynamicObject("quota");
        DynamicObject material = quotaAssign.getDynamicObject("material");
        DynamicObject masterid = material.getDynamicObject("masterid");
        Long materialmasterid = (Long)masterid.getPkValue();
        Long quotaId = (Long)quotaSchema.getPkValue();
        String quotaPattern = quotaSchema.getString("quotatype");
        QuotamsInDetailDTO quotaMSTemplate = quotaMSCalculate.getQuotaMSTemplate();
        Long srcBillId = quotaMSTemplate.getSrcBillId();
        Long srcBillEntryId = quotaMSTemplate.getSrcBillEntryId();
        Long materialId = quotaMSTemplate.getMaterialId();
        BigDecimal baseRemainQty = quotaMSTemplate.getSurplusBaseQty();
        LocalDate quotaTime = quotaMSCalculate.getQuotaTime();
        LocalDateTime todaystart = LocalDateTime.of(quotaTime, LocalTime.MIN);
        Date bizTime = Date.from(todaystart.atZone(ZoneId.systemDefault()).toInstant());
        DynamicObjectCollection entries = quotaSchema.getDynamicObjectCollection("entryentity");
        Long orgId = quotaMSCalculate.getOrgId();
        DynamicObject baseUnit = quotaMSCalculate.getBaseUnit();
        Long baseUnitId = (Long)baseUnit.getPkValue();
        ArrayList<QuotamsOutParamterDTO> calculateResult = new ArrayList<QuotamsOutParamterDTO>(16);
        block0: for (DynamicObject entry : entries) {
            if (bizTime.before(entry.getDate("effectdate")) || bizTime.after(entry.getDate("expirydate"))) continue;
            DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
            BigDecimal sumbasequotaQty = ZERO;
            ArrayListValuedHashMap mapSuppierRow = new ArrayListValuedHashMap(subEntries.size());
            for (int i = 0; i < subEntries.size(); ++i) {
                DynamicObject subEntry = (DynamicObject)subEntries.get(i);
                int rank = subEntry.getInt("supplyrank");
                mapSuppierRow.put((Object)rank, (Object)subEntry);
            }
            Map asMap = mapSuppierRow.asMap();
            block2: for (Map.Entry rankRowEntrty : asMap.entrySet()) {
                Collection rowEntrtyTemp = (Collection)rankRowEntrty.getValue();
                List rowEntrty = (List)rowEntrtyTemp;
                baseRemainQty = baseRemainQty.subtract(sumbasequotaQty);
                sumbasequotaQty = ZERO;
                if (baseRemainQty.compareTo(ZERO) <= 0) continue block0;
                for (int i = 0; i < rowEntrty.size(); ++i) {
                    DynamicObject row = (DynamicObject)rowEntrty.get(i);
                    DynamicObject supplier = row.getDynamicObject("supplier");
                    Long supplierid = (Long)supplier.getPkValue();
                    BigDecimal quotaPercentage = row.getBigDecimal("quotarate");
                    BigDecimal allotBaseQty = ZERO;
                    allotBaseQty = i == rowEntrty.size() - 1 ? baseRemainQty.subtract(sumbasequotaQty) : baseRemainQty.multiply(row.getBigDecimal("quotarate")).divide(new BigDecimal(HUNDRED), BillQtyAndUnitHelper.getPrecision(baseUnit), BillQtyAndUnitHelper.getPrecisionType(baseUnit));
                    QuotaCalculateDTO sourceDTO = QuotaCalculImpHelper.calculateMSQuotaQty(supplierid, orgId, materialId, allotBaseQty, baseUnit, bizTime, materialmasterid);
                    BigDecimal quotaBaseQty = sourceDTO.getQuotaBaseQty();
                    BigDecimal maxbillqty = sourceDTO.getMaxbillqty();
                    BigDecimal minbillqty = sourceDTO.getMinbillqty();
                    BigDecimal packagebatchqty = sourceDTO.getPackagebatchqty();
                    if (quotaBaseQty != null && quotaBaseQty.compareTo(ZERO) <= 0) continue block2;
                    QuotamsOutParamterDTO acceptResult = QuotamsOutParamterDTO.acceptResult(supplierid, orgId, materialId, srcBillId, srcBillEntryId, quotaBaseQty, baseUnitId, allotBaseQty, quotaId, quotaPattern, quotaPercentage, maxbillqty, minbillqty, packagebatchqty);
                    calculateResult.add(acceptResult);
                    if (quotaBaseQty == null) continue;
                    sumbasequotaQty = sumbasequotaQty.add(quotaBaseQty);
                }
            }
        }
        return calculateResult;
    }
}

