/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.pmp.business.helper.PurStairEntry;

public class PurStairPriceHelper {
    public static int getCheckStairPrice(BigDecimal minPrice, BigDecimal maxPrice, DynamicObjectCollection purStairPrices) {
        if (purStairPrices == null || purStairPrices.size() <= 1) {
            return -1;
        }
        List<PurStairEntry> list = new ArrayList<PurStairEntry>(8);
        int seq = PurStairPriceHelper.purStairPricesCheck(list, purStairPrices, minPrice, maxPrice);
        list = list.stream().sorted(Comparator.comparing(PurStairEntry::getStairqtystart)).collect(Collectors.toList());
        if (seq == 0) {
            seq = PurStairPriceHelper.purStairEntrySortCheck(list);
        }
        if (seq == 0) {
            for (int i = 0; i < purStairPrices.size(); ++i) {
                ((DynamicObject)purStairPrices.get(i)).set("stairqtystart", (Object)list.get(i).getStairqtystart());
                ((DynamicObject)purStairPrices.get(i)).set("stairqtyend", (Object)list.get(i).getStairqtyend());
                ((DynamicObject)purStairPrices.get(i)).set("stairprice", (Object)list.get(i).getStairprice());
            }
        }
        return seq;
    }

    private static int purStairPricesCheck(List<PurStairEntry> list, DynamicObjectCollection purStairPrices, BigDecimal minPrice, BigDecimal maxPrice) {
        int seq = 1;
        for (DynamicObject purStairPrice : purStairPrices) {
            PurStairEntry purStairEntry = new PurStairEntry();
            purStairEntry.setSeq(seq);
            BigDecimal stairPrice = purStairPrice.getBigDecimal("stairprice");
            if (stairPrice == null || stairPrice.compareTo(BigDecimal.ZERO) <= 0) {
                return 100;
            }
            if (minPrice.compareTo(BigDecimal.ZERO) != 0 && stairPrice.compareTo(minPrice) < 0) {
                return 200;
            }
            if (maxPrice.compareTo(BigDecimal.ZERO) != 0 && stairPrice.compareTo(maxPrice) > 0) {
                return 300;
            }
            BigDecimal stairQtyStart = purStairPrice.getBigDecimal("stairqtystart");
            BigDecimal stairQtyEnd = purStairPrice.getBigDecimal("stairqtyend");
            if (stairQtyEnd.compareTo(BigDecimal.ZERO) > 0 && stairQtyStart.compareTo(stairQtyEnd) >= 0) {
                return 400;
            }
            purStairEntry.setStairqtystart(stairQtyStart);
            purStairEntry.setStairqtyend(stairQtyEnd);
            purStairEntry.setStairprice(stairPrice);
            list.add(purStairEntry);
            ++seq;
        }
        return 0;
    }

    private static int purStairEntrySortCheck(List<PurStairEntry> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            PurStairEntry stairFirst = list.get(0);
            PurStairEntry stairRow = list.get(i);
            PurStairEntry stairNextRow = list.get(i + 1);
            int seq = stairRow.getSeq();
            if (stairFirst.getStairqtystart().compareTo(BigDecimal.ZERO) != 0) {
                return 500;
            }
            if (stairRow.getStairqtyend().compareTo(BigDecimal.ZERO) == 0) {
                return 600;
            }
            if (stairRow.getStairqtyend().compareTo(stairNextRow.getStairqtystart()) == 0) continue;
            return 700;
        }
        return 0;
    }

    public static String getDetailMsg(int count) {
        String msgDetail = "";
        switch (count) {
            case -1: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u5206\u5f55\u9700\u8981\u81f3\u5c11\u67092\u884c\u6570\u636e\u3002", (String)"SalesPriceSubmitValidator_20", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 100: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"SalesPriceSubmitValidator_13", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 200: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"SalesPriceSubmitValidator_14", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 300: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u4e0d\u80fd\u5927\u4e8e\u6700\u9ad8\u9650\u4ef7\u3002", (String)"SalesPriceSubmitValidator_15", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 400: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u540c\u4e00\u884c\u201c\u9636\u68af\u6570\u91cf(\u4ece)\u201d\u5fc5\u987b\u5c0f\u4e8e\u201c\u9636\u68af\u6570\u91cf(\u81f3)\u201d\u3002", (String)"SalesPriceSubmitValidator_16", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 500: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u8d77\u59cb\u884c\u201c\u9636\u68af\u6570\u91cf(\u4ece)\u201d\u5fc5\u987b\u4e3a0\u3002", (String)"SalesPriceSubmitValidator_17", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 600: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u622a\u6b62\u884c\u4e4b\u5916\u7684\u884c\uff0c\u201c\u9636\u68af\u6570\u91cf(\u81f3)\u201d\u5fc5\u987b\u5f55\u5165\u3002", (String)"SalesPriceSubmitValidator_18", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 700: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u884c\u7684\u201c\u9636\u68af\u6570\u91cf(\u4ece)\u201d\u5fc5\u987b\u7b49\u4e8e\u4e0a\u4e00\u884c\u7684\u201c\u9636\u68af\u6570\u91cf(\u81f3)\u201d\u3002", (String)"SalesPriceSubmitValidator_19", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
            }
        }
        return msgDetail;
    }
}

