/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.accept;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.opvalidate.validator.IsPresentValidator;
import kd.scmc.pm.business.helper.LastUpdateBillHelper;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.enums.ExchangeTypeEnum;
import kd.scmc.pm.validation.accept.PurAcceptBillSubmitValidator;
import kd.scmc.pm.validation.tpl.InvoiceBizTypeValidator;

public class PurAcceptBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("a_allocationper");
        keys.add("isallocbyper");
        keys.add("isexpensealloc");
        keys.add("totalamount");
        keys.add("a_allocationamt");
        keys.add("invoicebiztype");
        keys.add("lastupdateuser");
        keys.add("lastupdatetime");
        keys.add("bookdate");
        keys.add("biztime");
        keys.add("exchangetype");
        keys.add("supplier");
        keys.add("ordersupplier");
        keys.add("invoicesupplier");
        keys.add("receivesupplier");
        e.getFieldKeys().add("discountamount");
        e.getFieldKeys().add("amountandtax");
        e.getFieldKeys().add("ispresent");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PurAcceptBillSubmitValidator());
        e.addValidator((AbstractValidator)new InvoiceBizTypeValidator());
        e.addValidator((AbstractValidator)new IsPresentValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String key = e.getOperationKey();
        if ("submit".equals(key)) {
            DynamicObject[] bills;
            for (DynamicObject bill : bills = e.getDataEntities()) {
                if (StringUtils.isBlank((CharSequence)bill.getString("exchangetype"))) {
                    bill.set("exchangetype", (Object)ExchangeTypeEnum.DIRECT.getValue());
                }
                this.addDefaultSuppliers(bill);
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        if ("submit".equals(key)) {
            DynamicObject[] bills = e.getDataEntities();
            DynamicObject currentUserId = LastUpdateBillHelper.getCurrentUserId();
            Date now = TimeServiceHelper.now();
            for (DynamicObject bill : bills) {
                bill.set("lastupdateuser", (Object)currentUserId);
                bill.set("lastupdatetime", (Object)now);
            }
        }
    }

    private void addDefaultSuppliers(DynamicObject bill) {
        DynamicObjectCollection entry;
        String appId;
        DynamicObject invoiceType;
        DynamicObject supplier = bill.getDynamicObject("supplier");
        if (bill.get("invoicebiztype") == null && supplier != null && (invoiceType = SupplierHelper.getInvoiceType((DynamicObject)supplier, (String)(appId = this.billEntityType.getAppId()))) != null) {
            bill.set("invoicebiztype", (Object)invoiceType);
        }
        if ((entry = bill.getDynamicObjectCollection("billentry")) == null) {
            return;
        }
        for (DynamicObject row : entry) {
            DynamicObject orderSupplier = row.getDynamicObject("ordersupplier");
            if (orderSupplier == null) continue;
            SupplierHelper.nullToDefault((DynamicObject)row, (DynamicObject)orderSupplier, (String[])new String[]{"invoicesupplier", "receivesupplier"});
        }
    }
}

