/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.accept;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PurAcceptBillVerifyHeadAmountOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PurAcceptBillVerifyHeadAmountOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("amount");
        keys.add("taxamount");
        keys.add("amountandtax");
        keys.add("totalamount");
        keys.add("totaltaxamount");
        keys.add("totalallamount");
        keys.add("allocationentry");
        keys.add("a_allocationper");
        keys.add("isallocbyper");
        keys.add("isexpensealloc");
        keys.add("billentry");
        keys.add("settlecurrency");
        keys.add("a_allocationamt");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        for (DynamicObject bill : dataEntities) {
            Map<String, BigDecimal> entrySumCount;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
            if (entry == null || entry.isEmpty() || (entrySumCount = PurAcceptBillVerifyHeadAmountOp.getEntrySumCount(bill, "amount", "taxamount", "amountandtax")).isEmpty()) continue;
            Boolean updateAllocation = Boolean.FALSE;
            DynamicObjectCollection allocationentrys = bill.getDynamicObjectCollection("allocationentry");
            if (allocationentrys == null || allocationentrys.isEmpty()) {
                updateAllocation = Boolean.FALSE;
            } else {
                BigDecimal sumAllocationAmt = BigDecimal.ZERO;
                BigDecimal sumAllocationPer = BigDecimal.ZERO;
                for (DynamicObject allocationentry : allocationentrys) {
                    BigDecimal allocationamt = allocationentry.getBigDecimal("a_allocationamt");
                    BigDecimal allocationper = allocationentry.getBigDecimal("a_allocationper");
                    if (allocationamt == null || allocationper == null) continue;
                    sumAllocationAmt = sumAllocationAmt.add(allocationamt);
                    sumAllocationPer = sumAllocationPer.add(allocationper);
                }
                if (sumAllocationAmt.compareTo(bill.getBigDecimal("totalamount")) != 0 || sumAllocationPer.compareTo(new BigDecimal(100)) != 0) {
                    updateAllocation = Boolean.TRUE;
                }
            }
            this.setHeadIfNoEqual("totalamount", "amount", bill, entrySumCount);
            this.setHeadIfNoEqual("totaltaxamount", "taxamount", bill, entrySumCount);
            this.setHeadIfNoEqual("totalallamount", "amountandtax", bill, entrySumCount);
            if (!updateAllocation.booleanValue()) continue;
            this.updateAllocationEntry(bill, bill.getBigDecimal("totalamount"));
        }
    }

    public static Map<String, BigDecimal> getEntrySumCount(DynamicObject bill, String ... entryKey) {
        ConcurrentHashMap<String, BigDecimal> sumMap = new ConcurrentHashMap<String, BigDecimal>(8);
        if (bill == null || entryKey == null || entryKey.length == 0) {
            return sumMap;
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null || entry.isEmpty()) {
            return sumMap;
        }
        for (String key : entryKey) {
            sumMap.put(key, BigDecimal.ZERO);
        }
        for (DynamicObject row : entry) {
            for (Map.Entry e : sumMap.entrySet()) {
                sumMap.put((String)e.getKey(), ((BigDecimal)e.getValue()).add(row.getBigDecimal((String)e.getKey())));
            }
        }
        return sumMap;
    }

    private void setHeadIfNoEqual(String headKey, String entryKey, DynamicObject bill, Map<String, BigDecimal> entrySum) {
        if (entrySum.get(entryKey).compareTo(bill.getBigDecimal(headKey)) == 0) {
            return;
        }
        bill.set(headKey, (Object)entrySum.get(entryKey));
    }

    private void updateAllocationEntry(DynamicObject bill, BigDecimal totalamount) {
        BigDecimal HUNDRED = new BigDecimal(100);
        Boolean isallocbyper = bill.getBoolean("isallocbyper");
        DynamicObjectCollection allocationentry = bill.getDynamicObjectCollection("allocationentry");
        if (allocationentry == null || allocationentry.size() == 0) {
            return;
        }
        DynamicObject currency = bill.getDynamicObject("settlecurrency");
        int precision = 2;
        if (currency != null) {
            precision = currency.getInt("amtprecision");
        }
        if (isallocbyper.booleanValue()) {
            BigDecimal sumAllocationPer = BigDecimal.ZERO;
            BigDecimal sumAllocationAmt = BigDecimal.ZERO;
            BigDecimal allocationAmt = BigDecimal.ZERO;
            for (DynamicObject entry : allocationentry) {
                BigDecimal allocationper = entry.getBigDecimal("a_allocationper");
                if (allocationper == null) continue;
                sumAllocationPer = sumAllocationPer.add(allocationper);
            }
            for (int i = 0; i < allocationentry.size(); ++i) {
                if (sumAllocationPer.compareTo(HUNDRED) == 0 && i == allocationentry.size() - 1) {
                    allocationAmt = totalamount == null ? BigDecimal.ZERO : totalamount.subtract(sumAllocationAmt);
                } else {
                    BigDecimal allocationPer = ((DynamicObject)allocationentry.get(i)).getBigDecimal("a_allocationper");
                    allocationAmt = totalamount == null ? BigDecimal.ZERO : totalamount.multiply(allocationPer.divide(HUNDRED, precision, RoundingMode.HALF_UP)).setScale(precision, RoundingMode.HALF_UP);
                    sumAllocationAmt = sumAllocationAmt.add(allocationAmt);
                }
                ((DynamicObject)allocationentry.get(i)).set("a_allocationamt", (Object)allocationAmt);
            }
        } else {
            BigDecimal sumAllocationAmt = BigDecimal.ZERO;
            BigDecimal sumAllocationPer = BigDecimal.ZERO;
            BigDecimal alloCationPer = BigDecimal.ZERO;
            for (DynamicObject entry : allocationentry) {
                BigDecimal allocationamt = entry.getBigDecimal("a_allocationamt");
                if (allocationamt == null) continue;
                sumAllocationAmt = sumAllocationAmt.add(allocationamt.abs());
            }
            for (int i = 0; i < allocationentry.size(); ++i) {
                if (totalamount.compareTo(BigDecimal.ZERO) == 0) {
                    alloCationPer = BigDecimal.ZERO;
                } else if (i == allocationentry.size() - 1 && sumAllocationAmt.compareTo(totalamount) == 0) {
                    alloCationPer = HUNDRED.subtract(sumAllocationPer);
                } else {
                    BigDecimal allocationAmt = ((DynamicObject)allocationentry.get(i)).getBigDecimal("a_allocationamt");
                    alloCationPer = allocationAmt == null ? BigDecimal.ZERO : allocationAmt.abs().divide(totalamount, 10, RoundingMode.HALF_UP).multiply(HUNDRED).setScale(2, RoundingMode.HALF_UP);
                    sumAllocationPer = sumAllocationPer.add(alloCationPer);
                }
                ((DynamicObject)allocationentry.get(i)).set("a_allocationper", (Object)alloCationPer);
            }
        }
    }
}

