/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.notice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.pm.business.helper.AppParameterHelper;
import kd.scmc.pm.business.helper.BillRowCloseOpHelper;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.utils.CommonUtils;
import kd.scmc.pm.validation.notice.PurBillRowCloseValidator;

public class PurReceiptNoticeBillRowUnCloseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PurBillRowCloseValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject bill = e.getDataEntities()[0];
            QFilter billIDFilter = new QFilter("id", "=", bill.getPkValue());
            DynamicObject[] noticeBillDynamics = BusinessDataServiceHelper.load((String)bill.getDataEntityType().getName(), (String)"id,closestatus,closer,closedate,org,billentry.id,billentry.rowclosestatus,billentry.seq,billentry.srcbillid,billentry.srcbillentity,billentry.srcbillentryid,billentry.baseqty,billentry.joinbaseqty", (QFilter[])new QFilter[]{billIDFilter});
            if (noticeBillDynamics == null || noticeBillDynamics.length == 0) {
                return;
            }
            DynamicObject noticeBillDynamic = noticeBillDynamics[0];
            String selectRow = this.getOption().getVariableValue("selectRows", null);
            if (selectRow == null || selectRow.length() == 0) {
                return;
            }
            List<String> rows = Arrays.asList(selectRow.split(","));
            boolean closeBill = true;
            ArrayList<String> actualRows = new ArrayList<String>();
            DynamicObjectCollection noticeBillEntryDys = noticeBillDynamic.getDynamicObjectCollection("billentry");
            for (DynamicObject noticeBillEntryDy : noticeBillEntryDys) {
                String rowCloseStatus = noticeBillEntryDy.getString("rowclosestatus");
                if (rowCloseStatus.equals(RowCloseStatusEnum.UNROWCLOSE.getValue())) {
                    closeBill = false;
                    continue;
                }
                int seq = noticeBillEntryDy.getInt("seq");
                String rowSeq = String.valueOf(seq - 1);
                if (!rows.contains(rowSeq)) continue;
                actualRows.add(rowSeq);
                noticeBillEntryDy.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
                closeBill = false;
            }
            if (closeBill && "closestatus".equals(BizCloseStatusEnum.CLOSE.getValue())) {
                noticeBillDynamic.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
                noticeBillDynamic.set("closer", null);
                noticeBillDynamic.set("closedate", null);
            }
            SaveServiceHelper.update((DynamicObject)noticeBillDynamic);
            DynamicObject orgDy = noticeBillDynamic.getDynamicObject("org");
            if (CommonUtils.isNull((Object)orgDy)) {
                return;
            }
            Object isUpOrder = AppParameterHelper.getPmAppParameter((Long)((Long)orgDy.getPkValue()), (String)"isunreceiptnoticeuporder");
            if (isUpOrder instanceof Boolean && ((Boolean)isUpOrder).booleanValue()) {
                boolean bl = BillRowCloseOpHelper.upSrcBillJoinBaseQty((DynamicObject)noticeBillDynamic, actualRows, (String)"rowunclose");
            }
        }
    }
}

