/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.plan;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.validation.plan.PurPlanBillRowCloseValidator;

public class PurPlanBillRowCloseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("billentry");
        keys.add("rowclosestatus");
        keys.add("billstatus");
        keys.add("closestatus");
        keys.add("closer");
        keys.add("closedate");
        keys.add("seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PurPlanBillRowCloseValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject bill = e.getDataEntities()[0];
            boolean closeBill = true;
            DynamicObjectCollection noticeBillEntryDys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject noticeBillEntryDy : noticeBillEntryDys) {
                String rowCloseStatus = noticeBillEntryDy.getString("rowclosestatus");
                if (!rowCloseStatus.equals(RowCloseStatusEnum.UNROWCLOSE.getValue())) continue;
                closeBill = false;
                break;
            }
            if (closeBill) {
                bill.set("closestatus", (Object)BizCloseStatusEnum.CLOSE.getValue());
                bill.set("closer", (Object)1L);
                bill.set("closedate", (Object)TimeServiceHelper.now());
                SaveServiceHelper.update((DynamicObject)bill);
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }
}

