/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.tpl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.opplugin.BillTypeCoreValidator;
import kd.mpscmm.msbd.opvalidate.validator.IsPresentValidator;
import kd.scmc.pm.business.helper.LastUpdateBillHelper;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.enums.ExchangeTypeEnum;
import kd.scmc.pm.validation.tpl.AmountDirectionValidator;
import kd.scmc.pm.validation.tpl.InvoiceBizTypeValidator;
import kd.scmc.pm.validation.tpl.MaterialNameValidator;
import kd.scmc.pm.validation.tpl.OperatorGroupIsolateValidator;

public class BillTplSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("discounttype");
        fieldKeys.add("discountrate");
        fieldKeys.add("priceandtax");
        fieldKeys.add("operator");
        fieldKeys.add("org");
        fieldKeys.add("billtype");
        fieldKeys.add("biztype");
        fieldKeys.add("operator");
        fieldKeys.add("lastupdateuser");
        fieldKeys.add("lastupdatetime");
        fieldKeys.add("billentry");
        fieldKeys.add("materialname");
        fieldKeys.add("qty");
        fieldKeys.add("taxamount");
        fieldKeys.add("discountamount");
        fieldKeys.add("amount");
        fieldKeys.add("amountandtax");
        fieldKeys.add("linetype");
        fieldKeys.add("exchangetype");
        fieldKeys.add("supplier");
        fieldKeys.add("providersupplier");
        fieldKeys.add("invoicesupplier");
        fieldKeys.add("receivesupplier");
        fieldKeys.add("providerlinkman");
        fieldKeys.add("provideraddress");
        fieldKeys.add("invoicebiztype");
        e.getFieldKeys().add("entrychangetype");
        e.getFieldKeys().add("discountamount");
        e.getFieldKeys().add("amountandtax");
        e.getFieldKeys().add("ispresent");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new OperatorGroupIsolateValidator());
        e.addValidator((AbstractValidator)new MaterialNameValidator());
        e.addValidator((AbstractValidator)new AmountDirectionValidator());
        e.addValidator((AbstractValidator)new BillTypeCoreValidator());
        e.addValidator((AbstractValidator)new InvoiceBizTypeValidator());
        ArrayList<String> billName = new ArrayList<String>();
        billName.add("pm_purorderbill");
        billName.add("pm_xpurorderbill");
        billName.add("pm_xspurorderbill");
        billName.add("pm_purrefundapplybill");
        billName.add("pm_receiptnotice");
        String dateEnTityName = this.billEntityType.getName();
        if (!StringUtils.isEmpty((CharSequence)dateEnTityName) && billName != null && billName.contains(dateEnTityName)) {
            e.addValidator((AbstractValidator)new IsPresentValidator());
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String key = e.getOperationKey();
        if ("submit".equals(key)) {
            DynamicObject[] bills;
            DynamicObject currentUserId = LastUpdateBillHelper.getCurrentUserId();
            for (DynamicObject bill : bills = e.getDataEntities()) {
                bill.set("lastupdateuser", (Object)currentUserId);
                bill.set("lastupdatetime", (Object)LastUpdateBillHelper.getCurrentDate());
                if (StringUtils.isBlank((CharSequence)bill.getString("exchangetype"))) {
                    bill.set("exchangetype", (Object)ExchangeTypeEnum.DIRECT.getValue());
                }
                this.addDefaultSupplier(bill);
            }
        }
    }

    private void addDefaultSupplier(DynamicObject bill) {
        String appId;
        DynamicObject invoiceType;
        DynamicObject supplier = bill.getDynamicObject("supplier");
        if (bill.get("supplier") == null) {
            return;
        }
        if (bill.get("invoicebiztype") == null && (invoiceType = SupplierHelper.getInvoiceType((DynamicObject)supplier, (String)(appId = this.billEntityType.getAppId()))) != null) {
            bill.set("invoicebiztype", (Object)invoiceType);
        }
        if (bill.get("providersupplier") == null) {
            SupplierHelper.nullToDefault((DynamicObject)bill, (DynamicObject)supplier, (String[])new String[]{"providersupplier"});
            bill.set("providerlinkman", (Object)SupplierHelper.getDefaultLinkManObj((DynamicObject)supplier));
            bill.set("provideraddress", (Object)SupplierHelper.getDefaultAddressString((DynamicObject)supplier));
        }
        SupplierHelper.nullToDefault((DynamicObject)bill, (DynamicObject)supplier, (String[])new String[]{"invoicesupplier", "receivesupplier"});
    }
}

