/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.accept;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class PurAcceptPushedValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(PurAcceptPushedValidator.class);

    public void validate() {
        Map<Long, ExtendedDataEntity> billIdMap = this.billIdMap();
        Map<Long, BFRowLinkDownNode> targetBills = this.getTargetBills(billIdMap.keySet());
        this.validTargetBills(targetBills, billIdMap);
    }

    private void validTargetBills(Map<Long, BFRowLinkDownNode> targetBills, Map<Long, ExtendedDataEntity> billIdMap) {
        Long purReceiptTableId = this.getTableId("pur_receipt");
        log.info("\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\u6821\u9a8c \u534f\u540c\u6536\u8d27\u5355tableId=" + purReceiptTableId);
        Long purReceiptReturnTableId = this.getTableId("pur_receipt_return");
        log.info("\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\u6821\u9a8c \u534f\u540c\u9000\u8d27\u5355tableId=" + purReceiptReturnTableId);
        HashMap<Long, List<Long>> validPurParam = new HashMap<Long, List<Long>>(16);
        for (Map.Entry<Long, BFRowLinkDownNode> linkDownNodeEntry : targetBills.entrySet()) {
            this.validChildNodes(linkDownNodeEntry, billIdMap, validPurParam, purReceiptTableId, purReceiptReturnTableId);
        }
        if (!validPurParam.isEmpty()) {
            this.validPur(validPurParam, billIdMap);
        }
    }

    private void validChildNodes(Map.Entry<Long, BFRowLinkDownNode> linkDownNodeEntry, Map<Long, ExtendedDataEntity> billIdMap, Map<Long, List<Long>> validPurParam, Long purReceiptTableId, Long purReceiptReturnTableId) {
        Long billId = linkDownNodeEntry.getKey();
        BFRowLinkDownNode linkDownNode = linkDownNodeEntry.getValue();
        if (linkDownNode == null) {
            log.info("\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\u6821\u9a8c billId=" + billId + " \u65e0botp\u5173\u7cfb");
            return;
        }
        List childNodes = linkDownNode.findAllChildNodes();
        if (childNodes == null || childNodes.isEmpty()) {
            log.info("\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\u6821\u9a8c billId=" + billId + " \u65e0\u4e0b\u6e38\u5355\u636e");
            return;
        }
        boolean isPushed = false;
        boolean isPurReceipt = false;
        for (BFRowLinkDownNode childNode : childNodes) {
            BFRowId rowId = childNode.getRowId();
            if (rowId == null) continue;
            if (this.isPurReceiptBill(rowId, purReceiptTableId, purReceiptReturnTableId)) {
                isPurReceipt = true;
                continue;
            }
            isPushed = true;
        }
        if (isPushed) {
            this.addMessage(billIdMap.get(billId), ResManager.loadKDString((String)"\u5355\u636e\u5df2\u4e0b\u63a8\uff0c\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"PurAcceptPushedValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        } else if (isPurReceipt) {
            this.putValidPurParamMap(validPurParam, billIdMap.get(billId));
        }
    }

    private Map<Long, ExtendedDataEntity> billIdMap() {
        HashMap<Long, ExtendedDataEntity> billIdMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length << 1);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            Long billId = (Long)bill.getPkValue();
            billIdMap.put(billId, data);
        }
        return billIdMap;
    }

    private boolean isPurReceiptBill(BFRowId rowId, Long ... purTableIds) {
        Long tableId = rowId.getTableId();
        for (Long purTableId : purTableIds) {
            if (!purTableId.equals(tableId)) continue;
            return true;
        }
        return false;
    }

    private Map<Long, BFRowLinkDownNode> getTargetBills(Set<Long> billIds) {
        log.info("\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\u6821\u9a8c billIds=" + billIds);
        return BFTrackerServiceHelper.loadBillLinkDownNodes((String)this.entityKey, (Long[])billIds.toArray(new Long[0]), (boolean)true);
    }

    private Long getTableId(String billName) {
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)billName, (String)billName);
        if (tableDefine == null) {
            return null;
        }
        return tableDefine.getTableId();
    }

    private void validPur(Map<Long, List<Long>> validPurParam, Map<Long, ExtendedDataEntity> billIdMap) {
        log.info("\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\uff1a\u8c03\u7528\u534f\u540c\u6821\u9a8c\u5fae\u670d\u52a1\u53c2\u6570\uff0cparam=" + validPurParam);
        try {
            Map serviceResult = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"ICancelVerifyService", (String)"CanCancelVerify", (Object[])new Object[]{"pm_puracceptbill", "billentry", validPurParam});
            log.info("\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\uff1a\u534f\u540c\u6821\u9a8c\u5fae\u670d\u52a1\u8fd4\u56de\u7ed3\u679c " + serviceResult);
            if (serviceResult == null) {
                return;
            }
            Boolean success = (Boolean)serviceResult.get("succed");
            if (success == null || success.booleanValue()) {
                return;
            }
            Map data = (Map)serviceResult.get("data");
            if (data == null || data.isEmpty()) {
                this.addMessage(this.dataEntities[0], (String)serviceResult.get("message"), ErrorLevel.Error);
            } else {
                for (Long billId : data.keySet()) {
                    ExtendedDataEntity extendedDataEntity = billIdMap.get(billId);
                    if (extendedDataEntity == null) {
                        log.info("\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\uff1a\u534f\u540c\u6821\u9a8c\u5fae\u670d\u52a1\u8fd4\u56de\u503cid\u4e0d\u5339\u914d ->" + billId);
                        continue;
                    }
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5bf9\u8d26\u6216\u8005\u5f00\u7968\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"PurAcceptPushedValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
        }
        catch (KDException e) {
            log.info("\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\uff1a\u8c03\u7528\u534f\u540c\u6821\u9a8c\u5fae\u670d\u52a1\u4e1a\u52a1\u5f02\u5e38 ", (Object)e);
            this.addMessage(this.dataEntities[0], e.getMessage(), ErrorLevel.Error);
        }
        catch (Exception e) {
            log.error("\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\uff1a\u8c03\u7528\u534f\u540c\u6821\u9a8c\u5fae\u670d\u52a1\u5f02\u5e38 ", (Throwable)e);
        }
    }

    private void putValidPurParamMap(Map<Long, List<Long>> validPurParam, ExtendedDataEntity dataEntity) {
        if (dataEntity == null) {
            return;
        }
        DynamicObject bill = dataEntity.getDataEntity();
        Long billId = (Long)bill.getPkValue();
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null || entry.isEmpty()) {
            validPurParam.put(billId, Collections.emptyList());
        } else {
            validPurParam.put(billId, entry.stream().map(row -> (Long)row.getPkValue()).collect(Collectors.toList()));
        }
    }
}

