/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.apply;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.BatXBillHelper;
import kd.mpscmm.msbd.changemodel.common.enums.BatChangeStatusEnum;
import kd.mpscmm.msbd.common.enums.BillStatusEnum;
import kd.mpscmm.msbd.common.enums.ChangeStatusEnum;
import kd.scmc.pm.enums.BizCancelStatusEnum;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.StatusEnum;

public class BatXPurApplyBillSrcBillValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(BatXPurApplyBillSrcBillValidator.class);

    public void validate() {
        try {
            Set selectRows = BatXBillHelper.getSelectRows((OperateOption)this.getOption());
            HashSet<Long> allNeedValidSBEntryIds = new HashSet<Long>();
            for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                DynamicObject bill = extendedDataEntity.getDataEntity();
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                if (entrys == null) continue;
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    if (selectRows != null && selectRows.size() != 0 && !selectRows.contains((Long)entry.getPkValue())) continue;
                    String entryChangeStatus = entry.getString("changestatus");
                    if (!BatChangeStatusEnum.NORMAL.getValue().equals(entryChangeStatus)) continue;
                    allNeedValidSBEntryIds.add(entry.getLong("xsbillentryid"));
                }
            }
            if (allNeedValidSBEntryIds.size() == 0) {
                return;
            }
            HashMap purApplyData = new HashMap(8);
            QFilter q = new QFilter("billentry.id", "in", allNeedValidSBEntryIds);
            Throwable throwable = null;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purapplybill", (String)"org,billstatus,changestatus,cancelstatus,closestatus,billentry.id entryid,billentry.rowclosestatus rowclosestatus,billentry.material material,billentry.unit unit,billentry.qty qty,billentry.joinbaseqty joinbaseqty", (QFilter[])new QFilter[]{q}, null);){
                if (ds != null) {
                    for (Row row : ds) {
                        Long entryid = row.getLong("entryid");
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("org", row.getLong("org"));
                        map.put("billstatus", row.getString("billstatus"));
                        map.put("changestatus", row.getString("changestatus"));
                        map.put("cancelstatus", row.getString("cancelstatus"));
                        map.put("closestatus", row.getString("closestatus"));
                        map.put("rowclosestatus", row.getString("rowclosestatus"));
                        map.put("joinbaseqty", row.getBigDecimal("joinbaseqty"));
                        map.put("qty", row.getBigDecimal("qty"));
                        map.put("unit", row.getLong("unit"));
                        map.put("material", row.getLong("material"));
                        purApplyData.put(entryid, map);
                    }
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            HashSet allSrcBillIds = new HashSet(8);
            HashSet<Long> hashSet = new HashSet<Long>(8);
            for (ExtendedDataEntity extend3 : this.dataEntities) {
                DynamicObject bill = extend3.getDataEntity();
                String billStatus = bill.getString("billstatus");
                DynamicObject org = bill.getDynamicObject("org");
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                hashSet.clear();
                if (entrys == null) continue;
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    if (selectRows != null && selectRows.size() != 0 && !selectRows.contains((Long)entry.getPkValue())) continue;
                    long xsBillId = entry.getLong("xsbillid");
                    long xsBillEntryId = entry.getLong("xsbillentryid");
                    if (xsBillId == 0L || xsBillEntryId == 0L || !allNeedValidSBEntryIds.contains(xsBillEntryId)) continue;
                    Map data = (Map)purApplyData.get(xsBillEntryId);
                    if (data != null && data.size() > 0) {
                        String errorMsg;
                        String billstatus = (String)data.get("billstatus");
                        String changestatus = (String)data.get("changestatus");
                        String cancelstatus = (String)data.get("cancelstatus");
                        String closestatus = (String)data.get("closestatus");
                        String rowclosestatus = (String)data.get("rowclosestatus");
                        BigDecimal joinbaseqty = (BigDecimal)data.get("joinbaseqty");
                        if (org != null && !org.getPkValue().equals(data.get("org"))) {
                            String errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u7533\u8bf7\u5355\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u4e0e\u6279\u91cf\u53d8\u66f4\u5355\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatXPurApplyBillSrcBillValidator_12", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend3, errMsg, ErrorLevel.Error);
                        }
                        if (!StatusEnum.AUDIT.getValue().equals(billstatus)) {
                            errorMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u7533\u8bf7\u5355\u72b6\u6001\u4e0d\u662f\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurApplyBillSrcBillValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend3, errorMsg, ErrorLevel.Error);
                        }
                        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                            if ("submit".equals(this.getOperateKey())) {
                                if (allSrcBillIds.contains(xsBillId)) {
                                    errorMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5176\u4ed6\u6279\u91cf\u53d8\u66f4\u5355\u4e2d\u5df2\u5b58\u5728\u540c\u4e00\u91c7\u8d2d\u7533\u8bf7\u5355\uff0c\u65e0\u6cd5\u540c\u65f6\u63d0\u4ea4\u3002", (String)"BatXPurApplyBillSrcBillValidator_9", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                                    this.addMessage(extend3, errorMsg, ErrorLevel.Error);
                                } else {
                                    hashSet.add(xsBillId);
                                }
                            }
                            if (ChangeStatusEnum.REVISING.getValue().equals(changestatus) || ChangeStatusEnum.CHANGING.getValue().equals(changestatus)) {
                                errorMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u7533\u8bf7\u5355\u53d8\u66f4\u72b6\u6001\u4e3a\u201c\u53d8\u66f4\u4e2d\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurApplyBillSrcBillValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                                this.addMessage(extend3, errorMsg, ErrorLevel.Error);
                            }
                        }
                        if (BizCancelStatusEnum.CANCEL.getValue().equals(cancelstatus)) {
                            errorMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u7533\u8bf7\u5355\u4f5c\u5e9f\u72b6\u6001\u4e3a\u201c\u5df2\u4f5c\u5e9f\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurApplyBillSrcBillValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend3, errorMsg, ErrorLevel.Error);
                        }
                        if (BizCloseStatusEnum.CLOSE.getValue().equals(closestatus)) {
                            errorMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u7533\u8bf7\u5355\u5173\u95ed\u72b6\u6001\u4e3a\u201c\u5df2\u5173\u95ed\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurApplyBillSrcBillValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend3, errorMsg, ErrorLevel.Error);
                        }
                        if (RowCloseStatusEnum.ROWCLOSE.getValue().equals(rowclosestatus)) {
                            errorMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u7533\u8bf7\u5355\u884c\u5173\u95ed\u72b6\u6001\u4e3a\u201c\u5df2\u5173\u95ed\u201d\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurApplyBillSrcBillValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend3, errorMsg, ErrorLevel.Error);
                        }
                        DynamicObject unit = entry.getDynamicObject("unit");
                        Object srcUnit = data.get("unit");
                        if (unit != null && !unit.getPkValue().equals(srcUnit)) {
                            String errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4e0e\u91c7\u8d2d\u7533\u8bf7\u5355\u884c\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurApplyBillSrcBillValidator_6", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend3, errMsg, ErrorLevel.Error);
                        }
                        DynamicObject material = entry.getDynamicObject("material");
                        Object srcMaterial = data.get("material");
                        if (material != null && !material.getPkValue().equals(srcMaterial)) {
                            String errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4e0e\u91c7\u8d2d\u7533\u8bf7\u5355\u884c\u201c\u7269\u6599\u7f16\u7801\u201d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurApplyBillSrcBillValidator_7", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend3, errMsg, ErrorLevel.Error);
                        }
                        BigDecimal qty = entry.getBigDecimal("qty");
                        BigDecimal srcQty = (BigDecimal)data.get("qty");
                        if (qty != null && qty.compareTo(srcQty) != 0) {
                            String errMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4e0e\u91c7\u8d2d\u7533\u8bf7\u5355\u884c\u201c\u6838\u51c6\u6570\u91cf\u201d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurApplyBillSrcBillValidator_8", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                            this.addMessage(extend3, errMsg, ErrorLevel.Error);
                        }
                        BigDecimal afterBaseQty = entry.getBigDecimal("afterbaseqty");
                        if (joinbaseqty == null || afterBaseQty.compareTo(joinbaseqty) >= 0) continue;
                        String errorMsg2 = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u53d8\u66f4\u540e\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u539f\u5355\u636e\u201c\u5173\u8054\u6570\u91cf\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatXPurApplyBillSrcBillValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                        this.addMessage(extend3, errorMsg2, ErrorLevel.Error);
                        continue;
                    }
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6\u7b2c%s\u884c\uff0c\u91c7\u8d2d\u7533\u8bf7\u5355\u884c\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"BatXPurApplyBillSrcBillValidator_11", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                    this.addMessage(extend3, errorMsg, ErrorLevel.Error);
                }
                allSrcBillIds.addAll(hashSet);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\u3002", (String)"BatXPurApplyBillSrcBillValidator_10", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
        }
    }
}

